/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.models.config.ipc.ssl.WSCertificateExpirationMonitor;
import com.ibm.ws.crypto.config.WSNotifier;
import com.ibm.ws.crypto.config.WSScheduler;
import com.ibm.ws.ffdc.FFDCFilter;
import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;

public class CertificateExpirationMonitor
implements AlarmListener {
    private static final TraceComponent tc = Tr.register(CertificateExpirationMonitor.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static CertificateExpirationMonitor thisClass = null;
    private WSNotifier notifier = null;
    private WSScheduler scheduler = null;
    private String name = null;
    private boolean autoReplace = false;
    private boolean deleteOld = false;
    private int daysBeforeNotification = 30;
    private boolean isEnabled = true;

    private CertificateExpirationMonitor(WSCertificateExpirationMonitor wSCertificateExpirationMonitor) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.name = wSCertificateExpirationMonitor.getName();
        this.autoReplace = wSCertificateExpirationMonitor.isAutoReplace();
        this.deleteOld = wSCertificateExpirationMonitor.isDeleteOld();
        this.daysBeforeNotification = wSCertificateExpirationMonitor.getDaysBeforeNotification();
        this.isEnabled = wSCertificateExpirationMonitor.isIsEnabled();
        if (this.isEnabled) {
            this.scheduler = new WSScheduler(wSCertificateExpirationMonitor.getWsSchedule(), this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", new Object[]{this.toString()});
        }
    }

    public static CertificateExpirationMonitor getInstance(WSCertificateExpirationMonitor wSCertificateExpirationMonitor) {
        if (thisClass == null) {
            thisClass = new CertificateExpirationMonitor(wSCertificateExpirationMonitor);
        }
        return thisClass;
    }

    public static CertificateExpirationMonitor getInstance() {
        return thisClass;
    }

    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm", object);
        }
        this.monitorExpirations();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm");
        }
    }

    public String monitorExpirations() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "monitorExpirations");
        }
        String string = null;
        try {
            StartAlarm startAlarm = new StartAlarm();
            Class<?> clazz = Class.forName("com.ibm.ws.security.core.ContextManagerFactory");
            Method method2 = clazz.getMethod("getInstance", null);
            Object object = method2.invoke(null, null);
            Class<?> clazz2 = Class.forName("com.ibm.ws.security.core.ContextManager");
            Method method3 = clazz2.getMethod("runAsSystem", PrivilegedExceptionAction.class);
            string = (String)method3.invoke(object, startAlarm);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.utils.CertificateExpirationMonitor.alarm", "130", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "monitorExpirations alarm did not execute.", new Object[]{exception});
            }
            string = "CertificateExpirationMonitor alarm did not execute; the error is: " + exception.getMessage();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm");
        }
        return string;
    }

    public String toString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toString");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CertificateExpirationMonitor.toString() {\n");
        stringBuffer.append("name = ");
        stringBuffer.append(this.name);
        stringBuffer.append("\n");
        stringBuffer.append("autoReplace = ");
        stringBuffer.append(this.autoReplace);
        stringBuffer.append("\n");
        stringBuffer.append("deleteOld = ");
        stringBuffer.append(this.autoReplace);
        stringBuffer.append("\n");
        stringBuffer.append("daysBeforeNotification = ");
        stringBuffer.append(this.daysBeforeNotification);
        stringBuffer.append("\n");
        stringBuffer.append("isEnabled = ");
        stringBuffer.append(this.isEnabled);
        stringBuffer.append("\n}");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toString");
        }
        return stringBuffer.toString();
    }

    class StartAlarm
    implements PrivilegedExceptionAction {
        public Object run() throws Exception {
            String string = null;
            try {
                CommandMgr commandMgr = CommandMgr.getCommandMgr();
                AdminCommand adminCommand = commandMgr.createCommand("startCertificateExpMonitor");
                Session session = new Session();
                adminCommand.setConfigSession(session);
                adminCommand.setParameter("ExpMonitorSaveConfig", Boolean.TRUE);
                adminCommand.execute();
                CommandResult commandResult = adminCommand.getCommandResult();
                if (commandResult.isSuccessful()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "monitorExpirations");
                    }
                    return (String)commandResult.getResult();
                }
                Throwable throwable = commandResult.getException();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "monitorExpirations did not execute.", new Object[]{throwable});
                }
                Tr.error(tc, "ssl.expiration.monitor.start.error.CWPKI0038E", new Object[]{throwable.getMessage()});
                string = "Error occurred executing expiration monitor: " + throwable.getMessage();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "monitorExpirations did not execute.", new Object[]{exception});
                }
                Tr.error(tc, "ssl.expiration.monitor.start.error.CWPKI0038E", new Object[]{exception.getMessage()});
                string = "Error occurred executing expiration monitor: " + exception.getMessage();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "monitorExpirations");
            }
            return string;
        }
    }
}

