/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.signerCertificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.File;
import java.security.KeyStoreException;
import javax.management.ObjectName;

public class AddSignerCertificate
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(AddSignerCertificate.class, "SSL", "com.ibm.ws.ssl.commands.trustedCertificates");
    private String keyStoreName = null;
    private String keyStoreScope = null;
    private String certFilePath = null;
    private String certFilePathExpanded = null;
    private String certAlias = null;
    private Boolean base64Encoded = null;
    private KeyStoreInfo ksInfo = null;

    public AddSignerCertificate(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public AddSignerCertificate(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            objectName = ConfigServiceHelper.createObjectName(null, "Security");
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName2 = configService.queryConfigObjects(session, objectName3, objectName, null)[0];
            }
            Object var6_8 = null;
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.certFilePath = (String)this.getParameter(CommandConstants.CERT_FILE_PATH);
            this.certAlias = (String)this.getParameter(CommandConstants.CERT_ALIAS);
            this.base64Encoded = (Boolean)this.getParameter(CommandConstants.CERT_BASE64ENCODED);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " keyStoreScope=" + this.keyStoreScope + " certAlias=" + this.certAlias + " certFilePath=" + this.certFilePath + " base64Encoded=" + this.base64Encoded);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultCellScope(objectName3);
                Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
            }
            this.certFilePathExpanded = KeyStoreManager.getInstance().expand(this.certFilePath);
            File file = new File(this.certFilePathExpanded);
            if (!file.isAbsolute()) {
                this.certFilePathExpanded = KeyStoreManager.getInstance().expand("${USER_INSTALL_ROOT}" + File.separator + "etc" + File.separator + this.certFilePath);
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, configService, this.keyStoreName, this.keyStoreScope);
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            throw new CommandValidationException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        boolean bl = false;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            this.signerCertificateAdd(this.ksInfo, this.certFilePathExpanded, this.certAlias);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public void signerCertificateAdd(KeyStoreInfo keyStoreInfo, String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "signerCertificateAdd");
        }
        WSKeyStoreRemotable wSKeyStoreRemotable = new WSKeyStoreRemotable(keyStoreInfo);
        try {
            String string3 = "containsAlias";
            Object[] objectArray = new Object[]{string2};
            Object[] objectArray2 = wSKeyStoreRemotable.invokeKeyStoreCommand(string3, objectArray);
            if (((Boolean)objectArray2[0]).booleanValue()) {
                String string4 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.alias.already.exists.CWPKI0630E", new Object[]{string2, keyStoreInfo.getName()}, "Alias \"" + string2 + "\" is already in key store \"" + keyStoreInfo.getName() + "\".");
                throw new KeyStoreException(string4);
            }
            string3 = "receiveCertificate";
            objectArray = new Object[]{keyStoreInfo, string, string2};
            wSKeyStoreRemotable.invokeKeyStoreCommand(string3, objectArray);
            Session session = this.getConfigSession();
            PersonalCertificateHelper.setWorkspaceUpdated(session, keyStoreInfo.getLocation());
            PersonalCertificateHelper.markSSLConfigChanged(keyStoreInfo, session);
        }
        catch (Exception exception) {
            throw new Exception(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "signerCertificateAdd");
        }
    }
}

