/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.personalCertificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.models.config.ipc.ssl.KeyStore;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.ssl.commands.certificateRequests.CertificateRequestHelper;
import com.ibm.ws.ssl.commands.keyStores.KeyStoreHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeData;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class PersonalCertificateHelper {
    private static TraceComponent tc = Tr.register(PersonalCertificateHelper.class, "SSL", "com.ibm.ws.ssl.commands.personalCertificates");

    public static KeyStoreInfo getKsInfo(Session session, ConfigService configService, String string, String string2) throws Exception {
        KeyStoreInfo keyStoreInfo = null;
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        AttributeList attributeList = null;
        ObjectName objectName3 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKsInfo");
        }
        try {
            String[] stringArray;
            objectName = ConfigServiceHelper.createObjectName(null, "Security");
            objectName2 = configService.resolve(session, "Cell=:Security=")[0];
            CommandHelper commandHelper = new CommandHelper();
            AttributeList attributeList2 = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList2, CommandConstants.NAME, string);
            objectName3 = commandHelper.getObjectName(configService, session, objectName2, CommandConstants.KEY_STORES, attributeList2, string2);
            if (objectName3 == null) {
                String string3 = string + " object not found.";
                throw new CommandValidationException(string3);
            }
            attributeList = configService.getAttributes(session, objectName3, null, false);
            keyStoreInfo = KeyStoreHelper.makeKsInfo(attributeList, session);
            String string4 = PersonalCertificateHelper.genWorkspaceLocation(session, keyStoreInfo, stringArray = configService.getUnsavedChanges(session));
            if (string4 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Working from the key store file located in " + string4);
                }
                keyStoreInfo.setLocation(string4);
            } else {
                String string5 = keyStoreInfo.getLocation();
                String string6 = null;
                String string7 = null;
                String string8 = null;
                string5 = string5.replace('\\', '/');
                WorkSpace workSpace = WorkSpaceManagerFactory.getManager().getWorkSpace(session.toString());
                ManagementScopeData managementScopeData = new ManagementScopeData(keyStoreInfo.getScopeNameString());
                int n = string5.indexOf("cells/" + managementScopeData.getCellName());
                if (n != -1) {
                    string7 = string5.substring(n);
                    int n2 = string7.lastIndexOf("/");
                    string6 = string7.substring(n2 + 1);
                    string8 = string7.substring(0, n2);
                    RepositoryContext repositoryContext = workSpace.findContext(string8);
                    repositoryContext.extract(string6, true);
                    String string9 = KeyStoreManager.getInstance().expand("${WORKSPACE_ROOT}/" + session.toString() + "/workspace");
                    String string10 = PersonalCertificateHelper.fixLocation(string9, KeyStoreManager.getInstance().expand(string5));
                    if (string10 != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Working from the key store file located in " + string10);
                        }
                        keyStoreInfo.setLocation(string10);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Working from the key store file located in " + string5);
                }
            }
        }
        catch (ConfigServiceException configServiceException) {
            String string11 = configServiceException.getMessage();
            throw new CommandValidationException(string11);
        }
        catch (Exception exception) {
            String string12 = exception.getMessage();
            throw new CommandValidationException(string12);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKsInfo");
        }
        return keyStoreInfo;
    }

    public static boolean verifyKeyPassword(KeyStoreInfo keyStoreInfo, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifyKeyPassword");
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        string3 = keyStoreInfo.getType();
        string4 = keyStoreInfo.getLocation();
        string2 = keyStoreInfo.getProvider();
        string5 = KeyStoreManager.getInstance().expand(string4);
        int n = KeyStoreHelper.checkKeyFile(string3, string5, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifyKeyPassword");
        }
        return n == 0;
    }

    public static AttributeList getCertAttrlist(String string, X509Certificate x509Certificate, Locale locale) throws Exception {
        AttributeList attributeList = new AttributeList();
        attributeList.clear();
        if (string != null) {
            ConfigServiceHelper.setAttributeValue(attributeList, "alias", string);
        }
        try {
            Object object;
            String string2;
            Principal principal;
            ConfigServiceHelper.setAttributeValue(attributeList, "version", String.valueOf(x509Certificate.getVersion()));
            PublicKey publicKey = x509Certificate.getPublicKey();
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded());
            KeyFactory keyFactory = KeyFactory.getInstance(publicKey.getAlgorithm());
            int n = 0;
            PublicKey publicKey2 = keyFactory.generatePublic(x509EncodedKeySpec);
            n = publicKey2 instanceof RSAPublicKey ? ((RSAPublicKey)publicKey2).getModulus().bitLength() : ((DSAPublicKey)publicKey2).getY().bitLength();
            if (n % 2 != 0) {
                ++n;
            }
            ConfigServiceHelper.setAttributeValue(attributeList, "size", String.valueOf(n));
            ConfigServiceHelper.setAttributeValue(attributeList, "serialNumber", x509Certificate.getSerialNumber());
            Principal principal2 = x509Certificate.getSubjectDN();
            if (principal2 != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, "issuedTo", ((Object)principal2).toString());
            }
            if ((principal = x509Certificate.getIssuerDN()) != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, "issuedBy", ((Object)principal).toString());
            }
            if ((string2 = KeyStoreManager.getInstance().generateDigest("SHA-1", x509Certificate)) != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, "fingerPrint", string2);
            }
            String string3 = x509Certificate.getSigAlgName();
            String string4 = x509Certificate.getSigAlgOID();
            if (string3 != null && string4 != null) {
                object = new String(string3 + "(" + string4 + ")");
                ConfigServiceHelper.setAttributeValue(attributeList, "signatureAlgorithm", object);
            }
            object = x509Certificate.getNotBefore();
            Date date = x509Certificate.getNotAfter();
            if (object != null && date != null) {
                DateFormat dateFormat = DateFormat.getDateInstance(1, locale);
                String string5 = dateFormat.format((Date)object);
                String string6 = dateFormat.format(date);
                String string7 = TraceNLSHelper.getInstance().getFormattedMessage("certificateValidity", new Object[]{string5, string6}, "Valid from " + string5 + " to " + string6 + ".", locale);
                ConfigServiceHelper.setAttributeValue(attributeList, "validity", string7);
            }
        }
        catch (Exception exception) {
            throw new CommandValidationException(exception.getMessage());
        }
        return attributeList;
    }

    public static String deleteOldCerts(Session session, KeyStoreInfo keyStoreInfo, int n, Locale locale) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteCerts", new Object[]{session, keyStoreInfo, new Integer(n)});
        }
        StringBuffer stringBuffer = new StringBuffer();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        ObjectName objectName = configService.resolve(session, "Cell=:Security=")[0];
        String string = keyStoreInfo.getName();
        String string2 = keyStoreInfo.getScopeNameString();
        List list = (List)configService.getAttribute(session, objectName, CommandConstants.KEY_STORES);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeList attributeList = (AttributeList)iterator.next();
            String string3 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "name");
            Boolean bl = (Boolean)ConfigServiceHelper.getAttributeValue(attributeList, "readOnly");
            Boolean bl2 = (Boolean)ConfigServiceHelper.getAttributeValue(attributeList, "fileBased");
            ObjectName objectName2 = (ObjectName)ConfigServiceHelper.getAttributeValue(attributeList, "managementScope");
            String string4 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "password");
            String string5 = (String)configService.getAttribute(session, objectName2, CommandConstants.SCOPE_NAME);
            if (string3.equals(string2) && string5.equals(string2) || !string3.equals(string)) continue;
            KeyStoreInfo keyStoreInfo2 = PersonalCertificateHelper.getKsInfo(session, configService, string3, string5);
            WSKeyStoreRemotable wSKeyStoreRemotable = new WSKeyStoreRemotable(keyStoreInfo2);
            String string6 = System.getProperty("line.separator");
            String string7 = null;
            try {
                String string8 = "aliases";
                Object[] objectArray = null;
                Object[] objectArray2 = wSKeyStoreRemotable.invokeKeyStoreCommand(string8, objectArray);
                if (objectArray2 != null) {
                    for (int i = 0; i < objectArray2.length; ++i) {
                        string8 = "getCertificate";
                        String string9 = (String)objectArray2[i];
                        objectArray = new Object[]{string9};
                        Object[] objectArray3 = wSKeyStoreRemotable.invokeKeyStoreCommand(string8, objectArray);
                        X509Certificate x509Certificate = (X509Certificate)objectArray3[0];
                        if (x509Certificate == null) continue;
                        try {
                            x509Certificate.checkValidity();
                            continue;
                        }
                        catch (CertificateExpiredException certificateExpiredException) {
                            string8 = "isKeyEntry";
                            objectArray = new Object[]{string9};
                            Object[] objectArray4 = wSKeyStoreRemotable.invokeKeyStoreCommand(string8, objectArray);
                            if (bl.booleanValue() || !bl2.booleanValue()) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Keystore is file base, delete the cert!");
                            }
                            if (((Boolean)objectArray4[0]).booleanValue()) {
                                string8 = "deleteEntry";
                                objectArray = new Object[]{string9};
                                wSKeyStoreRemotable.invokeKeyStoreCommand(string8, objectArray);
                                string7 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.monitor.personal.delete.CWPKI0647I=", new Object[]{string9, string3}, "Personal certificate alias \"" + string9 + "\" was DELETED from KeyStore \"" + string3 + "\"", locale);
                                stringBuffer.append(string6);
                                stringBuffer.append(string7);
                            } else {
                                string8 = "deleteEntry";
                                objectArray = new Object[]{string9};
                                wSKeyStoreRemotable.invokeKeyStoreCommand(string8, objectArray);
                                string7 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.monitor.signer.delete.CWPKI0646I", new Object[]{string9, string3}, "Signer certificate alias \"" + string9 + "\" was DELETED from KeyStore \"" + string3 + "\"", locale);
                                stringBuffer.append(string6);
                                stringBuffer.append(string7);
                            }
                            PersonalCertificateHelper.setWorkspaceUpdated(session, keyStoreInfo2.getLocation());
                            continue;
                        }
                        catch (CertificateNotYetValidException certificateNotYetValidException) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Alias list is null for key store " + keyStoreInfo2.getName() + " could be that the mbean is not active.");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new Exception(exception.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteCerts");
        }
        return stringBuffer.toString();
    }

    public static String replaceCerts(Session session, KeyStoreInfo keyStoreInfo, String string, X509Certificate x509Certificate, String string2, X509Certificate x509Certificate2, Certificate[] certificateArray, Key key, boolean bl, Locale locale) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "replaceCerts");
        }
        ObjectName objectName = null;
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
        String string3 = keyStoreInfo.getName();
        String string4 = keyStoreInfo.getScopeNameString();
        String string5 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        objectName = configService.resolve(session, "Cell=:Security=")[0];
        BigInteger bigInteger = x509Certificate.getSerialNumber();
        String string6 = KeyStoreManager.getInstance().generateDigest("SHA-1", x509Certificate);
        List list = (List)configService.getAttribute(session, objectName, CommandConstants.KEY_STORES);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeList attributeList = (AttributeList)iterator.next();
            String string7 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "name");
            Boolean bl2 = (Boolean)ConfigServiceHelper.getAttributeValue(attributeList, "readOnly");
            Boolean bl3 = (Boolean)ConfigServiceHelper.getAttributeValue(attributeList, "fileBased");
            ObjectName objectName2 = (ObjectName)ConfigServiceHelper.getAttributeValue(attributeList, "managementScope");
            String string8 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "password");
            String string9 = (String)configService.getAttribute(session, objectName2, CommandConstants.SCOPE_NAME);
            if (string7.equals(string4) && string9.equals(string4)) continue;
            ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attributeList), null);
            KeyStoreInfo keyStoreInfo2 = PersonalCertificateHelper.getKsInfo(session, configService, string7, string9);
            WSKeyStoreRemotable wSKeyStoreRemotable = new WSKeyStoreRemotable(keyStoreInfo2);
            try {
                if (bl2.booleanValue() || !bl3.booleanValue()) continue;
                String string10 = "aliases";
                Object[] objectArray = null;
                Object[] objectArray2 = wSKeyStoreRemotable.invokeKeyStoreCommand(string10, objectArray);
                for (int i = 0; i < objectArray2.length; ++i) {
                    Object object;
                    String string11;
                    BigInteger bigInteger2;
                    String string12 = (String)objectArray2[i];
                    string10 = "isCertificateEntry";
                    objectArray = new Object[]{string12};
                    Object[] objectArray3 = wSKeyStoreRemotable.invokeKeyStoreCommand(string10, objectArray);
                    string10 = "isKeyEntry";
                    objectArray = new Object[]{string12};
                    Object[] objectArray4 = wSKeyStoreRemotable.invokeKeyStoreCommand(string10, objectArray);
                    string10 = "getCertificate";
                    objectArray = new Object[]{string12};
                    Object[] objectArray5 = wSKeyStoreRemotable.invokeKeyStoreCommand(string10, objectArray);
                    X509Certificate x509Certificate3 = (X509Certificate)objectArray5[0];
                    if (string2 == null) {
                        string2 = string12;
                    }
                    if (x509Certificate3 == null || (bigInteger2 = x509Certificate.getSerialNumber()).compareTo(bigInteger) != 0 || !(string11 = KeyStoreManager.getInstance().generateDigest("SHA-1", x509Certificate3)).equals(string6)) continue;
                    if (((Boolean)objectArray3[0]).booleanValue()) {
                        if (bl) {
                            string10 = "deleteEntry";
                            objectArray = new Object[]{string12};
                            wSKeyStoreRemotable.invokeKeyStoreCommand(string10, objectArray);
                        }
                        string10 = "setCertificateEntry";
                        objectArray = new Object[]{string12, x509Certificate2};
                        wSKeyStoreRemotable.invokeKeyStoreCommand(string10, objectArray);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Signer certificate " + string12 + " is being replaced in " + string7);
                        }
                        object = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.monitor.signer.replace.CWPKI0644I", new Object[]{string12, string7}, "Signer certificate alias \"" + string12 + "\" in KeyStore \"" + string7 + "\" was REPLACED.", locale);
                        stringBuffer.append(string5);
                        stringBuffer.append((String)object);
                        arrayList.add(objectNameArray[0]);
                        PersonalCertificateHelper.setWorkspaceUpdated(session, keyStoreInfo2.getLocation());
                    }
                    if (!((Boolean)objectArray4[0]).booleanValue() || key == null || certificateArray[0] == null || CertificateRequestHelper.isKeyCertReq(x509Certificate3, string12) != null) continue;
                    string10 = "setKeyEntry";
                    objectArray = new Object[]{string12, key, string8.toCharArray(), certificateArray};
                    object = wSKeyStoreRemotable.invokeKeyStoreCommand(string10, objectArray);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Personal certificate " + object + " is added to " + string7);
                    }
                    PersonalCertificateHelper.changeAliasReferences(session, keyStoreInfo2, string12, (String)object[0]);
                    arrayList.add(objectNameArray[0]);
                    PersonalCertificateHelper.setWorkspaceUpdated(session, keyStoreInfo2.getLocation());
                }
                if (arrayList == null || arrayList.size() <= 0) continue;
                PersonalCertificateHelper.markSSLConfigChanged(arrayList, session, configService, objectName);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred replacing signers.", new Object[]{exception});
                }
                throw exception;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "replaceCerts");
        }
        return stringBuffer.toString();
    }

    public static boolean isAliasInKeyStore(String string, KeyStore keyStore) throws KeyException {
        boolean bl = false;
        WSKeyStoreRemotable wSKeyStoreRemotable = new WSKeyStoreRemotable(keyStore);
        String string2 = "isKeyEntry";
        Object[] objectArray = new Object[]{string};
        Object[] objectArray2 = wSKeyStoreRemotable.invokeKeyStoreCommand(string2, objectArray);
        if (((Boolean)objectArray2[0]).booleanValue()) {
            string2 = "getCertificate";
            objectArray = new Object[]{string};
            Object[] objectArray3 = wSKeyStoreRemotable.invokeKeyStoreCommand(string2, objectArray);
            X509Certificate x509Certificate = (X509Certificate)objectArray3[0];
            if (CertificateRequestHelper.isKeyCertReq(x509Certificate, string) == null) {
                bl = true;
            }
        }
        return bl;
    }

    private static String genWorkspaceLocation(Session session, KeyStoreInfo keyStoreInfo, String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "genWorkspaceLocation");
        }
        String string = null;
        String string2 = keyStoreInfo.getLocation();
        String string3 = KeyStoreManager.getInstance().expand("${WORKSPACE_ROOT}/" + session.toString() + "/workspace/");
        int n = (string2 = string2.replace('\\', '/')).indexOf("cells/");
        if (n != -1) {
            String string4 = string2.substring(n);
            for (int i = 0; i < stringArray.length; ++i) {
                String string5 = stringArray[i].replace("//", "/");
                if (!string5.endsWith(string4)) continue;
                string = string3 + string4;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "genWorkspaceLocation -->" + string);
        }
        return string;
    }

    public static void setWorkspaceUpdated(Session session, String string) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setWorkspaceUpdated");
            }
            string = string.replace("\\", "/");
            try {
                String string2 = KeyStoreManager.getInstance().expand(string);
                WorkSpace workSpace = WorkSpaceManagerFactory.getManager().getWorkSpace(session.toString());
                int n = string2.indexOf("cells/" + ManagementScopeManager.getInstance().getCellName());
                if (n != -1) {
                    String string3 = string2.substring(n);
                    int n2 = string3.lastIndexOf("/");
                    String string4 = string3.substring(n2 + 1);
                    String string5 = string3.substring(0, n2);
                    RepositoryContext repositoryContext = workSpace.findContext(string5);
                    repositoryContext.notifyChanged(1, string4);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Exception updating workspace " + exception.getMessage());
            }
        }
    }

    private static String fixLocation(String string, String string2) {
        string2 = string2.replace('\\', '/');
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixLocation", new Object[]{string, string2});
        }
        int n = string2.indexOf("/cells/");
        String string3 = string2;
        if (n != -1) {
            String string4 = string2.substring(n);
            string3 = string + string4;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixLocation -> " + string3);
        }
        return string3;
    }

    public static void changeAliasReferences(Session session, KeyStoreInfo keyStoreInfo, String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeAliasReferences");
        }
        String string3 = null;
        String string4 = null;
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        Object var8_8 = null;
        ObjectName objectName3 = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        AttributeList attributeList = new AttributeList();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Replacing all references to certificate alias " + string + " with " + string2 + " in key store " + keyStoreInfo.getName());
        }
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            ObjectName objectName4;
            Object object5;
            Object object6;
            ConfigService configService = ConfigServiceFactory.getConfigService();
            objectName3 = configService.resolve(session, "Cell=:Security=")[0];
            string4 = keyStoreInfo.getName();
            objectName = keyStoreInfo.getScopeName();
            string3 = (String)configService.getAttribute(session, objectName, "scopeName");
            CommandHelper commandHelper = new CommandHelper();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, string4);
            objectName2 = commandHelper.getObjectName(configService, session, objectName3, CommandConstants.KEY_STORES, attributeList, string3);
            AttributeList attributeList2 = configService.getAttributes(session, objectName3, new String[]{CommandConstants.REPERTOIRE}, false);
            List list = (List)((Attribute)attributeList2.get(0)).getValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Looking at the repertoires.");
            }
            Object object7 = list.iterator();
            while (object7.hasNext()) {
                object6 = (ObjectName)object7.next();
                object5 = (AttributeList)configService.getAttribute(session, (ObjectName)object6, "setting");
                objectName4 = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName((AttributeList)object5), null)[0];
                object4 = (ObjectName)ConfigServiceHelper.getAttributeValue((AttributeList)object5, "keyStore");
                if (object4 == null) continue;
                object3 = new AttributeList();
                if (((ObjectName)object4).equals(objectName2)) {
                    object2 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)object5, "serverKeyAlias");
                    if (object2 != null && ((String)object2).equals(string)) {
                        ConfigServiceHelper.setAttributeValue((AttributeList)object3, "serverKeyAlias", string2);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Replacing serverKeyAlias");
                        }
                    }
                    if ((object = (String)ConfigServiceHelper.getAttributeValue((AttributeList)object5, "clientKeyAlias")) != null && ((String)object).equals(string)) {
                        ConfigServiceHelper.setAttributeValue((AttributeList)object3, "clientKeyAlias", string2);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Replacing clientKeyAlias");
                        }
                    }
                }
                if (!((ArrayList)object3).isEmpty()) {
                    configService.setAttributes(session, objectName4, (AttributeList)object3);
                    arrayList.add(object6);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Modify the alias in the config and save repertoire in list.");
                    }
                }
                ((ArrayList)object3).clear();
            }
            attributeList2.clear();
            if (!arrayList.isEmpty()) {
                attributeList2 = configService.getAttributes(session, objectName3, new String[]{CommandConstants.DYNAMIC_SSL_CONFIG_SELECTIONS}, false);
                object7 = (List)((Attribute)attributeList2.get(0)).getValue();
                object6 = object7.iterator();
                while (object6.hasNext()) {
                    object5 = (ObjectName)object6.next();
                    objectName4 = (ObjectName)configService.getAttribute(session, (ObjectName)object5, "sslConfig");
                    object4 = arrayList.iterator();
                    while (object4.hasNext()) {
                        object3 = (ObjectName)object4.next();
                        object2 = new AttributeList();
                        if (!((ObjectName)object3).equals(objectName4)) continue;
                        ((ArrayList)object2).clear();
                        object = (String)configService.getAttribute(session, (ObjectName)object5, "certificateAlias");
                        if (object == null || !((String)object).equals(string)) continue;
                        ConfigServiceHelper.setAttributeValue((AttributeList)object2, "certificateAlias", string2);
                        configService.setAttributes(session, (ObjectName)object5, (AttributeList)object2);
                    }
                }
                attributeList2.clear();
                attributeList2 = configService.getAttributes(session, objectName3, new String[]{CommandConstants.SSL_CONFIG_GROUPS}, false);
                object6 = (List)((Attribute)attributeList2.get(0)).getValue();
                object5 = object6.iterator();
                while (object5.hasNext()) {
                    objectName4 = (ObjectName)object5.next();
                    object4 = (ObjectName)configService.getAttribute(session, objectName4, "sslConfig");
                    object3 = arrayList.iterator();
                    while (object3.hasNext()) {
                        object2 = (ObjectName)object3.next();
                        object = new AttributeList();
                        if (!((ObjectName)object2).equals(object4)) continue;
                        ((ArrayList)object).clear();
                        String string5 = (String)configService.getAttribute(session, objectName4, "certificateAlias");
                        if (string5 == null || !string5.equals(string)) continue;
                        ConfigServiceHelper.setAttributeValue((AttributeList)object, "certificateAlias", string2);
                        configService.setAttributes(session, objectName4, (AttributeList)object);
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Certificate " + string + " is not used in the configuration.");
            }
            arrayList.clear();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception changing certificate references: " + exception.getMessage());
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "replaceAliasReferences");
        }
    }

    public static void markSSLConfigChanged(List list, Session session, ConfigService configService, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "markSSLConfigChanged");
        }
        for (int i = 0; i < list.size(); ++i) {
            ObjectName objectName2 = (ObjectName)list.get(i);
            try {
                AttributeList attributeList = configService.getAttributes(session, objectName, new String[]{CommandConstants.REPERTOIRE}, false);
                List list2 = (List)((Attribute)attributeList.get(0)).getValue();
                Iterator iterator = list2.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    String string = null;
                    ObjectName objectName3 = null;
                    ObjectName objectName4 = (ObjectName)iterator.next();
                    AttributeList attributeList2 = (AttributeList)configService.getAttribute(session, objectName4, CommandConstants.SETTING);
                    ObjectName objectName5 = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attributeList2), null)[0];
                    ObjectName objectName6 = (ObjectName)configService.getAttribute(session, objectName5, CommandConstants.KEY_STORE);
                    ObjectName objectName7 = (ObjectName)configService.getAttribute(session, objectName5, CommandConstants.TRUST_STORE);
                    if ((objectName6 == null || !objectName6.equals(objectName2)) && (objectName7 == null || !objectName7.equals(objectName2))) continue;
                    AttributeList attributeList3 = configService.getAttributes(session, objectName5, new String[]{CommandConstants.PROPERTIES}, false);
                    if (attributeList3 != null && attributeList3.size() > 0) {
                        List list3 = (List)((Attribute)attributeList3.get(0)).getValue();
                        object = list3.iterator();
                        while (object.hasNext()) {
                            objectName3 = (ObjectName)object.next();
                            String string2 = (String)configService.getAttribute(session, objectName3, "name");
                            if (!string2.equals("com.ibm.ssl.changed")) continue;
                            string = (String)configService.getAttribute(session, objectName3, "value");
                        }
                    }
                    int n = 0;
                    if (string != null) {
                        n = Integer.valueOf(string);
                        ++n;
                        configService.deleteConfigData(session, objectName3);
                    }
                    object = new AttributeList();
                    ((AttributeList)object).add(new Attribute(CommandConstants.NAME, "com.ibm.ssl.changed"));
                    ((AttributeList)object).add(new Attribute(CommandConstants.VALUE, String.valueOf(n)));
                    configService.createConfigData(session, objectName5, CommandConstants.PROPERTIES, null, (AttributeList)object);
                }
                continue;
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception while marking ssl config changed: " + exception.getMessage());
                }
                throw exception;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "markSSLConfigChanged");
        }
    }

    public static void markSSLConfigChanged(KeyStoreInfo keyStoreInfo, Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "markSSLConfigChanged");
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        String string = keyStoreInfo.getName();
        String string2 = keyStoreInfo.getScopeNameString();
        ObjectName objectName = null;
        ObjectName objectName2 = configService.resolve(session, "Cell=:Security=")[0];
        CommandHelper commandHelper = new CommandHelper();
        AttributeList attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, string);
        objectName = commandHelper.getObjectName(configService, session, objectName2, CommandConstants.KEY_STORES, attributeList, string2);
        if (objectName != null) {
            try {
                AttributeList attributeList2 = configService.getAttributes(session, objectName2, new String[]{CommandConstants.REPERTOIRE}, false);
                List list = (List)((Attribute)attributeList2.get(0)).getValue();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    String string3 = null;
                    ObjectName objectName3 = null;
                    ObjectName objectName4 = (ObjectName)iterator.next();
                    AttributeList attributeList3 = (AttributeList)configService.getAttribute(session, objectName4, CommandConstants.SETTING);
                    ObjectName objectName5 = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attributeList3), null)[0];
                    ObjectName objectName6 = (ObjectName)configService.getAttribute(session, objectName5, CommandConstants.KEY_STORE);
                    ObjectName objectName7 = (ObjectName)configService.getAttribute(session, objectName5, CommandConstants.TRUST_STORE);
                    if (!objectName6.equals(objectName) && !objectName7.equals(objectName)) continue;
                    AttributeList attributeList4 = configService.getAttributes(session, objectName5, new String[]{CommandConstants.PROPERTIES}, false);
                    if (attributeList4 != null && attributeList4.size() > 0) {
                        List list2 = (List)((Attribute)attributeList4.get(0)).getValue();
                        object = list2.iterator();
                        while (object.hasNext()) {
                            objectName3 = (ObjectName)object.next();
                            String string4 = (String)configService.getAttribute(session, objectName3, "name");
                            if (!string4.equals("com.ibm.ssl.changed")) continue;
                            string3 = (String)configService.getAttribute(session, objectName3, "value");
                        }
                    }
                    int n = 0;
                    if (string3 != null) {
                        n = Integer.valueOf(string3);
                        ++n;
                        configService.deleteConfigData(session, objectName3);
                    }
                    object = new AttributeList();
                    ((AttributeList)object).add(new Attribute(CommandConstants.NAME, "com.ibm.ssl.changed"));
                    ((AttributeList)object).add(new Attribute(CommandConstants.VALUE, String.valueOf(n)));
                    configService.createConfigData(session, objectName5, CommandConstants.PROPERTIES, null, (AttributeList)object);
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception while marking ssl config changed: " + exception.getMessage());
                }
                throw exception;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "markSSLConfigChanged");
        }
    }
}

