/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.personalCertificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.certificateRequests.CertificateRequestHelper;
import com.ibm.ws.ssl.commands.keyStores.KeyStoreHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.security.cert.X509Certificate;
import javax.management.ObjectName;

public class ExportCertificate
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ExportCertificate.class, "SSL", "com.ibm.ws.ssl.commands.personalCertificates");
    private String keyStoreName = null;
    private String keyStorePassword = null;
    private String keyFilePath = null;
    private String keyFilePathExpanded = null;
    private String keyFilePassword = null;
    private String keyFileType = null;
    private String aliasInKeyStore = null;
    private String certAlias = null;
    private String keyStoreScope = null;
    private KeyStoreInfo ksInfo = null;

    public ExportCertificate(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ExportCertificate(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        Object var1_1 = null;
        ObjectName objectName = null;
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName2 = configService.resolve(session, "Cell=")[0];
            objectName = configService.resolve(session, "Cell=:Security=")[0];
            String string = null;
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStorePassword = (String)this.getParameter(CommandConstants.KEY_STORE_PASSWORD);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.keyFilePath = (String)this.getParameter(CommandConstants.KEY_FILE_PATH);
            this.keyFilePassword = (String)this.getParameter(CommandConstants.KEY_FILE_PASSWORD);
            this.keyFileType = (String)this.getParameter(CommandConstants.KEY_FILE_TYPE);
            this.certAlias = (String)this.getParameter(CommandConstants.CERT_ALIAS);
            this.aliasInKeyStore = (String)this.getParameter(CommandConstants.NEW_CERT_ALIAS);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " keyFileName=" + string + " keyFileType=" + this.keyFileType + " certAlias=" + this.certAlias + " aliasInKeyStore=" + this.aliasInKeyStore);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultCellScope(objectName2);
                Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, configService, this.keyStoreName, this.keyStoreScope);
            this.keyFilePathExpanded = KeyStoreManager.getInstance().expand(this.keyFilePath);
            if (KeyStoreHelper.checkKeyFile(this.keyFileType, this.keyFilePathExpanded, this.keyFilePassword) != 0) {
                String string2 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.keyStore.check.key.file.CWPKI0663E", new Object[]{this.keyFilePath}, "Key store file \"" + this.keyFilePath + "\" did not verify, make sure the file exits, check key store type and password.");
                throw new CommandValidationException(string2);
            }
            if (KeyStoreHelper.checkKeyFile(this.ksInfo.getType(), this.ksInfo.getLocation(), this.keyStorePassword) != 0) {
                String string3 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.keyStore.check.key.file.CWPKI0663E", new Object[]{this.keyFilePath}, "Key store file \"" + this.ksInfo.getLocation() + "\" did not verify, make sure the file exists, check key store type and password.");
                throw new CommandValidationException(string3);
            }
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            throw new CommandValidationException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        boolean bl = false;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            this.personalCertificateExport(this.ksInfo, this.keyFilePath, this.keyFileType, this.keyFilePassword, this.certAlias, this.aliasInKeyStore);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.commands.ExportCertificate.afterStepsExecuted", "165", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred.", new Object[]{exception});
            }
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public void personalCertificateExport(KeyStoreInfo keyStoreInfo, String string, String string2, String string3, String string4, String string5) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "personalCertificateExport");
        }
        WSKeyStoreRemotable wSKeyStoreRemotable = new WSKeyStoreRemotable(keyStoreInfo);
        String string6 = null;
        String string7 = KeyStoreManager.getInstance().expand(string);
        if (string5 != null && !string5.trim().equals("")) {
            string6 = string5;
        }
        if (string6 == null) {
            string6 = string4;
        }
        String string8 = "getCertificate";
        Object[] objectArray = new Object[]{string4};
        Object[] objectArray2 = wSKeyStoreRemotable.invokeKeyStoreCommand(string8, objectArray);
        X509Certificate x509Certificate = (X509Certificate)objectArray2[0];
        if (CertificateRequestHelper.isKeyCertReq(x509Certificate, string4) != null) {
            String string9 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.in.keystore.CWPKI0672E", new Object[]{string4, keyStoreInfo.getLocation()}, "Alias \"" + string4 + "\" is not a personal certificate in key store \"" + keyStoreInfo.getLocation() + "\".");
            throw new CommandValidationException(string9);
        }
        string8 = "getCertificateChain";
        objectArray = new Object[]{string4};
        Object[] objectArray3 = wSKeyStoreRemotable.invokeKeyStoreCommand(string8, objectArray);
        string8 = "getKey";
        objectArray = new Object[]{string4, this.keyStorePassword.toCharArray()};
        Object[] objectArray4 = wSKeyStoreRemotable.invokeKeyStoreCommand(string8, objectArray);
        if (objectArray3[0] != null && objectArray4[0] != null) {
            string8 = "containsAliasFromUnManagedKeyStore";
            objectArray = new Object[]{string7, string2, string3 != null ? string3.toCharArray() : null, string6};
            Object[] objectArray5 = wSKeyStoreRemotable.invokeKeyStoreCommand(string8, objectArray);
            if (((Boolean)objectArray5[0]).booleanValue()) {
                String string10 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.alias.already.exists.CWPKI0630E", new Object[]{string6, string}, "Alias \"" + string6 + "\" already exists in key store \"" + string + "\".");
                throw new CommandValidationException(string10);
            }
        } else {
            String string11 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.in.keystore.CWPKI0672E", new Object[]{string4, keyStoreInfo.getLocation()}, "Alias \"" + string4 + "\" is not a personal certificate in key store \"" + keyStoreInfo.getLocation() + "\".");
            throw new CommandValidationException(string11);
        }
        string8 = "setKeyEntryFromUnManagedKeyStore";
        objectArray = new Object[]{string7, string2, string3 != null ? string3.toCharArray() : null, string6, objectArray3[0], objectArray4[0]};
        wSKeyStoreRemotable.invokeKeyStoreCommand(string8, objectArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "personalCertificateExport");
        }
    }
}

