/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.personalCertificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.certclient.util.PkSsCertFactory;
import com.ibm.security.certclient.util.PkSsCertificate;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.CertReqInfo;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.management.ObjectName;

public class CreateSelfSignedCertificate
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateSelfSignedCertificate.class, "SSL", "com.ibm.ws.ssl.commands.personalCertificates");
    private String keyStoreName = null;
    private String keyStoreScope = null;
    private String certLabel = null;
    private String certCommonName = null;
    private String certOrganization = null;
    private String certOrganizationalUnit = null;
    private int certSize = 0;
    private String certVersion = null;
    private String certZip = null;
    private String certCountry = null;
    private int certValidDays = 0;
    private String certLocality = null;
    private String certState = null;
    private KeyStoreInfo ksInfo = null;
    private CertReqInfo certInfo = null;

    public CreateSelfSignedCertificate(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public CreateSelfSignedCertificate(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        Object var3_3 = null;
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            objectName = ConfigServiceHelper.createObjectName(null, "Security");
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName2 = configService.queryConfigObjects(session, objectName3, objectName, null)[0];
            }
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.certLabel = (String)this.getParameter(CommandConstants.CERT_ALIAS);
            this.certCommonName = (String)this.getParameter(CommandConstants.CERT_COMMON_NAME);
            this.certSize = (Integer)this.getParameter(CommandConstants.CERT_SIZE);
            this.certOrganization = (String)this.getParameter(CommandConstants.CERT_ORGANIZATION);
            this.certOrganizationalUnit = (String)this.getParameter(CommandConstants.CERT_ORGANIZATIONAL_UNIT);
            this.certLocality = (String)this.getParameter(CommandConstants.CERT_LOCALITY);
            this.certState = (String)this.getParameter(CommandConstants.CERT_STATE);
            this.certZip = (String)this.getParameter(CommandConstants.CERT_ZIP);
            this.certCountry = (String)this.getParameter(CommandConstants.CERT_COUNTRY);
            this.certVersion = (String)this.getParameter(CommandConstants.CERT_VERSION);
            this.certValidDays = (Integer)this.getParameter(CommandConstants.CERT_DAYS);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " certlabel=" + this.certLabel + " certCommonName=" + this.certCommonName + " certSize=" + this.certSize + " certOrganization=" + this.certOrganization + " certOrganizationalUnit=" + this.certOrganizationalUnit + " certLocality=" + this.certLocality + " certState=" + this.certState + " certZip=" + this.certZip + " certCountry=" + this.certCountry + " certVersion=" + this.certVersion + " certValidDays=" + this.certValidDays);
            }
            if (this.certValidDays < 1 || this.certValidDays > 7300) {
                String string = TraceNLSHelper.getInstance().getString("ssl.command.object.exists.CWPKI0628E=CWPKI0628E", "Valid days parameter is out of range.  It should be between 1 and 7300 days.");
                throw new CommandValidationException(string);
            }
            String string = this.makeSubjectDN(this.certCommonName, this.certOrganization, this.certOrganizationalUnit, this.certLocality, this.certState, this.certZip, this.certCountry);
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultCellScope(objectName3);
                Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, configService, this.keyStoreName, this.keyStoreScope);
            this.certInfo = new CertReqInfo(this.certLabel, this.certSize, string, this.certValidDays, this.ksInfo, null);
        }
        catch (ConfigServiceException configServiceException) {
            String string = configServiceException.getMessage();
            throw new CommandValidationException(string);
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            throw new CommandValidationException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        boolean bl = false;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            bl = this.personalCertificateCreate(this.certInfo);
            taskCommandResultImpl.setResult(new Boolean(bl));
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public String makeSubjectDN(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws CommandValidationException {
        String string8 = null;
        if (string == null || string.length() == 0) {
            String string9 = "CommonName is missing, unable to create the Certificate.";
            throw new CommandValidationException(string9);
        }
        string8 = "CN=" + string;
        if (string3 != null && string3.length() != 0) {
            string8 = string8 + ", OU=" + string3;
        }
        if (string2 == null || string2.length() == 0) {
            String string10 = "Organization is missing, unable to create the Certificate.";
            throw new CommandValidationException(string10);
        }
        string8 = string8 + ", O=" + string2;
        if (string4 != null && string4.length() != 0) {
            string8 = string8 + ", L=" + string4;
        }
        if (string5 != null && string5.length() != 0) {
            string8 = string8 + ", ST=" + string5;
        }
        if (string6 != null && string6.length() != 0) {
            string8 = string8 + ", POSTALCODE=" + string6;
        }
        if (string7 == null || string7.length() == 0) {
            String string11 = "Country is missing, unable to create the Certificate.";
            throw new CommandValidationException(string11);
        }
        string8 = string8 + ", C=" + string7;
        return string8;
    }

    public boolean personalCertificateCreate(CertReqInfo certReqInfo) throws Exception {
        boolean bl = false;
        String string = null;
        String string2 = null;
        int n = 0;
        int n2 = 0;
        KeyStoreInfo keyStoreInfo = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        string2 = certReqInfo.getSubjectDN();
        string = certReqInfo.getLabel();
        n = certReqInfo.getSize();
        n2 = certReqInfo.getValidDays();
        keyStoreInfo = certReqInfo.getKsInfo();
        string3 = keyStoreInfo.getProvider();
        string5 = keyStoreInfo.getType();
        string4 = keyStoreInfo.getPassword();
        WSKeyStoreRemotable wSKeyStoreRemotable = new WSKeyStoreRemotable(keyStoreInfo);
        PkSsCertificate pkSsCertificate = null;
        X509Certificate x509Certificate = null;
        PrivateKey privateKey = null;
        String string6 = "containsAlias";
        Object[] objectArray = new Object[]{string};
        Object[] objectArray2 = wSKeyStoreRemotable.invokeKeyStoreCommand(string6, objectArray);
        if (((Boolean)objectArray2[0]).booleanValue()) {
            String string7 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.alias.already.exists.CWPKI0630E", new Object[]{string, keyStoreInfo.getName()}, "Alias \"" + string + " already exists in key store \"" + keyStoreInfo.getName() + "\".");
            throw new CommandValidationException(string7);
        }
        if (string5 != null && (string5.equals("CMSKS") || string5.equals("IBMi5OSKeyStore"))) {
            string3 = JSSEProviderFactory.isFipsEnabled() ? "IBMJCEFIPS" : "IBMJCE";
        }
        Date date = new Date();
        date.setTime(date.getTime() - 86400000L);
        pkSsCertificate = PkSsCertFactory.newSsCert((int)n, (String)string2, (int)n2, (Date)date, (boolean)true, (boolean)true, (String)string3);
        if (pkSsCertificate != null) {
            x509Certificate = pkSsCertificate.getCertificate();
            privateKey = pkSsCertificate.getKey();
            string6 = "setKeyEntry";
            objectArray = new Object[]{string, privateKey, string4.toCharArray(), new X509Certificate[]{x509Certificate}};
            wSKeyStoreRemotable.invokeKeyStoreCommand(string6, objectArray);
            bl = true;
            try {
                Tr.audit(tc, "Self Signed Certificate: notBefore time: " + x509Certificate.getNotBefore().toString() + " notAfter time: " + x509Certificate.getNotAfter().toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (bl) {
            Session session = this.getConfigSession();
            PersonalCertificateHelper.setWorkspaceUpdated(session, certReqInfo.getKsInfo().getLocation());
            PersonalCertificateHelper.markSSLConfigChanged(certReqInfo.getKsInfo(), session);
        }
        return bl;
    }
}

