/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.keyStores;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.ws.ssl.commands.certificateRequests.CertificateRequestHelper;
import com.ibm.ws.ssl.commands.keyStores.KeyStoreHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.WSKeyStore;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;

public class ListKeyFileAliases
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListKeyFileAliases.class, "SSL", "com.ibm.ws.ssl.commands.keyStores");
    private String keyFilePath = null;
    private String keyFilePassword = null;
    private String keyFileType = null;

    public ListKeyFileAliases(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ListKeyFileAliases(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        InputStream inputStream = null;
        KeyStore keyStore = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            this.keyFilePath = (String)this.getParameter(CommandConstants.KEY_FILE_PATH);
            this.keyFilePassword = (String)this.getParameter(CommandConstants.KEY_FILE_PASSWORD);
            this.keyFileType = (String)this.getParameter(CommandConstants.KEY_FILE_TYPE);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ListKeyFileAliases parameters:  keyFilePath=" + this.keyFilePath + " keyFilePassword=***** keyFileType=" + this.keyFileType);
            }
            if (KeyStoreHelper.checkKeyFile(this.keyFileType, this.keyFilePath, this.keyFilePassword) != 0) {
                String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.keyStore.check.key.file.CWPKI0663E", new Object[]{this.keyFilePath}, "Key store file \"" + this.keyFilePath + "\" did not verify, check key store type and password.");
                throw new CommandValidationException(string);
            }
            keyStore = WSKeyStore.loadKeyStore(this.keyFilePath, this.keyFileType, this.keyFilePassword);
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                X509Certificate x509Certificate;
                String string = enumeration.nextElement();
                if (!keyStore.isKeyEntry(string) || (x509Certificate = (X509Certificate)keyStore.getCertificate(string)) == null || CertificateRequestHelper.isKeyCertReq(x509Certificate, string) != null) continue;
                arrayList.add(string);
            }
            if (inputStream != null) {
                inputStream.close();
            }
            taskCommandResultImpl.setResult(arrayList);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

