/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.keyStores;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ssl.commands.ManagementScope.ManagementScopeHelper;
import com.ibm.ws.ssl.commands.keyStores.KeyStoreHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeData;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.File;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateKeyStore
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateKeyStore.class, "SSL", "com.ibm.ws.ssl.commands.keyStores");
    private String keyStoreName = null;
    private String keyStoreLocation = null;
    private String keyStoreType = null;
    private String keyStorePassword = null;
    private String keyStorePasswordVerify = null;
    private String keyStoreHostList = null;
    private String keyStoreProvider = null;
    private Boolean keyStoreIsFileBased = null;
    private Boolean keyStoreReadOnly = null;
    private Boolean keyStoreInitAtStartup = null;
    private String keyStoreCustomProvider = null;
    private Boolean keyStoreStashFile = null;
    private String scopeName = null;
    private Boolean keyStoreForAcceleration = null;
    private boolean createKeyFile = true;
    private ObjectName mgmScopeObjName = null;
    private boolean createMgmScope = false;

    public CreateKeyStore(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public CreateKeyStore(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        ObjectName objectName3 = null;
        Object var6_6 = null;
        boolean bl = false;
        try {
            Object object;
            objectName = ConfigServiceHelper.createObjectName(null, "Security");
            objectName2 = configService.resolve(session, "Cell=")[0];
            if (objectName2 != null) {
                objectName3 = configService.queryConfigObjects(session, objectName2, objectName, null)[0];
            }
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreLocation = (String)this.getParameter(CommandConstants.KEY_STORE_LOCATION);
            this.keyStoreType = (String)this.getParameter(CommandConstants.KEY_STORE_TYPE);
            this.keyStorePassword = (String)this.getParameter(CommandConstants.KEY_STORE_PASSWORD);
            this.keyStorePasswordVerify = (String)this.getParameter(CommandConstants.KEY_STORE_PASSWORD_VERIFY);
            this.keyStoreHostList = (String)this.getParameter(CommandConstants.KEY_STORE_HOST_LIST);
            this.keyStoreProvider = (String)this.getParameter(CommandConstants.KEY_STORE_PROVIDER);
            this.keyStoreIsFileBased = (Boolean)this.getParameter(CommandConstants.KEY_STORE_IS_FILE_BASED);
            this.keyStoreReadOnly = (Boolean)this.getParameter(CommandConstants.KEY_STORE_READ_ONLY);
            this.keyStoreInitAtStartup = (Boolean)this.getParameter(CommandConstants.KEY_STORE_INIT_AT_STARTUP);
            this.keyStoreStashFile = (Boolean)this.getParameter(CommandConstants.KEY_STORE_STASH_FILE);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.keyStoreForAcceleration = (Boolean)this.getParameter(CommandConstants.KEY_STORE_ACCELERATION);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " keyStoreLocation=" + this.keyStoreLocation + " keyStoreType=" + this.keyStoreType + " keyStorePassword=" + this.keyStorePassword + " keyStoreHostList=" + this.keyStoreHostList + " keyStoreProvider=" + this.keyStoreProvider + " keyStoreIsFileBased=" + this.keyStoreIsFileBased + " keyStoreReadOnly=" + this.keyStoreReadOnly + " keyStoreInitAtStartup=" + this.keyStoreInitAtStartup + " keyStoreCustomProvider=" + this.keyStoreCustomProvider + " keyStoreStashFile=" + this.keyStoreStashFile + " scopeName=" + this.scopeName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(objectName2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
                }
            } else if (!ManagementScopeHelper.validScopeName(session, configService, this.scopeName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not a valid management scope name: " + this.scopeName);
                }
                String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.scope.not.valid.CWPKI0604E", new Object[]{this.scopeName}, "The following Management scope is not valid: " + this.scopeName);
                throw new CommandValidationException(string);
            }
            if (this.keyStoreType.indexOf("(PKCS11)") >= 0) {
                this.keyStoreType = "PKCS11";
            }
            if (this.keyStoreType.equals("PKCS11") || this.keyStoreType.equals("JCERACFKS") || this.keyStoreType.equals("JCECCARACFKS")) {
                this.keyStoreIsFileBased = Boolean.FALSE;
            }
            if (this.keyStoreType.equals("JCERACFKS") || this.keyStoreType.equals("JCECCARACFKS")) {
                this.keyStoreReadOnly = Boolean.TRUE;
            }
            if (this.keyStoreForAcceleration == null || !this.keyStoreForAcceleration.booleanValue()) {
                if (this.keyStorePassword != null && this.keyStorePasswordVerify == null || this.keyStorePassword == null && this.keyStorePasswordVerify != null || this.keyStorePassword == null && this.keyStorePasswordVerify == null) {
                    String string = TraceNLSHelper.getInstance().getString("ssl.command.password.missing.CWPKI0632E", "Both password and verify password were not supplied.");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Both password and verify password were not supplied.");
                    }
                    throw new CommandValidationException(string);
                }
                if (!KeyStoreHelper.passwordVerify(this.keyStorePassword, this.keyStorePasswordVerify)) {
                    String string = TraceNLSHelper.getInstance().getString("ssl.command.keyStore.password.not.confirm.CWPKI0619E", "Passwords do not match.");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Password did not verify.");
                    }
                    throw new CommandValidationException(string);
                }
            }
            if (this.keyStoreProvider == null) {
                if (this.keyStoreType.equals("CMSKS")) {
                    this.keyStoreProvider = "IBMCMSProvider";
                } else if (this.keyStoreType.equals("IBMi5OSKeyStore")) {
                    this.keyStoreProvider = "IBMi5OSJSSEProvider";
                } else if (this.keyStoreType.equals("PKCS11")) {
                    this.keyStoreProvider = "PKCS11";
                } else if (this.keyStoreType.equals("PKCS12") || this.keyStoreType.equals("JKS") || this.keyStoreType.equals("JCEKS")) {
                    this.keyStoreProvider = "IBMJCE";
                } else if (this.keyStoreType.equals("JCECCAKS") || this.keyStoreType.equals("JCECCARACFKS")) {
                    this.keyStoreProvider = "IBMJCECCA";
                }
            }
            if (this.keyStoreIsFileBased != null && !this.keyStoreIsFileBased.booleanValue()) {
                this.createKeyFile = false;
            }
            if (this.keyStoreHostList == null) {
                if (this.keyStoreIsFileBased.booleanValue()) {
                    int n = KeyStoreHelper.checkKeyFile(this.keyStoreType, KeyStoreManager.getInstance().expand(this.keyStoreLocation), this.keyStorePassword);
                    if (n == 1 && (this.keyStoreType.equals("PKCS12") || this.keyStoreType.equals("JKS") || this.keyStoreType.equals("JCEKS")) && !((File)(object = new File(KeyStoreManager.getInstance().expand(this.keyStoreLocation)))).isAbsolute()) {
                        this.keyStoreLocation = KeyStoreManager.getInstance().expand("${USER_INSTALL_ROOT}" + File.separator + "etc" + File.separator + object);
                        n = KeyStoreHelper.checkKeyFile(this.keyStoreType, KeyStoreManager.getInstance().expand(this.keyStoreLocation), this.keyStorePassword);
                    }
                    if (n == 1) {
                        this.createKeyFile = true;
                    } else if (n == 0) {
                        this.createKeyFile = false;
                    } else if (n == 2 || n == 3) {
                        object = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.keyStore.check.key.file.CWPKI0663E", new Object[]{this.keyStoreLocation}, "Key store file \"" + this.keyStoreLocation + "\" did not verify, check key store type and password.");
                        throw new CommandValidationException((String)object);
                    }
                }
                if (this.keyStoreReadOnly != null && this.keyStoreReadOnly.booleanValue() && this.keyStoreType.equalsIgnoreCase("PKCS11")) {
                    File file = new File(KeyStoreManager.getInstance().expand(this.keyStoreLocation));
                    if (file == null || !file.isFile() || !file.canRead()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Key store file \"" + this.keyStoreLocation + "\" does not exist.");
                        }
                        object = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.check.file.CWPKI0673E", new Object[]{this.keyStoreLocation}, "Creating a read only key store object.  File \"" + this.keyStoreLocation + "\" should already exist.");
                        throw new CommandValidationException((String)object);
                    }
                    this.createKeyFile = false;
                }
                if (this.keyStoreForAcceleration != null && this.keyStoreForAcceleration.booleanValue()) {
                    File file = new File(KeyStoreManager.getInstance().expand(this.keyStoreLocation));
                    if (file == null || !file.isFile() || !file.canRead()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "File \"" + this.keyStoreLocation + "\" does not exist.");
                        }
                        if (this.keyStoreForAcceleration != null && this.keyStoreForAcceleration.booleanValue()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Crypto operations config file does not exist.");
                            }
                            object = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.check.acceleration.file.CWPKI0664E", new Object[]{this.keyStoreLocation}, "Cryptographic operations configuration file \"" + this.keyStoreLocation + "\"does not exist.");
                            throw new Exception((String)object);
                        }
                    }
                    this.createKeyFile = false;
                }
            } else {
                AdminService adminService = AdminServiceFactory.getAdminService();
                object = adminService.getProcessType();
                if (object != null && ((String)object).equals("UnManagedProcess")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Can not remotely manage key stores from a base application server.");
                    }
                    String string = TraceNLSHelper.getInstance().getString("ssl.command.not.remote.CWPKI0669E", "Key stores and certificates can not be remotely managed from a base application server.");
                    throw new Exception(string);
                }
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.keyStoreName);
            bl = commandHelper.exists(configService, session, objectName3, CommandConstants.KEY_STORES, attributeList, this.scopeName);
            if (bl) {
                object = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.already.exists.CWPKI0601E", new Object[]{this.keyStoreName, this.scopeName}, this.keyStoreName + " in the management scope " + this.scopeName + " already exists.");
                throw new CommandValidationException((String)object);
            }
            if (this.keyStoreForAcceleration != null && !this.keyStoreType.equals("PKCS11")) {
                object = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.keystore.hardware.CWPKI0658E", new Object[]{"PKCS11"}, "Key store types for hardware devices must be PKCS11");
                throw new CommandValidationException((String)object);
            }
            attributeList.clear();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_NAME, this.scopeName);
            boolean bl2 = commandHelper.exists(configService, session, objectName3, CommandConstants.MANAGEMENT_SCOPES, attributeList, null);
            if (!bl2) {
                this.createMgmScope = true;
            } else {
                this.mgmScopeObjName = commandHelper.getObjectName(configService, session, objectName3, CommandConstants.MANAGEMENT_SCOPES, attributeList, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "mgmScopeObjName: " + this.mgmScopeObjName);
                }
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConfigService exception is" + configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        AttributeList attributeList = new AttributeList();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            Object object;
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            objectName2 = configService.resolve(session, "Cell=:Security=")[0];
            if (this.createMgmScope) {
                object = new ManagementScopeData(this.scopeName);
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_NAME, this.scopeName);
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_TYPE, ((ManagementScopeData)object).getScopeType());
                this.mgmScopeObjName = configService.createConfigData(session, objectName2, CommandConstants.MANAGEMENT_SCOPES, null, attributeList);
                attributeList.clear();
            }
            object = new KeyStoreInfo(this.keyStoreName, this.keyStoreLocation, this.keyStorePassword, this.keyStoreProvider, this.keyStoreType, this.keyStoreIsFileBased, this.keyStoreHostList, this.scopeName, this.mgmScopeObjName, this.keyStoreReadOnly, this.keyStoreInitAtStartup, this.keyStoreStashFile, this.keyStoreCustomProvider, null, this.keyStoreForAcceleration, null);
            objectName = KeyStoreHelper.createKeyStoreCmd(session, (KeyStoreInfo)object, this.createKeyFile);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.MANAGEMENT_SCOPE, this.mgmScopeObjName);
            configService.setAttributes(session, objectName, attributeList);
            attributeList.clear();
            taskCommandResultImpl.setResult(objectName);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

