/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.keyStores;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.models.config.ipc.ssl.KeyStore;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.ssl.commands.keyStores.KeyStoreHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ChangeMultipleKeyStorePasswords
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ChangeMultipleKeyStorePasswords.class, "SSL", "com.ibm.ws.ssl.commands.keyStores");
    private String keyStorePassword = null;
    private String newKeyStorePassword = null;
    private String newKeyStorePasswordVerify = null;

    public ChangeMultipleKeyStorePasswords(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ChangeMultipleKeyStorePasswords(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        Object var3_3 = null;
        Object var4_4 = null;
        Object var5_5 = null;
        try {
            this.keyStorePassword = (String)this.getParameter(CommandConstants.KEY_STORE_PASSWORD);
            this.newKeyStorePassword = (String)this.getParameter(CommandConstants.NEW_KEY_STORE_PASSWORD);
            this.newKeyStorePasswordVerify = (String)this.getParameter(CommandConstants.NEW_KEY_STORE_PASSWORD_VERIFY);
            if (!KeyStoreHelper.passwordVerify(this.newKeyStorePassword, this.newKeyStorePasswordVerify)) {
                String string = TraceNLSHelper.getInstance().getString("ssl.command.keyStore.password.not.confirm.CWPKI0619E", "Passwords do not match.");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Password do not match during password conformation.");
                }
                throw new CommandValidationException(string);
            }
        }
        catch (Exception exception) {
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        Object var1_1 = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            List list = this.changeKSPasswords(this.keyStorePassword, this.newKeyStorePassword);
            taskCommandResultImpl.setResult(list);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private List changeKSPasswords(String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeKSPasswords");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ObjectName objectName = null;
        AttributeList attributeList = new AttributeList();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        objectName = configService.resolve(session, "Cell=:Security=")[0];
        AttributeList attributeList2 = configService.getAttributes(session, objectName, new String[]{"keyStores"}, false);
        List list = (List)((Attribute)attributeList2.get(0)).getValue();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Serializable serializable;
            String string3;
            ObjectName objectName2 = (ObjectName)iterator.next();
            Boolean bl = (Boolean)configService.getAttribute(session, objectName2, "readOnly");
            Boolean bl2 = (Boolean)configService.getAttribute(session, objectName2, "fileBased");
            String string4 = (String)configService.getAttribute(session, objectName2, "type");
            if (bl == null || bl.booleanValue() || bl2 == null || !bl2.booleanValue() || !string.equals(string3 = (String)configService.getAttribute(session, objectName2, "password"))) continue;
            KeyStore keyStore = (KeyStore)MOFUtil.convertToEObject((Session)session, (ObjectName)objectName2);
            if (string4.equals("CMSKS") || string4.equals("IBMi5OSKeyStore")) {
                serializable = KeyStoreHelper.makeKsInfo(keyStore);
                KeyStoreHelper.changePasswordCMS((KeyStoreInfo)serializable, string2);
            } else if (string4.equals("PKCS12")) {
                serializable = KeyStoreHelper.makeKsInfo(keyStore);
                KeyStoreHelper.changePasswordPKCS12((KeyStoreInfo)serializable, string2);
            } else {
                serializable = new WSKeyStoreRemotable(keyStore);
                KeyStoreHelper.changePassword((WSKeyStoreRemotable)serializable, this.keyStorePassword, string2);
            }
            attributeList.clear();
            ConfigServiceHelper.setAttributeValue(attributeList, "password", string2);
            configService.setAttributes(session, objectName2, attributeList);
            serializable = configService.getAttributes(session, objectName, new String[]{CommandConstants.KEY_SETS}, false);
            List list2 = (List)((Attribute)((ArrayList)serializable).get(0)).getValue();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                String string5;
                ObjectName objectName3 = (ObjectName)iterator2.next();
                ObjectName objectName4 = (ObjectName)configService.getAttribute(session, objectName3, CommandConstants.KEY_STORE);
                if (objectName4 == null || !objectName4.equals(objectName4) || (string5 = (String)configService.getAttribute(session, objectName3, "password")) == null) continue;
                attributeList2.clear();
                ConfigServiceHelper.setAttributeValue(attributeList2, "password", string2);
                configService.setAttributes(session, objectName3, attributeList2);
            }
            configService.save(session, true);
            arrayList.add(keyStore.getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeKSPasswords");
        }
        return arrayList;
    }
}

