/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.keyStores;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ssl.commands.keyStores.KeyStoreHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ChangeKeyStorePassword
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ChangeKeyStorePassword.class, "SSL", "com.ibm.ws.ssl.commands.keyStores");
    private String keyStoreName = null;
    private String scopeName = null;
    private String keyStorePassword = null;
    private String newKeyStorePassword = null;
    private String newKeyStorePasswordVerify = null;
    ObjectName keyStoreObjName = null;
    KeyStoreInfo ksInfo = null;

    public ChangeKeyStorePassword(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ChangeKeyStorePassword(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        ObjectName objectName3 = null;
        try {
            objectName = ConfigServiceHelper.createObjectName(null, "Security");
            objectName2 = configService.resolve(session, "Cell=")[0];
            if (objectName2 != null) {
                objectName3 = configService.queryConfigObjects(session, objectName2, objectName, null)[0];
            }
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.keyStorePassword = (String)this.getParameter(CommandConstants.KEY_STORE_PASSWORD);
            this.newKeyStorePassword = (String)this.getParameter(CommandConstants.NEW_KEY_STORE_PASSWORD);
            this.newKeyStorePasswordVerify = (String)this.getParameter(CommandConstants.NEW_KEY_STORE_PASSWORD_VERIFY);
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(objectName2);
                Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.keyStoreName);
            this.keyStoreObjName = commandHelper.getObjectName(configService, session, objectName3, CommandConstants.KEY_STORES, attributeList, this.scopeName);
            if (this.keyStoreObjName == null) {
                String string = this.keyStoreName + " object not found.";
                throw new CommandValidationException(string);
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, configService, this.keyStoreName, this.scopeName);
            if (this.ksInfo == null) {
                String string = this.keyStoreName + " object not found.";
                throw new CommandValidationException(string);
            }
            if (!PersonalCertificateHelper.verifyKeyPassword(this.ksInfo, this.keyStorePassword)) {
                String string = TraceNLSHelper.getInstance().getString("sl.command.check.key.store.CWPKI0671E", "Key store did not verify.  Make sure the file exists, check the key file type and password.");
                throw new CommandValidationException(string);
            }
            if (!KeyStoreHelper.passwordVerify(this.newKeyStorePassword, this.newKeyStorePasswordVerify)) {
                String string = TraceNLSHelper.getInstance().getString("ssl.command.keyStore.password.not.confirm.CWPKI0619E", "Passwords do not match.");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Password do not match during password conformation.");
                }
                throw new CommandValidationException(string);
            }
        }
        catch (ConfigServiceException configServiceException) {
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        Object var1_1 = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            this.changeKSPassword(this.ksInfo, this.newKeyStorePassword);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private void changeKSPassword(KeyStoreInfo keyStoreInfo, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeKSPassword");
        }
        Boolean bl = keyStoreInfo.getReadOnly();
        Boolean bl2 = keyStoreInfo.getFileBased();
        String string2 = keyStoreInfo.getPassword();
        String string3 = keyStoreInfo.getType();
        Object var7_7 = null;
        String string4 = keyStoreInfo.getLocation();
        String string5 = KeyStoreManager.getInstance().expand(string4);
        if (bl != null && !bl.booleanValue() && bl2.booleanValue()) {
            Object object;
            if (string3.equals("CMSKS") || string3.equals("IBMi5OSKeyStore")) {
                KeyStoreHelper.changePasswordCMS(keyStoreInfo, string);
            } else if (string3.equals("PKCS12")) {
                KeyStoreHelper.changePasswordPKCS12(keyStoreInfo, string);
            } else {
                object = new WSKeyStoreRemotable(keyStoreInfo);
                KeyStoreHelper.changePassword((WSKeyStoreRemotable)object, string2, string);
            }
            try {
                Comparable<File> comparable;
                Object object2;
                Object object3;
                object = ConfigServiceFactory.getConfigService();
                Session session = this.getConfigSession();
                ObjectName objectName = object.resolve(session, "Cell=:Security=")[0];
                AttributeList attributeList = new AttributeList();
                ConfigServiceHelper.setAttributeValue(attributeList, "password", string);
                object.setAttributes(session, this.keyStoreObjName, attributeList);
                PersonalCertificateHelper.setWorkspaceUpdated(session, keyStoreInfo.getLocation());
                if (keyStoreInfo.getStashFile().booleanValue()) {
                    object3 = keyStoreInfo.getLocation();
                    object2 = null;
                    int n = ((String)object3).lastIndexOf(".");
                    object2 = n != -1 ? ((String)object3).substring(0, n + 1) + "sth" : (String)object3 + ".sth";
                    if (object2 != null && ((File)(comparable = new File((String)object2))).isFile() && ((File)comparable).canWrite()) {
                        PersonalCertificateHelper.setWorkspaceUpdated(session, (String)object2);
                    }
                }
                object3 = object.getAttributes(session, objectName, new String[]{CommandConstants.KEY_SETS}, false);
                object2 = (List)((Attribute)((ArrayList)object3).get(0)).getValue();
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    String string6;
                    comparable = (ObjectName)iterator.next();
                    ObjectName objectName2 = (ObjectName)object.getAttribute(session, (ObjectName)comparable, CommandConstants.KEY_STORE);
                    if (objectName2 == null || !objectName2.equals(this.keyStoreObjName) || (string6 = (String)object.getAttribute(session, (ObjectName)comparable, "password")) == null) continue;
                    attributeList.clear();
                    ConfigServiceHelper.setAttributeValue(attributeList, "password", string);
                    object.setAttributes(session, (ObjectName)comparable, attributeList);
                }
                object.save(session, true);
            }
            catch (Exception exception) {
                throw new Exception(exception);
            }
        } else {
            String string7 = TraceNLSHelper.getInstance().getString("sl.command.check.key.store.CWPKI0670E", "Unable to change the key store password.  The key store is either a read only store or it is not a file based key store.");
            throw new CommandValidationException(string7);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeKSPassword");
        }
    }
}

