/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.dynamicSSLConfigSelections;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DeleteDynamicSSLConfigSelection
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(DeleteDynamicSSLConfigSelection.class, "SSL", "com.ibm.ws.ssl.commands.keyStores");
    private String dynSSLName = null;
    private String scopeName = null;
    private ObjectName dynSSLObjName = null;

    public DeleteDynamicSSLConfigSelection(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public DeleteDynamicSSLConfigSelection(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        ObjectName objectName3 = null;
        boolean bl = false;
        try {
            objectName = ConfigServiceHelper.createObjectName(null, "Security");
            objectName2 = configService.resolve(session, "Cell=")[0];
            if (objectName2 != null) {
                objectName3 = configService.queryConfigObjects(session, objectName2, objectName, null)[0];
            }
            this.dynSSLName = (String)this.getParameter(CommandConstants.DYN_SSL_CFG_NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(objectName2);
                Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.dynSSLName);
            boolean bl2 = commandHelper.exists(configService, session, objectName3, CommandConstants.DYNAMIC_SSL_CONFIG_SELECTIONS, attributeList, this.scopeName);
            if (!bl2) {
                String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.already.exists.CWPKI0600E", new Object[]{this.dynSSLName, this.scopeName}, this.dynSSLName + " does not exist within the management scope " + this.scopeName);
                throw new CommandValidationException(string);
            }
            this.dynSSLObjName = commandHelper.getObjectName(configService, session, objectName3, CommandConstants.DYNAMIC_SSL_CONFIG_SELECTIONS, attributeList, this.scopeName);
        }
        catch (ConfigServiceException configServiceException) {
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.afterStepsExecuted();
        ObjectName objectName = null;
        Object var2_2 = null;
        boolean bl = false;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "Security");
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            configService.deleteConfigData(session, this.dynSSLObjName);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

