/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.dynamicSSLConfigSelections;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.ssl.commands.ManagementScope.ManagementScopeHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.ManagementScopeData;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import java.io.InputStream;
import java.security.KeyStore;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateDynamicSSLConfigSelection
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateDynamicSSLConfigSelection.class, "SSL", "com.ibm.ws.ssl.commands.dynamicSSLConfigSelection");
    private String dynSSLName = null;
    private String description = null;
    private String info = null;
    private String sslCfg = null;
    private String sslCfgScope = null;
    private String certAlias = null;
    private String scopeName = null;
    private ObjectName mgmScopeObjName = null;
    private ObjectName sslCfgObjName = null;
    private boolean createMgmScope = false;

    public CreateDynamicSSLConfigSelection(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public CreateDynamicSSLConfigSelection(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        boolean bl = false;
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        ObjectName objectName3 = null;
        Object var7_7 = null;
        try {
            objectName = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            objectName2 = configService.resolve(session, "Cell=")[0];
            if (objectName2 != null) {
                objectName3 = configService.queryConfigObjects(session, objectName2, objectName, null)[0];
            }
            this.dynSSLName = (String)this.getParameter(CommandConstants.DYN_SSL_CFG_NAME);
            this.description = (String)this.getParameter(CommandConstants.DYN_SSL_CFG_DESCRIPTION);
            this.info = (String)this.getParameter(CommandConstants.DYN_SSL_CFG_INFO);
            this.sslCfg = (String)this.getParameter(CommandConstants.DYN_SSL_CFG_SSL_CFG);
            this.certAlias = (String)this.getParameter(CommandConstants.DYN_SSL_CFG_CERT_ALIAS);
            this.sslCfgScope = (String)this.getParameter(CommandConstants.DYN_SSL_CFG_SSL_CFG_SCOPE);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name=" + this.dynSSLName + " description=" + this.description + " info=" + this.info + " sslCfg=" + this.sslCfg + " certAlias=" + this.certAlias + " scopeName=" + this.scopeName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(objectName2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
                }
            } else if (!ManagementScopeHelper.validScopeName(session, configService, this.scopeName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not a valid management scope name: " + this.scopeName);
                }
                String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.scope.not.valid.CWPKI0604E", new Object[]{this.scopeName}, "The following Management scope is not valid: " + this.scopeName);
                throw new CommandValidationException(string);
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.dynSSLName);
            bl = commandHelper.exists(configService, session, objectName3, CommandConstants.DYNAMIC_SSL_CONFIG_SELECTIONS, attributeList, this.scopeName);
            if (bl) {
                String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.already.exists.CWPKI0601E", new Object[]{this.dynSSLName, this.scopeName}, this.dynSSLName + " in the management scope " + this.scopeName + " already exists.");
                throw new CommandValidationException(string);
            }
            attributeList.clear();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.ALIAS, this.sslCfg);
            this.sslCfgObjName = commandHelper.getObjectName(configService, session, objectName3, CommandConstants.REPERTOIRE, attributeList, this.sslCfgScope);
            if (this.sslCfgObjName != null) {
                boolean bl2;
                AttributeList attributeList2 = configService.getAttributes(session, this.sslCfgObjName, null, true);
                if (attributeList2 != null && !(bl2 = commandHelper.withInScope(configService, session, attributeList2, this.scopeName))) {
                    String string = TraceNLSHelper.getInstance().getString("ssl.command.createDynSSLConfigSel.CWPKI0657E", "SSL Config is not within Dynamic SSL Configuration Selection management scope.");
                    throw new CommandValidationException(string);
                }
            } else {
                String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.not.found.CWPKI0600E", new Object[]{this.sslCfg, this.sslCfgScope}, this.sslCfg + " does not exists within scope " + this.sslCfgScope);
                throw new CommandValidationException(string);
            }
            attributeList.clear();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_NAME, this.scopeName);
            boolean bl3 = commandHelper.exists(configService, session, objectName3, CommandConstants.MANAGEMENT_SCOPES, attributeList, null);
            if (!bl3) {
                this.createMgmScope = true;
            } else {
                this.mgmScopeObjName = commandHelper.getObjectName(configService, session, objectName3, CommandConstants.MANAGEMENT_SCOPES, attributeList, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "mgmScopeObjName: " + this.mgmScopeObjName);
                }
            }
            if (!this.goodInfoFormat(this.info)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Information parameter is not formatted correctly.");
                }
                String string = TraceNLSHelper.getInstance().getString("ssl.command.cert.information.format.check.CWPKI0681E", "Dynamic SSL configuration selection information parameter is not in the correct format. It should be in the format protocol,host,port.");
                throw new CommandValidationException(string);
            }
            if (this.certAlias != null && !this.certAlias.equals("") && !this.checkCertAlias(session, configService, this.sslCfgObjName, this.certAlias)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SSLConfig of certificate alias did not verify");
                }
                String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.not.SSLConfig.CWPKI0617E", new Object[]{this.certAlias, this.sslCfg}, "Certificate " + this.certAlias + " is not in SSL configuration " + this.sslCfg + ".");
                throw new CommandValidationException(string);
            }
        }
        catch (ConfigServiceException configServiceException) {
            String string = configServiceException.getMessage();
            throw new CommandValidationException(string);
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            throw new CommandValidationException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            Object var8_8 = null;
            AttributeList attributeList = new AttributeList();
            ObjectName objectName4 = configService.resolve(session, "Cell=")[0];
            if (objectName4 != null) {
                objectName = configService.queryConfigObjects(session, objectName4, objectName3, null)[0];
            }
            if (this.createMgmScope) {
                ManagementScopeData managementScopeData = new ManagementScopeData(this.scopeName);
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_NAME, this.scopeName);
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_TYPE, managementScopeData.getScopeType());
                this.mgmScopeObjName = configService.createConfigData(session, objectName, CommandConstants.MANAGEMENT_SCOPES, null, attributeList);
                attributeList.clear();
            }
            ConfigServiceHelper.setAttributeValue(attributeList, "name", this.dynSSLName);
            ConfigServiceHelper.setAttributeValue(attributeList, "description", this.description);
            ConfigServiceHelper.setAttributeValue(attributeList, "dynamicSelectionInfo", this.info);
            ConfigServiceHelper.setAttributeValue(attributeList, "sslConfig", this.sslCfgObjName);
            if (this.certAlias != null && !this.certAlias.equals("")) {
                ConfigServiceHelper.setAttributeValue(attributeList, "certificateAlias", this.certAlias);
            }
            ConfigServiceHelper.setAttributeValue(attributeList, "managementScope", this.mgmScopeObjName);
            objectName2 = configService.createConfigData(session, objectName, "dynamicSSLConfigSelections", "DynamicSSLConfigSelection", attributeList);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        taskCommandResultImpl.setResult(objectName2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    private boolean checkCertAlias(Session session, ConfigService configService, ObjectName objectName, String string) throws Exception {
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCertAlias");
        }
        try {
            AttributeList attributeList = (AttributeList)configService.getAttribute(session, objectName, "setting");
            ObjectName objectName2 = (ObjectName)ConfigServiceHelper.getAttributeValue(attributeList, CommandConstants.KEY_STORE);
            if (objectName2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Old style SSL config.");
                }
                if (this.verifyCertInKeyStore(string, string2 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "keyFileName"), string3 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "keyFilePassword"), string4 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "keyFileFormat"))) {
                    bl = true;
                }
            } else {
                com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "New SSLConfig.");
                }
                if (this.verifyCertInKeyStore(string, keyStore = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)MOFUtil.convertToEObject((Session)session, (ObjectName)objectName2))) {
                    bl = true;
                }
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkCertAlias");
        }
        return bl;
    }

    private boolean verifyCertInKeyStore(String string, String string2, String string3, String string4) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifyCertInKeyStore");
        }
        boolean bl = false;
        KeyStore keyStore = null;
        InputStream inputStream = null;
        try {
            keyStore = KeyStore.getInstance(string4, "IBMJCE");
            inputStream = WSKeyStore.openKeyStore(string2);
            keyStore.load(inputStream, string3.toCharArray());
            if (keyStore.containsAlias(string)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "keyAlias found");
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is ", exception.getMessage());
            }
            throw new Exception(exception.getMessage());
        }
        finally {
            inputStream.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifyCertInKeyStore");
        }
        return bl;
    }

    private boolean verifyCertInKeyStore(String string, com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifyCertInKeyStore");
        }
        boolean bl = false;
        WSKeyStoreRemotable wSKeyStoreRemotable = new WSKeyStoreRemotable(keyStore);
        try {
            String string2 = "containsAlias";
            Object[] objectArray = new Object[]{string};
            Object[] objectArray2 = wSKeyStoreRemotable.invokeKeyStoreCommand(string2, objectArray);
            if (((Boolean)objectArray2[0]).booleanValue()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "keyAlias found");
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is ", exception.getMessage());
            }
            throw new Exception(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifyCertInKeyStore");
        }
        return bl;
    }

    private boolean goodInfoFormat(String string) {
        String[] stringArray = string.split("\\|");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(",");
            if (stringArray2.length == 3) {
                String string2 = stringArray2[0];
                String string3 = stringArray2[1];
                String string4 = stringArray2[2];
                if (!string2.equals("") && !string3.equals("") && !string4.equals("")) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

