/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.WSNotification;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ModifyWSNotification
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ModifyWSNotification.class, "SSL", "com.ibm.ws.ssl.commands");
    private String wsNotificationName = null;
    private Boolean logToSystemOut = null;
    private Boolean sendEmail = null;
    private String emailList = null;
    private ObjectName wsNotificationObjName = null;

    public ModifyWSNotification(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ModifyWSNotification(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        boolean bl = false;
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            this.wsNotificationName = (String)this.getParameter(CommandConstants.NAME);
            this.logToSystemOut = (Boolean)this.getParameter(CommandConstants.LOG_TO_SYSTEM_OUT);
            this.sendEmail = (Boolean)this.getParameter(CommandConstants.SEND_EMAIL);
            this.emailList = (String)this.getParameter(CommandConstants.EMAIL_LIST);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wsNotificationName: " + this.wsNotificationName);
            }
            CommandHelper commandHelper = new CommandHelper();
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.wsNotificationName);
            this.wsNotificationObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.WS_NOTIFICATIONS, attributeList, null);
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.commands.modifyWSNotification.validate", "140", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.wsNotificationName);
            if (this.logToSystemOut != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.LOG_TO_SYSTEM_OUT, this.logToSystemOut);
            }
            if (this.sendEmail != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SEND_EMAIL, this.sendEmail);
            }
            if (this.emailList != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.EMAIL_LIST, this.emailList);
            }
            configService.setAttributes(session, this.wsNotificationObjName, attributeList);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

