/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.WSNotification;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DeleteWSNotification
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(DeleteWSNotification.class, "SSL", "com.ibm.ws.ssl.commands");
    private String wsNotificationName = null;
    private ObjectName wsNotificationObjName = null;

    public DeleteWSNotification(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public DeleteWSNotification(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        try {
            ObjectName objectName2;
            ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName4 = configService.resolve(session, "Cell=")[0];
            if (objectName4 != null) {
                objectName = configService.queryConfigObjects(session, objectName4, objectName3, null)[0];
            }
            this.wsNotificationName = (String)this.getParameter(CommandConstants.NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wsNotificationName: " + this.wsNotificationName);
            }
            CommandHelper commandHelper = new CommandHelper();
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.wsNotificationName);
            this.wsNotificationObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.WS_NOTIFICATIONS, attributeList, null);
            AttributeList attributeList2 = (AttributeList)configService.getAttribute(session, objectName, CommandConstants.WS_CERT_EXP_MONITOR);
            if (attributeList2 != null) {
                objectName2 = ConfigServiceHelper.createObjectName(attributeList2);
            }
            objectName2 = (ObjectName)ConfigServiceHelper.getAttributeValue(attributeList2, CommandConstants.WS_NOTIFICATION);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "notification: " + objectName2);
            }
            if (objectName2 != null && this.wsNotificationObjName.equals(objectName2)) {
                AttributeList attributeList3 = new AttributeList();
                String string = (String)ConfigServiceHelper.getAttributeValue(attributeList2, CommandConstants.NAME);
                attributeList3.add(new Attribute(CommandConstants.WS_CERT_EXP_MONITOR, string));
                String string2 = "This object is referenced by " + attributeList3;
                throw new CommandValidationException(string2);
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.ssl.commands.deleteWSNotification.validate", "147");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            configService.deleteConfigData(session, this.wsNotificationObjName);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

