/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.SSLConfigGroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ModifySSLConfigGroup
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ModifySSLConfigGroup.class, "SSL", "com.ibm.ws.ssl.commands");
    private String sslConfigGroupName = null;
    private String direction = null;
    private String certificateAlias = null;
    private String sslConfigGroupScopeName = null;
    private String sslConfigAliasName = null;
    private String sslConfigScopeName = null;
    private ObjectName sslConfigGroupObjName = null;
    private ObjectName scopeObjName = null;
    private ObjectName sslConfigObjName = null;

    public ModifySSLConfigGroup(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ModifySSLConfigGroup(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate");
            }
            super.validate();
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName = null;
            try {
                ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
                ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
                if (objectName3 != null) {
                    objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
                }
                this.sslConfigGroupName = (String)this.getParameter(CommandConstants.NAME);
                this.direction = (String)this.getParameter(CommandConstants.DIRECTION);
                this.certificateAlias = (String)this.getParameter(CommandConstants.CERTIFICATE_ALIAS);
                this.sslConfigGroupScopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
                this.sslConfigAliasName = (String)this.getParameter(CommandConstants.SSL_CONFIG_ALIAS_NAME);
                this.sslConfigScopeName = (String)this.getParameter(CommandConstants.SSL_CONFIG_SCOPE_NAME);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SSLConfigGroupName: " + this.sslConfigGroupName);
                    Tr.debug(tc, "direction: " + this.direction);
                    Tr.debug(tc, "sslConfigGroupScopeName: " + this.sslConfigGroupScopeName);
                    Tr.debug(tc, "sslConfigAliasName: " + this.sslConfigAliasName);
                    Tr.debug(tc, "sslConfigScopeName: " + this.sslConfigScopeName);
                }
                CommandHelper commandHelper = new CommandHelper();
                if (this.sslConfigGroupScopeName == null) {
                    this.sslConfigGroupScopeName = commandHelper.defaultCellScope(objectName3);
                }
                if (this.sslConfigScopeName == null) {
                    this.sslConfigScopeName = commandHelper.defaultCellScope(objectName3);
                }
                if (this.direction != null && !this.direction.equalsIgnoreCase("inbound") && !this.direction.equalsIgnoreCase("outbound")) {
                    String string = "Invalid direction value: " + this.direction;
                    throw new CommandValidationException(string);
                }
                AttributeList attributeList = new AttributeList();
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.sslConfigGroupName);
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.DIRECTION, this.direction);
                this.sslConfigGroupObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.SSL_CONFIG_GROUPS, attributeList, this.sslConfigGroupScopeName);
                attributeList.clear();
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_NAME, this.sslConfigGroupScopeName);
                this.scopeObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.MANAGEMENT_SCOPES, attributeList, null);
                if (this.sslConfigAliasName == null) break block14;
                attributeList.clear();
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.ALIAS, this.sslConfigAliasName);
                this.sslConfigObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.REPERTOIRE, attributeList, this.sslConfigScopeName);
                AttributeList attributeList2 = configService.getAttributes(session, this.sslConfigObjName, null, true);
                if (attributeList2 != null) {
                    boolean bl = commandHelper.withInScope(configService, session, attributeList2, this.sslConfigGroupScopeName);
                    if (!bl) {
                        String string = "SSLConfig is not within the SSLConfigGroup mananagementScope.";
                        throw new CommandValidationException(string);
                    }
                    break block14;
                }
                String string = "Attribute list for SSLConfig is null.";
                throw new CommandValidationException(string);
            }
            catch (ConfigServiceException configServiceException) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Error getting configuration: ", configServiceException.getMessage());
                }
                throw new CommandValidationException(configServiceException.getMessage());
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.commands.modifySSLConfigGroup.validate", "197", this);
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Error getting configuration: ", exception.getMessage());
                }
                throw new CommandValidationException(exception.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.sslConfigGroupName);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.DIRECTION, this.direction);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName);
            if (this.certificateAlias != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.CERTIFICATE_ALIAS, this.certificateAlias);
            }
            if (this.sslConfigObjName != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SSL_CONFIG, this.sslConfigObjName);
            }
            configService.setAttributes(session, this.sslConfigGroupObjName, attributeList);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

