/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.SSLConfig;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.ssl.protocol.SSLSocketFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.ManagementScope.ManagementScopeHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.SSLConfigManager;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ListSSLCiphers
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListSSLCiphers.class, "SSL", "com.ibm.ws.ssl.commands");
    private String sslConfigAliasName = null;
    private String scopeName = null;
    private String securityLevel = null;
    private String sslCfgType = "JSSE";

    public ListSSLCiphers(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ListSSLCiphers(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        boolean bl = false;
        ObjectName objectName2 = null;
        try {
            Object object;
            ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName4 = configService.resolve(session, "Cell=")[0];
            if (objectName4 != null) {
                objectName2 = configService.queryConfigObjects(session, objectName4, objectName3, null)[0];
            }
            this.sslConfigAliasName = (String)this.getParameter(CommandConstants.SSL_CONFIG_ALIAS_NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.securityLevel = (String)this.getParameter(CommandConstants.SECURITY_LEVEL);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sslConfigAliasName: " + this.sslConfigAliasName);
                Tr.debug(tc, "scopeName: " + this.scopeName);
                Tr.debug(tc, "securityLevel: " + this.securityLevel);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.sslConfigAliasName != null) {
                if (this.scopeName == null || this.scopeName.equals("")) {
                    this.scopeName = commandHelper.defaultCellScope(objectName4);
                    bl = true;
                } else if (!ManagementScopeHelper.validScopeName(session, configService, this.scopeName)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Not a valid management scope name: " + this.scopeName);
                    }
                    String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.scope.not.valid.CWPKI0604E", new Object[]{this.scopeName}, "The following Management scope is not valid: " + this.scopeName);
                    throw new CommandValidationException(string);
                }
                object = new AttributeList();
                ConfigServiceHelper.setAttributeValue((AttributeList)object, CommandConstants.ALIAS, this.sslConfigAliasName);
                try {
                    objectName = commandHelper.getObjectName(configService, session, objectName2, CommandConstants.REPERTOIRE, (AttributeList)object, this.scopeName);
                }
                catch (Exception exception) {
                    if (bl) {
                        objectName = commandHelper.getObjectName(configService, session, objectName2, CommandConstants.REPERTOIRE, (AttributeList)object, null);
                    }
                    throw exception;
                }
                if (objectName != null) {
                    this.sslCfgType = (String)configService.getAttribute(session, objectName, "type");
                }
            }
            if (this.securityLevel != null && !commandHelper.contains(CommandConstants.SSLSecurityLevel, this.securityLevel)) {
                object = "SSLSecurityLevel is not valid.";
                throw new CommandValidationException((String)object);
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.commands.getSSLConfig.validate", "133", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        String[] stringArray = null;
        SSLSocketFactory sSLSocketFactory = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            if (this.sslCfgType.equals("JSSE")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getting JSSE ciphers");
                }
                sSLSocketFactory = this.sslConfigAliasName == null ? new SSLSocketFactory() : new SSLSocketFactory(this.sslConfigAliasName);
                stringArray = sSLSocketFactory.getSupportedCipherSuites();
            } else if (this.sslCfgType.equals("SSSL")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getting SSSL ciphers");
                }
                stringArray = SSLConfigManager.getInstance().getSystemSSLCiphers();
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Try to get the Cipher list from the default SSL config");
            }
            sSLSocketFactory = new SSLSocketFactory();
            stringArray = sSLSocketFactory.getSupportedCipherSuites();
        }
        try {
            stringArray = SSLConfigManager.getInstance().adjustSupportedCiphersToSecurityLevel(stringArray, this.securityLevel);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ciphers: " + stringArray);
            }
            taskCommandResultImpl.setResult(stringArray);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is: " + exception.getMessage());
            }
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

