/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.ProfileCreation;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.models.config.ipc.ssl.KeyStore;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.ssl.commands.ProfileCreation.PrepareKeysUtility;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class PrepareKeysForCellProfile
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(PrepareKeysForCellProfile.class, "SSL", "com.ibm.ws.ssl.commands.keyStores");
    public static boolean generatedLTPA = false;
    private PrepareKeysUtility pku = new PrepareKeysUtility();
    private String nodeName = null;
    private String appServerNodeName = null;
    private String cellName = null;
    private String dmgrProfileRoot = null;
    private String nodeProfileRoot = null;
    List keyStores = null;
    private boolean nodeProfileExists = false;
    private boolean dmgrProfileExists = false;
    ConfigService cs = null;
    Session session = null;

    public PrepareKeysForCellProfile(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public PrepareKeysForCellProfile(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            Object object;
            this.cs = ConfigServiceFactory.getConfigService();
            if (this.cs == null) {
                object = new Properties();
                ((Properties)object).put("location", "local");
                this.cs = ConfigServiceFactory.createConfigService(true, (Properties)object);
            }
            this.session = this.getConfigSession();
            this.dmgrProfileRoot = (String)this.getParameter(CommandConstants.DMGR_PROFILE_ROOT);
            this.nodeProfileRoot = (String)this.getParameter(CommandConstants.NODE_PROFILE_ROOT);
            this.cellName = (String)this.getParameter(CommandConstants.CELL_NAME);
            if (this.dmgrProfileRoot == null) {
                object = "The dmgr profile root is not specified for the task parameter " + CommandConstants.DMGR_PROFILE_ROOT + ".";
                throw new CommandValidationException((String)object);
            }
            if (this.nodeProfileRoot == null) {
                object = "The node profile root is not specified for the task parameter " + CommandConstants.NODE_PROFILE_ROOT + ".";
                throw new CommandValidationException((String)object);
            }
            if (this.cellName == null) {
                object = "The cell name is not specified for the task parameter " + CommandConstants.CELL_NAME + ".";
                throw new CommandValidationException((String)object);
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConfigService exception: ", new Object[]{configServiceException});
            }
            throw new CommandValidationException(configServiceException, configServiceException.getMessage());
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred in validate: ", new Object[]{exception});
            }
            throw new CommandValidationException(exception, exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void afterStepsExecuted() {
        Object object;
        TaskCommandResultImpl taskCommandResultImpl;
        block30: {
            Object object2;
            List list;
            List list2;
            block32: {
                Object object3;
                block31: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "afterStepsExecuted");
                    }
                    super.afterStepsExecuted();
                    taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
                    if (!taskCommandResultImpl.isSuccessful()) {
                        if (!tc.isEntryEnabled()) return;
                        Tr.exit(tc, "afterStepsExecuted");
                        return;
                    }
                    try {
                        ObjectName objectName = null;
                        ObjectName objectName2 = null;
                        ObjectName objectName3 = null;
                        Security security2 = null;
                        String string = System.getProperty("file.separator");
                        this.dmgrProfileExists = this.pku.checkForProfileExistance(this.dmgrProfileRoot, this.cellName);
                        this.nodeProfileExists = this.pku.checkForProfileExistance(this.nodeProfileRoot, this.cellName);
                        String string2 = "(cell):" + this.cellName;
                        objectName = ConfigServiceHelper.createObjectName(null, "Security");
                        objectName2 = this.cs.resolve(this.session, "Cell=")[0];
                        if (objectName2 != null) {
                            objectName3 = this.cs.queryConfigObjects(this.session, objectName2, objectName, null)[0];
                            security2 = (Security)MOFUtil.convertToEObject((Session)this.session, (ObjectName)objectName3);
                        }
                        CommandHelper commandHelper = new CommandHelper();
                        if (this.dmgrProfileExists && !this.nodeProfileExists) {
                            object = this.getKeyStoreList(objectName3, commandHelper, this.dmgrProfileRoot, "dmgr");
                            KeyStoreManager keyStoreManager = KeyStoreManager.getInstance();
                            if (object == null) {
                                String string3 = "Could not get KeyStore list during Cell profile creation, SSL/LTPA keys not shared.";
                                taskCommandResultImpl.setResult(string3);
                                if (!tc.isEntryEnabled()) return;
                                Tr.exit(tc, "afterStepsExecuted");
                                return;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "create DM keystores");
                            }
                            this.pku.createLTPAKeysIfNecessary(security2);
                            generatedLTPA = true;
                            this.pku.createAllKeyStores((List)object, string2, security2, this.dmgrProfileRoot, null);
                            break block30;
                        }
                        if (this.nodeProfileExists && !this.dmgrProfileExists) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "create Node keystores");
                            }
                            object = this.getKeyStoreList(objectName3, commandHelper, this.nodeProfileRoot, "node");
                            KeyStoreManager keyStoreManager = KeyStoreManager.getInstance();
                            if (object == null) {
                                String string4 = "Could not get KeyStore list during Node profile creation, SSL/LTPA keys not shared.";
                                taskCommandResultImpl.setResult(string4);
                                if (!tc.isEntryEnabled()) return;
                                Tr.exit(tc, "afterStepsExecuted");
                                return;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Node profile exists, DM does not - create node keystores");
                            }
                            this.pku.createLTPAKeysIfNecessary(security2);
                            generatedLTPA = true;
                            this.pku.createAllKeyStores((List)object, string2, security2, this.nodeProfileRoot, null);
                            break block30;
                        }
                        if (this.dmgrProfileExists && this.nodeProfileExists) {
                            object = KeyStoreManager.getInstance();
                            list2 = this.getKeyStoreList(objectName3, commandHelper, this.dmgrProfileRoot, "dmgr");
                            list = this.getKeyStoreList(objectName3, commandHelper, this.nodeProfileRoot, "node");
                            this.pku.createAllKeyStores(list, string2, security2, this.nodeProfileRoot, null);
                            this.pku.createAllKeyStores(list2, string2, security2, this.dmgrProfileRoot, null);
                            ((KeyStoreManager)object).loadKeyStores(security2);
                            if (list2 != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "copy DM keystore to Node keystore location");
                                }
                                this.pku.createLTPAKeysIfNecessary(security2);
                                break block31;
                            }
                            if (list == null) {
                                String string5 = "Both Node and DM Keystores are null, although the profiles appear to exist.";
                                taskCommandResultImpl.setResult(string5);
                                if (!tc.isEntryEnabled()) return;
                                Tr.exit(tc, "afterStepsExecuted");
                                return;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "copy Node keystore to DM keystore location");
                            }
                            this.pku.createLTPAKeysIfNecessary(security2);
                            break block32;
                        }
                        String string6 = "Could not get KeyStore list during Cell profile creation, SSL/LTPA keys not shared.";
                        taskCommandResultImpl.setResult(string6);
                        if (!tc.isEntryEnabled()) return;
                        Tr.exit(tc, "afterStepsExecuted");
                        return;
                    }
                    catch (ConfigServiceException configServiceException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ConfigService exception: ", new Object[]{configServiceException});
                        }
                        taskCommandResultImpl.setException(new CommandException(configServiceException, configServiceException.getMessage()));
                        return;
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception occurred in validate: ", new Object[]{exception});
                        }
                        taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
                    }
                    return;
                }
                for (int i = 0; i < list2.size(); ++i) {
                    File file;
                    File file2;
                    File file3;
                    File file4;
                    String string;
                    Object object4;
                    object3 = (KeyStore)list2.get(i);
                    String string7 = object3.getManagementScope().getScopeType();
                    if (string7 != null && string7.equals("cell") && object3.getName().endsWith("DefaultKeyStore") && object3.isFileBased()) {
                        for (int j = 0; j < list.size(); ++j) {
                            object4 = (KeyStore)list.get(j);
                            string = object4.getManagementScope().getScopeType();
                            if (string == null || string.equals("cell") || !object4.getName().endsWith("DefaultTrustStore") || !object4.isFileBased()) continue;
                            ((KeyStoreManager)object).exchangeSigners(this.nodeProfileRoot, (KeyStore)object3, this.nodeProfileRoot, (KeyStore)object4);
                            file4 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.nodeProfileRoot, object3.getLocation()));
                            file3 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.dmgrProfileRoot, object3.getLocation()));
                            file2 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.nodeProfileRoot, object4.getLocation()));
                            file = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.dmgrProfileRoot, object4.getLocation()));
                            this.pku.copy(file4, file3);
                            this.pku.copy(file2, file);
                        }
                        continue;
                    }
                    if (string7 != null && string7.equals("cell") && object3.getName().endsWith("DefaultTrustStore") && object3.isFileBased()) {
                        for (int j = 0; j < list.size(); ++j) {
                            object4 = (KeyStore)list.get(j);
                            string = object4.getManagementScope().getScopeType();
                            if (string == null || string.equals("cell") || !object4.getName().endsWith("DefaultKeyStore") || !object4.isFileBased()) continue;
                            ((KeyStoreManager)object).exchangeSigners(this.nodeProfileRoot, (KeyStore)object4, this.nodeProfileRoot, (KeyStore)object3);
                            file4 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.nodeProfileRoot, object3.getLocation()));
                            file3 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.dmgrProfileRoot, object3.getLocation()));
                            file2 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.nodeProfileRoot, object4.getLocation()));
                            file = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.dmgrProfileRoot, object4.getLocation()));
                            this.pku.copy(file4, file3);
                            this.pku.copy(file2, file);
                        }
                        continue;
                    }
                    if (!object3.getName().endsWith("LTPAKeys") || !object3.isFileBased()) continue;
                    File file5 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.dmgrProfileRoot, object3.getLocation()));
                    object4 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.nodeProfileRoot, object3.getLocation()));
                    this.pku.copy(file5, (File)object4);
                }
                File file = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(this.dmgrProfileRoot, "/etc/key.p12"));
                object3 = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(this.nodeProfileRoot, "/etc/key.p12"));
                this.pku.copy(file, (File)object3);
                file = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(this.dmgrProfileRoot, "/etc/trust.p12"));
                object3 = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(this.nodeProfileRoot, "/etc/trust.p12"));
                this.pku.copy(file, (File)object3);
                break block30;
            }
            for (int i = 0; i < list.size(); ++i) {
                File file;
                File file6;
                File file7;
                File file8;
                String string;
                Object object5;
                object2 = (KeyStore)list.get(i);
                String string8 = object2.getManagementScope().getScopeType();
                if (string8 != null && string8.equals("cell") && object2.getName().endsWith("DefaultKeyStore") && object2.isFileBased()) {
                    for (int j = 0; j < list2.size(); ++j) {
                        object5 = (KeyStore)list2.get(j);
                        string = object5.getManagementScope().getScopeType();
                        if (string == null || string.equals("cell") || !object5.getName().endsWith("DefaultTrustStore") || !object5.isFileBased()) continue;
                        ((KeyStoreManager)object).exchangeSigners(this.dmgrProfileRoot, (KeyStore)object2, this.dmgrProfileRoot, (KeyStore)object5);
                        file8 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.dmgrProfileRoot, object5.getLocation()));
                        file7 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.nodeProfileRoot, object5.getLocation()));
                        file6 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.dmgrProfileRoot, object2.getLocation()));
                        file = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.nodeProfileRoot, object2.getLocation()));
                        this.pku.copy(file8, file7);
                        this.pku.copy(file6, file);
                    }
                    continue;
                }
                if (string8 != null && string8.equals("cell") && object2.getName().endsWith("DefaultTrustStore") && object2.isFileBased()) {
                    for (int j = 0; j < list2.size(); ++j) {
                        object5 = (KeyStore)list2.get(j);
                        string = object5.getManagementScope().getScopeType();
                        if (string == null || string.equals("cell") || !object5.getName().endsWith("DefaultKeyStore") || !object5.isFileBased()) continue;
                        ((KeyStoreManager)object).exchangeSigners(this.dmgrProfileRoot, (KeyStore)object5, this.dmgrProfileRoot, (KeyStore)object2);
                        ((KeyStoreManager)object).exchangeSigners(this.dmgrProfileRoot, (KeyStore)object2, this.dmgrProfileRoot, (KeyStore)object5);
                        file8 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.dmgrProfileRoot, object5.getLocation()));
                        file7 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.nodeProfileRoot, object5.getLocation()));
                        file6 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.dmgrProfileRoot, object2.getLocation()));
                        file = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.nodeProfileRoot, object2.getLocation()));
                        this.pku.copy(file8, file7);
                        this.pku.copy(file6, file);
                    }
                    continue;
                }
                if (!object2.getName().endsWith("LTPAKeys") || !object2.isFileBased()) continue;
                File file9 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.nodeProfileRoot, object2.getLocation()));
                object5 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.dmgrProfileRoot, object2.getLocation()));
                this.pku.copy(file9, (File)object5);
            }
            File file = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(this.dmgrProfileRoot, "/etc/key.p12"));
            object2 = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(this.nodeProfileRoot, "/etc/key.p12"));
            this.pku.copy((File)object2, file);
            file = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(this.dmgrProfileRoot, "/etc/trust.p12"));
            object2 = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(this.nodeProfileRoot, "/etc/trust.p12"));
            this.pku.copy((File)object2, file);
        }
        object = "KeyStore creation and certificate exchange successful for Cell profile.";
        taskCommandResultImpl.setResult(object);
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "afterStepsExecuted");
    }

    public List getKeyStoreList(ObjectName objectName, CommandHelper commandHelper, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyStoreList");
        }
        try {
            if (this.cs != null && this.session != null) {
                List list = (List)this.cs.getAttribute(this.session, objectName, CommandConstants.KEY_STORES);
                ArrayList<KeyStore> arrayList = new ArrayList<KeyStore>(list.size());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    AttributeList attributeList = (AttributeList)iterator.next();
                    ObjectName[] objectNameArray = this.cs.queryConfigObjects(this.session, null, ConfigServiceHelper.createObjectName(attributeList), null);
                    KeyStore keyStore = (KeyStore)MOFUtil.convertToEObject((Session)this.session, (ObjectName)objectNameArray[0]);
                    if (keyStore == null) continue;
                    keyStore.setLocation(PrepareKeysUtility.fixupLocationWithRepositoryRoot(string, keyStore.getLocation()));
                    String string3 = keyStore.getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding keyStore name: " + keyStore.getName());
                    }
                    if (string3 != null && string2 == "dmgr" && string3.startsWith("Cell")) {
                        arrayList.add(keyStore);
                        continue;
                    }
                    if (string3 == null || string2 != "node" || !string3.startsWith("Node")) continue;
                    arrayList.add(keyStore);
                }
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "getKeyStoreList");
                }
                return arrayList;
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in getKeyStoreList: ", new Object[]{exception});
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyStoreList");
        }
        return null;
    }
}

