/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.ManagementScope;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DeleteManagementScope
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(DeleteManagementScope.class, "SSL", "com.ibm.ws.ssl.commands");
    private String scopeName = null;
    private ObjectName scopeObjName = null;

    public DeleteManagementScope(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public DeleteManagementScope(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        try {
            AttributeList attributeList;
            AttributeList attributeList2;
            AttributeList attributeList3;
            AttributeList attributeList4;
            AttributeList attributeList5;
            AttributeList attributeList6;
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "scopeName: " + this.scopeName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(objectName3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
                }
            }
            AttributeList attributeList7 = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList7, CommandConstants.SCOPE_NAME, this.scopeName);
            this.scopeObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.MANAGEMENT_SCOPES, attributeList7, null);
            AttributeList attributeList8 = new AttributeList();
            AttributeList attributeList9 = commandHelper.getReference(configService, session, objectName, CommandConstants.KEY_SETS, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName);
            if (attributeList9.size() > 0) {
                attributeList8.addAll(attributeList9);
            }
            if ((attributeList6 = commandHelper.getReference(configService, session, objectName, CommandConstants.KEY_SET_GROUPS, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName)).size() > 0) {
                attributeList8.addAll(attributeList6);
            }
            if ((attributeList5 = commandHelper.getReference(configService, session, objectName, CommandConstants.KEY_STORES, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName)).size() > 0) {
                attributeList8.addAll(attributeList5);
            }
            if ((attributeList4 = commandHelper.getReference(configService, session, objectName, CommandConstants.SSL_CONFIG_GROUPS, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName)).size() > 0) {
                attributeList8.addAll(attributeList4);
            }
            if ((attributeList3 = commandHelper.getReference(configService, session, objectName, CommandConstants.TRUST_MANAGERS, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName)).size() > 0) {
                attributeList8.addAll(attributeList3);
            }
            if ((attributeList2 = commandHelper.getReference(configService, session, objectName, CommandConstants.KEY_MANAGERS, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName)).size() > 0) {
                attributeList8.addAll(attributeList2);
            }
            if ((attributeList = commandHelper.getReference(configService, session, objectName, CommandConstants.DYNAMIC_SSL_CONFIG_SELECTIONS, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName)).size() > 0) {
                attributeList8.addAll(attributeList);
            }
            if (attributeList8.size() > 0) {
                String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.management.scope.referenced.CWPKI0637E", new Object[]{attributeList8}, "This object is referenced by " + attributeList8);
                throw new CommandValidationException(string);
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.ssl.commands.deleteManagementScope.validate", "200");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            configService.deleteConfigData(session, this.scopeObjName);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

