/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.ManagementScope;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.ManagementScope.ManagementScopeHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.ManagementScopeData;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateManagementScope
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateManagementScope.class, "SSL", "com.ibm.ws.ssl.commands");
    private String scopeName = null;
    private String scopeType = null;

    public CreateManagementScope(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public CreateManagementScope(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        try {
            Object object;
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.scopeType = (String)this.getParameter(CommandConstants.SCOPE_TYPE);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "scopeName: " + this.scopeName);
                Tr.debug(tc, "scopeType: " + this.scopeType);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(objectName3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Use default cell scopeName: " + this.scopeName);
                }
            } else if (!ManagementScopeHelper.validScopeName(session, configService, this.scopeName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not a valid management scope name: " + this.scopeName);
                }
                String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.scope.not.valid.CWPKI0604E", new Object[]{this.scopeName}, "The following Management scope is not valid: " + this.scopeName);
                throw new CommandValidationException(string);
            }
            if (this.scopeType == null) {
                object = new ManagementScopeData(this.scopeName);
                this.scopeType = ((ManagementScopeData)object).getScopeType();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Use default cell scopeType: " + this.scopeType);
                }
            } else {
                if (!ManagementScopeHelper.checkScopeType(this.scopeType)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Not a valid management scope type: " + this.scopeType);
                    }
                    String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.ManagementScope.type.not.valid.CWPKI0607E", new Object[]{this.scopeType}, "The following management scope type is not valid: " + this.scopeName);
                    throw new CommandValidationException(string);
                }
                object = new ManagementScopeData(this.scopeName);
                String string = ((ManagementScopeData)object).getScopeType();
                if (!this.scopeType.equalsIgnoreCase(string)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Not a valid management scope type: " + this.scopeType);
                    }
                    String string2 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.MangementScope.not.type.CWPKI0608E", new Object[]{this.scopeName, this.scopeType}, "The following management scope type is not valid: " + this.scopeName);
                    throw new CommandValidationException(string2);
                }
            }
            object = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)object, CommandConstants.SCOPE_NAME, this.scopeName);
            boolean bl = commandHelper.exists(configService, session, objectName, CommandConstants.MANAGEMENT_SCOPES, (AttributeList)object, null);
            if (bl) {
                String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.ManagementScope.already.exists.CWPKI0609E", new Object[]{this.scopeName}, "Management scope " + this.scopeName + " already exists.");
                throw new CommandValidationException(string);
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.commands.createManagementScope.validate", "144", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_NAME, this.scopeName);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_TYPE, this.scopeType);
            ObjectName objectName4 = configService.createConfigData(session, objectName, CommandConstants.MANAGEMENT_SCOPES, null, attributeList);
            if (objectName4 != null) {
                taskCommandResultImpl.setResult(objectName4);
            }
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

