/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.KeySet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.models.config.ipc.ssl.KeySet;
import com.ibm.ws.crypto.config.KeyReference;
import com.ibm.ws.crypto.config.WSKeyPairReference;
import com.ibm.ws.crypto.config.WSKeyReference;
import com.ibm.ws.crypto.config.WSKeySet;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class GenerateKeyForKeySet
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(GenerateKeyForKeySet.class, "SSL", "com.ibm.ws.ssl.commands");
    private String keySetName = null;
    private String scopeName = null;
    private Boolean saveConfig = Boolean.FALSE;
    ObjectName keySetObjName = null;
    KeySet keySet = null;
    WSKeySet wsKeySet = null;

    public GenerateKeyForKeySet(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public GenerateKeyForKeySet(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            this.keySetName = (String)this.getParameter(CommandConstants.KEY_SET_NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.KEY_SET_SCOPE);
            this.saveConfig = (Boolean)this.getParameter(CommandConstants.KEY_SET_SAVE_CONFIG);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keySetName: " + this.keySetName);
                Tr.debug(tc, "scopeName: " + this.scopeName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(objectName3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
                }
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.keySetName);
            this.keySetObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.KEY_SETS, attributeList, this.scopeName);
            if (this.keySetObjName == null) {
                String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.not.found.CWPKI0600E", new Object[]{this.keySetName, this.scopeName}, this.keySetName + " does not exist within management scope " + this.scopeName);
                throw new CommandValidationException(string);
            }
            this.keySet = (KeySet)MOFUtil.convertToEObject((Session)session, (ObjectName)this.keySetObjName);
            this.wsKeySet = new WSKeySet(this.keySet);
            String string = this.keySet.getKeyGenerationClass();
            if (string == null) {
                String string2 = TraceNLSHelper.getInstance().getString("ssl.command.generate.key.class.CWPKI0635E", "Cannot generate keys since the key generator class is not configured.");
                throw new CommandValidationException(string2);
            }
            boolean bl = this.keySet.getKeyStore().isReadOnly();
            if (bl) {
                String string3 = "Cannot generate keys since KeyStore \"" + this.keySet.getKeyStore().getName() + "\" is marked read-only.";
                throw new CommandValidationException(string3);
            }
            attributeList.clear();
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration:", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.ssl.commands.getKeySet.validate", "132");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration:", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        CommandHelper commandHelper = new CommandHelper();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            Serializable serializable;
            Cloneable cloneable;
            Object object;
            Object object2;
            String string;
            Object object3;
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            String string2 = this.wsKeySet.getAliasPrefix();
            int n = this.wsKeySet.getMaxKeyReferences();
            boolean bl = this.wsKeySet.getDeleteOldKeys();
            int n2 = 0;
            int n3 = 0;
            KeyReference keyReference = this.wsKeySet.getLatestKeyReference();
            if (keyReference != null) {
                n2 = keyReference.getVersion();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Current key version: " + n2);
                }
                n3 = ++n2;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Next key version: " + n3);
                }
            } else {
                n3 = 1;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Next key version: " + n3);
                }
            }
            TreeSet treeSet = this.wsKeySet.getKeyReferenceTreeSet();
            int n4 = treeSet.size();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Total keys: " + n4);
            }
            while (n4 >= n) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Total keys > max keys.");
                }
                object3 = this.wsKeySet.getOldestKeyReference();
                string = ((KeyReference)object3).getKeyAlias();
                int n5 = ((KeyReference)object3).getVersion();
                object2 = (List)configService.getAttribute(session, this.keySetObjName, CommandConstants.KEY_REFERENCE);
                object = object2.iterator();
                while (object.hasNext()) {
                    Object object4;
                    WSKeyStoreRemotable wSKeyStoreRemotable;
                    cloneable = (AttributeList)object.next();
                    serializable = (Integer)ConfigServiceHelper.getAttributeValue((AttributeList)cloneable, CommandConstants.VERSION);
                    if (serializable != n5) continue;
                    AttributeList attributeList = new AttributeList();
                    ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.KEY_ALIAS, string);
                    ObjectName objectName4 = commandHelper.getObjectName(configService, session, this.keySetObjName, CommandConstants.KEY_REFERENCE, attributeList, null);
                    if (objectName4 == null) break;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Deleting KeyReference for version " + serializable);
                    }
                    configService.deleteConfigData(session, objectName4);
                    if (!bl) break;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Deleting keys from KeyStore.");
                    }
                    if ((wSKeyStoreRemotable = new WSKeyStoreRemotable(this.wsKeySet.getWSKeyStore())) != null && !this.wsKeySet.getIsKeyPair()) {
                        String string3 = "deleteEntry";
                        object4 = new Object[]{string};
                        wSKeyStoreRemotable.invokeKeyStoreCommand(string3, (Object[])object4);
                        break;
                    }
                    if (wSKeyStoreRemotable == null) break;
                    boolean bl2 = false;
                    object4 = "containsAlias";
                    Object[] objectArray = new Object[]{string + "_public"};
                    Object[] objectArray2 = wSKeyStoreRemotable.invokeKeyStoreCommand((String)object4, objectArray);
                    if (((Boolean)objectArray2[0]).booleanValue()) {
                        object4 = "deleteEntry";
                        objectArray = new Object[]{string + "_public"};
                        wSKeyStoreRemotable.invokeKeyStoreCommand((String)object4, objectArray);
                        bl2 = true;
                    }
                    if (((Boolean)(objectArray2 = wSKeyStoreRemotable.invokeKeyStoreCommand((String)(object4 = "containsAlias"), objectArray = new Object[]{string + "_private"}))[0]).booleanValue()) {
                        object4 = "deleteEntry";
                        objectArray = new Object[]{string + "_private"};
                        wSKeyStoreRemotable.invokeKeyStoreCommand((String)object4, objectArray);
                        bl2 = true;
                    }
                    if (bl2 || !((Boolean)(objectArray2 = wSKeyStoreRemotable.invokeKeyStoreCommand((String)(object4 = "containsAlias"), objectArray = new Object[]{string}))[0]).booleanValue()) break;
                    object4 = "deleteEntry";
                    objectArray = new Object[]{string};
                    wSKeyStoreRemotable.invokeKeyStoreCommand((String)object4, objectArray);
                    bl2 = true;
                    break;
                }
                this.wsKeySet.removeOldestReference();
                n4 = treeSet.size();
            }
            object3 = new AttributeList();
            string = string2 + "_" + n3;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Next alias: " + string);
            }
            ConfigServiceHelper.setAttributeValue((AttributeList)object3, CommandConstants.VERSION, new Integer(n3));
            ConfigServiceHelper.setAttributeValue((AttributeList)object3, CommandConstants.KEY_ALIAS, string);
            ObjectName objectName5 = configService.createConfigData(session, this.keySetObjName, CommandConstants.KEY_REFERENCE, null, (AttributeList)object3);
            object2 = (com.ibm.websphere.models.config.ipc.ssl.KeyReference)MOFUtil.convertToEObject((Session)session, (ObjectName)objectName5);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "KeyReference: " + object2);
            }
            object = null;
            cloneable = new HashMap();
            if (this.wsKeySet.getIsKeyPair()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating a KeyPair.");
                }
                object = new WSKeyPairReference((com.ibm.websphere.models.config.ipc.ssl.KeyReference)object2, this.wsKeySet, this.wsKeySet.getWSKeyStore());
                serializable = ((WSKeyPairReference)object).getKeyPair();
                cloneable.put(string, serializable);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating a Key.");
                }
                object = new WSKeyReference((com.ibm.websphere.models.config.ipc.ssl.KeyReference)object2, this.wsKeySet, this.wsKeySet.getWSKeyStore());
                serializable = ((WSKeyReference)object).getKey();
                cloneable.put(string, serializable);
            }
            if (this.saveConfig != null && this.saveConfig.booleanValue()) {
                configService.save(session, true);
            }
            taskCommandResultImpl.setResult(cloneable);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.commands.GenerateKeyForKeySet.beforeStepsExecuted", "378", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred.", new Object[]{exception});
            }
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

