/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.KeyManager;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ModifyKeyManager
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ModifyKeyManager.class, "SSL", "com.ibm.ws.ssl.commands");
    private String keyManagerName = null;
    private String provider = null;
    private String algorithm = null;
    private String keyManagerClass = null;
    private String scopeName = null;
    private ObjectName keyManagerObjName = null;
    private ObjectName scopeObjName = null;

    public ModifyKeyManager(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ModifyKeyManager(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            this.keyManagerName = (String)this.getParameter(CommandConstants.NAME);
            this.provider = (String)this.getParameter(CommandConstants.PROVIDER);
            this.algorithm = (String)this.getParameter(CommandConstants.ALGORITHM);
            this.keyManagerClass = (String)this.getParameter(CommandConstants.KEY_MANAGER_CLASS);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyManagerName: " + this.keyManagerName);
                Tr.debug(tc, "scopeName: " + this.scopeName);
            }
            if ((this.provider == null || this.algorithm == null) && this.keyManagerClass == null || (this.provider != null || this.algorithm != null) && this.keyManagerClass != null) {
                String string = TraceNLSHelper.getInstance().getString("ssl.command.createKeyManager.CWPKI0603E", "Specify either provider/algorithm or keyManagerClass.");
                throw new CommandValidationException(string);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(objectName3);
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.keyManagerName);
            this.keyManagerObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.KEY_MANAGERS, attributeList, this.scopeName);
            attributeList.clear();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_NAME, this.scopeName);
            this.scopeObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.MANAGEMENT_SCOPES, attributeList, null);
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.commands.modifyKeyManager.validate", "164", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.keyManagerName);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.PROVIDER, this.provider);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.ALGORITHM, this.algorithm);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.KEY_MANAGER_CLASS, this.keyManagerClass);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName);
            configService.setAttributes(session, this.keyManagerObjName, attributeList);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

