/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.DescriptiveProp;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import java.io.Serializable;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateDescriptiveProp
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateDescriptiveProp.class, "SSL", "com.ibm.ws.ssl.commands");
    private String parentDataType = null;
    private String parentClassName = null;
    private String parentScopeName = null;
    private String name = null;
    private String value = null;
    private String type = null;
    private String displayNameKey = null;
    private String nlsRangeKey = null;
    private String hoverHelpKey = null;
    private String range = null;
    private Boolean inclusive = null;
    private Boolean firstClass = null;
    private ObjectName parentObjName = null;
    private String descPropDataType = null;

    public CreateDescriptiveProp(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public CreateDescriptiveProp(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        boolean bl = false;
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        try {
            ObjectName objectName2;
            Serializable serializable;
            ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName4 = configService.resolve(session, "Cell=")[0];
            if (objectName4 != null) {
                objectName = configService.queryConfigObjects(session, objectName4, objectName3, null)[0];
            }
            this.parentDataType = (String)this.getParameter(CommandConstants.PARENT_DATA_TYPE);
            this.parentClassName = (String)this.getParameter(CommandConstants.PARENT_CLASS_NAME);
            this.parentScopeName = (String)this.getParameter(CommandConstants.PARENT_SCOPE_NAME);
            this.name = (String)this.getParameter(CommandConstants.NAME);
            this.value = (String)this.getParameter(CommandConstants.VALUE);
            this.type = (String)this.getParameter(CommandConstants.TYPE);
            this.displayNameKey = (String)this.getParameter(CommandConstants.DISPLAY_NAME_KEY);
            this.nlsRangeKey = (String)this.getParameter(CommandConstants.NLS_RANGE_KEY);
            this.hoverHelpKey = (String)this.getParameter(CommandConstants.HOVER_HELP_KEY);
            this.range = (String)this.getParameter(CommandConstants.RANGE);
            this.inclusive = (Boolean)this.getParameter(CommandConstants.INCLUSIVE);
            this.firstClass = (Boolean)this.getParameter(CommandConstants.FIRST_CLASS);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parentDataType:   " + this.parentDataType);
                Tr.debug(tc, "parentClassName:  " + this.parentClassName);
                Tr.debug(tc, "parentScopeName:  " + this.parentScopeName);
                Tr.debug(tc, "name:             " + this.name);
                Tr.debug(tc, "value:            " + this.value);
                Tr.debug(tc, "type:             " + this.type);
                Tr.debug(tc, "displayNameKey:   " + this.displayNameKey);
                Tr.debug(tc, "nlsRangeKey:      " + this.nlsRangeKey);
                Tr.debug(tc, "hoverHelpKey:     " + this.hoverHelpKey);
                Tr.debug(tc, "range:            " + this.range);
                Tr.debug(tc, "inclusive:        " + this.inclusive);
                Tr.debug(tc, "firstClass:       " + this.firstClass);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.parentDataType == null) {
                String string = TraceNLSHelper.getInstance().getString("ssl.command.descriptive.prop.parentDataType.CWPKI0638E", "The data type of the parent is empty or blank.");
                throw new CommandValidationException(string);
            }
            this.descPropDataType = commandHelper.childDataType(this.parentDataType);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "descPropDataType: " + this.descPropDataType);
            }
            if (this.parentClassName == null) {
                String string = TraceNLSHelper.getInstance().getString("ssl.command.descriptive.prop.className.CWPKI0639E", "The class name of the parent is empty or blank");
                throw new CommandValidationException(string);
            }
            if (this.parentScopeName == null) {
                this.parentScopeName = commandHelper.defaultCellScope(objectName4);
            }
            if (this.name == null) {
                String string = TraceNLSHelper.getInstance().getString("ssl.command.descriptive.prop.name.CWPKI0640E", "The name of the descriptive property is empty or blank");
                throw new CommandValidationException(string);
            }
            if (this.value == null) {
                String string = "The value of the descriptive property is empty or blank";
                throw new CommandValidationException(string);
            }
            if (this.type == null) {
                String string = TraceNLSHelper.getInstance().getString("ssl.command.descriptive.prop.type.CWPKI0641E", "The type of the descriptive property is not valid");
                throw new CommandValidationException(string);
            }
            if (!commandHelper.contains(CommandConstants.DESC_PROPERTY_TYPES, this.type)) {
                String string = "The type of the descriptive property is not valid";
                throw new CommandValidationException(string);
            }
            if (this.type.equalsIgnoreCase("INT") || this.type.equalsIgnoreCase("INTEGER")) {
                try {
                    serializable = Integer.valueOf(this.value);
                }
                catch (NumberFormatException numberFormatException) {
                    String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.value.not.integer.CWPKI0668E", new Object[]{this.value, this.type}, "\"" + this.value + "\" is not of type \"" + this.type + "\".");
                    throw new CommandValidationException(string);
                }
            }
            serializable = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)serializable, CommandConstants.NAME, this.parentClassName);
            this.parentObjName = commandHelper.getObjectName(configService, session, objectName, this.parentDataType, (AttributeList)serializable, this.parentScopeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parentObjName: " + this.parentObjName);
            }
            if ((objectName2 = commandHelper.getDescPropObj(configService, session, this.parentObjName, this.descPropDataType, CommandConstants.NAME, this.name)) != null) {
                String string = "The " + this.descPropDataType + " named " + this.name + " beneath the " + this.parentDataType + " named " + this.parentClassName + " already exist.";
                throw new CommandValidationException(string);
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.commands.CreateDescriptiveProp.validate", "241", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName objectName2;
            ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName4 = configService.resolve(session, "Cell=")[0];
            if (objectName4 != null) {
                objectName = configService.queryConfigObjects(session, objectName4, objectName3, null)[0];
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.name);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.VALUE, this.value);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.TYPE, this.type);
            if (this.displayNameKey != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.DISPLAY_NAME_KEY, this.displayNameKey);
            }
            if (this.nlsRangeKey != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NLS_RANGE_KEY, this.nlsRangeKey);
            }
            if (this.hoverHelpKey != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.HOVER_HELP_KEY, this.hoverHelpKey);
            }
            if (this.range != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.RANGE, this.range);
            }
            if (this.inclusive != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.INCLUSIVE, this.inclusive);
            }
            if (this.firstClass != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.FIRST_CLASS, this.firstClass);
            }
            if ((objectName2 = configService.createConfigData(session, this.parentObjName, this.descPropDataType, null, attributeList)) != null) {
                taskCommandResultImpl.setResult(objectName2);
            }
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

