/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.migration;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.impl.FileAccessorUtil;
import com.ibm.ws.sm.workspace.impl.WorkSpaceImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public final class WSURIConverter
extends URIConverterImpl {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(WSURIConverter.class);
    private RepositoryContext context;
    private URI baseURI;
    FileAccessor fa = null;

    public WSURIConverter(RepositoryContext repositoryContext) {
        this.context = repositoryContext;
        this.baseURI = URI.createURI(repositoryContext.getURI());
        WorkSpaceImpl workSpaceImpl = (WorkSpaceImpl)repositoryContext.getWorkSpace();
        this.fa = workSpaceImpl.getFileAccessor();
    }

    public URI normalize(URI uRI) {
        return URI.createURI(this.baseURI.toString() + "/" + uRI.toString());
    }

    public OutputStream createOutputStream(URI uRI) throws IOException {
        URI uRI2 = this.normalize(uRI);
        this.checkExtracted(uRI);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createOutputStream", uRI2.toString());
        }
        return FileAccessorUtil.getOutputStream(this.fa, uRI2.toString());
    }

    public InputStream createInputStream(URI uRI) throws IOException {
        URI uRI2 = this.normalize(uRI);
        this.checkExtracted(uRI);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createInputStream", uRI2.toString());
        }
        return FileAccessorUtil.getInputStream(this.fa, uRI2.toString());
    }

    private void checkExtracted(URI uRI) throws IOException {
        String string = uRI.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "file " + string);
        }
        if (this.context.isAvailable(string) && !this.context.isExtracted(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "file is not exists,but not extracted " + string);
            }
            try {
                this.context.extract(string, false);
            }
            catch (WorkSpaceException workSpaceException) {
                throw new IOException(workSpaceException.getMessage());
            }
        }
    }
}

