/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.metadata.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryDocumentType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.impl.RepositoryDocumentTypeImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RepositoryContextTypeImpl
implements RepositoryContextType {
    protected static TraceComponent tc = WorkSpaceLogger.registerTC(RepositoryContextTypeImpl.class);
    protected String name = "";
    protected String dirName = null;
    protected String handlerClassName = null;
    protected List childContextTypes = null;
    protected List childContextTypeNames = new ArrayList();
    protected List documentTypes = null;
    protected List documentTypeNames = new ArrayList();
    protected RepositoryDocumentType rootDocumentType = null;
    protected String rootDocumentTypeName = null;
    protected RepositoryMetaData metaData = null;
    private transient HashMap reachableChildTypes = new HashMap();

    RepositoryContextTypeImpl(RepositoryMetaData repositoryMetaData) {
        this.metaData = repositoryMetaData;
    }

    public RepositoryDocumentType getRootDocumentType() {
        if (this.rootDocumentType == null && this.rootDocumentTypeName != null) {
            this.rootDocumentType = this.metaData.getDocumentType(this.rootDocumentTypeName);
            if (this.rootDocumentType == null) {
                this.rootDocumentTypeName = null;
            }
        }
        return this.rootDocumentType;
    }

    void setRootDocumentTypeName(String string) {
        this.rootDocumentTypeName = string;
    }

    public RepositoryContextType getChildContextType(String string) {
        RepositoryContextType repositoryContextType = this.metaData.getContextType(string);
        if (repositoryContextType != null && !this.getChildContextTypes().contains(repositoryContextType)) {
            repositoryContextType = null;
        }
        return repositoryContextType;
    }

    void addChildContextTypeName(String string) {
        this.childContextTypeNames.add(string);
    }

    public List getChildContextTypes() {
        if (this.childContextTypes == null) {
            this.childContextTypes = new ArrayList();
            for (int i = 0; i < this.childContextTypeNames.size(); ++i) {
                RepositoryContextType repositoryContextType = this.metaData.getContextType((String)this.childContextTypeNames.get(i));
                if (repositoryContextType != null) {
                    this.childContextTypes.add(repositoryContextType);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Child context is null: " + (String)this.childContextTypeNames.get(i));
            }
        }
        return this.childContextTypes;
    }

    public RepositoryDocumentType getChildDocumentType(String string) {
        Iterator iterator = this.getChildDocumentTypes().iterator();
        while (iterator.hasNext()) {
            RepositoryDocumentTypeImpl repositoryDocumentTypeImpl = (RepositoryDocumentTypeImpl)iterator.next();
            if (!repositoryDocumentTypeImpl.matches(string)) continue;
            return repositoryDocumentTypeImpl;
        }
        return null;
    }

    public List getChildDocumentTypes() {
        if (this.documentTypes == null) {
            this.documentTypes = new ArrayList();
            for (int i = 0; i < this.documentTypeNames.size(); ++i) {
                RepositoryDocumentType repositoryDocumentType = this.metaData.getDocumentType((String)this.documentTypeNames.get(i));
                if (repositoryDocumentType != null) {
                    this.documentTypes.add(repositoryDocumentType);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Child doc is null: " + (String)this.documentTypeNames.get(i));
            }
        }
        return this.documentTypes;
    }

    void addDocumentTypeName(String string) {
        this.documentTypeNames.add(string);
    }

    public String getName() {
        return this.name;
    }

    void setName(String string) {
        this.name = string;
    }

    public String getDirectoryName() {
        if (this.dirName == null && this.name != null) {
            this.dirName = this.name;
        }
        return this.dirName;
    }

    void setDirectoryName(String string) {
        this.dirName = string;
    }

    public String getHandlerClassName() {
        return this.handlerClassName;
    }

    void setHandlerClassName(String string) {
        this.handlerClassName = string;
    }

    public Set findReachableChildrenTo(String string) {
        HashSet<RepositoryContextType> hashSet = (HashSet<RepositoryContextType>)this.reachableChildTypes.get(string);
        if (hashSet == null) {
            hashSet = new HashSet<RepositoryContextType>();
            List list = this.getChildContextTypes();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                RepositoryContextType repositoryContextType = (RepositoryContextType)iterator.next();
                if (!repositoryContextType.getName().equals(string) && repositoryContextType.findReachableChildrenTo(string).isEmpty() || repositoryContextType.getName().equals("config")) continue;
                hashSet.add(repositoryContextType);
            }
            this.reachableChildTypes.put(string, hashSet);
        }
        return hashSet;
    }
}

