/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.metadata.impl;

import com.ibm.ws.sm.workspace.metadata.impl.MetaDataParserConstant;
import com.ibm.ws.sm.workspace.metadata.impl.RepositoryContextTypeImpl;
import com.ibm.ws.sm.workspace.metadata.impl.RepositoryDocumentTypeImpl;
import com.ibm.ws.sm.workspace.metadata.impl.RepositoryMetaDataImpl;
import com.ibm.ws.sm.workspace.metadata.impl.RepositoryValidatorDefImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MetaDataParserHandler
extends DefaultHandler
implements MetaDataParserConstant {
    private RepositoryMetaDataImpl metaData = new RepositoryMetaDataImpl();
    private boolean display = false;
    private static Writer out;
    private String indentString = "    ";
    private int indentLevel = 0;
    private RepositoryContextTypeImpl context = null;
    private String contextName = null;
    private RepositoryDocumentTypeImpl document = null;
    private String documentName = null;
    private RepositoryValidatorDefImpl validator = null;
    private String validatorName = null;
    private String elementName = null;
    private String elementValue = null;

    RepositoryMetaDataImpl getMetaData() {
        return this.metaData;
    }

    private void handleStartElement(String string) {
        this.elementName = string;
        this.elementValue = "";
        if (string.equals("context")) {
            this.context = null;
            this.contextName = "";
        } else if (string.equals("document")) {
            this.document = null;
            this.documentName = "";
        } else if (string.equals("validator")) {
            this.validator = null;
            this.validatorName = "";
        }
    }

    private RepositoryContextTypeImpl getContext() {
        if (this.context == null) {
            this.context = (RepositoryContextTypeImpl)this.getMetaData().getContextType(this.contextName);
            if (this.context == null) {
                this.context = new RepositoryContextTypeImpl(this.getMetaData());
                this.context.setName(this.contextName);
                this.getMetaData().addContextType(this.context);
            }
        }
        return this.context;
    }

    private RepositoryDocumentTypeImpl getDocument() {
        if (this.document == null) {
            this.document = (RepositoryDocumentTypeImpl)this.getMetaData().getDocumentType(this.documentName);
            if (this.document == null) {
                this.document = new RepositoryDocumentTypeImpl(this.getMetaData());
                this.document.setDisplayName(this.documentName);
                this.getMetaData().addDocumentType(this.document);
            }
        }
        return this.document;
    }

    private RepositoryValidatorDefImpl getValidator() {
        if (this.validator == null) {
            this.validator = (RepositoryValidatorDefImpl)this.getMetaData().getValidatorDef(this.validatorName);
            if (this.validator == null) {
                this.validator = new RepositoryValidatorDefImpl();
                this.validator.setDisplayName(this.validatorName);
                this.getMetaData().addValidatorType(this.validator);
            }
        }
        return this.validator;
    }

    private void handleEndElement(String string) {
        this.elementName = null;
        this.elementValue = this.elementValue.trim();
        if (string.equals("metadata-name")) {
            this.getMetaData().setName(this.elementValue);
        } else if (string.equals("root-context-type")) {
            this.getMetaData().setRootContextTypeName(this.elementValue);
        } else if (string.equals("context-name")) {
            this.contextName = this.elementValue;
            this.getContext();
        } else if (string.equals("document-name")) {
            this.documentName = this.elementValue;
            this.getDocument();
        } else if (string.equals("validator-name")) {
            this.validatorName = this.elementValue;
            this.getValidator();
        } else if (string.equals("child-document-name")) {
            this.getContext().addDocumentTypeName(this.elementValue);
        } else if (string.equals("child-context-name")) {
            this.getContext().addChildContextTypeName(this.elementValue);
        } else if (string.equals("root-document-type")) {
            this.getContext().setRootDocumentTypeName(this.elementValue);
        } else if (string.equals("root-refobject-type")) {
            this.getDocument().addRootRefObjectTypeName(this.elementValue);
        } else if (string.equals("child-validator-name")) {
            this.getDocument().addValidatorName(this.elementValue);
        } else if (string.equals("file-pattern")) {
            this.getDocument().setFilePattern(this.elementValue);
        } else if (string.equals("file-type")) {
            this.getDocument().setFileType(Integer.getInteger(this.elementValue));
        } else if (string.equals("validator-class-name")) {
            this.getValidator().setClassName(this.elementValue);
        } else if (string.equals("validator-description")) {
            this.getValidator().setDescription(this.elementValue);
        } else if (string.equals("validator-type")) {
            this.getValidator().setValidatorType(this.elementValue);
        } else if (string.equals("cross-document")) {
            this.getValidator().setCrossDocumentValidator(new Boolean(this.elementValue));
        }
    }

    private void handleChar(String string) {
        if (this.elementName == null) {
            return;
        }
        this.elementValue = this.elementValue + string;
    }

    public void startDocument() throws SAXException {
        try {
            out = new OutputStreamWriter((OutputStream)System.out, "UTF8");
            this.nl();
            this.nl();
            this.emit("START DOCUMENT");
            this.nl();
            this.emit("<?xml version='1.0' encoding='UTF-8'?>");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void endDocument() throws SAXException {
        this.nl();
        this.emit("END DOCUMENT");
        try {
            this.nl();
            out.flush();
        }
        catch (IOException iOException) {
            throw new SAXException("I/O error", iOException);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ++this.indentLevel;
        this.nl();
        this.emit("ELEMENT: ");
        String string4 = string2;
        if ("".equals(string4)) {
            string4 = string3;
        }
        this.emit("<" + string4);
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string5 = attributes.getLocalName(i);
                if ("".equals(string5)) {
                    string5 = attributes.getQName(i);
                }
                this.nl();
                this.emit("   ATTR: ");
                this.emit(string5);
                this.emit("\t\"");
                this.emit(attributes.getValue(i));
                this.emit("\"");
            }
        }
        if (attributes.getLength() > 0) {
            this.nl();
        }
        this.emit(">");
        this.handleStartElement(string4);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.nl();
        this.emit("END_ELM: ");
        String string4 = string2;
        if ("".equals(string4)) {
            string4 = string3;
        }
        this.emit("</" + string4 + ">");
        --this.indentLevel;
        this.handleEndElement(string4);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.nl();
        this.emit("CHARS:   ");
        String string = new String(cArray, n, n2);
        this.emit(string);
        this.handleChar(string);
    }

    private void emit(String string) throws SAXException {
        if (!this.display) {
            return;
        }
        try {
            out.write(string);
            out.flush();
        }
        catch (IOException iOException) {
            throw new SAXException("I/O error", iOException);
        }
    }

    private void nl() throws SAXException {
        if (!this.display) {
            return;
        }
        String string = System.getProperty("line.separator");
        try {
            out.write(string);
            for (int i = 0; i < this.indentLevel; ++i) {
                out.write(this.indentString);
            }
        }
        catch (IOException iOException) {
            throw new SAXException("I/O error", iOException);
        }
    }
}

