/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.metadata.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryDocumentType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryValidatorDef;
import com.ibm.ws.sm.workspace.metadata.impl.MetaDataParserHandler;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class MetaDataParser
extends DefaultHandler {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(MetaDataParser.class);
    private MetaDataParserHandler handler = null;

    public static void main(String[] stringArray) {
        MetaDataParser metaDataParser = new MetaDataParser();
        metaDataParser.parse("c:/websphere/appserver/config/.repository");
        RepositoryMetaData repositoryMetaData = metaDataParser.getMetaData();
        MetaDataParser.display(repositoryMetaData);
        System.exit(0);
    }

    RepositoryMetaData getMetaData() {
        if (this.handler == null) {
            return null;
        }
        return this.handler.getMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parse(String string) {
        this.handler = new MetaDataParserHandler();
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader = thread2.getContextClassLoader();
        thread2.setContextClassLoader(this.getClass().getClassLoader());
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            File file = new File(string);
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Parsing " + fileArray[i]);
                    }
                    SAXParser sAXParser = sAXParserFactory.newSAXParser();
                    this.parse(sAXParser, fileArray[i]);
                }
            } else {
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                this.parse(sAXParser, file);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            thread2.setContextClassLoader(classLoader);
        }
    }

    private void parse(SAXParser sAXParser, File file) throws Exception {
        sAXParser.parse(file, (DefaultHandler)this.handler);
    }

    static void display(RepositoryMetaData repositoryMetaData) {
        if (repositoryMetaData == null) {
            return;
        }
        System.out.println("Meta Data:");
        System.out.println("\tName:" + repositoryMetaData.getName());
        RepositoryContextType repositoryContextType = repositoryMetaData.getRootContextType();
        System.out.println("\tRootContextType:" + repositoryContextType.getName());
        System.out.println("\tContext Type:");
        Iterator iterator = repositoryMetaData.getContextTypeAccess();
        while (iterator.hasNext()) {
            MetaDataParser.display((RepositoryContextType)iterator.next());
        }
        System.out.println();
        System.out.println("\tDocument Type:");
        iterator = repositoryMetaData.getDocumentTypeAccess();
        while (iterator.hasNext()) {
            MetaDataParser.display((RepositoryDocumentType)iterator.next());
        }
        System.out.println();
        System.out.println("\tValidator Type:");
        iterator = repositoryMetaData.getValidatorDefAccess();
        while (iterator.hasNext()) {
            MetaDataParser.display((RepositoryValidatorDef)iterator.next());
        }
    }

    static void display(RepositoryContextType repositoryContextType) {
        int n;
        System.out.println("\t\tContext:" + repositoryContextType.getName());
        System.out.println("\t\t\tHandle Class name:" + repositoryContextType.getHandlerClassName());
        System.out.println("\t\t\tChild Context Type:");
        List list = repositoryContextType.getChildContextTypes();
        for (n = 0; n < list.size(); ++n) {
            System.out.println("\t\t\t\t" + ((RepositoryContextType)list.get(n)).getName());
        }
        System.out.println("\t\t\tDocument Type:");
        list = repositoryContextType.getChildDocumentTypes();
        for (n = 0; n < list.size(); ++n) {
            System.out.println("\t\t\t\t" + ((RepositoryDocumentType)list.get(n)).getDisplayName());
        }
        if (repositoryContextType.getRootDocumentType() != null) {
            System.out.println("\t\t\tRoot Doc Type:" + repositoryContextType.getRootDocumentType().getDisplayName());
        }
    }

    static void display(RepositoryDocumentType repositoryDocumentType) {
        System.out.println("\t\tDocument:" + repositoryDocumentType.getDisplayName());
        System.out.println("\t\t\tFile Pattern:" + repositoryDocumentType.getFilePattern());
        System.out.println("\t\t\tFile Type:" + repositoryDocumentType.getFileType());
        System.out.println("\t\t\tRoot RefObject Types:");
        for (int i = 0; i < repositoryDocumentType.getRootRefObjectTypes().length; ++i) {
            System.out.println("\t\t\t\t" + repositoryDocumentType.getRootRefObjectTypes()[i]);
        }
        System.out.println("\t\t\tValidator Type:");
        List list = repositoryDocumentType.getValidatorDefs();
        for (int i = 0; i < list.size(); ++i) {
            System.out.println("\t\t\t\t" + ((RepositoryValidatorDef)list.get(i)).getDisplayName());
        }
    }

    static void display(RepositoryValidatorDef repositoryValidatorDef) {
        System.out.println("\t\tValidator:" + repositoryValidatorDef.getDisplayName());
        System.out.println("\t\t\tClass Name:" + repositoryValidatorDef.getClassName());
        System.out.println("\t\t\tDescription:" + repositoryValidatorDef.getDescription());
        System.out.println("\t\t\tType:" + repositoryValidatorDef.getValidatorType());
    }
}

