/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceEvent;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceListener;
import com.ibm.ws.sm.workspace.WorkSpaceRepositoryAdapter;
import com.ibm.ws.sm.workspace.impl.FileAccessorUtil;
import com.ibm.ws.sm.workspace.impl.RepositoryContextImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceCatalogManager;
import com.ibm.ws.sm.workspace.impl.WorkSpaceConstant;
import com.ibm.ws.sm.workspace.impl.WorkSpaceEventImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceFileImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.impl.WorkSpaceMasterRepositoryAdapter;
import com.ibm.ws.sm.workspace.impl.WorkSpaceMessage;
import com.ibm.ws.sm.workspace.impl.WorkspaceMetadataAccessor;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.migration.MOFWorkSpaceImpl;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class WorkSpaceImpl
extends MOFWorkSpaceImpl
implements WorkSpace,
WorkSpaceConstant,
WorkSpaceMessage {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(WorkSpaceImpl.class);
    protected boolean enableSave = true;
    protected String userName = "";
    protected String sessionId = null;
    protected String path = null;
    protected String userPath = null;
    protected FileAccessor fa = null;
    protected RepositoryContextImpl rootContext = null;
    protected List listeners = new ArrayList();
    private WorkSpaceCatalogManager catalogManager;
    private RepositoryMetaData metaData;
    private WorkSpaceRepositoryAdapter repositoryAdapter;
    private ManagedObjectMetadataHelper metadataHelper;
    private ManagedObjectMetadataAccessor accessor;
    private String callerInfo = "";
    private boolean cleanupNeeded = true;

    public WorkSpaceImpl(String string) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WorkSpaceImpl (userName: " + string + ")");
        }
        this.userName = string;
        Properties properties = new Properties();
        try {
            this.accessor = new WorkspaceMetadataAccessor(this, properties);
            this.metadataHelper = new ManagedObjectMetadataHelper(this.accessor);
        }
        catch (AdminException adminException) {
            throw new WorkSpaceException("unexpected expection", adminException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WorkSpaceImpl (userName: " + string + ")");
        }
    }

    WorkSpaceCatalogManager getCatalogManager() {
        if (this.catalogManager == null) {
            this.catalogManager = new WorkSpaceCatalogManager(this);
        }
        return this.catalogManager;
    }

    public RepositoryMetaData getMetaData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMetaData");
        }
        if (this.metaData == null) {
            this.metaData = this.getRepositoryAdapter().getMetaData();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMetaData", this.metaData);
        }
        return this.metaData;
    }

    WorkSpaceRepositoryAdapter getRepositoryAdapter() {
        return this.repositoryAdapter;
    }

    void setRepositoryAdapter(WorkSpaceRepositoryAdapter workSpaceRepositoryAdapter) {
        this.repositoryAdapter = workSpaceRepositoryAdapter;
    }

    void setMetaData(RepositoryMetaData repositoryMetaData) {
        this.metaData = repositoryMetaData;
    }

    public void addWorkSpaceListener(WorkSpaceListener workSpaceListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addWorkSpaceListener", workSpaceListener);
        }
        if (!this.listeners.contains(workSpaceListener)) {
            this.listeners.add(workSpaceListener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addWorkSpaceListener");
        }
    }

    public Map checkSynchState() throws WorkSpaceException {
        return this.getRootContext().checkSynchState();
    }

    public Map checkSynchStateForRefresh() throws WorkSpaceException {
        return this.getRootContext().checkSynchStateForRefresh();
    }

    public Map checkSynchState(RepositoryContext repositoryContext) throws WorkSpaceException {
        return repositoryContext.checkSynchState();
    }

    public Map checkSynchStateForRefresh(RepositoryContext repositoryContext) throws WorkSpaceException {
        return repositoryContext.checkSynchStateForRefresh();
    }

    public void checkValid() throws WorkSpaceException {
        if (!this.isValid()) {
            this.notify(new WorkSpaceEventImpl(this, 0));
            throw WorkSpaceLogger.createException(tc, "WKSP0009E Workspace is invalid");
        }
    }

    public synchronized RepositoryContext create(RepositoryContext repositoryContext, RepositoryContextType repositoryContextType, String string) throws WorkSpaceException {
        return repositoryContext.create(repositoryContextType, string);
    }

    private RepositoryContextImpl createRootContext() {
        RepositoryContextImpl repositoryContextImpl = new RepositoryContextImpl(this, this.getRootContextType(), "", null);
        repositoryContextImpl.setRelativeURI("");
        return repositoryContextImpl;
    }

    public void delete(RepositoryContext repositoryContext) throws WorkSpaceException {
        repositoryContext.delete(true);
    }

    public void extract(RepositoryContext repositoryContext, String string, boolean bl) throws WorkSpaceException {
        repositoryContext.extract(string, bl);
    }

    public void extract(RepositoryContext repositoryContext, boolean bl) throws WorkSpaceException {
        repositoryContext.extract(bl);
    }

    public Collection findContext(RepositoryContextType repositoryContextType) throws WorkSpaceException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "findContext,  type: " + repositoryContextType.getName() + ", from ROOT.");
        }
        return this.getRootContext().findContext(repositoryContextType);
    }

    public RepositoryContext findContext(String string) throws WorkSpaceException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "findContext,   uri: " + string + ", from ROOT.");
        }
        return this.getRootContext().findContext(string);
    }

    public List getModifiedList() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getModifiedList");
        }
        List list = this.getRootContext().getModifiedList(true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getModifiedList", list);
        }
        return list;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getPath() {
        if (this.path == null) {
            this.path = this.getUserPath() + FILE_SEPERATOR + "workspace";
        }
        return this.path;
    }

    public String getUserPath() {
        if (this.userPath == null) {
            this.userPath = WORKSPACE_PATH_NAME + FILE_SEPERATOR + this.getUserName();
        }
        return this.userPath;
    }

    public FileAccessor getFileAccessor() {
        return this.fa;
    }

    void setFileAccessor(FileAccessor fileAccessor) {
        this.fa = fileAccessor;
    }

    void setUserRoot(String string) {
        this.userPath = string + FILE_SEPERATOR + this.getUserName();
        this.path = null;
    }

    void setPath(String string) {
        this.path = string;
        this.userPath = string;
    }

    public RepositoryContext getRootContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRootContext ()");
        }
        if (this.rootContext == null) {
            this.rootContext = this.createRootContext();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRootContext () \"" + this.rootContext + "\"");
        }
        return this.rootContext;
    }

    private RepositoryContextType getRootContextType() {
        return this.getMetaData().getRootContextType();
    }

    public boolean isExtracted(RepositoryContext repositoryContext, String string) {
        return repositoryContext.isExtracted(string);
    }

    void enableSave() {
        this.enableSave = true;
    }

    void disableSave() {
        this.enableSave = false;
    }

    boolean isEnableSave() {
        return this.enableSave;
    }

    boolean isValid() throws WorkSpaceException {
        boolean bl = true;
        bl = this.sessionId == null ? false : this.getRepositoryAdapter().isValid(this);
        return bl;
    }

    public void notify(WorkSpaceEvent workSpaceEvent) throws WorkSpaceException {
        Iterator iterator;
        String string = "notify [" + workSpaceEvent.getType() + "] ";
        if (tc.isEntryEnabled()) {
            iterator = workSpaceEvent.getSource();
            if (iterator instanceof WorkSpaceImpl) {
                string = string + "path: " + this.userPath;
            } else if (iterator instanceof RepositoryContextImpl) {
                string = string + (RepositoryContextImpl)((Object)iterator);
            } else if (iterator instanceof WorkSpaceFileImpl) {
                string = string + (WorkSpaceFileImpl)((Object)iterator);
            }
            Tr.entry(tc, string);
        }
        iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            WorkSpaceListener workSpaceListener = (WorkSpaceListener)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  listener: " + workSpaceListener);
            }
            workSpaceListener.handle(workSpaceEvent);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    void remove() throws WorkSpaceException {
        this.release();
        this.getRepositoryAdapter().remove(this);
    }

    public void release() throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Start releasing workspace. Discard all the changes in the local workspace of UserID: " + this.userName + ", SessionID: " + this.sessionId);
        }
        this.getRootContext().release(true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Done releasing workspace.");
        }
    }

    public void releaseUnchanged(boolean bl) throws WorkSpaceException {
        this.getRootContext().releaseUnchanged(true, bl);
    }

    public void release(RepositoryContext repositoryContext) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Start releasing context. Discard all the changes under context " + repositoryContext.getName());
        }
        repositoryContext.release(true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Done releasing context.");
        }
    }

    public void removePersistent() throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removePersistent");
        }
        if (WorkSpaceMasterRepositoryAdapter.class.isInstance(this.repositoryAdapter)) {
            FileAccessorUtil.deleteTree(this.getFileAccessor(), "");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removePersistent");
        }
    }

    public void removeWorkSpaceListener(WorkSpaceListener workSpaceListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeWorkSpaceListener", workSpaceListener);
        }
        if (this.listeners.contains(workSpaceListener)) {
            this.listeners.remove(workSpaceListener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeWorkSpaceListener");
        }
    }

    void restore() throws WorkSpaceException {
        String string = this.getPath();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Restoring repository context tree from wstemp, " + string);
        }
        long l = System.currentTimeMillis();
        ((RepositoryContextImpl)this.getRootContext()).restore();
        long l2 = System.currentTimeMillis();
        long l3 = (l2 - l) / 1000L;
        long l4 = (l2 - l) % 1000L;
        ((RepositoryContextImpl)this.getRootContext()).getAdapter().releaseCachedCatalog(this.getUserName());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Restoring repository context tree from wstemp, " + string + " took " + l3 + "." + l4 + " sec.");
        }
    }

    public void synch(RepositoryContext repositoryContext, Map map) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "synch", new Object[]{repositoryContext, map});
        }
        repositoryContext.synch(map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "synch");
        }
    }

    public void synch(Map map) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "synch from root", map);
        }
        this.getRootContext().synch(map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "synch from root");
        }
    }

    boolean ofSession(String string) throws WorkSpaceException {
        boolean bl = true;
        if (this.isValid()) {
            if (string == null) {
                string = "";
            }
            bl = this.sessionId.equals(string);
        }
        return bl;
    }

    void setSessionId(String string) throws WorkSpaceException {
        if (string == null) {
            string = "";
        }
        this.sessionId = string;
        this.getRepositoryAdapter().setSessionId(this);
        this.notify(new WorkSpaceEventImpl(this, 1));
    }

    void unsetSessionId() throws WorkSpaceException {
        if (this.sessionId != null) {
            this.getRepositoryAdapter().unsetSessionId(this);
            this.sessionId = null;
        }
        this.notify(new WorkSpaceEventImpl(this, 0));
        this.listeners.clear();
    }

    void setCallerInfo(String string) {
        this.callerInfo = string;
    }

    String getCallerInfo() {
        return this.callerInfo;
    }

    public boolean cleanupNeeded() {
        return this.cleanupNeeded;
    }

    public void setDisableCleanup() {
        this.cleanupNeeded = false;
    }

    public ManagedObjectMetadataHelper getMetadataHelper() {
        return this.metadataHelper;
    }

    public ManagedObjectMetadataAccessor getManagedObjectMetadataAccessor() {
        return this.accessor;
    }
}

