/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.impl.RepositoryContextImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceConstant;
import com.ibm.ws.sm.workspace.impl.WorkSpaceImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.impl.WorkSpacePersistentObjectImpl;
import com.ibm.ws.sm.workspace.metadata.RepositoryDocumentType;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.util.Enumeration;

public final class WorkSpaceFileImpl
implements WorkSpaceFile,
WorkSpaceConstant {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(WorkSpaceFileImpl.class);
    private RepositoryContext context;
    private RepositoryDocumentType type = null;
    private FileAccessor fa = null;
    private WorkSpacePersistentObjectImpl data;

    WorkSpaceFileImpl(RepositoryContext repositoryContext, String string) {
        this.context = repositoryContext;
        this.data = new WorkSpacePersistentObjectImpl(string);
        WorkSpaceImpl workSpaceImpl = (WorkSpaceImpl)repositoryContext.getWorkSpace();
        this.fa = workSpaceImpl.getFileAccessor();
    }

    public RepositoryContext getContext() {
        return this.context;
    }

    public String getFileName() {
        return this.getName().replace('/', FILE_SEPERATOR_CHAR);
    }

    public String getName() {
        return this.data.getName();
    }

    public String getPath() {
        StringBuffer stringBuffer = new StringBuffer(this.context.getPath());
        stringBuffer.append(FILE_SEPERATOR);
        stringBuffer.append(this.getFileName());
        return stringBuffer.toString();
    }

    public Integer getState() {
        return this.data.getState();
    }

    public String getURI() {
        StringBuffer stringBuffer = new StringBuffer(this.context.getURI());
        if (stringBuffer.length() > 0) {
            stringBuffer.append('/');
        }
        stringBuffer.append(this.getName());
        return stringBuffer.toString();
    }

    public RepositoryDocumentType getType() {
        if (this.type == null) {
            this.type = this.context.getType().getChildDocumentType(this.getName());
        }
        return this.type;
    }

    public String getProperty(String string) {
        return this.data.getProperty(string);
    }

    public void setProperty(String string, String string2) throws WorkSpaceException {
        this.data.setProperty(string, string2);
        ((RepositoryContextImpl)this.context).save(false, false);
    }

    public Enumeration getPropertyNames() {
        return this.data.getPropertyNames();
    }

    public String removeProperty(String string) throws WorkSpaceException {
        String string2 = this.data.removeProperty(string);
        ((RepositoryContextImpl)this.context).save(false, false);
        return string2;
    }

    void restore(String string) throws WorkSpaceException {
        this.data.restore(string);
    }

    public String getPersistData() {
        return this.data.getPersistData();
    }

    void setState(Integer n) {
        this.data.setState(n);
    }

    public String toString() {
        return this.getURI();
    }
}

