/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sm.workspace.impl.WorkSpaceConstant;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.wsspi.configarchive.DefaultFileAccessor;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class FileAccessorUtil {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(FileAccessorUtil.class);
    public static final int FOLDER = 0;
    public static final int DOCUMENT = 1;
    public static final int BOTH = 2;
    public static final int FULL = -1;
    public static final int SELF = 0;
    public static final int ONE = 1;
    private static String needTrace = null;
    private static final String[] listType = new String[]{"FOLDER", "DOCUMENT", "BOTH"};

    public static void deleteTree(FileAccessor fileAccessor, String string) {
        if (tc.isEntryEnabled() && needTrace == null) {
            Tr.entry(tc, "deleteTree \"" + string + "\"");
            needTrace = string;
        }
        List list = null;
        try {
            list = fileAccessor.listFolders(string);
        }
        catch (Exception exception) {
            list = new ArrayList();
        }
        Object[] objectArray = list.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            FileAccessorUtil.deleteTree(fileAccessor, (String)objectArray[i]);
        }
        try {
            list = fileAccessor.listFiles(string);
        }
        catch (Exception exception) {
            list = new ArrayList();
        }
        objectArray = list.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            FileAccessorUtil.delete(fileAccessor, (String)objectArray[i]);
        }
        FileAccessorUtil.delete(fileAccessor, string);
        if (string.equals(needTrace)) {
            needTrace = null;
        }
        if (tc.isEntryEnabled() && needTrace == null) {
            Tr.exit(tc, "deleteTree \"" + string + "\"");
        }
    }

    public static void delete(FileAccessor fileAccessor, String string) {
        try {
            fileAccessor.delete(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "  delete " + string);
        }
    }

    public static List listFiles(FileAccessor fileAccessor, String string, int n, int n2) {
        ArrayList arrayList = new ArrayList();
        FileAccessorUtil.listFiles(fileAccessor, string, n, n2, arrayList);
        return arrayList;
    }

    private static void listFiles(FileAccessor fileAccessor, String string, int n, int n2, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listFiles (URI: " + string + ", Type: " + listType[n] + ", Depth: " + n2 + ")");
        }
        if (n2 == 0) {
            try {
                if (fileAccessor.exists(string)) {
                    list.add(string);
                }
            }
            catch (Exception exception) {
                String string2 = "";
                if (fileAccessor instanceof DefaultFileAccessor) {
                    DefaultFileAccessor defaultFileAccessor = (DefaultFileAccessor)fileAccessor;
                    string2 = "listFiles (" + defaultFileAccessor.getRootDir().getPath() + File.separator + string + ") failed with unexpected exception, " + exception;
                } else {
                    string2 = "listFiles (" + string + ") failed with unexpected exception, " + exception;
                }
                FFDCFilter.processException(exception, "com.ibm.ws.sm.workspace.impl.FileAccessorUtil.listFiles", "115");
                Tr.warning(tc, string2);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listFiles");
            }
            return;
        }
        List list2 = null;
        Object[] objectArray = null;
        if (n == 1 || n == 2) {
            try {
                list2 = fileAccessor.listFiles(string);
            }
            catch (Exception exception) {
                list2 = new ArrayList();
            }
            objectArray = list2.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding " + objectArray[i]);
                }
                list.add(objectArray[i]);
            }
        }
        list2 = null;
        try {
            list2 = fileAccessor.listFolders(string);
        }
        catch (Exception exception) {
            list2 = new ArrayList();
        }
        objectArray = list2.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (n == 2 || n == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding " + objectArray[i]);
                }
                list.add(objectArray[i]);
            }
            if (n2 == 1) continue;
            FileAccessorUtil.listFiles(fileAccessor, (String)objectArray[i], n, n2 == -1 ? -1 : n2 - 1, list);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listFiles");
        }
    }

    public static void makeDir(FileAccessor fileAccessor, String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeDir (" + string + ")");
        }
        try {
            fileAccessor.makeDir(string);
        }
        catch (IOException iOException) {
            String string2 = "";
            if (fileAccessor instanceof DefaultFileAccessor) {
                DefaultFileAccessor defaultFileAccessor = (DefaultFileAccessor)fileAccessor;
                string2 = "makeDir (" + defaultFileAccessor.getRootDir().getPath() + File.separator + string + ") failed with unexpected exception, " + iOException;
            } else {
                string2 = "makeDir (" + string + ") failed with unexpected exception, " + iOException;
            }
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.sm.workspace.impl.FileAccessorUtil.makeDir", "165", new Object[]{string2});
            throw iOException;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "makeDir " + string + " complete.");
        }
    }

    private static String getCallStack() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        String string = "";
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            string = string + "    " + stackTraceElementArray[i] + "\n";
        }
        return string;
    }

    public static boolean exist(FileAccessor fileAccessor, String string) {
        boolean bl = false;
        try {
            bl = fileAccessor.exists(string);
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!(!tc.isDebugEnabled() || bl && string.startsWith(".workspace_"))) {
            Tr.debug(tc, "  exist [" + (bl ? "1" : "0") + "] \"" + string + "\"");
        }
        return bl;
    }

    public static void copyFile(FileAccessor fileAccessor, String string, String string2) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyFile (" + string + " " + string2 + ")");
        }
        InputStream inputStream = fileAccessor.load(string);
        fileAccessor.save(string2, inputStream);
        if (inputStream instanceof FileInputStream) {
            inputStream.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyFile");
        }
    }

    public static String convertToURI(String string) throws IOException {
        return string;
    }

    public static InputStream getInputStream(FileAccessor fileAccessor, String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInputStream (" + string + ")");
        }
        InputStream inputStream = fileAccessor.load(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInputStream");
        }
        return inputStream;
    }

    public static OutputStream getOutputStream(FileAccessor fileAccessor, String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutputStream (" + string + ")");
        }
        OutputStream outputStream = fileAccessor.getOutputStream(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutputStream", outputStream);
        }
        return outputStream;
    }

    public static void deleteUserPath(FileAccessor fileAccessor, String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteUserPath (" + string + ")");
        }
        try {
            if (fileAccessor instanceof DefaultFileAccessor) {
                DefaultFileAccessor defaultFileAccessor = (DefaultFileAccessor)fileAccessor;
                File file = defaultFileAccessor.getRootDir();
                String string2 = file.getPath();
                String string3 = string2.substring(0, string2.lastIndexOf(File.separatorChar));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "UserPath ", string3);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RootPath ", string2);
                }
                if (string3.equals(string.replace('/', WorkSpaceConstant.FILE_SEPERATOR_CHAR))) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deletingUserPath ", string3);
                    }
                    defaultFileAccessor.deleteRootDir();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteUserPath");
        }
    }

    public static void createNewFile(FileAccessor fileAccessor, String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNewFile (" + string + ")");
        }
        try {
            if (fileAccessor instanceof DefaultFileAccessor) {
                DefaultFileAccessor defaultFileAccessor = (DefaultFileAccessor)fileAccessor;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating new file");
                }
                defaultFileAccessor.createNewFile(string);
            }
        }
        catch (IOException iOException) {
            String string2 = "";
            if (fileAccessor instanceof DefaultFileAccessor) {
                DefaultFileAccessor defaultFileAccessor = (DefaultFileAccessor)fileAccessor;
                string2 = "createNewFile (" + defaultFileAccessor.getRootDir().getPath() + File.separator + string + ") failed with unexpected exception, " + iOException;
            } else {
                string2 = "createNewFile (" + string + ") failed with unexpected exception, " + iOException;
            }
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.sm.workspace.impl.FileAccessorUtil.createNewFile", "260", new Object[]{string2});
            throw iOException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNewFile");
        }
    }

    public static long getLength(FileAccessor fileAccessor, String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLength (" + string + ")");
        }
        long l = 1L;
        try {
            if (fileAccessor instanceof DefaultFileAccessor) {
                DefaultFileAccessor defaultFileAccessor = (DefaultFileAccessor)fileAccessor;
                l = defaultFileAccessor.getLength(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLength return " + l);
        }
        return l;
    }

    public static String getFullPath(FileAccessor fileAccessor, String string) {
        String string2 = string;
        if (fileAccessor instanceof DefaultFileAccessor) {
            DefaultFileAccessor defaultFileAccessor = (DefaultFileAccessor)fileAccessor;
            string2 = defaultFileAccessor.getFullPath(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getFullPath return " + string2);
        }
        return string2;
    }
}

