/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.zOS;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.auth.AuthenticationFailedException;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.Cache;
import com.ibm.ws.security.auth.CacheEvictionListener;
import com.ibm.ws.security.auth.CacheException;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.zOS.SAFCredentialTokenImpl;
import com.ibm.ws.security.zOS.SAFServiceResult;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;

public final class PlatformCredentialManager {
    public static final String DEFAULT_UNAUTHENTICATED_AUDIT_STRING = "WebSphere Default/Unauthenticated Login";
    private static final String DEFAULT_PASSWORD_AUDIT_STRING = "WebSphere Userid/Password Login";
    private static final String DEFAULT_CERTIFICATE_AUDIT_STRING = "WebSphere Certificate Login";
    private static final String DEFAULT_AUTHORIZED_CREATE_AUDIT_STRING = "WebSphere Authorized Login";
    private static final String DEFAULT_SERVER_AUDIT_STRING = "WebSphere Server Identity";
    private static final TraceComponent tc = Tr.register(PlatformCredentialManager.class, "Security", "com.ibm.ejs.resources.security");
    private static final PlatformCredentialManager _instance = new PlatformCredentialManager();
    private String unauthenticatedUserId;
    private Cache _cache;
    static /* synthetic */ Class class$com$ibm$ws$security$auth$PlatformCredential;

    public static PlatformCredentialManager instance() {
        return _instance;
    }

    private PlatformCredentialManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        int n = 100;
        long l = 300000L;
        int n2 = 5000;
        this._cache = new Cache(n, l, n2, new CacheEvictionCallback());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public PlatformCredential createPasswordCredential(String string, String string2) throws PasswordCheckFailedException {
        return this.createPasswordCredential(string, string2, DEFAULT_PASSWORD_AUDIT_STRING);
    }

    public PlatformCredential createCertificateCredential(X509Certificate[] x509CertificateArray) throws CertificateMapFailedException {
        return this.createCertificateCredential(x509CertificateArray, DEFAULT_CERTIFICATE_AUDIT_STRING);
    }

    public PlatformCredential createCredential(String string) {
        return this.createCredential(string, DEFAULT_AUTHORIZED_CREATE_AUDIT_STRING);
    }

    public PlatformCredential createDefaultCredential() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDefaultCredential");
        }
        PlatformCredential platformCredential = new PlatformCredential();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDefaultCredential", platformCredential);
        }
        return platformCredential;
    }

    public PlatformCredential createPasswordCredential(String string, String string2, String string3) throws PasswordCheckFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPasswordCredential", new Object[]{string, string2 != null ? "****" : null, string3});
        }
        PlatformCredential platformCredential = new PlatformCredential(PlatformCredential.BASIC, string, string3);
        try {
            this.authenticateCredential(platformCredential, string2);
        }
        catch (Throwable throwable) {
            throw new PasswordCheckFailedException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createPasswordCredential", platformCredential);
        }
        return platformCredential;
    }

    public PlatformCredential createCertificateCredential(X509Certificate[] x509CertificateArray, String string) throws CertificateMapFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCertificateCredential", new Object[]{x509CertificateArray, string});
        }
        PlatformCredential platformCredential = new PlatformCredential(x509CertificateArray, string);
        try {
            this.authenticateCredential(platformCredential, null);
        }
        catch (Throwable throwable) {
            throw new CertificateMapFailedException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCertificateCredential", platformCredential);
        }
        return platformCredential;
    }

    public PlatformCredential createRoleCredential(String string, String string2, String string3) {
        PlatformCredential platformCredential;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createRoleCredential", new Object[]{string, string2, string3});
            }
            String string4 = this.createRoleAuditString(string, string2, string3);
            platformCredential = new PlatformCredential(PlatformCredential.ROLE, string3, string4);
            try {
                SAFCredentialTokenImpl sAFCredentialTokenImpl = this.getCredentialToken(platformCredential);
                if (sAFCredentialTokenImpl != null) {
                    platformCredential.setMvsUserId(sAFCredentialTokenImpl.getMvsUserId());
                } else {
                    platformCredential = null;
                }
            }
            catch (CredentialDestroyedException credentialDestroyedException) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Credential destroyed", credentialDestroyedException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRoleCredential", platformCredential);
        }
        return platformCredential;
    }

    public PlatformCredential createCredential(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCredential", new Object[]{string, string2});
        }
        PlatformCredential platformCredential = new PlatformCredential(PlatformCredential.ASSERTED, string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCredential", platformCredential);
        }
        return platformCredential;
    }

    public PlatformCredential createServerCredential() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerCredential");
        }
        String string = System.getProperty("user.name");
        PlatformCredential platformCredential = new PlatformCredential(PlatformCredential.SERVER, string, DEFAULT_SERVER_AUDIT_STRING);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerCredential", platformCredential);
        }
        return platformCredential;
    }

    private String createRoleAuditString(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer("WebSphere Role Delegation:");
        stringBuffer.append(" Application=").append(string);
        stringBuffer.append(",Role=").append(string2);
        stringBuffer.append(",Profile=").append(string3);
        return stringBuffer.toString();
    }

    public String getKeyFromCredential(PlatformCredential platformCredential) {
        String string;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getKeyFromCredential", platformCredential);
            }
            string = null;
            try {
                SAFCredentialTokenImpl sAFCredentialTokenImpl = this.getCredentialToken(platformCredential);
                if (sAFCredentialTokenImpl == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unable to get native credential token from PlatFormCredential");
                    }
                    throw new IllegalArgumentException("Unable to get native credential token from PlatFormCredential");
                }
                string = sAFCredentialTokenImpl.getAsString();
                this._cache.insert(string, platformCredential);
            }
            catch (CredentialDestroyedException credentialDestroyedException) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Credential already destroyed", credentialDestroyedException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyFromCredential", string);
        }
        return string;
    }

    public PlatformCredential getCredentialFromKey(String string) {
        PlatformCredential platformCredential;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getCredentialFromKey", string);
            }
            platformCredential = null;
            try {
                platformCredential = (PlatformCredential)this._cache.get(string);
            }
            catch (CacheException cacheException) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Unexpected cache exception", cacheException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCredentialFromKey", platformCredential);
        }
        return platformCredential;
    }

    public byte[] createUtoken(PlatformCredential platformCredential) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createUtoken", platformCredential);
        }
        byte[] byArray = this.ntv_createUtoken(platformCredential);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createUtoken", byArray);
        }
        return byArray;
    }

    private synchronized SAFCredentialTokenImpl getCredentialToken(PlatformCredential platformCredential) throws CredentialDestroyedException {
        SAFCredentialTokenImpl sAFCredentialTokenImpl;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getCredentialToken", platformCredential);
            }
            sAFCredentialTokenImpl = null;
            try {
                sAFCredentialTokenImpl = (SAFCredentialTokenImpl)this._cache.get(platformCredential);
            }
            catch (CacheException cacheException) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Unexpected cache exception", cacheException);
            }
        }
        if (sAFCredentialTokenImpl == null) {
            sAFCredentialTokenImpl = this.refreshCredential(platformCredential);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCredentialToken", sAFCredentialTokenImpl);
        }
        return sAFCredentialTokenImpl;
    }

    private synchronized SAFCredentialTokenImpl refreshCredential(PlatformCredential platformCredential) throws CredentialDestroyedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshCredential", platformCredential);
        }
        if (platformCredential.getCredentialType() == PlatformCredential.BASIC && !platformCredential.isAuthenticated()) {
            throw new CredentialDestroyedException();
        }
        SAFCredentialTokenImpl sAFCredentialTokenImpl = null;
        SAFCredentialTokenImpl sAFCredentialTokenImpl2 = null;
        try {
            sAFCredentialTokenImpl = (SAFCredentialTokenImpl)this._cache.get(platformCredential);
        }
        catch (Exception exception) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Cache failure", exception);
            }
            sAFCredentialTokenImpl = null;
        }
        if (sAFCredentialTokenImpl != null) {
            sAFCredentialTokenImpl2 = sAFCredentialTokenImpl;
        } else if (platformCredential.getCredentialType() == PlatformCredential.DEFAULT) {
            sAFCredentialTokenImpl2 = this.ntv_createCredentialToken(platformCredential, platformCredential.getUserId(), platformCredential.getAuditString(), null);
        } else if (platformCredential.getCredentialType() == PlatformCredential.BASIC) {
            sAFCredentialTokenImpl2 = this.ntv_createCredentialToken(platformCredential, platformCredential.getUserId(), platformCredential.getAuditString(), null);
        } else if (platformCredential.getCredentialType() == PlatformCredential.ASSERTED) {
            sAFCredentialTokenImpl2 = this.ntv_createCredentialToken(platformCredential, platformCredential.getUserId(), platformCredential.getAuditString(), null);
        } else if (platformCredential.getCredentialType() == PlatformCredential.ROLE) {
            sAFCredentialTokenImpl2 = this.ntv_createRoleCredentialToken(platformCredential, platformCredential.getRoleProfile(), platformCredential.getAuditString());
            if (sAFCredentialTokenImpl2 != null) {
                sAFCredentialTokenImpl2.setMvsUserId(platformCredential.getUserId());
            }
        } else if (platformCredential.getCredentialType() == PlatformCredential.SERVER) {
            sAFCredentialTokenImpl2 = this.ntv_createServerCredentialToken(platformCredential);
        } else if (platformCredential.getCredentialType() == PlatformCredential.CERTIFICATE) {
            byte[] byArray = this.getEncodedCertificate(platformCredential);
            sAFCredentialTokenImpl2 = this.ntv_createCertificateCredentialToken(platformCredential, byArray, byArray.length, platformCredential.getAuditString());
        } else {
            throw new IllegalArgumentException();
        }
        if (sAFCredentialTokenImpl == null && sAFCredentialTokenImpl2 != null) {
            this._cache.insert(platformCredential, sAFCredentialTokenImpl2);
        } else if (sAFCredentialTokenImpl2 == null) {
            Tr.error(tc, "security.zos.saf.authen.refresh.failed.error", new Object[]{platformCredential.getUserId(), SAFServiceResult.getSafServiceResult()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshCredential", sAFCredentialTokenImpl2);
        }
        return sAFCredentialTokenImpl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SAFCredentialTokenImpl authenticateCredential(PlatformCredential platformCredential, String string) throws AuthenticationFailedException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authenticateCredential", new Object[]{platformCredential, string != null ? "****" : null});
        }
        Object object3 = null;
        if (platformCredential.getCredentialType() == PlatformCredential.BASIC) {
            object3 = this.ntv_createCredentialToken(platformCredential, platformCredential.getUserId(), platformCredential.getAuditString(), string);
            if (object3 == null) {
                Tr.info(tc, "security.zos.saf.authen.pw.check.failed.info", new Object[]{platformCredential.getUserId(), SAFServiceResult.getSafServiceResult()});
            }
        } else if (platformCredential.getCredentialType() == PlatformCredential.CERTIFICATE && (object3 = this.ntv_createCertificateCredentialToken(platformCredential, (byte[])(object2 = this.getEncodedCertificate(platformCredential)), ((byte[])object2).length, platformCredential.getAuditString())) == null) {
            object = platformCredential.getCertificateChain()[0];
            Tr.info(tc, "security.zos.saf.authen.cert.map.failed.info", new Object[]{((X509Certificate)object).getIssuerX500Principal().getName(), ((X509Certificate)object).getSubjectX500Principal().getName(), SAFServiceResult.getSafServiceResult()});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Updated PlatformCredential", platformCredential);
        }
        if (object3 == null) {
            throw new AuthenticationFailedException();
        }
        PlatformCredentialManager platformCredentialManager = this;
        object2 = platformCredentialManager;
        synchronized (platformCredentialManager) {
            block15: {
                object = null;
                try {
                    object = (SAFCredentialTokenImpl)this._cache.get(platformCredential);
                }
                catch (CacheException cacheException) {
                    if (!tc.isDebugEnabled()) break block15;
                    Tr.debug(tc, "Unexpected cache exception", cacheException);
                }
            }
            if (object == null) {
                this._cache.insert(platformCredential, object3);
            } else {
                this.destroyCredential((SAFCredentialTokenImpl)object3);
                object3 = object;
            }
            // ** MonitorExit[var4_4 /* !! */ ] (shouldn't be in output)
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "authenticateCredential", object3);
            }
            return object3;
        }
    }

    void destroyCredential(SAFCredentialTokenImpl sAFCredentialTokenImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroyCredential", sAFCredentialTokenImpl);
        }
        this.ntv_destroyCredential(sAFCredentialTokenImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroyCredential");
        }
    }

    private byte[] getEncodedCertificate(PlatformCredential platformCredential) {
        byte[] byArray;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getEncodedCertificate", platformCredential);
            }
            byArray = null;
            try {
                X509Certificate x509Certificate = platformCredential.getCertificateChain()[0];
                byArray = x509Certificate.getEncoded();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Unable to get certificate data", certificateEncodingException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEncodedCertificate", byArray);
        }
        return byArray;
    }

    public PlatformCredential getPlatformCredentialFromSubject(Subject subject) {
        PlatformCredential platformCredential;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getPlatformCredentialFromSubject", subject);
            }
            platformCredential = null;
            if (subject != null) {
                try {
                    GetPlatformCredentialAction getPlatformCredentialAction = new GetPlatformCredentialAction(subject);
                    platformCredential = (PlatformCredential)AccessController.doPrivileged(getPlatformCredentialAction);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "Unable to get platform cred", privilegedActionException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPlatformCredentialFromSubject", platformCredential);
        }
        return platformCredential;
    }

    private native SAFCredentialTokenImpl ntv_createCredentialToken(PlatformCredential var1, String var2, String var3, String var4);

    private native SAFCredentialTokenImpl ntv_createCertificateCredentialToken(PlatformCredential var1, byte[] var2, int var3, String var4);

    private native SAFCredentialTokenImpl ntv_createRoleCredentialToken(PlatformCredential var1, String var2, String var3);

    private native SAFCredentialTokenImpl ntv_createServerCredentialToken(PlatformCredential var1);

    private native byte[] ntv_createUtoken(PlatformCredential var1);

    private native void ntv_destroyCredential(SAFCredentialTokenImpl var1);

    private static final class GetPlatformCredentialAction
    implements PrivilegedExceptionAction {
        final Subject _subject;

        GetPlatformCredentialAction(Subject subject) {
            this._subject = subject;
        }

        public Object run() throws Exception {
            PlatformCredential platformCredential = null;
            Set set = this._subject.getPrivateCredentials(class$com$ibm$ws$security$auth$PlatformCredential == null ? (class$com$ibm$ws$security$auth$PlatformCredential = PlatformCredentialManager.class$("com.ibm.ws.security.auth.PlatformCredential")) : class$com$ibm$ws$security$auth$PlatformCredential);
            if (!set.isEmpty()) {
                platformCredential = (PlatformCredential)set.iterator().next();
            } else {
                WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(this._subject);
                if (wSCredential != null) {
                    platformCredential = (PlatformCredential)wSCredential.get("com.ibm.ws.security.zos.PlatformCredential");
                }
            }
            return platformCredential;
        }
    }

    private static final class CacheEvictionCallback
    implements CacheEvictionListener {
        CacheEvictionCallback() {
        }

        public void evicted(List list) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "evicted", list);
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof SAFCredentialTokenImpl)) continue;
                _instance.destroyCredential((SAFCredentialTokenImpl)e);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "evicted");
            }
        }
    }
}

