/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.zOS;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.zOS.PlatformCredentialManager;
import com.ibm.ws.security.zOS.authz.AccessLevel;
import com.ibm.ws.security.zOS.authz.SAFAuthorizationManager;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;

public final class NativeConfiguration {
    public static final TraceComponent tc = Tr.register(NativeConfiguration.class, "Security", "com.ibm.ejs.resources.security");
    private static final NativeConfiguration _instance = new NativeConfiguration();
    private Properties topLevelSecurityProps = null;

    public static NativeConfiguration getConfig() {
        return _instance;
    }

    private NativeConfiguration() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public void initializeConfiguration(Security security2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeConfiguration");
        }
        this.buildSecurityProperties(security2);
        PlatformCredentialManager platformCredentialManager = PlatformCredentialManager.instance();
        PlatformCredential platformCredential = platformCredentialManager.createServerCredential();
        SecurityConfig securityConfig = SecurityConfig.getConfig();
        String string = NativeConfiguration.getValue("cell.short.name");
        String string2 = NativeConfiguration.getValue("generic.server.short.name");
        if (this.isControllerJvm()) {
            this.setupTrustedApplications(platformCredential, string, string2);
            if (this.ntv_isTrustedApplicationsEnabled()) {
                Tr.audit(tc, "security.zos.trusted.apps.enabled");
            } else {
                Tr.audit(tc, "security.zos.trusted.apps.disabled");
            }
        }
        if (this.isControllerJvm() && this.isThreadIdentityRequested()) {
            this.setupThreadIdentity(platformCredential, string, string2);
            if (this.isApplicationSyncToThreadEnabled()) {
                Tr.audit(tc, "security.zos.threadid.app.enabled");
            } else if (this.isApplicationSyncToThreadRequested() && !this.isApplicationSyncToThreadEnabled()) {
                Tr.audit(tc, "security.zos.threadid.app.denied");
            }
            if (this.isConnectionManagementThreadIdentityEnabled()) {
                Tr.audit(tc, "security.zos.threadid.connmgmt.enabled");
            } else if (this.isConnectionManagementThreadIdentityRequested() && !this.isConnectionManagementThreadIdentityEnabled()) {
                Tr.audit(tc, "security.zos.threadid.connmgmt.denied");
            }
            if (this.ntv_isSkipSurrogateChecksEnabled()) {
                Tr.audit(tc, "security.zos.threadid.skip.surrogate.enabled");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeConfiguration", this);
        }
    }

    private void buildSecurityProperties(Security security2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildSecurityProperties");
        }
        EList eList = security2.getProperties();
        this.topLevelSecurityProps = new Properties();
        for (int i = 0; i < eList.size(); ++i) {
            Property property = (Property)eList.get(i);
            this.topLevelSecurityProps.put(property.getName(), property.getValue());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildSecurityProperties");
        }
    }

    public static String getValue(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getValue", string);
        }
        String string2 = null;
        SecurityConfig securityConfig = SecurityConfig.getConfig();
        Object object = securityConfig.getValue(string);
        string2 = object instanceof String ? (String)object : (object != null ? object.toString() : NativeConfiguration._instance.topLevelSecurityProps.getProperty(string));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getValue", string2 != null ? "****" : string2);
        }
        return string2;
    }

    public boolean isConnectionManagementThreadIdentityEnabled() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isConnectionManagementThreadIdentityEnabled");
        }
        boolean bl2 = bl = this.isConnectionManagementThreadIdentityRequested() && this.ntv_isSyncToThreadEnabled();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isConnectionManagementThreadIdentityEnabled", new Boolean(bl));
        }
        return bl;
    }

    public boolean isApplicationSyncToThreadEnabled() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isApplicationSyncToThreadEnabled");
        }
        boolean bl2 = bl = this.isApplicationSyncToThreadRequested() && this.ntv_isSyncToThreadEnabled();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isApplicationSyncToThreadEnabled", new Boolean(bl));
        }
        return bl;
    }

    private boolean isControllerJvm() {
        PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
        return platformHelper.isControlJvm();
    }

    private void setupTrustedApplications(PlatformCredential platformCredential, String string, String string2) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setupTrustedApplications", new Object[]{platformCredential, string, string2});
            }
            String string3 = "BBO.TRUSTEDAPPS." + string + "." + string2;
            String string4 = "FACILITY";
            try {
                if (SAFAuthorizationManager.instance().isAuthorized(platformCredential, string4, string3)) {
                    this.setTrustedApplicationsEnabled(true);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Not setting trusted apps", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupTrustedApplications");
        }
    }

    private boolean setTrustedApplicationsEnabled(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTrustedApplicationsEnabled", new Boolean(bl));
        }
        boolean bl2 = this.ntv_setTrustedApplicationsEnabled(bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTrustedApplicationsEnabled", new Boolean(bl2));
        }
        return bl2;
    }

    private boolean isThreadIdentityRequested() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isThreadIdentityRequested");
        }
        boolean bl2 = this.isApplicationSyncToThreadRequested();
        boolean bl3 = this.isConnectionManagementThreadIdentityRequested();
        boolean bl4 = bl = bl2 || bl3;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isThreadIdentityRequested", new Boolean(bl));
        }
        return bl;
    }

    private boolean isConnectionManagementThreadIdentityRequested() {
        return Boolean.valueOf(NativeConfiguration.getValue("was.security.EnableRunAsIdentity"));
    }

    private boolean isApplicationSyncToThreadRequested() {
        return Boolean.valueOf(NativeConfiguration.getValue("was.security.EnableSyncToOSThread"));
    }

    private void setupThreadIdentity(PlatformCredential platformCredential, String string, String string2) {
        block9: {
            SAFAuthorizationManager sAFAuthorizationManager;
            String string3;
            String string4;
            block8: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "setupThreadIdentity", new Object[]{platformCredential, string, string2});
                }
                string4 = "BBO.SYNC." + string + "." + string2;
                string3 = "FACILITY";
                sAFAuthorizationManager = SAFAuthorizationManager.instance();
                try {
                    if (sAFAuthorizationManager.isAuthorized(platformCredential, string3, string4, AccessLevel.CONTROL)) {
                        this.setSkipSurrogateChecksEnabled(true);
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "Not setting skip surrogate checks", exception);
                }
            }
            try {
                if (sAFAuthorizationManager.isAuthorized(platformCredential, string3, string4, AccessLevel.READ)) {
                    this.setSyncToThreadEnabled(true);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "Not setting thread identity enabled", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupThreadIdentity");
        }
    }

    private boolean setSyncToThreadEnabled(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSyncToThreadEnabled", new Boolean(bl));
        }
        boolean bl2 = this.ntv_setSyncToThreadEnabled(bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSyncToThreadEnabled", new Boolean(bl2));
        }
        return bl2;
    }

    private boolean setSkipSurrogateChecksEnabled(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSkipSurrogateChecksEnabled", new Boolean(bl));
        }
        boolean bl2 = this.ntv_setSkipSurrogateChecksEnabled(bl);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSkipSurrogateChecksEnabled", new Boolean(bl2));
        }
        return bl2;
    }

    private native boolean ntv_setTrustedApplicationsEnabled(boolean var1);

    private native boolean ntv_isTrustedApplicationsEnabled();

    private native boolean ntv_setSyncToThreadEnabled(boolean var1);

    private native boolean ntv_isSyncToThreadEnabled();

    private native boolean ntv_setSkipSurrogateChecksEnabled(boolean var1);

    private native boolean ntv_isSkipSurrogateChecksEnabled();
}

