/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.TrustAssociationInterceptor;
import com.ibm.websphere.security.WebSphereBaseTrustAssociationInterceptor;
import com.ibm.websphere.security.WebTrustAssociationException;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.websphere.security.WebTrustAssociationUserException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.tai.NegotiateTrustAssociationInterceptor;
import com.ibm.wsspi.security.tai.TAIPrincipal;
import com.ibm.wsspi.security.tai.TAIResult;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

final class TAIWrapper {
    private TrustAssociationInterceptor tai = null;
    private NegotiateTrustAssociationInterceptor taiV2 = null;
    private com.ibm.wsspi.security.tai.TrustAssociationInterceptor taiV3 = null;
    private String name;
    private static final TraceComponent tc = Tr.register(TAIWrapper.class, null, "com.ibm.ejs.resources.security");

    TAIWrapper(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TAIWrapper(" + object + ")");
        }
        if (object == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TrustAssociationInterceptor is null");
            }
            throw new NullPointerException("TrustAssociationInterceptor is null");
        }
        if (object instanceof com.ibm.wsspi.security.tai.TrustAssociationInterceptor) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Trust association type: com.ibm.wsspi.security.tai.TrustAssociationInterceptor");
            }
            this.taiV3 = (com.ibm.wsspi.security.tai.TrustAssociationInterceptor)object;
            this.setName(this.taiV3.getType());
        } else if (object instanceof NegotiateTrustAssociationInterceptor) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Trust association type: com.ibm.wsspi.security.tai.NegotiateTrustAssociationInterceptor");
            }
            this.taiV2 = (NegotiateTrustAssociationInterceptor)object;
            if (object instanceof WebSphereBaseTrustAssociationInterceptor) {
                this.setName(((WebSphereBaseTrustAssociationInterceptor)object).getType());
            } else {
                this.setName(this.getClassName());
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Trust association type: com.ibm.websphere.security.TrustAssociationInterceptor");
            }
            this.tai = (TrustAssociationInterceptor)object;
            if (object instanceof WebSphereBaseTrustAssociationInterceptor) {
                this.setName(((WebSphereBaseTrustAssociationInterceptor)object).getType());
            } else {
                this.setName(this.getClassName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TAIWrapper(" + object + ")");
        }
    }

    TAIResult negotiateAndValidateEstablishedTrust(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws WebTrustAssociationFailedException, WebTrustAssociationUserException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "negotiateAndValidateEstablishedTrust()");
        }
        TAIResult tAIResult = null;
        if (this.taiV3 != null) {
            tAIResult = this.taiV3.negotiateValidateandEstablishTrust(httpServletRequest, httpServletResponse);
        } else if (this.taiV2 != null) {
            int n = this.taiV2.negotiateAndValidateEstablishedTrust(httpServletRequest, httpServletResponse);
            if (n == 200) {
                Subject subject = this.taiV2.getSubject();
                if (subject != null) {
                    String string = this.getTAIUsernameFromSubjectPrincipal(subject);
                    if (string != null && (string = string.trim()).length() == 0) {
                        string = null;
                    }
                    if (string == null) {
                        string = this.taiV2.getAuthenticatedUsername(httpServletRequest);
                    }
                    tAIResult = TAIResult.create(n, string, subject);
                } else {
                    tAIResult = TAIResult.create(n, this.taiV2.getAuthenticatedUsername(httpServletRequest));
                }
            } else {
                tAIResult = TAIResult.create(n);
            }
        } else {
            this.tai.validateEstablishedTrust(httpServletRequest);
            tAIResult = TAIResult.create(200, this.tai.getAuthenticatedUsername(httpServletRequest));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "negotiateAndValidateEstablishedTrust(): status code = " + tAIResult.getStatus());
        }
        return tAIResult;
    }

    boolean isTargetInterceptor(HttpServletRequest httpServletRequest) throws WebTrustAssociationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTargetInterceptor()");
        }
        boolean bl = false;
        bl = this.taiV3 != null ? this.taiV3.isTargetInterceptor(httpServletRequest) : (this.taiV2 != null ? this.taiV2.isTargetInterceptor(httpServletRequest) : this.tai.isTargetInterceptor(httpServletRequest));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTargetInterceptor(): " + this.name + " returning " + bl);
        }
        return bl;
    }

    void cleanup() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup()");
        }
        if (this.taiV3 != null) {
            this.taiV3.cleanup();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, this.name + " is cleaned up");
            }
        } else if (this.taiV2 != null) {
            if (this.taiV2 instanceof WebSphereBaseTrustAssociationInterceptor) {
                ((WebSphereBaseTrustAssociationInterceptor)((Object)this.taiV2)).cleanup();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, this.name + " is cleaned up");
                }
            }
        } else if (this.tai instanceof WebSphereBaseTrustAssociationInterceptor) {
            ((WebSphereBaseTrustAssociationInterceptor)((Object)this.tai)).cleanup();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, this.name + " is cleaned up");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup()");
        }
    }

    String getName() {
        return this.name;
    }

    private void setName(String string) {
        if (string != null && (string = string.trim()).length() != 0) {
            this.name = string;
        }
        if (this.name == null) {
            this.name = this.getClassName();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Trust association class name: " + this.name);
        }
    }

    protected String getClassName() {
        String string = null;
        if (this.taiV3 != null) {
            string = this.taiV3.getClass().getName();
        } else if (this.taiV2 != null) {
            string = this.taiV2.getClass().getName();
        } else if (this.tai != null) {
            string = this.tai.getClass().getName();
        }
        return string;
    }

    private String getTAIUsernameFromSubjectPrincipal(final Subject subject) throws WebTrustAssociationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTAIUsernameFromSubjectPrincipal");
        }
        String string = null;
        if (subject != null) {
            try {
                string = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws WebTrustAssociationFailedException {
                        Set<Principal> set = subject.getPrincipals();
                        Object[] objectArray = null;
                        if (set.size() > 0) {
                            objectArray = set.toArray();
                        }
                        if (objectArray != null && objectArray.length == 1) {
                            if (objectArray[0] instanceof Principal) {
                                return ((Principal)objectArray[0]).getName();
                            }
                            Tr.error(tc, "security.web.ta.invalidprincipal");
                            return null;
                        }
                        if (objectArray != null) {
                            String string = null;
                            for (int i = 0; i < objectArray.length; ++i) {
                                if (!(objectArray[i] instanceof TAIPrincipal)) continue;
                                if (string == null) {
                                    string = ((Principal)objectArray[i]).getName();
                                    continue;
                                }
                                Tr.error(tc, "security.web.ta.invalidprincipal");
                                throw new WebTrustAssociationFailedException("More than one com.ibm.wsspi.security.tai.TAIPrincipal in the Subject");
                            }
                            if (string == null) {
                                Tr.error(tc, "security.web.ta.invalidprincipal");
                            }
                            return string;
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.web.TAIWrapper.getTAIUsernameFromSubjectPrincipal", "328", this);
                throw (WebTrustAssociationFailedException)privilegedActionException.getException();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTAIUsernameFromSubjectPrincipal: " + string);
        }
        return string;
    }
}

