/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token;

import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.DistributedMap;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.AuthCache;
import com.ibm.ws.security.auth.CacheException;
import com.ibm.ws.security.auth.DistributedMapFactory;
import com.ibm.ws.security.auth.ServerCredSigner;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.token.AuthenticationTokenImpl;
import com.ibm.ws.security.token.AuthorizationTokenImpl;
import com.ibm.ws.security.token.PropagationTokenImpl;
import com.ibm.ws.security.token.SingleSignonTokenImpl;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.ws.security.zOS.PlatformCredentialManager;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.wsspi.security.token.AuthenticationToken;
import com.ibm.wsspi.security.token.AuthorizationToken;
import com.ibm.wsspi.security.token.PropagationToken;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.security.token.Token;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.ietf.jgss.GSSCredential;

public class WSCredentialTokenMapper
implements WSCredentialTokenMapperInterface {
    private LTPAServerObject ltpaServer;
    private ContextManager contextManager;
    private WSPrincipal wsPrincipal;
    private static WSCredentialTokenMapperInterface wsCredTokenMapper = null;
    private DistributedMap dm;
    private DistributedMap dmns;
    private String activeAuthMech;
    private MessageDigest md;
    private static final String MESSAGE_DIGEST_ALGORITHM = "SHA";
    private String JCEProvider;
    public static ContextManager ctxMgr = ContextManagerFactory.getInstance();
    private static boolean propEnabled = true;
    private static boolean propEnabledChecked = false;
    private static final TraceComponent tc = Tr.register(WSCredentialTokenMapper.class, null, "com.ibm.ejs.resources.security");
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    private static final WebSphereRuntimePermission GET_OPAQUE_TOKEN_FROM_MBEAN = new WebSphereRuntimePermission("wssecurity.getOpaqueTokenFromMBean");
    static /* synthetic */ Class class$com$ibm$wsspi$security$token$Token;
    static /* synthetic */ Class class$com$ibm$wsspi$security$token$AuthorizationToken;
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class class$com$ibm$ws$security$token$AbstractTokenImpl;

    public static WSCredentialTokenMapperInterface getInstance() {
        if (wsCredTokenMapper == null) {
            wsCredTokenMapper = new WSCredentialTokenMapper();
        }
        return wsCredTokenMapper;
    }

    public WSCredentialTokenMapper() {
        block5: {
            this.ltpaServer = null;
            this.contextManager = null;
            this.wsPrincipal = null;
            this.dm = null;
            this.dmns = null;
            this.activeAuthMech = null;
            this.md = null;
            this.JCEProvider = "IBMJCE";
            this.JCEProvider = this.getJCEProvider();
            try {
                this.md = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM, this.JCEProvider);
                try {
                    this.activeAuthMech = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism");
                    if (!this.activeAuthMech.equals("SWAM")) {
                        this.ltpaServer = (LTPAServerObject)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return LTPAServerObject.getLTPAServer();
                            }
                        });
                    }
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.token.WSCredentialTokenMapper.init", "147", this);
                    throw privilegedActionException.getException();
                }
                this.contextManager = ContextManagerFactory.getInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSCredentialTokenMapper.constructor", "155", this);
                Tr.debug(tc, "Exception validating LTPA token.", new Object[]{exception});
                if (this.contextManager == null) break block5;
                this.contextManager.setRootException(exception);
            }
        }
    }

    private DistributedMap getDM() {
        if (this.dm == null) {
            this.dm = DistributedMapFactory.getMap("WSSecureMap");
        }
        return this.dm;
    }

    private DistributedMap getDMNotShared() {
        if (this.dmns == null) {
            this.dmns = DistributedMapFactory.getMap("WSSecureMapNotShared");
        }
        return this.dmns;
    }

    public WSCredential createWSCredentialFromProperties(Hashtable hashtable) throws WSLoginFailedException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createWSCredentialFromProperties");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + MAP_CREDENTIAL.toString());
            }
            securityManager.checkPermission(MAP_CREDENTIAL);
        }
        try {
            Object object;
            Object object2;
            String string;
            String string2;
            Object object3;
            Enumeration enumeration;
            Object object4;
            Object object5 = null;
            Object object6 = null;
            String string3 = null;
            String string4 = null;
            ArrayList<String> arrayList = null;
            Hashtable<String, String> hashtable2 = null;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            Enumeration enumeration2 = hashtable.keys();
            while (enumeration2 != null && enumeration2.hasMoreElements()) {
                object4 = (String)enumeration2.nextElement();
                if (object4 == null || (enumeration = hashtable.get(object4)) == null) continue;
                if (!bl && ((String)object4).equals("com.ibm.wsspi.security.cred.uniqueId")) {
                    object5 = enumeration;
                    if (!((String)object5).startsWith("user") && !this.contextManager.isInternalServerId((String)object5)) {
                        object5 = "user:" + (String)object5;
                    }
                    bl = true;
                    continue;
                }
                if (!bl2 && ((String)object4).equals("com.ibm.wsspi.security.cred.realm")) {
                    object6 = enumeration;
                    if (!((String)object6).equalsIgnoreCase(ContextManagerFactory.getInstance().getDefaultRealm())) {
                        Tr.warning(tc, "security.sap.warning.realm.does.not.match.current.realm", (Object)new Object[]{object6, ContextManagerFactory.getInstance().getDefaultRealm()});
                    }
                    bl2 = true;
                    continue;
                }
                if (!bl3 && ((String)object4).equals("com.ibm.wsspi.security.cred.securityName")) {
                    string3 = enumeration;
                    bl3 = true;
                    continue;
                }
                if (!bl4 && ((String)object4).equals("com.ibm.wsspi.security.cred.longSecurityName")) {
                    string4 = enumeration;
                    bl4 = true;
                    continue;
                }
                if (!bl5 && ((String)object4).equals("com.ibm.wsspi.security.cred.groups")) {
                    object3 = (ArrayList)((Object)enumeration);
                    arrayList = new ArrayList<String>();
                    arrayList.addAll((Collection<String>)object3);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Prepending \"group:\" to group list entries.");
                    }
                    for (int i = 0; i < arrayList.size(); ++i) {
                        string2 = (String)arrayList.get(i);
                        string = null;
                        if (string2.startsWith("group")) continue;
                        string = "group:" + this.contextManager.getDefaultRealm() + "/" + string2;
                        arrayList.set(i, string);
                    }
                    bl5 = true;
                    continue;
                }
                if (((String)object4).equals("com.ibm.wsspi.security.cred.cacheKey")) {
                    if (enumeration != null && enumeration instanceof String && ((String)((Object)enumeration)).equals("")) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Cache Key value is null string. Ignore it.");
                        continue;
                    }
                    if (hashtable2 == null) {
                        hashtable2 = new Hashtable();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting Cache Key in hashtable: " + enumeration);
                    }
                    hashtable2.put((String)object4, (String)((Object)enumeration));
                    continue;
                }
                if (hashtable2 == null) {
                    hashtable2 = new Hashtable<String, String>();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting key in hashtable: " + (String)object4);
                }
                hashtable2.put((String)object4, (String)((Object)enumeration));
            }
            object4 = null;
            if (string4 == null || string4.length() == 0) {
                enumeration = object5;
                if (((String)object5).startsWith("user:")) {
                    enumeration = ((String)object5).substring("user:".length());
                } else if (((String)object5).startsWith("server:")) {
                    enumeration = ((String)object5).substring("server:".length());
                }
                string4 = RealmSecurityName.getSecurityName((String)((Object)enumeration));
            }
            if (object6 == null || ((String)object6).length() == 0) {
                object6 = ContextManagerFactory.getInstance().getDefaultRealm();
            }
            if (string4 == null || string4.length() == 0) {
                Tr.error(tc, "security.sap.error.longsecurityname.not.found.in.hashtable");
                throw new WSLoginFailedException("Did not find value for com.ibm.wsspi.security.cred.longSecurityName property.");
            }
            if (!bl) {
                Tr.error(tc, "security.sap.error.uniqueid.not.found.in.hashtable");
                throw new WSLoginFailedException("Did not find value for com.ibm.wsspi.security.cred.uniqueId property.");
            }
            if (!bl3) {
                Tr.error(tc, "security.sap.error.securityname.not.found.in.hashtable");
                throw new WSLoginFailedException("Did not find value for com.ibm.wsspi.security.cred.securityName property.");
            }
            enumeration = null;
            object3 = object5;
            final String string5 = object6;
            string2 = string3;
            string = string4;
            ArrayList<String> arrayList2 = arrayList;
            try {
                enumeration = (WSCredential)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction((String)object3, arrayList2){
                    private final /* synthetic */ String val$accessIdPriv;
                    private final /* synthetic */ ArrayList val$groupListPriv;
                    {
                        this.val$accessIdPriv = string4;
                        this.val$groupListPriv = arrayList;
                    }

                    public Object run() throws Exception {
                        return new WSCredentialImpl(string5, string2, string, "", this.val$accessIdPriv, null, this.val$groupListPriv);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.token.WSCredentialTokenMapper.createWSCredentialFromProperties", "399", this);
                throw privilegedActionException.getException();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating auth mech cred.");
            }
            if (this.activeAuthMech.equals("LTPA")) {
                object2 = enumeration;
                object = this.ltpaServer;
                try {
                    object4 = (WSCredential)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction((LTPAServerObject)object, (WSCredential)object2){
                        private final /* synthetic */ LTPAServerObject val$ltpaServerPriv;
                        private final /* synthetic */ WSCredential val$regCredPriv;
                        {
                            this.val$ltpaServerPriv = lTPAServerObject;
                            this.val$regCredPriv = wSCredential;
                        }

                        public Object run() throws Exception {
                            return this.val$ltpaServerPriv.createLTPAToken(this.val$regCredPriv);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception occurred creating new WS cred.", new Object[]{privilegedActionException.getException()});
                    }
                    FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.security.token.WSCredentialTokenMapper.createWSCredentialFromProperties", "425", this);
                    this.contextManager.setRootException(privilegedActionException.getException());
                    throw privilegedActionException.getException();
                }
            } else if (this.activeAuthMech.equals("SWAM")) {
                object2 = enumeration;
                try {
                    object4 = (WSCredential)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction((WSCredential)object2){
                        private final /* synthetic */ WSCredential val$regCredPriv;
                        {
                            this.val$regCredPriv = wSCredential;
                        }

                        public Object run() throws Exception {
                            return new WSCredentialImpl(this.val$regCredPriv, "No OID for this mechanism", RegistryUtil.nullByteArray, false, -1L);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception occurred creating new WS cred.", new Object[]{privilegedActionException.getException()});
                    }
                    FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.security.token.WSCredentialTokenMapper.createWSCredentialFromProperties", "451", this);
                    this.contextManager.setRootException(privilegedActionException.getException());
                    throw privilegedActionException.getException();
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Authentication mechanism not SWAM or LTPA.  Returning reg cred for auth mech: " + this.activeAuthMech);
                }
                object4 = enumeration;
            }
            if (object4 != null && hashtable2 != null) {
                object2 = hashtable2.keys();
                while (object2 != null && object2.hasMoreElements()) {
                    Object v;
                    object = (String)object2.nextElement();
                    if (object == null || (v = hashtable2.get(object)) == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting key/value in hashtable of WSCred: " + (String)object + ", " + v);
                    }
                    if (((String)object).equals("com.ibm.wsspi.security.cred.cacheKey") && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cache Key Object: " + v.getClass().getName());
                    }
                    object4.set((String)object, v);
                }
            }
            if (ctxMgr.getPlatformHelper().isZOS() && object4 != null && object4.get("com.ibm.ws.security.zos.PlatformCredential") == null && (object2 = (Boolean)SecurityConfig.getConfig().getValue("security.use.localos.userregistry")) != null && ((Boolean)object2).booleanValue()) {
                object = null;
                object = ctxMgr.isInternalServerCredential((WSCredential)object4) ? PlatformCredentialManager.instance().createServerCredential() : PlatformCredentialManager.instance().createCredential(string3);
                object4.set("com.ibm.ws.security.zos.PlatformCredential", object);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createWSCredentialFromProperties");
            }
            return object4;
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            Tr.error(tc, "security.sap.error.credential.not.mapped", new Object[]{wSLoginFailedException});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createWSCredentialFromProperties");
            }
            FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.token.WSCredentialTokenMapper.createWSCredentialFromProperties", "522", this);
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            Tr.error(tc, "security.sap.error.credential.not.mapped", new Object[]{exception});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createWSCredentialFromProperties");
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSCredentialTokenMapper.createWSCredentialFromProperties", "529", this);
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
    }

    public WSCredential createWSCredentialFromTokens(byte[] byArray, AuthorizationToken authorizationToken) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createWSCredentialFromTokens");
        }
        if (byArray == null || authorizationToken == null) {
            throw new WSLoginFailedException("Passed in null parameters.");
        }
        String string = null;
        long l = 0L;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        ArrayList<String> arrayList = null;
        Object var11_10 = null;
        String string6 = null;
        boolean bl = true;
        WSCredential wSCredential = null;
        try {
            Object object;
            String string7;
            Object object2;
            Object object3;
            Object object4;
            Enumeration enumeration = authorizationToken.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                object4 = (String)enumeration.nextElement();
                if ((string == null || string.length() == 0) && ((String)object4).equals("com.ibm.wsspi.security.cred.uniqueId") && (object3 = authorizationToken.getAttributes((String)object4)) != null && ((String[])object3).length > 0) {
                    string = object3[0];
                }
                l = authorizationToken.getExpiration();
                if ((string2 == null || string2.length() == 0) && ((String)object4).equals("com.ibm.wsspi.security.cred.realm") && (object3 = authorizationToken.getAttributes((String)object4)) != null && ((String[])object3).length > 0) {
                    string2 = object3[0];
                }
                if ((string3 == null || string3.length() == 0) && ((String)object4).equals("com.ibm.wsspi.security.cred.securityName") && (object3 = authorizationToken.getAttributes((String)object4)) != null && ((String[])object3).length > 0) {
                    string3 = object3[0];
                }
                if ((string4 == null || string4.length() == 0) && ((String)object4).equals("com.ibm.wsspi.security.cred.longSecurityName") && (object3 = authorizationToken.getAttributes((String)object4)) != null && ((String[])object3).length > 0) {
                    string4 = object3[0];
                }
                if ((string5 == null || string5.length() == 0) && ((String)object4).equals("com.ibm.wsspi.security.cred.primaryGroupId") && (object3 = authorizationToken.getAttributes((String)object4)) != null && ((String[])object3).length > 0) {
                    string5 = object3[0];
                }
                if (arrayList == null && ((String)object4).equals("com.ibm.wsspi.security.cred.groups") && (object3 = authorizationToken.getAttributes((String)object4)) != null && ((String[])object3).length > 0) {
                    arrayList = new ArrayList<String>(((String[])object3).length);
                    for (int i = 0; i < ((String[])object3).length; ++i) {
                        if (object3[i] == null) continue;
                        arrayList.add(object3[i]);
                    }
                }
                if ((string6 == null || string6.length() == 0) && ((String)object4).equals("com.ibm.wsspi.security.cred.oid") && (object3 = authorizationToken.getAttributes((String)object4)) != null && ((String[])object3).length > 0) {
                    string6 = object3[0];
                }
                if (!((String)object4).equals("com.ibm.wsspi.security.cred.forwardable")) continue;
                object3 = authorizationToken.getAttributes((String)object4);
                if (object3 != null && ((String[])object3).length > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Forwardable string = " + object3[0]);
                    }
                    bl = Boolean.valueOf(object3[0]);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Forwardable attribute null: com.ibm.wsspi.security.cred.forwardable");
            }
            boolean bl2 = true;
            if (string == null || string.length() == 0) {
                throw new WSLoginFailedException("Missing the ACCESSID attribute: com.ibm.wsspi.security.cred.uniqueId");
            }
            if (l == 0L) {
                throw new WSLoginFailedException("Missing the EXPIRATION attribute: com.ibm.wsspi.security.cred.expiration");
            }
            if (string2 == null || string2.length() == 0) {
                throw new WSLoginFailedException("Missing the REALM attribute: com.ibm.wsspi.security.cred.realm");
            }
            if (string3 == null || string3.length() == 0) {
                throw new WSLoginFailedException("Missing the SECURITYNAME attribute: com.ibm.wsspi.security.cred.securityName");
            }
            if (string4 == null || string4.length() == 0) {
                throw new WSLoginFailedException("Missing the LONGSECURITYNAME attribute: com.ibm.wsspi.security.cred.longSecurityName");
            }
            if (arrayList == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "There are no groups defined for user: " + string3);
            }
            if ((string5 == null || string5.length() == 0) && tc.isDebugEnabled()) {
                Tr.debug(tc, "There is no primary group defined for user: " + string3);
            }
            if (string6 == null || string6.length() == 0) {
                throw new WSLoginFailedException("Missing the OID attribute: com.ibm.wsspi.security.cred.oid");
            }
            object4 = null;
            object3 = string;
            String string8 = (String)SecurityConfig.getConfig().getValue("com.ibm.websphere.security.krb.support_ltpa");
            if ("oid:1.2.840.113554.1.2.2".endsWith(string6) && string8 != null && string8.equalsIgnoreCase("true")) {
                object2 = null;
                string7 = (String)SecurityConfig.getConfig().getValue("com.ibm.wsspi.security.token.authenticationTokenFactory");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating ltpa auth token using factory " + string7 + " for caller: " + string3);
                }
                try {
                    object = this.ltpaServer;
                    object2 = (com.ibm.wsspi.security.ltpa.Token)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction((LTPAServerObject)object, (String)object3, string7){
                        private final /* synthetic */ LTPAServerObject val$ltpaServerPriv;
                        private final /* synthetic */ String val$accessIdPriv;
                        private final /* synthetic */ String val$factory;
                        {
                            this.val$ltpaServerPriv = lTPAServerObject;
                            this.val$accessIdPriv = string;
                            this.val$factory = string2;
                        }

                        public Object run() throws Exception {
                            return this.val$ltpaServerPriv.createLTPAToken(this.val$accessIdPriv, this.val$factory);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.token.WSCredentialTokenMapper.createAuthzTokenFromWSCredential", "714", this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "createSSOTokenFromWSCredential", new Object[]{privilegedActionException.getException()});
                    }
                    throw privilegedActionException.getException();
                }
                byArray = object2.getBytes();
            }
            object2 = byArray;
            string7 = string2;
            object = string3;
            String string9 = string4;
            String string10 = string5;
            ArrayList<String> arrayList2 = arrayList;
            String string11 = string6;
            long l2 = l;
            boolean bl3 = bl;
            try {
                object4 = (WSCredential)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction((String)object, string9, string10, (String)object3, arrayList2){
                    private final /* synthetic */ String val$securityNamePriv;
                    private final /* synthetic */ String val$longSecurityNamePriv;
                    private final /* synthetic */ String val$primaryGroupIdPriv;
                    private final /* synthetic */ String val$accessIdPriv;
                    private final /* synthetic */ ArrayList val$groupsPriv;
                    {
                        this.val$securityNamePriv = string2;
                        this.val$longSecurityNamePriv = string3;
                        this.val$primaryGroupIdPriv = string4;
                        this.val$accessIdPriv = string5;
                        this.val$groupsPriv = arrayList;
                    }

                    public Object run() throws Exception {
                        return new WSCredentialImpl(string7, this.val$securityNamePriv, this.val$longSecurityNamePriv, this.val$primaryGroupIdPriv != null ? this.val$primaryGroupIdPriv : RegistryUtil.nullString, this.val$accessIdPriv, null, this.val$groupsPriv);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred creating new WS cred.", new Object[]{privilegedActionException.getException()});
                }
                FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.security.token.WSCredentialTokenMapper.createWSCredentialFromTokens", "754", this);
                throw privilegedActionException.getException();
            }
            Object object5 = object4;
            try {
                wSCredential = (WSCredential)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction((WSCredential)object5, string11, (byte[])object2, bl3, l2){
                    private final /* synthetic */ WSCredential val$credPriv;
                    private final /* synthetic */ String val$oidPriv;
                    private final /* synthetic */ byte[] val$credTokenPriv;
                    private final /* synthetic */ boolean val$forwardablePriv;
                    private final /* synthetic */ long val$expirationPriv;
                    {
                        this.val$credPriv = wSCredential;
                        this.val$oidPriv = string;
                        this.val$credTokenPriv = byArray;
                        this.val$forwardablePriv = bl;
                        this.val$expirationPriv = l;
                    }

                    public Object run() throws Exception {
                        return new WSCredentialImpl(this.val$credPriv, this.val$oidPriv, this.val$credTokenPriv, this.val$forwardablePriv, this.val$expirationPriv);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred creating new WS cred.", new Object[]{privilegedActionException.getException()});
                }
                FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.security.token.WSCredentialTokenMapper.createWSCredentialFromTokens", "776", this);
                throw privilegedActionException.getException();
            }
            if (wSCredential == null) {
                throw new WSLoginFailedException("WSCredential is null.");
            }
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            Tr.error(tc, "security.sap.error.credential.not.mapped", new Object[]{wSLoginFailedException.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSLoginFailedException occurred creating new WS cred from SAP tokens.", new Object[]{wSLoginFailedException});
            }
            FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.token.WSCredentialTokenMapper.createWSCredentialFromTokens", "790", this);
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            Tr.error(tc, "security.sap.error.credential.not.mapped", new Object[]{exception.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred creating new WS cred from SAP tokens.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSCredentialTokenMapper.createWSCredentialFromTokens", "797", this);
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("WSCredential created with the following values: \n");
        stringBuffer.append("\trealm = ");
        stringBuffer.append(string2);
        stringBuffer.append("\n\tsecurityName = ");
        stringBuffer.append(string3);
        stringBuffer.append("\n\tlongSecurityName = ");
        stringBuffer.append(string4);
        stringBuffer.append("\n\taccessId = ");
        stringBuffer.append(string);
        stringBuffer.append("\n\tGroup count = ");
        stringBuffer.append(arrayList != null ? String.valueOf(arrayList.size()) : "0");
        stringBuffer.append("\n\toid = ");
        stringBuffer.append(string6);
        stringBuffer.append("\n\texpiration = ");
        stringBuffer.append(l);
        stringBuffer.append("\n\tforwardable = ");
        stringBuffer.append(bl);
        stringBuffer.append("\n");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, stringBuffer.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createWSCredentialFromTokens");
        }
        return wSCredential;
    }

    public AuthenticationToken createAuthTokenFromWSCredential(WSCredential wSCredential) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAuthTokenFromWSCredential");
        }
        byte[] byArray = null;
        String string = (String)SecurityConfig.getConfig().getValue("com.ibm.websphere.security.krb.support_ltpa");
        if (string == null || !string.equalsIgnoreCase("true")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createAuthTokenFromWSCredential (null), ltpa not supported.");
            }
            return null;
        }
        try {
            byArray = wSCredential.getCredentialToken();
            if (byArray == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createAuthTokenFromWSCredential (null), no ltpa token in WSCredential.");
                }
                return null;
            }
            AuthenticationTokenImpl authenticationTokenImpl = new AuthenticationTokenImpl();
            authenticationTokenImpl.initializeToken((Subject)null, "oid:1.3.18.0.2.30.2", byArray);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createAuthTokenFromWSCredential");
            }
            return authenticationTokenImpl;
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            Tr.error(tc, "security.sap.error.authentication.token.not.mapped", new Object[]{wSLoginFailedException});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createAuthTokenFromWSCredential");
            }
            FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.token.WSCredentialTokenMapper.createAuthTokenFromWSCredential", "872", this);
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            Tr.error(tc, "security.sap.error.authentication.token.not.mapped", new Object[]{exception});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createAuthTokenFromWSCredential");
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSCredentialTokenMapper.createAuthTokenFromWSCredential", "879", this);
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
    }

    public SingleSignonToken createSSOTokenFromWSCredential(WSCredential wSCredential) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSSOTokenFromWSCredential");
        }
        com.ibm.wsspi.security.ltpa.Token token = null;
        try {
            Object object;
            String string = (String)SecurityConfig.getConfig().getValue("com.ibm.wsspi.security.token.singleSignonTokenFactory");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating sso token using factory " + string + " for caller: " + wSCredential.getSecurityName());
            }
            try {
                object = this.ltpaServer;
                token = (com.ibm.wsspi.security.ltpa.Token)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction((LTPAServerObject)object, wSCredential, string){
                    private final /* synthetic */ LTPAServerObject val$ltpaServerPriv;
                    private final /* synthetic */ WSCredential val$wsCred;
                    private final /* synthetic */ String val$factory;
                    {
                        this.val$ltpaServerPriv = lTPAServerObject;
                        this.val$wsCred = wSCredential;
                        this.val$factory = string;
                    }

                    public Object run() throws Exception {
                        return this.val$ltpaServerPriv.createLTPAToken(this.val$wsCred.getAccessId(), this.val$factory);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.token.WSCredentialTokenMapper.createAuthzTokenFromWSCredential", "922", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createSSOTokenFromWSCredential", new Object[]{privilegedActionException.getException()});
                }
                throw privilegedActionException.getException();
            }
            object = new SingleSignonTokenImpl();
            ((SingleSignonTokenImpl)object).initializeToken(token);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSSOTokenFromWSCredential");
            }
            return object;
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            Tr.error(tc, "security.sap.error.single.signon.token.not.mapped", new Object[]{wSLoginFailedException});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSSOTokenFromWSCredential");
            }
            FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.token.WSCredentialTokenMapper.createSSOTokenFromWSCredential", "936", this);
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            Tr.error(tc, "security.sap.error.single.signon.token.not.mapped", new Object[]{exception});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSSOTokenFromWSCredential");
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSCredentialTokenMapper.createSSOTokenFromWSCredential", "943", this);
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
    }

    public AuthorizationToken createAuthzTokenFromWSCredential(WSCredential wSCredential) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAuthzTokenFromWSCredential");
        }
        com.ibm.wsspi.security.ltpa.Token token = null;
        try {
            ArrayList arrayList;
            Object object;
            String string = (String)SecurityConfig.getConfig().getValue("com.ibm.wsspi.security.token.authorizationTokenFactory");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating authorization token using factory " + string + " for caller: " + wSCredential.getSecurityName());
            }
            try {
                object = this.ltpaServer;
                token = (com.ibm.wsspi.security.ltpa.Token)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction((LTPAServerObject)object, wSCredential, string){
                    private final /* synthetic */ LTPAServerObject val$ltpaServerPriv;
                    private final /* synthetic */ WSCredential val$wsCred;
                    private final /* synthetic */ String val$factory;
                    {
                        this.val$ltpaServerPriv = lTPAServerObject;
                        this.val$wsCred = wSCredential;
                        this.val$factory = string;
                    }

                    public Object run() throws Exception {
                        return this.val$ltpaServerPriv.createLTPAToken(this.val$wsCred.getAccessId(), this.val$factory);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.token.WSCredentialTokenMapper.createAuthzTokenFromWSCredential", "985", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createAuthzTokenFromWSCredential", new Object[]{privilegedActionException.getException()});
                }
                throw privilegedActionException.getException();
            }
            token.addAttribute("com.ibm.wsspi.security.cred.uniqueId", wSCredential.getAccessId());
            token.addAttribute("com.ibm.wsspi.security.cred.realm", wSCredential.getRealmName());
            token.addAttribute("com.ibm.wsspi.security.cred.securityName", wSCredential.getSecurityName());
            token.addAttribute("com.ibm.wsspi.security.cred.longSecurityName", wSCredential.getUniqueSecurityName());
            token.addAttribute("com.ibm.wsspi.security.cred.primaryGroupId", wSCredential.getPrimaryGroupId());
            object = wSCredential.get("com.ibm.wsspi.security.cred.cacheKey");
            if (object != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting cache key in Authz token: " + object.toString());
                }
                token.addAttribute("com.ibm.wsspi.security.cred.cacheKey", object.toString());
            }
            if ((arrayList = wSCredential.getGroupIds()) != null) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string2 = (String)arrayList.get(i);
                    token.addAttribute("com.ibm.wsspi.security.cred.groups", string2);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting group list: " + arrayList);
                }
            }
            if (wSCredential.getOID() != null) {
                token.addAttribute("com.ibm.wsspi.security.cred.expiration", String.valueOf(wSCredential.getExpiration()));
                token.addAttribute("com.ibm.wsspi.security.cred.oid", wSCredential.getOID());
                boolean bl = wSCredential.isForwardable();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Forwardable string set as: " + bl);
                }
                token.addAttribute("com.ibm.wsspi.security.cred.forwardable", String.valueOf(bl));
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "OID is null, deferring adding mechanism attributes to Kerberos commit().");
            }
            AuthorizationTokenImpl authorizationTokenImpl = new AuthorizationTokenImpl();
            authorizationTokenImpl.initializeToken(token);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createAuthzTokenFromWSCredential");
            }
            return authorizationTokenImpl;
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            Tr.error(tc, "security.sap.error.authorization.token.not.mapped", new Object[]{wSLoginFailedException});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createAuthzTokenFromWSCredential");
            }
            FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.token.WSCredentialTokenMapper.createAuthzTokenFromWSCredential", "1051", this);
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            Tr.error(tc, "security.sap.error.authorization.token.not.mapped", new Object[]{exception});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createAuthzTokenFromWSCredential");
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSCredentialTokenMapper.createAuthzTokenFromWSCredential", "1058", this);
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
    }

    public PropagationToken createPropagationTokenFromWSCredential(WSCredential wSCredential) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPropagationTokenFromWSCredential");
        }
        try {
            Object object;
            String string = this.contextManager.getProperty("com.ibm.CSI.CellNodeServer");
            String string2 = string + ":" + wSCredential.getRealmSecurityName();
            String string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.wsspi.security.token.propagationTokenFactory");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating propagation token using factory " + string3 + " for caller: " + string2 + ", host: " + string);
            }
            com.ibm.wsspi.security.ltpa.Token token = null;
            try {
                object = this.ltpaServer;
                token = (com.ibm.wsspi.security.ltpa.Token)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction((LTPAServerObject)object, wSCredential, string3){
                    private final /* synthetic */ LTPAServerObject val$ltpaServerPriv;
                    private final /* synthetic */ WSCredential val$wsCred;
                    private final /* synthetic */ String val$factory;
                    {
                        this.val$ltpaServerPriv = lTPAServerObject;
                        this.val$wsCred = wSCredential;
                        this.val$factory = string;
                    }

                    public Object run() throws Exception {
                        return this.val$ltpaServerPriv.createLTPAToken(this.val$wsCred.getAccessId(), this.val$factory);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.token.WSCredentialTokenMapper.createPropagationTokenFromWSCredential", "1103", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createPropagationTokenFromWSCredential", new Object[]{privilegedActionException.getException()});
                }
                throw privilegedActionException.getException();
            }
            token.addAttribute("com.ibm.wsspi.security.propagation.callers", string2);
            token.addAttribute("com.ibm.wsspi.security.propagation.hosts", string);
            object = new PropagationTokenImpl();
            ((PropagationTokenImpl)object).initializeToken(token);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createPropagationTokenFromWSCredential");
            }
            return object;
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            Tr.error(tc, "security.sap.error.propagation.token.not.mapped", new Object[]{wSLoginFailedException});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createPropagationTokenFromWSCredential");
            }
            FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.token.WSCredentialTokenMapper.createPropagationTokenFromWSCredential", "1123", this);
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            Tr.error(tc, "security.sap.error.propagation.token.not.mapped", new Object[]{exception});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createPropagationTokenFromWSCredential");
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSCredentialTokenMapper.createPropagationTokenFromWSCredential", "1130", this);
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
    }

    public ArrayList getForwardablePropagationTokensFromContext() throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getForwardablePropagationTokensFromContext");
        }
        try {
            ArrayList<TokenHolder> arrayList = new ArrayList<TokenHolder>();
            Map map = this.contextManager.getPropagationTokens();
            if (map == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No propagation token present on the thread.");
                }
                return null;
            }
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                PropagationToken propagationToken = (PropagationToken)iterator.next();
                if (propagationToken == null || !propagationToken.isForwardable()) continue;
                long l = System.currentTimeMillis();
                long l2 = propagationToken.getExpiration();
                long l3 = l2 - l - 300000L;
                if (l3 < 0L) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Propagation token with name " + propagationToken.getName() + " is expired.  Refreshing propagation token.");
                    }
                    propagationToken = (PropagationToken)propagationToken.clone();
                }
                if (propagationToken == null) continue;
                final PropagationToken propagationToken2 = propagationToken;
                byte[] byArray = (byte[])AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return propagationToken2.getBytes();
                    }
                });
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding propagation token, name: " + propagationToken.getName());
                }
                arrayList.add(new TokenHolder(byArray, propagationToken.getName(), propagationToken.getVersion()));
            }
            if (arrayList == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "Propagation token list is null.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getForwardablePropagationTokensFromContext");
            }
            return arrayList;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSCredentialTokenMapper.getForwardablePropagationTokensFromContext", "1215", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting forwardable propagation tokens.", new Object[]{exception});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getForwardablePropagationTokensFromContext");
            }
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
    }

    public PropagationToken createPropagationTokenBeforeAuthenticatedCallerSet() throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPropagationTokenBeforeAuthenticatedCallerSet");
        }
        try {
            Object object;
            String string = this.contextManager.getProperty("com.ibm.CSI.CellNodeServer");
            String string2 = (String)SecurityConfig.getConfig().getValue("com.ibm.wsspi.security.token.propagationTokenFactory");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating propagation token using factory " + string2 + " for host: " + string);
            }
            com.ibm.wsspi.security.ltpa.Token token = null;
            try {
                object = this.ltpaServer;
                token = (com.ibm.wsspi.security.ltpa.Token)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction((LTPAServerObject)object, string2){
                    private final /* synthetic */ LTPAServerObject val$ltpaServerPriv;
                    private final /* synthetic */ String val$factory;
                    {
                        this.val$ltpaServerPriv = lTPAServerObject;
                        this.val$factory = string;
                    }

                    public Object run() throws Exception {
                        return this.val$ltpaServerPriv.createLTPAToken("user:" + ContextManagerFactory.getInstance().getUnauthenticatedString(), this.val$factory);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.token.WSCredentialTokenMapper.createPropagationTokenBeforeAuthenticatedCallerSet", "1248", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createPropagationTokenFromWSCredential", new Object[]{privilegedActionException.getException()});
                }
                throw privilegedActionException.getException();
            }
            if (token != null) {
                token.addAttribute("com.ibm.wsspi.security.propagation.hosts", string);
                object = new PropagationTokenImpl();
                ((PropagationTokenImpl)object).initializeToken(token);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createPropagationTokenBeforeAuthenticatedCallerSet");
                }
                return object;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createPropagationTokenBeforeAuthenticatedCallerSet returns null.");
            }
            return null;
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            Tr.error(tc, "security.sap.error.propagation.token.not.mapped", new Object[]{wSLoginFailedException});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createPropagationTokenBeforeAuthenticatedCallerSet");
            }
            FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.token.WSCredentialTokenMapper.createPropagationTokenBeforeAuthenticatedCallerSet", "1274", this);
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            Tr.error(tc, "security.sap.error.propagation.token.not.mapped", new Object[]{exception});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createPropagationTokenBeforeAuthenticatedCallerSet");
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSCredentialTokenMapper.createPropagationTokenBeforeAuthenticatedCallerSet", "1281", this);
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
    }

    public com.ibm.wsspi.security.ltpa.Token validateLTPAToken(byte[] byArray) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateLTPAToken");
        }
        try {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validateLTPAToken");
            }
            return this.ltpaServer.validateToken(byArray);
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred validating LTPA token.", new Object[]{wSLoginFailedException});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validateLTPAToken");
            }
            FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.token.WSCredentialTokenMapper.createPropagationTokenBeforeAuthenticatedCallerSet", "1300", this);
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred validating LTPA token.", new Object[]{exception});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validateLTPAToken");
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSCredentialTokenMapper.createPropagationTokenBeforeAuthenticatedCallerSet", "1307", this);
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
    }

    public byte[] getOpaqueTokenFromMBean(ByteArray byteArray, String string, Properties properties) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOpaqueTokenFromMBean", new Object[]{string});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_OPAQUE_TOKEN_FROM_MBEAN.toString());
            }
            securityManager.checkPermission(GET_OPAQUE_TOKEN_FROM_MBEAN);
        }
        byte[] byArray = null;
        try {
            GetOpaqueTokenFromMBeanAction getOpaqueTokenFromMBeanAction = new GetOpaqueTokenFromMBeanAction(byteArray, string, properties);
            byArray = (byte[])ContextManagerFactory.getInstance().runAsSystem(getOpaqueTokenFromMBeanAction);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting opaque token.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSCredentialTokenMapper.getOpaqueTokenFromMBean", "1341", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOpaqueTokenFromMBean -> " + (byArray != null));
        }
        return byArray;
    }

    public byte[] getInitialContextTokenFromMBean(ByteArray byteArray, String string, Properties properties) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInitialContextTokenFromMBean", new Object[]{string, properties});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_OPAQUE_TOKEN_FROM_MBEAN.toString());
            }
            securityManager.checkPermission(GET_OPAQUE_TOKEN_FROM_MBEAN);
        }
        AdminClient adminClient = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        ObjectName objectName = null;
        try {
            ObjectName objectName2;
            Set set;
            String string5;
            Object object;
            Properties properties2 = (Properties)SecurityConfig.getConfig().getValue("process.jmxConnectorProps");
            Enumeration<?> enumeration = properties2.propertyNames();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                string5 = (String)properties2.get(object);
                if (object == null || string5 == null || string5.length() <= 0 || ((String)object).equals("type") || ((String)object).equals("host") || ((String)object).equals("port")) continue;
                properties.setProperty((String)object, string5);
            }
            adminClient = AdminClientFactory.createAdminClient(properties);
            object = new StringTokenizer(string, ":");
            if (object != null) {
                string2 = ((StringTokenizer)object).nextToken();
                string3 = ((StringTokenizer)object).nextToken();
                string4 = ((StringTokenizer)object).nextToken();
            }
            if ((string5 = (String)SecurityConfig.getConfig().getValue("process.hostName")) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "targetServer: " + string5);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "targetServer is null");
            }
            if ((set = adminClient.queryNames(objectName2 = new ObjectName("WebSphere:type=SecurityAdmin,cell=" + string2 + ",node=" + string3 + ",process=" + string4 + ",*"), null)).isEmpty()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getInitialContextTokenFromMBean: SecurityAdmin MBean was not found using queryString " + objectName2);
                }
                return null;
            }
            objectName = (ObjectName)set.iterator().next();
            TokenHolder tokenHolder = (TokenHolder)adminClient.invoke(objectName, "getInitialContextToken", new Object[]{byteArray, string5}, new String[]{"com.ibm.ws.security.util.ByteArray", "java.lang.String"});
            if (tokenHolder != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Returning InitialContext token from MBean.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getInitialContextTokenFromMBean");
                }
                return tokenHolder.getBytes();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning null InitialContext token.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getInitialContextTokenFromMBean");
            }
            return null;
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting admin client connection.", new Object[]{malformedObjectNameException});
            }
            FFDCFilter.processException((Throwable)malformedObjectNameException, "com.ibm.ws.security.token.WSCredentialTokenMapper.getInitialContextTokenFromMBean", "1531", this);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting admin client connection.", new Object[]{instanceNotFoundException});
            }
            FFDCFilter.processException((Throwable)instanceNotFoundException, "com.ibm.ws.security.token.WSCredentialTokenMapper.getInitialContextTokenFromMBean", "1536", this);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting admin client connection.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSCredentialTokenMapper.getInitialContextTokenFromMBean", "1541", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInitialContextTokenFromMBean");
        }
        return null;
    }

    public Object getDistributedObject(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDistributedObject: " + object);
        }
        try {
            DistributedMap distributedMap = this.getDM();
            if (distributedMap != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getDistributedObject");
                }
                return distributedMap.get(object);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDistributedObject returns null.");
            }
            return null;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting distributed object.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSCredentialTokenMapper.getDistributedObject", "1569", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDistributedObject (null)");
            }
            return null;
        }
    }

    public Object getDistributedObjectNotShared(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDistributedObjectNotShared: " + object);
        }
        try {
            DistributedMap distributedMap = this.getDMNotShared();
            if (distributedMap != null) {
                Object object2 = distributedMap.get(object);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getDistributedObjectNotShared " + (object2 != null ? "(not null)" : "(null)"));
                }
                return object2;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDistributedObjectNotShared returns null.");
            }
            return null;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting distributed object not shared.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSCredentialTokenMapper.getDistributedObjectNotShared", "1600", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDistributedObjectNotShared (null)");
            }
            return null;
        }
    }

    public Object putDistributedObjectNotShared(Object object, Object object2, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "putDistributedObjectNotShared: " + object);
        }
        try {
            DistributedMap distributedMap = this.getDMNotShared();
            if (distributedMap != null) {
                Object object3 = distributedMap.put(object, object2, 1, n, 1, null);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "putDistributedObjectNotShared " + (object3 != null ? "(not null)" : "(null)"));
                }
                return object3;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "putDistributedObjectNotShared returns null.");
            }
            return null;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred putting distributed object not shared.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSCredentialTokenMapper.putDistributedObjectNotShared", "1631", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "putDistributedObjectNotShared (null)");
            }
            return null;
        }
    }

    public Object putDistributedObject(Object object, Object object2, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "putDistributedObject: " + object);
        }
        try {
            DistributedMap distributedMap = this.getDM();
            if (distributedMap != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "putDistributedObject");
                }
                return distributedMap.put(object, object2, 1, n, 2, null);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "putDistributedObject returns null.");
            }
            return null;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred putting distributed object.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSCredentialTokenMapper.putDistributedObject", "1679", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "putDistributedObject (null)");
            }
            return null;
        }
    }

    public Object putDistributedObject(Object object, Object object2, int n, int n2, int n3, Object[] objectArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "putDistributedObject: ", new Object[]{object, new Integer(n), new Integer(n2), new Integer(n3), objectArray});
        }
        try {
            DistributedMap distributedMap = this.getDM();
            if (distributedMap != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "putDistributedObject");
                }
                return distributedMap.put(object, object2, n, n2, n3, objectArray);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "putDistributedObject returns null.");
            }
            return null;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred putting distributed object.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSCredentialTokenMapper.putDistributedObject", "1735", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "putDistributedObject (null)");
            }
            return null;
        }
    }

    public void invalidateDistributedObject(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invalidateDistributedObject: ", new Object[]{object});
        }
        try {
            DistributedMap distributedMap = this.getDM();
            if (distributedMap != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "invalidateDistributedObject");
                }
                distributedMap.invalidate(object);
                return;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invalidateDistributedObject returns null.");
            }
            return;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred invalidating distributed object.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSCredentialTokenMapper.invalidateDistributedObject", "1766", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invalidateDistributedObject");
            }
            return;
        }
    }

    public String createSubjectUniqueID(final Subject subject) {
        String string;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createSubjectUniqueID");
            }
            if (subject == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Subject is null.");
                }
                return null;
            }
            string = null;
            try {
                string = (String)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() throws Exception {
                        Object object;
                        TreeSet<Object> treeSet = new TreeSet<Object>();
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "Getting cacheKeyFromHashtable");
                        }
                        if ((object = WSCredentialTokenMapper.this.getCacheKeyFromHashtable(subject)) != null) {
                            if (tc.isEntryEnabled()) {
                                Tr.entry(tc, "Found cacheKeyFromHashtable");
                            }
                            if (object instanceof String) {
                                treeSet.add((String)object);
                            } else {
                                treeSet.add(object.toString());
                            }
                        } else if (tc.isEntryEnabled()) {
                            Tr.entry(tc, "Did not find cacheKeyFromHashtable");
                        }
                        Subject subject2 = subject;
                        synchronized (subject2) {
                            Object object2;
                            String string;
                            Object object3;
                            Object object4;
                            Object object5;
                            Set set = subject.getPrivateCredentials(class$com$ibm$wsspi$security$token$Token == null ? (class$com$ibm$wsspi$security$token$Token = WSCredentialTokenMapper.class$("com.ibm.wsspi.security.token.Token")) : class$com$ibm$wsspi$security$token$Token);
                            if (set != null && set.size() > 0) {
                                if (tc.isEntryEnabled()) {
                                    Tr.debug(tc, "Got some private credentials to iterate through.");
                                }
                                object5 = set.iterator();
                                while (object5.hasNext()) {
                                    object4 = object5.next();
                                    if (object4 == null || !(object4 instanceof Token)) continue;
                                    if (tc.isEntryEnabled()) {
                                        Tr.debug(tc, "Getting uniqueID from token.");
                                    }
                                    object3 = ((Token)object4).getUniqueID();
                                    string = ((Token)object4).getPrincipal();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Token found, ID/Principal: ", new Object[]{object3, string});
                                    }
                                    if (object3 == null || ((String)object3).length() <= 0) continue;
                                    if (string != null && string.length() > 0 && treeSet.size() == 0) {
                                        treeSet.add(string);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Unique string updated with principal: " + string);
                                        }
                                    }
                                    treeSet.add(object3);
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "Unique string updated with custom uniqueID: " + (String)object3);
                                }
                            }
                            if ((object5 = subject.getPublicCredentials(class$com$ibm$wsspi$security$token$Token == null ? (class$com$ibm$wsspi$security$token$Token = WSCredentialTokenMapper.class$("com.ibm.wsspi.security.token.Token")) : class$com$ibm$wsspi$security$token$Token)) != null && object5.size() > 0) {
                                if (tc.isEntryEnabled()) {
                                    Tr.debug(tc, "Got some public credentials to iterate through.");
                                }
                                object4 = object5.iterator();
                                while (object4.hasNext()) {
                                    object3 = object4.next();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "token found, looking for uniqueID.", new Object[]{object3});
                                    }
                                    if (object3 == null || !(object3 instanceof Token)) continue;
                                    string = ((Token)object3).getUniqueID();
                                    object2 = ((Token)object3).getPrincipal();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "ID/Principal: ", new Object[]{string, object2});
                                    }
                                    if (string == null || string.length() <= 0) continue;
                                    if (object2 != null && ((String)object2).length() > 0 && treeSet.size() == 0) {
                                        treeSet.add(object2);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Unique string updated with principal: " + (String)object2);
                                        }
                                    }
                                    treeSet.add(string);
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "Unique string updated with custom uniqueID: " + string);
                                }
                            }
                            if (treeSet != null && treeSet.size() > 0) {
                                ServerCredSigner serverCredSigner;
                                object4 = treeSet.toArray(new String[treeSet.size()]);
                                object3 = new StringBuffer(treeSet.size());
                                for (int i = 0; i < ((Object)object4).length; ++i) {
                                    ((StringBuffer)object3).append((String)object4[i]);
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.debug(tc, "Getting one-way hash.");
                                }
                                if ((object2 = (Object)(serverCredSigner = ServerCredSigner.getInstance()).getOneWayHash(((StringBuffer)object3).toString())) != null) {
                                    if (tc.isEntryEnabled()) {
                                        Tr.debug(tc, "Converting hash to string.");
                                    }
                                    BigInteger bigInteger = new BigInteger((byte[])object2);
                                    String string2 = bigInteger.toString();
                                    if (tc.isDebugEnabled()) {
                                        Tr.exit(tc, "createSubjectUniqueID returns uniqueID (" + ((StringBuffer)object3).toString() + ") as one-way hash: " + string2);
                                    }
                                    return string2;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.exit(tc, "createSubjectUniqueID returns uniqueID (" + ((StringBuffer)object3).toString() + ") as one-way hash: null.");
                                }
                                return null;
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.exit(tc, "createSubjectUniqueID returns null for uniqueID.");
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.token.WSCredentialTokenMapper.createSubjectUniqueID", "1937", this);
                if (!tc.isEntryEnabled()) break block6;
                Tr.exit(tc, "createSubjectUniqueID throwing exception.", new Object[]{privilegedActionException.getException()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSubjectUniqueID");
        }
        return string;
    }

    public String createUniqueIDFromAllTokens(final Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createUniqueIDFromAllTokens");
        }
        String string = null;
        try {
            string = (String)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Object object;
                    String string = WSCredentialTokenMapper.this.createSubjectUniqueID(subject);
                    if (string == null) {
                        try {
                            object = SubjectHelper.getWSCredentialFromSubject(subject);
                            string = object.getRealmUniqueSecurityName();
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSCredentialTokenMapper.createUniqueIDFromAllTokens", "1969", this);
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "createUniqueIDFromAllTokens catching exception accessing WSCredential and returning null.", new Object[]{exception});
                            }
                            return null;
                        }
                    }
                    if ((object = WSCredentialTokenMapper.this.contextManager.getPropagationTokens()) != null) {
                        String string2 = null;
                        Iterator iterator = object.values().iterator();
                        while (iterator.hasNext()) {
                            PropagationToken propagationToken = (PropagationToken)iterator.next();
                            if (propagationToken == null || propagationToken.getUniqueID() == null) continue;
                            if (string2 != null) {
                                string2 = string2 + ":" + propagationToken.getUniqueID();
                                continue;
                            }
                            string2 = propagationToken.getUniqueID();
                        }
                        if (string2 != null) {
                            string = string + ":" + string2;
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "createUniqueIDFromAllTokens: " + string);
                        }
                        return string;
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "createUniqueIDFromAllTokens: no PropTokens set on thread: " + string);
                    }
                    return string;
                }
            });
            return string;
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.token.WSCredentialTokenMapper.createUniqueIDFromAllTokens", "2021", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createUniqueIDFromAllTokens throwing exception.", new Object[]{privilegedActionException.getException()});
            }
            return null;
        }
    }

    public String getUniqueIDFromAuthzToken(final Subject subject) {
        String string;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getUniqueIDFromAuthzToken");
            }
            string = null;
            if (subject == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Subject is null.");
                }
                return null;
            }
            try {
                string = (String)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() throws Exception {
                        Subject subject2 = subject;
                        synchronized (subject2) {
                            Set set = subject.getPrivateCredentials(class$com$ibm$wsspi$security$token$AuthorizationToken == null ? (class$com$ibm$wsspi$security$token$AuthorizationToken = WSCredentialTokenMapper.class$("com.ibm.wsspi.security.token.AuthorizationToken")) : class$com$ibm$wsspi$security$token$AuthorizationToken);
                            if (set != null && set.size() > 0) {
                                Iterator iterator = set.iterator();
                                while (iterator.hasNext()) {
                                    String[] stringArray;
                                    AuthorizationToken authorizationToken = (AuthorizationToken)iterator.next();
                                    if (authorizationToken == null || !authorizationToken.getName().equals("com.ibm.ws.security.token.AuthorizationTokenImpl") || (stringArray = authorizationToken.getAttributes("hashed_uid")) == null || stringArray[0] == null) continue;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "getUniqueIDFromAuthzToken returning uniqueID: " + stringArray[0]);
                                    }
                                    return stringArray[0];
                                }
                            }
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.token.WSCredentialTokenMapper.createSubjectUniqueID", "2077", this);
                if (!tc.isEntryEnabled()) break block6;
                Tr.exit(tc, "getUniqueIDFromAuthzToken throwing exception.", new Object[]{privilegedActionException.getException()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueIDFromAuthzToken");
        }
        return string;
    }

    public Object getCacheKeyFromHashtable(final Subject subject) {
        Object object;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getCacheKeyFromHashtable");
            }
            if (subject == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Subject is null.");
                }
                return null;
            }
            object = null;
            try {
                object = com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() throws Exception {
                        HashSet hashSet = new HashSet();
                        Set set = null;
                        Set set2 = null;
                        Subject subject2 = subject;
                        synchronized (subject2) {
                            set = subject.getPrivateCredentials(class$java$util$Hashtable == null ? (class$java$util$Hashtable = WSCredentialTokenMapper.class$("java.util.Hashtable")) : class$java$util$Hashtable);
                            set2 = subject.getPublicCredentials(class$java$util$Hashtable == null ? (class$java$util$Hashtable = WSCredentialTokenMapper.class$("java.util.Hashtable")) : class$java$util$Hashtable);
                            if (set2.size() > 0) {
                                hashSet.addAll(set2);
                            }
                            if (set.size() > 0) {
                                hashSet.addAll(set);
                            }
                            if (hashSet != null && hashSet.size() > 0) {
                                Iterator iterator = hashSet.iterator();
                                while (iterator.hasNext()) {
                                    Hashtable hashtable = (Hashtable)iterator.next();
                                    if (hashtable == null) continue;
                                    Object v = hashtable.get("com.ibm.wsspi.security.cred.cacheKey");
                                    if (v != null && v instanceof String && ((String)v).equals("")) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Cache Key value is null string. Reset to null.");
                                        }
                                        v = null;
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Returning cache key for lookup: " + v);
                                    }
                                    return v;
                                }
                            }
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.token.WSCredentialTokenMapper.getCacheKeyFromHashtable", "2152", this);
                if (!tc.isEntryEnabled()) break block6;
                Tr.exit(tc, "getCacheKeyFromHashtable throwing exception.", new Object[]{privilegedActionException.getException()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCacheKeyFromHashtable");
        }
        return object;
    }

    public boolean subjectContainsLoginHashtable(final Subject subject) {
        Boolean bl;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "subjectContainsLoginHashtable");
            }
            bl = Boolean.valueOf("false");
            if (subject == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Subject is null.");
                }
                return bl;
            }
            try {
                bl = (Boolean)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() throws Exception {
                        HashSet hashSet = new HashSet();
                        Set set = null;
                        Set set2 = null;
                        Subject subject2 = subject;
                        synchronized (subject2) {
                            set = subject.getPrivateCredentials(class$java$util$Hashtable == null ? (class$java$util$Hashtable = WSCredentialTokenMapper.class$("java.util.Hashtable")) : class$java$util$Hashtable);
                            set2 = subject.getPublicCredentials(class$java$util$Hashtable == null ? (class$java$util$Hashtable = WSCredentialTokenMapper.class$("java.util.Hashtable")) : class$java$util$Hashtable);
                            if (set2.size() > 0) {
                                hashSet.addAll(set2);
                            }
                            if (set.size() > 0) {
                                hashSet.addAll(set);
                            }
                            if (hashSet != null && hashSet.size() > 0) {
                                Iterator iterator = hashSet.iterator();
                                while (iterator.hasNext()) {
                                    Hashtable hashtable = (Hashtable)iterator.next();
                                    if (hashtable == null || hashtable.get("com.ibm.wsspi.security.cred.securityName") == null || hashtable.get("com.ibm.wsspi.security.cred.uniqueId") == null) continue;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Subject contains valid login Hashtable.");
                                    }
                                    return Boolean.valueOf("true");
                                }
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Subject does not contain valid login Hashtable.");
                            }
                            return Boolean.valueOf("false");
                        }
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.token.WSCredentialTokenMapper.subjectContainsLoginHashtable", "2225", this);
                if (!tc.isEntryEnabled()) break block6;
                Tr.exit(tc, "subjectContainsLoginHashtable throwing exception.", new Object[]{privilegedActionException.getException()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "subjectContainsLoginHashtable -> " + bl);
        }
        return bl;
    }

    protected synchronized byte[] getOneWayHash(String string) {
        if (!SecurityContext.isSecurityEnabled() || !SecurityContext.isServerProcess()) {
            return null;
        }
        this.md.reset();
        this.md.update(string.getBytes());
        return this.md.digest();
    }

    public boolean checkCushionValidityOfAllTokens(final Subject subject, final long l, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCushionValidityOfAllTokens", new Object[]{new Long(l), new Boolean(bl)});
        }
        Boolean bl2 = Boolean.TRUE;
        if (subject == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Subject is null, returning false.");
            }
            return false;
        }
        try {
            final WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
            long l2 = wSCredential.getExpiration();
            final long l3 = System.currentTimeMillis();
            long l4 = l2 - l3 - l;
            if (l2 != 0L && l2 != -1L && l4 < 0L) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSCredential has expired, refreshing Subject.");
                }
                bl2 = Boolean.FALSE;
            }
            if (WSCredentialTokenMapper.isAnyPropagationEnabled() && bl2.booleanValue()) {
                bl2 = (Boolean)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() throws Exception {
                        Boolean bl = Boolean.TRUE;
                        if (!wSCredential.isForwardable() || wSCredential.isBasicAuth()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "WSCredential is not forwardable or BasicAuth.");
                            }
                            return Boolean.TRUE;
                        }
                        PropagationToken propagationToken = ContextManagerFactory.getInstance().getPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1");
                        if (propagationToken != null) {
                            long l4 = propagationToken.getExpiration();
                            long l2 = l4 - l3 - l;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Time remaining is " + l2 / 1000L + " seconds, for token: " + propagationToken.getClass().getName());
                            }
                            if (l2 < 0L) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Refreshing propagation token.");
                                }
                                PropagationToken propagationToken2 = (PropagationToken)propagationToken.clone();
                                ContextManagerFactory.getInstance().setPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1", propagationToken2);
                            }
                        }
                        if (!bl.booleanValue()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Returned false since WSCredential already expired.");
                            }
                            return bl;
                        }
                        Subject subject2 = subject;
                        synchronized (subject2) {
                            Set set = subject.getPrivateCredentials(class$com$ibm$ws$security$token$AbstractTokenImpl == null ? (class$com$ibm$ws$security$token$AbstractTokenImpl = WSCredentialTokenMapper.class$("com.ibm.ws.security.token.AbstractTokenImpl")) : class$com$ibm$ws$security$token$AbstractTokenImpl);
                            if (set != null && set.size() > 0) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Total number of Subject tokens to check: " + set.size());
                                }
                                Iterator iterator = set.iterator();
                                while (iterator.hasNext()) {
                                    Token token = (Token)iterator.next();
                                    if (token == null) continue;
                                    long l5 = token.getExpiration();
                                    long l32 = l5 - l3 - l;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Time remaining is " + l32 / 1000L + " seconds, for token: " + token.getClass().getName());
                                    }
                                    if (l32 >= 0L) continue;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Subject is not valid, should reauthenticate.");
                                    }
                                    bl = Boolean.FALSE;
                                    break;
                                }
                            }
                            if (bl == Boolean.TRUE && WSCredentialTokenMapper.this.checkGSSCredExpired(subject)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "GSSCredential is expired. Subject is not valid, should reauthenticate.");
                                }
                                bl = Boolean.FALSE;
                            }
                            return bl;
                        }
                    }
                });
            }
            if (bl && !bl2.booleanValue()) {
                boolean bl3 = ContextManagerFactory.getInstance().renew(subject, 0, true);
                if (bl3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Removing old Subject and updating cache with new Subject after renewal.");
                    }
                    WSCredential wSCredential2 = SubjectHelper.getWSCredentialFromSubject(subject);
                    try {
                        AuthCache.getInstance().removeEntry(wSCredential2.getRealmName(), wSCredential2.getSecurityName());
                    }
                    catch (CacheException cacheException) {
                        // empty catch block
                    }
                    AuthCache.getInstance().insert(subject);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkCushionValidityOfAllTokens -> " + bl3);
                }
                return bl3;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkCushionValidityOfAllTokens -> " + bl2);
            }
            return bl2;
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.token.WSCredentialTokenMapper.checkCushionValidityOfAllTokens", "2396", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkCushionValidityOfAllTokens throwing exception, returning false.", new Object[]{privilegedActionException.getException()});
            }
            bl2 = Boolean.FALSE;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSCredentialTokenMapper.checkCushionValidityOfAllTokens", "2402", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkCushionValidityOfAllTokens throwing exception, returning false.", new Object[]{exception});
            }
            bl2 = Boolean.FALSE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkCushionValidityOfAllTokens -> " + bl2);
        }
        return bl2;
    }

    public boolean checkCushionValidityOfAllTokens(Subject subject, long l) {
        return this.checkCushionValidityOfAllTokens(subject, l, false);
    }

    public boolean checkValidityOfAllTokens(Subject subject) {
        return this.checkCushionValidityOfAllTokens(subject, AuthCache.getInstance().getCushion(), false);
    }

    public boolean checkValidityOfAllTokensAndRefresh(Subject subject) {
        return this.checkCushionValidityOfAllTokens(subject, AuthCache.getInstance().getCushion(), true);
    }

    public boolean checkGSSCredExpired(Subject subject) {
        Boolean bl = Boolean.FALSE;
        long l = AuthCache.getInstance().getCushion();
        try {
            GSSCredential gSSCredential;
            Set set = subject.getPrivateCredentials(GSSCredential.class);
            if (set != null && set.size() > 0 && (gSSCredential = (GSSCredential)set.iterator().next()) != null) {
                long l2 = gSSCredential.getRemainingLifetime() * 1000;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Time remaining is " + l2 / 1000L + " seconds, for token: " + gSSCredential);
                }
                if (l2 - l < 0L) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "GSSCredential is expired.");
                    }
                    bl = Boolean.TRUE;
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSCredentialTokenMapper.checkGSSCredExpired", "2433", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkGSSCredExpired throwing exception, returning true.", new Object[]{exception});
            }
            bl = Boolean.TRUE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkGSSCredExpired -> " + bl);
        }
        return bl;
    }

    public String getJCEProvider() {
        List list = null;
        if (JSSEProviderFactory.isFipsEnabled() && (list = JSSEProviderFactory.fipsJCEProviders()) != null && list.size() > 0) {
            this.JCEProvider = (String)list.get(0);
        }
        return this.JCEProvider;
    }

    public static boolean isAnyPropagationEnabled() {
        if (!propEnabledChecked) {
            propEnabledChecked = true;
            if (WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "At least one propagation flag is enabled.");
                }
                propEnabled = true;
                return true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Propagation is disabled.");
            }
            propEnabled = false;
            return false;
        }
        return propEnabled;
    }

    class GetOpaqueTokenFromMBeanAction
    implements PrivilegedExceptionAction {
        private ByteArray ssoToken = null;
        private String serverName = null;
        private Properties connectorProps = null;

        public GetOpaqueTokenFromMBeanAction(ByteArray byteArray, String string, Properties properties) {
            this.ssoToken = byteArray;
            this.serverName = string;
            this.connectorProps = properties;
        }

        public Object run() throws Exception {
            Set set;
            Object object;
            Object object2;
            AdminClient adminClient = null;
            String string = null;
            String string2 = null;
            String string3 = null;
            ObjectName objectName = null;
            Properties properties = (Properties)SecurityConfig.getConfig().getValue("process.jmxConnectorProps");
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                object = (String)properties.get(object2);
                if (object2 == null || object == null || ((String)object).length() <= 0 || ((String)object2).equals("type") || ((String)object2).equals("host") || ((String)object2).equals("port")) continue;
                this.connectorProps.setProperty((String)object2, (String)object);
            }
            adminClient = AdminClientFactory.createAdminClient(this.connectorProps);
            object2 = new StringTokenizer(this.serverName, ":");
            if (object2 != null) {
                string = ((StringTokenizer)object2).nextToken();
                string2 = ((StringTokenizer)object2).nextToken();
                string3 = ((StringTokenizer)object2).nextToken();
            }
            if ((set = adminClient.queryNames((ObjectName)(object = new ObjectName("WebSphere:type=SecurityAdmin,cell=" + string + ",node=" + string2 + ",process=" + string3 + ",*")), null)).isEmpty()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getOpaqueTokenFromMBean: SecurityAdmin MBean was not found using queryString " + object);
                }
                return null;
            }
            objectName = (ObjectName)set.iterator().next();
            TokenHolder tokenHolder = (TokenHolder)adminClient.invoke(objectName, "getOpaqueToken", new Object[]{this.ssoToken}, new String[]{"com.ibm.ws.security.util.ByteArray"});
            if (tokenHolder != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Returning opaque token from MBean.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getOpaqueTokenFromMBean");
                }
                return tokenHolder.getBytes();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning null opaque token.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getOpaqueTokenFromMBean");
            }
            return null;
        }
    }
}

