/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.token.AbstractTokenImpl;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.PropagationToken;
import java.security.PrivilegedAction;
import java.util.Enumeration;

public class PropagationTokenImpl
extends AbstractTokenImpl
implements PropagationToken {
    private Token token = null;
    private LTPAServerObject ltpaServer = null;
    private ContextManager contextManager = null;
    private transient int hashCode = 0;
    private transient long changeCounterWhenHashCodeCalculated = 0L;
    private static final TraceComponent tc = Tr.register(PropagationTokenImpl.class, null, "com.ibm.ejs.resources.security");

    public void initializeToken(byte[] byArray) throws WSLoginFailedException {
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Initializing propagation token.");
            }
            this.hashCode = 0;
            this.changeCounterWhenHashCodeCalculated = 0L;
            this.ltpaServer = LTPAServerObject.getLTPAServer();
            this.contextManager = ContextManagerFactory.getInstance();
            final Token token = this.token = this.ltpaServer.validateToken(byArray);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    PropagationTokenImpl.this.setToken(token);
                    return null;
                }
            });
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.token.PropagationTokenImpl.initializeToken", "58", this);
            Tr.debug(tc, "Exception validating LTPA token.", new Object[]{wSLoginFailedException});
            this.contextManager.setRootException(wSLoginFailedException);
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.PropagationTokenImpl.initializeToken", "65", this);
            Tr.debug(tc, "Exception validating LTPA token.", new Object[]{exception});
            this.contextManager.setRootException(exception);
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
    }

    public void initializeToken(Token token) throws WSLoginFailedException {
        this.hashCode = 0;
        this.changeCounterWhenHashCodeCalculated = 0L;
        final Token token2 = this.token = token;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PropagationTokenImpl.this.setToken(token2);
                return null;
            }
        });
    }

    public String getUniqueID() {
        String string = Integer.toString(this.hashCode());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning uniqueID of propagation token: " + string);
        }
        return string;
    }

    public int hashCode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hashCode");
        }
        long l = Long.parseLong(this.getChangeCounter());
        if (this.hashCode == 0 || this.changeCounterWhenHashCodeCalculated != l) {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = this.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                String[] stringArray = this.getAttributes(string);
                stringBuffer.append(string);
                stringBuffer.append(": ");
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i] + ",");
                }
                stringBuffer.append("|");
            }
            string = stringBuffer.toString();
            if (string != null) {
                this.hashCode = string.hashCode();
                this.changeCounterWhenHashCodeCalculated = Long.parseLong(this.getChangeCounter());
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "hashCode calculated, current change counter: " + this.changeCounterWhenHashCodeCalculated);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hashCode -> " + this.hashCode);
        }
        return this.hashCode;
    }

    public byte[] getBytes() {
        if (this.token != null) {
            try {
                return super.getBytes();
            }
            catch (Exception exception) {
                Tr.debug(tc, "Exception creating byte[] of propagation token.", new Object[]{exception});
                FFDCFilter.processException(exception, "com.ibm.ws.security.token.PropagationTokenImpl.getUniqueID", "166");
                return null;
            }
        }
        return null;
    }

    public Object clone() {
        try {
            PropagationTokenImpl propagationTokenImpl = new PropagationTokenImpl();
            this.token = (Token)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return PropagationTokenImpl.this.getToken();
                }
            });
            propagationTokenImpl.initializeToken((Token)this.token.clone());
            return propagationTokenImpl;
        }
        catch (Exception exception) {
            Tr.debug(tc, "Exception creating clone of propagation token.", new Object[]{exception});
            FFDCFilter.processException(exception, "com.ibm.ws.security.ltpa.LTPAToken.clone", "190");
            return null;
        }
    }
}

