/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.token.AbstractTokenImpl;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.AuthorizationToken;
import java.security.PrivilegedAction;

public class AuthorizationTokenImpl
extends AbstractTokenImpl
implements AuthorizationToken {
    private Token token = null;
    private LTPAServerObject ltpaServer = null;
    private ContextManager contextManager = null;
    private static final TraceComponent tc = Tr.register(AuthorizationTokenImpl.class, null, "com.ibm.ejs.resources.security");

    public void initializeToken(byte[] byArray) throws WSLoginFailedException {
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Initializing authorization token.");
            }
            this.ltpaServer = LTPAServerObject.getLTPAServer();
            this.contextManager = ContextManagerFactory.getInstance();
            final Token token = this.token = this.ltpaServer.validateToken(byArray);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    AuthorizationTokenImpl.this.setToken(token);
                    return null;
                }
            });
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.token.AuthorizationTokenImpl.initializeToken", "61", this);
            Tr.debug(tc, "Exception validating LTPA token.", new Object[]{wSLoginFailedException});
            this.contextManager.setRootException(wSLoginFailedException);
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.AuthorizationTokenImpl.initializeToken", "68", this);
            Tr.debug(tc, "Exception validating LTPA token.", new Object[]{exception});
            this.contextManager.setRootException(exception);
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
    }

    public void initializeToken(Token token) throws WSLoginFailedException {
        final Token token2 = this.token = token;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                AuthorizationTokenImpl.this.setToken(token2);
                return null;
            }
        });
    }

    public Object clone() {
        try {
            AuthorizationTokenImpl authorizationTokenImpl = new AuthorizationTokenImpl();
            this.token = (Token)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return AuthorizationTokenImpl.this.getToken();
                }
            });
            authorizationTokenImpl.initializeToken((Token)this.token.clone());
            return authorizationTokenImpl;
        }
        catch (Exception exception) {
            Tr.debug(tc, "Exception creating clone of authorization token.", new Object[]{exception});
            FFDCFilter.processException(exception, "com.ibm.ws.security.ltpa.LTPAToken.clone", "112");
            return null;
        }
    }
}

