/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego.admin;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.security.spnego.Constants;
import com.ibm.ws.security.spnego.HTTPHeaderFilter;
import com.ibm.ws.security.spnego.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class CommandProviderImpl
extends SimpleCommandProvider {
    private static final String ME = CommandProviderImpl.class.getName();
    private static final Logger log = Logger.getLogger(ME, "com.ibm.ws.security.spnego.resources.TAIMsgs");
    private ConfigService config;
    private Session session;

    public AbstractAdminCommand createCommand(CommandMetadata commandMetadata) throws CommandNotFoundException {
        return super.createCommand(commandMetadata);
    }

    public AbstractAdminCommand loadCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        this.config = this.getCommandProviderHelper().getConfigService();
        return super.loadCommand(commandData);
    }

    public List addSpnegoTAIProperties(AbstractAdminCommand abstractAdminCommand) throws CommandException {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "addSpnegoTAIProperties", abstractAdminCommand);
        }
        Map map = null;
        ObjectName objectName = null;
        try {
            Object object;
            int n;
            objectName = this.getSpnegoConfig(abstractAdminCommand);
            ArrayList arrayList = (ArrayList)this.config.getAttribute(this.session, objectName, "trustProperties");
            Map map2 = this.toMap(arrayList);
            Map map3 = Util.getSpnIdMap("com.ibm.ws.security.spnego.SPN", map2);
            Integer n2 = (Integer)abstractAdminCommand.getParameter("spnId");
            if (n2 != null) {
                n = n2;
                if (n < 0) {
                    String string = TraceNLS.getFormattedMessage("com.ibm.ws.security.spnego.resources.TAIMsgs", "security.spnego.spnid.negative", new Object[]{n2}, "spnId " + n2 + " is negative, specify a non-negative value.");
                    throw new CommandException(string);
                }
                object = "com.ibm.ws.security.spnego.SPN" + n;
                if (!Util.extractPropertiesWithPrefix((String)object, map2).isEmpty()) {
                    String string = TraceNLS.getFormattedMessage("com.ibm.ws.security.spnego.resources.TAIMsgs", "security.spnego.spnid.notavailable", new Object[]{n2}, "spnId " + n2 + " already exists.");
                    throw new CommandException(string);
                }
            } else {
                n = Util.findAvailableSpnId("com.ibm.ws.security.spnego.SPN", map3);
            }
            if (!this.isFilterValid(n, map = this.getParameters(abstractAdminCommand, n))) {
                object = (String)map.get("com.ibm.ws.security.spnego.SPN" + n + ".filter");
                String string = TraceNLS.getFormattedMessage("com.ibm.ws.security.spnego.resources.TAIMsgs", "security.spnego.invalid.filter", new Object[]{object}, "Filter " + (String)object + " is malformed. Verify the syntax of the specified filter rules.");
                throw new CommandException(string);
            }
            if (!this.isValidURL(n, map)) {
                object = TraceNLS.getFormattedMessage("com.ibm.ws.security.spnego.resources.TAIMsgs", "security.spnego.invalid.url", new Object[0], "One of the URLs specified is malformed.");
                throw new CommandException((String)object);
            }
            object = map.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                AttributeList attributeList = new AttributeList();
                ConfigServiceHelper.setAttributeValue(attributeList, "name", string);
                ConfigServiceHelper.setAttributeValue(attributeList, "value", string2);
                this.config.createConfigData(this.session, objectName, "trustProperties", null, attributeList);
                log.logp(Level.INFO, ME, "addSpnegoTAIProperties", "security.spnego.addprops", new Object[]{string, string2});
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new CommandException(exception, "addSpnegoTAIProperties caught an unexpected exception");
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "addSpnegoTAIProperties");
        }
        return this.toList(map);
    }

    public List modifySpnegoTAIProperties(AbstractAdminCommand abstractAdminCommand) throws CommandException {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "modifySpnegoTAIProperties", abstractAdminCommand);
        }
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        ObjectName objectName = null;
        try {
            Object object;
            Object object2;
            String string;
            Object object3;
            objectName = this.getSpnegoConfig(abstractAdminCommand);
            Integer n = (Integer)abstractAdminCommand.getParameter("spnId");
            String string2 = "com.ibm.ws.security.spnego.SPN" + n + '.';
            ArrayList arrayList = (ArrayList)this.config.getAttribute(this.session, objectName, "trustProperties");
            Map map = Util.extractPropertiesWithPrefix(string2, this.toMap(arrayList));
            if (map.isEmpty()) {
                String string3 = TraceNLS.getFormattedMessage("com.ibm.ws.security.spnego.resources.TAIMsgs", "security.spnego.spnid.notexistent", new Object[]{n}, "spnId " + n + " does not exist.");
                throw new CommandException(string3);
            }
            int n2 = n;
            Map map2 = this.getParameters(abstractAdminCommand, n2);
            if (map2.isEmpty()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Specify the SpnegoTAI properties to be modified.");
                }
                String string4 = TraceNLS.getFormattedMessage("com.ibm.ws.security.spnego.resources.TAIMsgs", "security.spnego.spnid.noprops", new Object[]{n}, "Specify the SpnegoTAI properties to be modified.");
                throw new CommandException(string4);
            }
            if (!this.isFilterValid(n2, map2)) {
                String string5 = (String)map2.get("com.ibm.ws.security.spnego.SPN" + n2 + ".filter");
                String string6 = TraceNLS.getFormattedMessage("com.ibm.ws.security.spnego.resources.TAIMsgs", "security.spnego.invalid.filter", new Object[]{string5}, "Filter " + string5 + " is malformed. Verify the syntax of the specified filter rules.");
                throw new CommandException(string6);
            }
            if (!this.isValidURL(n2, map2)) {
                String string7 = TraceNLS.getFormattedMessage("com.ibm.ws.security.spnego.resources.TAIMsgs", "security.spnego.invalid.url", new Object[0], "One of the URLs specified is malformed.");
                throw new CommandException(string7);
            }
            Iterator<Object> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object3 = (AttributeList)iterator.next();
                string = (String)ConfigServiceHelper.getAttributeValue((AttributeList)object3, "name");
                if (!map2.containsKey(string)) continue;
                object2 = new AttributeList();
                object = (String)map2.get(string);
                String string8 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)object3, "value");
                ConfigServiceHelper.setAttributeValue((AttributeList)object2, "value", object);
                this.config.setAttributes(this.session, ConfigServiceHelper.createObjectName((AttributeList)object3), (AttributeList)object2);
                map2.remove(string);
                treeMap.put(string, object);
                log.logp(Level.INFO, ME, "modifySpnegoTAIProperties", "security.spnego.modifyprops", new Object[]{string, object, string8});
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine(string + " = " + (String)object + " (previous value = " + string8 + ")");
            }
            if (!map2.isEmpty()) {
                iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    object3 = (Map.Entry)iterator.next();
                    string = (String)object3.getKey();
                    object2 = (String)object3.getValue();
                    object = new AttributeList();
                    ConfigServiceHelper.setAttributeValue((AttributeList)object, "name", string);
                    ConfigServiceHelper.setAttributeValue((AttributeList)object, "value", object2);
                    this.config.createConfigData(this.session, objectName, "trustProperties", null, (AttributeList)object);
                    treeMap.put(string, object2);
                    log.logp(Level.INFO, ME, "modifySpnegoTAIProperties", "security.spnego.addprops", new Object[]{string, object2});
                }
            }
        }
        catch (Exception exception) {
            throw new CommandException(exception, "modifySpnegoTAIProperties caught an unexpected exception");
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "modifySpnegoTAIProperties");
        }
        return this.toList(treeMap);
    }

    public List deleteSpnegoTAIProperties(AbstractAdminCommand abstractAdminCommand) throws CommandException {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "deleteSpnegoTAIProperties", abstractAdminCommand);
        }
        ObjectName objectName = null;
        Map map = null;
        try {
            objectName = this.getSpnegoConfig(abstractAdminCommand);
            Integer n = (Integer)abstractAdminCommand.getParameter("spnId");
            ArrayList arrayList = (ArrayList)this.config.getAttribute(this.session, objectName, "trustProperties");
            if (n == null) {
                this.config.unsetAttributes(this.session, objectName, new String[]{"trustProperties"});
                map = this.toMap(arrayList);
                log.logp(Level.INFO, ME, "deleteSpnegoTAIProperties", "security.spnego.deleteall");
            } else {
                String string = "com.ibm.ws.security.spnego.SPN" + n + '.';
                map = Util.extractPropertiesWithPrefix(string, this.toMap(arrayList));
                if (map.isEmpty()) {
                    String string2 = TraceNLS.getFormattedMessage("com.ibm.ws.security.spnego.resources.TAIMsgs", "security.spnego.spnid.notexistent", new Object[]{n}, "spnId " + n + " does not exist.");
                    throw new CommandException(string2);
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    AttributeList attributeList = (AttributeList)iterator.next();
                    String string3 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "name");
                    if (!map.containsKey(string3)) continue;
                    this.config.deleteConfigData(this.session, ConfigServiceHelper.createObjectName(attributeList));
                    log.logp(Level.INFO, ME, "deleteSpnegoTAIProperties", "security.spnego.deleteprops", new Object[]{string3});
                }
            }
        }
        catch (Exception exception) {
            throw new CommandException(exception, "deleteSpnegoTAIProperties caught an unexpected exception");
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "deleteSpnegoTAIProperties");
        }
        return this.toList(map);
    }

    public List showSpnegoTAIProperties(AbstractAdminCommand abstractAdminCommand) throws CommandException {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "showSpnegoTAIProperties", abstractAdminCommand);
        }
        ObjectName objectName = null;
        Map map = null;
        try {
            Object object;
            Integer n;
            objectName = this.getSpnegoConfig(abstractAdminCommand);
            ArrayList arrayList = (ArrayList)this.config.getAttribute(this.session, objectName, "trustProperties");
            Map map2 = this.toMap(arrayList);
            String string = (String)this.config.getAttribute(this.session, objectName, "interceptorClassName");
            if (log.isLoggable(Level.FINE)) {
                log.fine("Spnego TAI classname = " + string);
            }
            if ((n = (Integer)abstractAdminCommand.getParameter("spnId")) != null) {
                object = "com.ibm.ws.security.spnego.SPN" + n.toString();
                map = Util.extractPropertiesWithPrefix((String)object, map2);
                if (map.isEmpty()) {
                    String string2 = TraceNLS.getFormattedMessage("com.ibm.ws.security.spnego.resources.TAIMsgs", "security.spnego.spnid.notexistent", new Object[]{n}, "spnId " + n + " does not exist.");
                    throw new CommandException(string2);
                }
            } else {
                map = this.toMap(arrayList);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Spnego TAI Properties: " + (map.isEmpty() ? "None" : ""));
            }
            if (log.isLoggable(Level.FINE)) {
                object = map.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry entry = (Map.Entry)object.next();
                    log.fine("\t" + entry.getKey() + " = " + entry.getValue());
                }
            }
        }
        catch (Exception exception) {
            throw new CommandException(exception, "showSpnegoTAIProperties caught an unexpected exception");
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "showSpnegoTAIProperties");
        }
        log.info(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.AdminCommandText", "security.spnego.page.content.spnego.not.supported", new Object[0], "Default Junk1"));
        log.info(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.AdminCommandText", "security.spnego.page.content.ntlm.token.received", new Object[0], "Default Junk2"));
        return this.toList(map);
    }

    public String createKrbConfigFile(AbstractAdminCommand abstractAdminCommand) throws CommandException {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "createKrbConfigFile", abstractAdminCommand);
        }
        String string = (String)abstractAdminCommand.getParameter("krbPath");
        String string2 = (String)abstractAdminCommand.getParameter("realm");
        String string3 = (String)abstractAdminCommand.getParameter("kdcHost");
        String string4 = (String)abstractAdminCommand.getParameter("dns");
        String string5 = (String)abstractAdminCommand.getParameter("keytabPath");
        Integer n = (Integer)abstractAdminCommand.getParameter("kdcPort");
        n = n == null ? new Integer(88) : n;
        String string6 = (String)abstractAdminCommand.getParameter("encryption");
        string6 = string6 == null ? "des-cbc-md5 rc4-hmac" : string6;
        File file = null;
        try {
            file = new File(string);
            File file2 = file.getParentFile();
            if (!(file2 == null || file2.isDirectory() && file2.exists() && file2.canWrite())) {
                log.logp(Level.WARNING, ME, "createKrbConfigFile", "security.spnego.krbconf.pathinvalid", new Object[]{file2});
                String string7 = TraceNLS.getFormattedMessage("com.ibm.ws.security.spnego.resources.TAIMsgs", "security.spnego.krbconf.pathinvalid", new Object[]{file2}, "Directory " + file2 + " does not exist or cannot be created, verify directory exists and is writable.");
                throw new CommandException(string7);
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, ME, "createKrbConfigFile", "krbPath=" + file);
                log.logp(Level.FINE, ME, "createKrbConfigFile", "realm=" + string2);
                log.logp(Level.FINE, ME, "createKrbConfigFile", "kdcHost=" + string3);
                log.logp(Level.FINE, ME, "createKrbConfigFile", "kdcPort=" + n);
                log.logp(Level.FINE, ME, "createKrbConfigFile", "dns=" + string4);
                log.logp(Level.FINE, ME, "createKrbConfigFile", "keytabPath=" + string5);
                log.logp(Level.FINE, ME, "createKrbConfigFile", "encryption=" + string6);
            }
            if (file.exists() || file.isDirectory()) {
                log.logp(Level.WARNING, ME, "createKrbConfigFile", "security.spnego.krbconf.fileexists", new Object[]{file});
                String string8 = TraceNLS.getFormattedMessage("com.ibm.ws.security.spnego.resources.TAIMsgs", "security.spnego.krbconf.fileexists", new Object[]{file}, "File " + file + " already exists, it has not been overwritten.");
                throw new CommandException(string8);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PrintWriter printWriter = null;
            printWriter = AdminHelper.getPlatformHelper().isZOS() ? new PrintWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "IBM1047")) : new PrintWriter(new OutputStreamWriter(fileOutputStream));
            printWriter.println("[libdefaults]");
            printWriter.println("\tdefault_realm = " + string2);
            printWriter.println("\tdefault_keytab_name = FILE:" + string5);
            printWriter.println("\tdefault_tkt_enctypes = " + string6);
            printWriter.println("\tdefault_tgs_enctypes = " + string6);
            printWriter.println("\tkdc_default_options = 0x54800000");
            printWriter.println("#\tforwardable  = true");
            printWriter.println("#\tproxiable  = true");
            printWriter.println("#\tnoaddresses = true");
            printWriter.println("[realms]");
            printWriter.println("\t" + string2 + " = {");
            printWriter.println("\t\tkdc = " + string3 + ":" + n);
            printWriter.println("\t\tdefault_domain = " + string4);
            printWriter.println("\t}");
            printWriter.println("[domain_realm]");
            printWriter.println("\t." + string4 + " = " + string2);
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new CommandException(iOException, "createKrbConfigFile caught an unexpected exception.");
        }
        log.logp(Level.INFO, ME, "createKrbConfigFile", "security.spnego.krbconf.success", new Object[]{file});
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "createKrbConfigFile", file.getAbsolutePath());
        }
        return file.getAbsolutePath() + " has been created.";
    }

    private Map toMap(ArrayList arrayList) throws AttributeNotFoundException {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "toMap");
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                AttributeList attributeList = (AttributeList)iterator.next();
                String string = (String)ConfigServiceHelper.getAttributeValue(attributeList, "name");
                String string2 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "value");
                treeMap.put(string, string2);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "toMap", "Map=" + treeMap);
        }
        return treeMap;
    }

    private ObjectName getSpnegoConfig(AbstractAdminCommand abstractAdminCommand) throws ConfigServiceException, ConnectorException, CommandValidationException {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "getSpnegoConfig", abstractAdminCommand.toString());
        }
        this.session = abstractAdminCommand.getConfigSession();
        ObjectName objectName = null;
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "TAInterceptor");
        ObjectName[] objectNameArray = this.config.queryConfigObjects(this.session, null, objectName2, null);
        if (objectNameArray != null && objectNameArray.length > 0) {
            for (int i = 0; i < objectNameArray.length; ++i) {
                ObjectName objectName3 = objectNameArray[i];
                String string = (String)this.config.getAttribute(this.session, objectName3, "interceptorClassName");
                if (!string.equals(Constants.SPNEGO_TAI_CLASSNAME)) continue;
                objectName = objectNameArray[i];
                break;
            }
        }
        if (objectName == null) {
            String string = "SpnegoTAI is not defined in the configuration.";
            if (log.isLoggable(Level.FINE)) {
                log.fine(string);
            }
            throw new CommandValidationException(string);
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "getSpnegoConfig", objectName.getCanonicalName());
        }
        return objectName;
    }

    private Map getParameters(AbstractAdminCommand abstractAdminCommand, int n) throws InvalidParameterNameException {
        Object object;
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "getParameters", "id=" + n);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = "com.ibm.ws.security.spnego.SPN" + n;
        String string2 = (String)abstractAdminCommand.getParameter("host");
        if (string2 != null) {
            hashMap.put(string + ".hostName", string2);
        }
        if ((string2 = (String)abstractAdminCommand.getParameter("filter")) != null) {
            hashMap.put(string + ".filter", string2);
        }
        if ((string2 = (String)abstractAdminCommand.getParameter("filterClass")) != null) {
            hashMap.put(string + ".filterClass", string2);
        }
        if ((string2 = (String)abstractAdminCommand.getParameter("noSpnegoPage")) != null) {
            hashMap.put(string + ".spnegoNotSupportedPage", string2);
        }
        if ((string2 = (String)abstractAdminCommand.getParameter("ntlmTokenPage")) != null) {
            hashMap.put(string + ".NTLMTokenReceivedPage", string2);
        }
        if ((object = abstractAdminCommand.getParameter("trimUserName")) != null) {
            hashMap.put(string + ".trimUserName", ((Boolean)object).toString());
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "getParameters", "Map=" + hashMap);
        }
        return hashMap;
    }

    private List toList(Map map) {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "toList", "parms=" + map);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!map.isEmpty()) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                arrayList.add(entry.getKey() + "=" + entry.getValue());
            }
        } else {
            arrayList = null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "toList", "result=" + arrayList);
        }
        return arrayList;
    }

    private boolean isFilterValid(int n, Map map) {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "isFilterValid", "id=" + n + " Map=" + map);
        }
        boolean bl = true;
        String string = (String)map.get("com.ibm.ws.security.spnego.SPN" + n + ".filter");
        if (string != null && string.length() != 0) {
            String string2 = (String)map.get("com.ibm.ws.security.spnego.SPN" + n + ".filterClass");
            if (string2 == null || "com.ibm.ws.security.spnego.HTTPHeaderFilter".equals(string2)) {
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, ME, "isFilterValid", "filter=\"" + string + "\"");
                }
                bl = HTTPHeaderFilter.isValid(string);
            }
        } else if (string != null) {
            bl = false;
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "isFilterValid", Boolean.toString(bl));
        }
        return bl;
    }

    private boolean isValidURL(int n, Map map) {
        boolean bl;
        block4: {
            if (log.isLoggable(Level.FINE)) {
                log.entering(ME, "isValidURL", "id=" + n + " Map=" + map);
            }
            bl = true;
            String string = null;
            try {
                string = (String)map.get("com.ibm.ws.security.spnego.SPN" + n + ".NTLMTokenReceivedPage");
                URL uRL = new URL(string);
                string = (String)map.get("com.ibm.ws.security.spnego.SPN" + n + ".spnegoNotSupportedPage");
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                if (!log.isLoggable(Level.FINE)) break block4;
                log.logp(Level.WARNING, ME, "isValidURL", "Malformed URL=" + string, malformedURLException);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "isValidURL", Boolean.toString(bl));
        }
        return bl;
    }
}

