/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Util {
    private static final String ME = Util.class.getName();
    private static final Logger log = Logger.getLogger(ME, "com.ibm.ws.security.spnego.resources.TAIMsgs");
    private static final char SPACE = ' ';
    private static final char TAB = '\t';
    private static final char NEWLINE = '\n';
    private static final char TILDA = '~';
    private static final char DOT = '.';

    public static String showHex(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        StringBuffer stringBuffer = new StringBuffer(n2);
        StringBuffer stringBuffer2 = new StringBuffer(n2 << 1);
        StringBuffer stringBuffer3 = new StringBuffer(n2 << 1);
        StringBuffer stringBuffer4 = new StringBuffer(n2 << 1);
        int n3 = 0;
        int n4 = 0;
        float f = 0.0f;
        for (n = 0; n < n2; ++n) {
            int n5 = byArray[n] & 0xFF;
            if (n5 == 13 || n5 == 10 || n5 == 9 || n5 >= 32 && n5 <= 126) {
                stringBuffer.append((char)n5);
            } else {
                stringBuffer.append('[' + Util.hexPad(Integer.toHexString(n5), 2) + ']');
                f += 1.0f;
            }
            if (n5 >= 32 && n5 <= 126) {
                stringBuffer4.append((char)n5);
            } else {
                stringBuffer4.append('.');
            }
            stringBuffer3.append(Util.hexPad(Integer.toHexString(n5), 2));
            if (n3 == 3 || n3 == 7 || n3 == 11) {
                stringBuffer3.append(' ');
                stringBuffer4.append(' ');
            }
            if (n3 == 15) {
                String string = Util.hexPad(Integer.toHexString(n4), 4);
                stringBuffer2.append(string).append(":  ").append(stringBuffer3).append("    ").append(stringBuffer4).append("\n");
                n3 = 0;
                n4 += 16;
                stringBuffer3.setLength(0);
                stringBuffer4.setLength(0);
                continue;
            }
            ++n3;
        }
        for (n = stringBuffer3.length(); n < 35; ++n) {
            stringBuffer3.append(' ');
        }
        String string = Util.hexPad(Integer.toHexString(n4), 4);
        stringBuffer2.append(string).append(":  ").append(stringBuffer3).append("    ").append(stringBuffer4).append("\n");
        return stringBuffer2.toString();
    }

    private static String hexPad(String string, int n) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2 + n);
        for (int i = n2; i < n; ++i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static Map extractPropertiesWithPrefix(String string, Map map) {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "extractPropertiesWithPrefix", "prefix=" + string + " Map=" + map);
        }
        HashMap hashMap = new HashMap();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            if (!string2.startsWith(string)) continue;
            hashMap.put(string2, entry.getValue());
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "extractPropertiesWithPrefix", "Map=" + hashMap);
        }
        return hashMap;
    }

    public static int findAvailableSpnId(String string, Map map) {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "findAvailableSpnId", "prefix=" + string + " Map=" + map);
        }
        int n = map.size() + 1;
        if (!map.isEmpty()) {
            for (int i = 1; i < map.size() + 1; ++i) {
                if (map.containsKey(string + i)) continue;
                n = i;
                break;
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "findAvailableSpnId", "id=" + n);
        }
        return n;
    }

    public static Map getSpnIdMap(String string, Map map) {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "getSpnIdMap", "prefix=" + string + " Map=" + map);
        }
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        for (int i = 1; i < map.size() + 1; ++i) {
            Map map2 = Util.extractPropertiesWithPrefix(string + i + '.', map);
            if (map2.isEmpty()) continue;
            hashMap.put(string + i, map2);
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "getSpnIdMap", "Map=" + hashMap);
        }
        return hashMap;
    }
}

