/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.spnego.AllServerConfigs;
import com.ibm.ws.security.spnego.Context;
import com.ibm.ws.security.spnego.ServerConfig;
import com.ibm.ws.security.spnego.ServerCredential;
import com.ibm.ws.security.spnego.TAIConfigurationException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class ServerCredentialsFactory {
    private static GSSManager gssMgr;
    private static Map serverCredentials;
    private static final String ME;
    private static final Logger logger;

    public static boolean initializeServer(ServerConfig serverConfig) throws TAIConfigurationException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "initializeServer");
        }
        String string = serverConfig.getHostName();
        boolean bl = false;
        try {
            ServerCredential serverCredential = new ServerCredential(serverConfig);
            serverCredentials.put(string, serverCredential);
            logger.logp(Level.INFO, ME, "initializeServer", "security.spnego.spn.init.success", new Object[]{string});
            bl = true;
        }
        catch (GSSException gSSException) {
            FFDCFilter.processException(gSSException, "com.ibm.ws.security.spnego.ServerCredentialsFactory.initializeServer", "68");
            logger.logp(Level.SEVERE, ME, "initializeServer", "security.spnego.spn.init.failed", new Object[]{serverConfig.getServerName()});
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "initializeServer");
        }
        return bl;
    }

    public static synchronized void initializeServerCreds(AllServerConfigs allServerConfigs) throws TAIConfigurationException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "initializeServerCreds");
        }
        int n = 0;
        if (allServerConfigs == null) {
            logger.logp(Level.SEVERE, ME, "initializeServerCreds", "security.spnego.unexpected.condition", "AllServerConfigs is null.");
            throw new TAIConfigurationException("initializeServerCreds: config=null");
        }
        if (serverCredentials == null || serverCredentials.isEmpty() || allServerConfigs.isReloadEnabled()) {
            ServerCredentialsFactory.initialize();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "initializeServerCreds", "Initialize server credentials for each service principal name.");
            }
            Enumeration enumeration = allServerConfigs.getServerConfigs().elements();
            while (enumeration.hasMoreElements()) {
                ServerConfig serverConfig = (ServerConfig)enumeration.nextElement();
                if (!ServerCredentialsFactory.initializeServer(serverConfig)) continue;
                ++n;
            }
            if (n < 1) {
                logger.logp(Level.SEVERE, ME, "initializeServerCreds", "security.spnego.allspns.init.failed");
                throw new TAIConfigurationException("initializeServerCreds: no credentials successfully created.");
            }
        } else if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "initializeServerCreds", "Server credentials already initialized.");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "initializeServerCreds");
        }
    }

    public static void initialize() {
        gssMgr = GSSManager.getInstance();
    }

    public static Context createContext(String string) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "createContext", string);
        }
        Context context = null;
        ServerCredential serverCredential = (ServerCredential)serverCredentials.get(string);
        GSSCredential gSSCredential = serverCredential.getGssCred();
        context = new Context(gSSCredential);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "createContext");
        }
        return context;
    }

    public static boolean hasServerCredentialsFor(String string) {
        boolean bl = serverCredentials.containsKey(string);
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "hasServerCredentialsFor", string);
            logger.exiting(ME, "hasServerCredentialsFor", Boolean.toString(bl));
        }
        return bl;
    }

    public static GSSManager getMgr() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "getMgr");
            logger.exiting(ME, "getMgr", gssMgr);
        }
        return gssMgr;
    }

    static {
        serverCredentials = new HashMap(16);
        ME = ServerCredentialsFactory.class.getName();
        logger = Logger.getLogger(ME, "com.ibm.ws.security.spnego.resources.TAIMsgs");
    }
}

