/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import com.ibm.wsspi.security.spnego.SpnegoTAIFilter;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class HTTPHeaderFilter
implements SpnegoTAIFilter {
    private static final String ME = HTTPHeaderFilter.class.getName();
    private static final Logger logger = Logger.getLogger(ME, "com.ibm.ws.security.spnego.resources.TAIMsgs");
    private boolean processAll = false;
    protected static final int _filterconditionSize = 32;
    protected Vector filterCondition = new Vector(32, 32);

    public boolean init(String string) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "init", string);
        }
        boolean bl = this.isFilterValid(string);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "init", Boolean.toString(bl));
        }
        return bl;
    }

    public boolean isFilterValid(String string) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "isFilterValid", string);
        }
        boolean bl = HTTPHeaderFilter.isValidCommon(string, this.filterCondition);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "isFilterValid", Boolean.toString(bl));
        }
        return bl;
    }

    public static boolean isValid(String string) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "isValid", string);
        }
        Vector vector = new Vector(32, 32);
        boolean bl = HTTPHeaderFilter.isValidCommon(string, vector);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "isValid", Boolean.toString(bl));
        }
        return bl;
    }

    public static boolean isValidCommon(String string, Vector vector) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "isValidCommon", string);
        }
        boolean bl = true;
        if (string == null) {
            logger.logp(Level.SEVERE, ME, "isValidCommon", "security.spnego.filter.init.null.string");
            bl = false;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            StringTokenizer stringTokenizer2 = null;
            String string2 = null;
            String[] stringArray = new String[3];
            while (stringTokenizer.hasMoreElements()) {
                string2 = stringTokenizer.nextToken();
                stringTokenizer2 = new StringTokenizer(string2, "^=!<>%");
                if (string2 == null || stringTokenizer2.countTokens() < 2) {
                    logger.logp(Level.SEVERE, ME, "isValidCommon", "security.spnego.malformed.filter.condition", new Object[]{string, string2, stringArray});
                    bl = false;
                    break;
                }
                vector.add(new String[3]);
                stringArray = (String[])vector.lastElement();
                stringArray[0] = stringTokenizer2.nextToken();
                stringArray[2] = stringTokenizer2.nextToken();
                if (string2 == null) {
                    logger.logp(Level.SEVERE, ME, "isValidCommon", "security.spnego.malformed.filter.condition", new Object[]{string, string2, stringArray});
                    bl = false;
                    break;
                }
                stringArray[1] = string2.substring(stringArray[0].length(), string2.length() - stringArray[2].length()).trim();
                if (!(stringArray[1].equals("==") || stringArray[1].equals("!=") || stringArray[1].equals("^=") || stringArray[1].equals("%=") || stringArray[1].equals("<") || stringArray[1].equals(">"))) {
                    logger.logp(Level.SEVERE, ME, "isValidCommon", "security.spnego.malformed.filter.operator", new Object[]{stringArray[1]});
                    bl = false;
                    break;
                }
                logger.logp(Level.FINER, ME, "isValidCommon", "Adding " + stringArray[0] + " " + stringArray[1] + " " + stringArray[2]);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "isValidCommon", Boolean.toString(bl));
        }
        return bl;
    }

    public boolean isAccepted(HttpServletRequest httpServletRequest) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "isAccepted");
        }
        boolean bl = true;
        String string = "TAI will intercept request.";
        if (this.processAll) {
            string = "processAll is true, therefore we always intercept.";
        } else {
            String[] stringArray = new String[3];
            String string2 = null;
            for (int i = 0; i < this.filterCondition.size(); ++i) {
                stringArray = (String[])this.filterCondition.elementAt(i);
                string2 = httpServletRequest.getHeader(stringArray[0]);
                if (string2 == null) {
                    if (stringArray[0].equals("remote-address")) {
                        string2 = httpServletRequest.getRemoteAddr();
                        if (logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, ME, "isAccepted", "HTTPheader obtained from 'remote-address' " + string2);
                        }
                    } else if (stringArray[0].equals("request-url")) {
                        String string3 = httpServletRequest.getRequestURL().toString();
                        String string4 = httpServletRequest.getQueryString();
                        string2 = string4 != null && string4.length() > 0 ? string3 + '?' + string4 : string3;
                        if (logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, ME, "isAccepted", "HTTPheader obtained from 'request-url' " + string2);
                        }
                    } else {
                        string = "No HTTPheader found, and no 'remote-address' or 'request-url' rule used - do not Intercept.";
                        bl = false;
                        break;
                    }
                }
                if (stringArray[1].equals("!=")) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "isAccepted", "Processing !=" + stringArray[2] + " - " + string2);
                    }
                    if (string2.indexOf(stringArray[2]) <= 0) continue;
                    string = "Found match, so do not intercept.";
                    bl = false;
                    break;
                }
                if (stringArray[1].equals("==")) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "isAccepted", "Processing ==" + stringArray[2] + " - " + string2);
                    }
                    if (string2.equals(stringArray[2])) continue;
                    string = "Did not find a match, so do not intercept.";
                    bl = false;
                    break;
                }
                if (stringArray[1].equals("^=")) {
                    String string5;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "isAccepted", "Processing ^=" + stringArray[2] + " - " + string2);
                    }
                    boolean bl2 = false;
                    int n = stringArray[2].indexOf("|");
                    int n2 = 0;
                    String string6 = string5 = n == -1 ? stringArray[2] : stringArray[2].substring(0, n);
                    while (!bl2 && string5 != null) {
                        if (string2.indexOf(string5) >= 0) {
                            bl2 = true;
                        }
                        if (n == -1) {
                            string5 = null;
                            continue;
                        }
                        n2 = n + 1;
                        string5 = (n = stringArray[2].indexOf("|", n2)) == -1 ? stringArray[2].substring(n2) : stringArray[2].substring(n2, n);
                    }
                    if (bl2) continue;
                    string = "Did not find a match, so do not intercept";
                    bl = false;
                    break;
                }
                if (stringArray[1].equals("%=")) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "isAccepted", "Processing %=" + stringArray[2] + " - " + string2);
                    }
                    if (string2.indexOf(stringArray[2]) >= 0) continue;
                    string = "Did not find a match, so do not intercept.";
                    bl = false;
                    break;
                }
                if (stringArray[1].equals(">")) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "isAccepted", "Processing >" + stringArray[2] + " - " + string2);
                    }
                    if (string2.compareTo(stringArray[2]) > 0) continue;
                    string = "Value is < needed, so do not intercept.";
                    bl = false;
                    break;
                }
                if (!stringArray[1].equals("<")) continue;
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, ME, "isAccepted", "Processing <" + stringArray[2] + " - " + string2);
                }
                if (string2.compareTo(stringArray[2]) < 0) continue;
                string = "Value is > needed, so do not intercept";
                bl = false;
                break;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "isAccepted", bl + " " + string);
        }
        return bl;
    }

    public void setProcessAll(boolean bl) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setProcessAll", Boolean.toString(bl));
        }
        this.processAll = bl;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setProcessAll");
        }
    }
}

