/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import com.ibm.ws.security.spnego.ServerCredentialsFactory;
import com.ibm.ws.security.spnego.Util;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class Context {
    private GSSCredential gssCred;
    private GSSContext gssContext;
    private static final String ME = Context.class.getName();
    private static final Logger logger = Logger.getLogger(ME, "com.ibm.ws.security.spnego.resources.TAIMsgs");
    private static final Oid SPNEGOMECHOID;

    public Context(GSSCredential gSSCredential) {
        this.gssCred = gSSCredential;
    }

    public byte[] begin(byte[] byArray) throws GSSException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "begin", Util.showHex(byArray));
        }
        this.gssContext = ServerCredentialsFactory.getMgr().createContext(this.gssCred);
        byte[] byArray2 = this.gssContext.acceptSecContext(byArray, 0, byArray.length);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "begin", "GSSContext accepted:" + this.gssContext.toString());
        }
        if (!this.gssContext.isEstablished()) {
            String string = "null";
            if (byArray2 != null) {
                string = Util.showHex(byArray2);
            }
            logger.logp(Level.SEVERE, ME, "begin", "security.spnego.bad.token", new Object[]{string});
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "begin", Util.showHex(byArray2));
        }
        return byArray2;
    }

    public boolean isEstablished() {
        boolean bl;
        boolean bl2 = bl = this.gssContext == null ? false : this.gssContext.isEstablished();
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "isEstablished");
            logger.exiting(ME, "isEstablished", Boolean.toString(bl));
        }
        return bl;
    }

    public void dispose() throws GSSException {
        this.gssContext.dispose();
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "dispose");
            logger.exiting(ME, "dispose");
        }
    }

    public final String getPrincipalName() throws GSSException {
        String string = ((Object)this.gssContext.getSrcName()).toString();
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "getPrincipalName");
            logger.exiting(ME, "getPrincipalName", string);
        }
        return string;
    }

    public GSSCredential getDelegateCred() throws GSSException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "getDelegateCred");
        }
        GSSCredential gSSCredential = null;
        if (this.gssContext != null && this.gssContext.getCredDelegState()) {
            gSSCredential = this.gssContext.getDelegCred();
            GSSName gSSName = GSSManager.getInstance().createName(((Object)gSSCredential.getName()).toString(), GSSName.NT_USER_NAME, SPNEGOMECHOID);
            int n = gSSCredential.getUsage();
            int n2 = gSSCredential.getRemainingLifetime();
            gSSCredential.add(gSSName, n2, n2, SPNEGOMECHOID, n);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "getDelegateCred", gSSName + " has been added.");
            }
        } else if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "getDelegateCred", "Unable to get delegated GSSCredential, GSSContext=" + this.gssContext.toString() + ", GSSCredential=" + this.gssCred);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "getDelegateCred", gSSCredential);
        }
        return gSSCredential;
    }

    static {
        Oid oid = null;
        try {
            oid = new Oid("1.3.6.1.5.5.2");
        }
        catch (GSSException gSSException) {
            oid = null;
        }
        SPNEGOMECHOID = oid;
    }
}

