/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import com.ibm.security.krb5.internal.Config;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.spnego.ServerConfig;
import com.ibm.ws.security.spnego.SpnegoHandler;
import com.ibm.ws.security.spnego.TAIConfigurationException;
import com.ibm.ws.security.spnego.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AllServerConfigs {
    private int numberOfServers;
    private boolean includePortInSPN = false;
    private static final String ME = AllServerConfigs.class.getName();
    private static Logger logger = Logger.getLogger(ME, "com.ibm.ws.security.spnego.resources.TAIMsgs");
    private Hashtable serverConfigs;
    private boolean taiEnabled;
    private boolean reloadEnabled = false;
    private boolean isProviderConfigured = false;
    private String useSubjCredsValue = null;
    private boolean useSubjCredsState = true;
    private int reloadTimeout;
    private long lastReloadTime;
    private long lastPropFileModifiedTime = 0L;
    private String reloadFile;
    private Properties currentProps;
    private static final short STR_LENGTH = 200;

    private AllServerConfigs() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AllServerConfigs(Properties properties) throws TAIConfigurationException {
        boolean bl;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "<constructor> Properties=" + properties);
        }
        this.setTaiEnabled(Boolean.getBoolean("com.ibm.ws.security.spnego.isEnabled"));
        if (!this.isTAIEnabled()) {
            throw new TAIConfigurationException("com.ibm.ws.security.spnego.isEnabled JVM property is false or not set, no further processing will be done.");
        }
        String string = System.getProperty("com.ibm.ws.security.spnego.propertyReloadTimeout");
        String string2 = System.getProperty("com.ibm.ws.security.spnego.propertyReloadFile");
        long l = 0L;
        boolean bl2 = bl = string != null && string2 != null || string == null && string2 == null;
        if (!bl) {
            String string3 = "com.ibm.ws.security.spnego.propertyReloadTimeout and com.ibm.ws.security.spnego.propertyReloadFile JVM properties are invalid, both or none must be set.";
            throw new TAIConfigurationException(string3);
        }
        try {
            if (string != null && string.length() != 0) {
                this.reloadTimeout = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            String string4 = "com.ibm.ws.security.spnego.propertyReloadTimeout JVM property value is invalid: " + numberFormatException + ". It must be a positive integer.";
            throw new TAIConfigurationException(string4);
        }
        if (string2 != null && string2.length() != 0) {
            try {
                Properties properties2 = new Properties();
                properties2.load(new FileInputStream(string2));
                this.setReloadFile(string2);
                this.setReloadEnabled(true);
                properties = properties2;
                File file = new File(string2);
                l = file.lastModified();
            }
            catch (IOException iOException) {
                String string5 = "com.ibm.ws.security.spnego.propertyReloadFile JVM property value is invalid: " + iOException.toString();
                throw new TAIConfigurationException(string5);
            }
        }
        this.setIncludePortInSPN(Boolean.valueOf(System.getProperty("com.ibm.ws.security.spnego.includePortInSPN")));
        this.doLoad(properties);
        this.setLastReloadTime();
        this.setCurrentProps(properties);
        if (l != 0L) {
            this.lastPropFileModifiedTime = l;
        }
        this.addSpnegoProvider();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "<constructor>");
        }
    }

    private void addSpnegoProvider() throws TAIConfigurationException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "addSpnegoProvider");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                AllServerConfigs.this.useSubjCredsValue = System.getProperty("javax.security.auth.useSubjectCredsOnly");
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, ME, "addSpnegoProvider", "useSubjCredsValue = " + AllServerConfigs.this.useSubjCredsValue);
                }
                if (AllServerConfigs.this.useSubjCredsValue == null || AllServerConfigs.this.useSubjCredsValue != null && AllServerConfigs.this.useSubjCredsValue.equalsIgnoreCase("true")) {
                    System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
                    AllServerConfigs.this.useSubjCredsState = false;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "addSpnegoProvider", "set useSubjectCredsOnly to false");
                    }
                }
                return null;
            }
        });
        Provider provider = Security.getProvider("IBMSPNEGO");
        if (provider == null) {
            String string = "com.ibm.security.jgss.mech.spnego.IBMSPNEGO";
            try {
                Security.addProvider((Provider)Class.forName(string).newInstance());
                provider = Security.getProvider("IBMSPNEGO");
                this.isProviderConfigured = true;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.spnego.AllServerConfigs.addSpnegoProvider", "248", this);
                logger.logp(Level.SEVERE, ME, "addSpnegoProvider", "security.spnego.provider.failed", exception);
                throw new TAIConfigurationException(exception.getLocalizedMessage());
            }
            logger.logp(Level.INFO, ME, "addSpnegoProvider", "security.spnego.init.provider", provider.toString());
        } else if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "addSpnegoProvider", provider.toString() + " is already installed.");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "addSpnegoProvider");
        }
    }

    public boolean isProviderConfigured() {
        return this.isProviderConfigured;
    }

    public void cleanup() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "cleanup");
        }
        if (this.isProviderConfigured()) {
            Provider provider = Security.getProvider("IBMSPNEGO");
            Security.removeProvider("IBMSPNEGO");
            logger.logp(Level.INFO, ME, "cleanup", "security.spnego.remove.provider", provider.toString());
        }
        if (!this.useSubjCredsState) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (AllServerConfigs.this.useSubjCredsValue != null) {
                        System.setProperty("javax.security.auth.useSubjectCredsOnly", AllServerConfigs.this.useSubjCredsValue);
                    } else {
                        System.clearProperty("javax.security.auth.useSubjectCredsOnly");
                    }
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "addSpnegoProvider", "set useSubjectCredsOnly back to " + AllServerConfigs.this.useSubjCredsValue);
                    }
                    return null;
                }
            });
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "cleanup");
        }
    }

    private void doLoad(Properties properties) throws TAIConfigurationException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "doLoad");
        }
        this.numberOfServers = Util.getSpnIdMap("com.ibm.ws.security.spnego.SPN", properties).size();
        if (this.numberOfServers < 1) {
            throw new TAIConfigurationException("No properties (com.ibm.ws.security.spnego.SPN*) for the SPNEGO TAI are defined.");
        }
        this.initServerConfigs(properties);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "doLoad");
        }
    }

    private void initServerConfigs(Properties properties) throws TAIConfigurationException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "initServerConfigs");
        }
        Hashtable<String, ServerConfig> hashtable = new Hashtable<String, ServerConfig>(this.numberOfServers);
        for (int i = 0; i < this.numberOfServers; ++i) {
            String string = "com.ibm.ws.security.spnego.SPN" + Integer.toString(i + 1);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "initServerConfigs", "Setting TAI properties with key = " + string);
            }
            String string2 = properties.getProperty(string + ".GSSNameType");
            String string3 = properties.getProperty(string + ".GSSCredType");
            String string4 = properties.getProperty(string + ".GSSCredDuration");
            String string5 = properties.getProperty(string + ".enableCredDelegate");
            String string6 = properties.getProperty(string + ".trimUserName");
            String string7 = properties.getProperty(string + ".hostName");
            if (string7 == null || string7.length() == 0) {
                throw new TAIConfigurationException(string + ".hostName" + " property must be specified.");
            }
            string7 = string7.trim();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "initServerConfigs", "Setting TAI configuration for HostName = " + string7);
            }
            String string8 = properties.getProperty(string + ".NTLMTokenReceivedPage");
            String string9 = properties.getProperty(string + ".spnegoNotSupportedPage");
            String string10 = properties.getProperty(string + ".filterClass");
            String string11 = properties.getProperty(string + ".filter");
            String string12 = properties.getProperty(string + ".kerberosRealm");
            if (string12 == null || string12.length() == 0) {
                try {
                    string12 = Config.getInstance().getDefaultRealm();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.spnego.AllServerConfigs.initServerConfigs", "381", this);
                    logger.logp(Level.FINER, ME, "initServerConfigs", exception.getMessage());
                    throw new TAIConfigurationException(string + ".kerberosRealm" + " " + exception.getMessage());
                }
            }
            string12 = string12.trim();
            ServerConfig serverConfig = new ServerConfig();
            if (string2 != null) {
                serverConfig.setGssNameType(string2);
            }
            if (string3 != null) {
                serverConfig.setGssCredType(string3);
            }
            if (string4 != null) {
                serverConfig.setGssCredDuration(string4);
            }
            if (string5 != null) {
                serverConfig.setEnableCredDelegate(string5);
            }
            if (string8 != null) {
                serverConfig.setNTLMTokenReceivedPage(string8);
            }
            if (string9 != null) {
                serverConfig.setSpnegoNotSupportedPage(string9);
            }
            if (string6 != null) {
                serverConfig.setTrimUserName(string6);
            }
            serverConfig.setRealm(string12);
            serverConfig.setServerName(string7);
            serverConfig.setFilterClass(string10);
            serverConfig.setFilter(string11, serverConfig.getFilterClass());
            hashtable.put(string7, serverConfig);
            if (!logger.isLoggable(Level.FINER)) continue;
            logger.logp(Level.FINER, ME, "initServerConfigs", "Configuration of Hostname = " + string7 + " is complete.");
        }
        this.serverConfigs = new Hashtable(this.numberOfServers);
        this.serverConfigs.putAll(hashtable);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "initServerConfigs");
        }
    }

    public synchronized void reload() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "reload");
        }
        if (this.isItTimeToReload()) {
            File file = new File(this.getReloadFile());
            long l = file.lastModified();
            if (l != this.lastPropFileModifiedTime) {
                Properties properties = new Properties();
                try {
                    properties.load(new FileInputStream(this.getReloadFile()));
                    this.doLoad(properties);
                    this.setCurrentProps(properties);
                    this.lastPropFileModifiedTime = l;
                    try {
                        SpnegoHandler.initializeServerCreds(this);
                        logger.logp(Level.INFO, ME, "reload", "security.spnego.reload.ok", new Object[]{this.toString()});
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.spnego.AllServerConfigs.reload", "445", this);
                        logger.logp(Level.WARNING, ME, "reload", "security.spnego.reload.initialize.failed");
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.spnego.AllServerConfigs.reload", "472", this);
                    logger.logp(Level.WARNING, ME, "reload", "security.spnego.reload.failed");
                }
            } else {
                logger.logp(Level.INFO, ME, "reload", "security.spnego.reload.not.needed");
            }
            this.setLastReloadTime();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "reload");
        }
    }

    public boolean isItTimeToReload() {
        long l = System.currentTimeMillis();
        long l2 = l - this.getLastReloadTime();
        return l2 > (long)(this.getReloadTimeout() * 1000);
    }

    public final boolean isTAIEnabled() {
        return this.taiEnabled;
    }

    private final void setTaiEnabled(boolean bl) {
        this.taiEnabled = bl;
    }

    public final boolean isIncludePortInSPN() {
        return this.includePortInSPN;
    }

    public final void setIncludePortInSPN(boolean bl) {
        this.includePortInSPN = bl;
    }

    private int getNumberOfServers() {
        return this.numberOfServers;
    }

    public Hashtable getServerConfigs() {
        return this.serverConfigs;
    }

    public ServerConfig getServerConfig(String string) {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "getServerConfig", "server = " + string);
        }
        return (ServerConfig)this.serverConfigs.get(string);
    }

    public boolean isReloadEnabled() {
        return this.reloadEnabled;
    }

    private String getReloadFile() {
        return this.reloadFile;
    }

    private int getReloadTimeout() {
        return this.reloadTimeout;
    }

    private void setReloadEnabled(boolean bl) {
        this.reloadEnabled = bl;
    }

    private void setReloadFile(String string) {
        this.reloadFile = string;
    }

    private void setCurrentProps(Properties properties) {
        this.currentProps = properties;
    }

    private void setReloadTimeout(int n) {
        this.reloadTimeout = n;
    }

    private long getLastReloadTime() {
        return this.lastReloadTime;
    }

    public void setLastReloadTime() {
        this.lastReloadTime = System.currentTimeMillis();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "setLastReloadTime", "currentTimeMillis = " + this.lastReloadTime);
        }
    }

    public String toString() {
        int n = this.getNumberOfServers();
        StringBuffer stringBuffer = new StringBuffer(200 * n);
        stringBuffer.append("\tTAI configuration (JVM) properties:");
        stringBuffer.append("\n\t").append("com.ibm.ws.security.spnego.isEnabled=").append(this.isTAIEnabled());
        if (this.isReloadEnabled()) {
            stringBuffer.append("\n\t").append("com.ibm.ws.security.spnego.propertyReloadTimeout=").append(this.getReloadTimeout());
            stringBuffer.append("\n\t").append("com.ibm.ws.security.spnego.propertyReloadFile=").append(this.getReloadFile());
        }
        Enumeration enumeration = this.getServerConfigs().elements();
        while (enumeration.hasMoreElements()) {
            ServerConfig serverConfig = (ServerConfig)enumeration.nextElement();
            stringBuffer.append("\n").append(serverConfig.toString());
        }
        return stringBuffer.toString();
    }
}

