/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.server.lm;

import com.ibm.ISecurityUtilityImpl.CSIUtil;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.registry.UserRegistryImpl;
import com.ibm.ws.security.server.SecurityServerImpl;
import com.ibm.ws.security.token.WSCredentialTokenMapper;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.auth.callback.WSX509CertificateChainCallback;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class swamLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private UserRegistryImpl registry = null;
    private ContextManager contextManager = null;
    private WSPrincipal principal;
    private WSCredential credential;
    private WSCredentialTokenMapperInterface wsCredMapper = null;
    protected boolean debug = false;
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    private static final TraceComponent tc = Tr.register(swamLoginModule.class, "Security", "com.ibm.ejs.resources.security");
    private static final ContextManager ctxMgr = ContextManagerFactory.getInstance();

    public swamLoginModule() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "swamLoginModule()");
            Tr.exit(tc, "swamLoginModule()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{subject, callbackHandler, map, map2});
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.contextManager = ContextManagerFactory.getInstance();
        this.debug = "true".equalsIgnoreCase((String)this.options.get("debug"));
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "WSLoginModuleImpl initialized");
        }
        try {
            this.wsCredMapper = WSCredentialTokenMapper.getInstance();
            this.registry = (UserRegistryImpl)SecurityServerImpl.getRegistryImpl(ContextManagerFactory.getInstance().getDefaultRealm());
            this.contextManager.clearRootException();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.swamLoginModule.initialize", "149", this);
            Tr.error(tc, "security.swam.find.registry", new Object[]{exception});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean login() throws LoginException {
        Object object;
        block69: {
            Object object2;
            Object object3;
            Callback[] callbackArray;
            Hashtable hashtable;
            if (this.debug || tc.isEntryEnabled()) {
                Tr.entry(tc, "login");
            }
            this.succeeded = false;
            if (this.commitSucceeded) {
                if (this.debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "The login module is in funny state, cleanup before starting a new login process.");
                }
                this.cleanup();
            }
            if ((hashtable = (Hashtable)this.sharedState.get("com.ibm.wsspi.security.cred.propertiesObject")) == null) {
                try {
                    callbackArray = this.subject;
                    hashtable = (Hashtable)AccessController.doPrivileged(new PrivilegedExceptionAction((Subject)callbackArray){
                        private final /* synthetic */ Subject val$subjectPriv;
                        {
                            this.val$subjectPriv = subject;
                        }

                        public Object run() throws Exception {
                            Object[] objectArray = this.val$subjectPriv.getPublicCredentials().toArray();
                            if (swamLoginModule.this.debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "Looking for custom properties in public cred list.");
                            }
                            for (int i = 0; i < objectArray.length; ++i) {
                                if (swamLoginModule.this.debug || tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Object[" + i + "] in public list: " + objectArray[i]);
                                }
                                if (!(objectArray[i] instanceof Hashtable) || ((Hashtable)objectArray[i]).get("com.ibm.wsspi.security.cred.uniqueId") == null && ((Hashtable)objectArray[i]).get("com.ibm.wsspi.security.cred.userId") == null) continue;
                                return objectArray[i];
                            }
                            Object[] objectArray2 = this.val$subjectPriv.getPrivateCredentials().toArray();
                            if (swamLoginModule.this.debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "Looking for custom properties in private cred list.");
                            }
                            for (int i = 0; i < objectArray2.length; ++i) {
                                if (swamLoginModule.this.debug || tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Object[" + i + "] in private list: " + objectArray2[i]);
                                }
                                if (!(objectArray2[i] instanceof Hashtable) || ((Hashtable)objectArray2[i]).get("com.ibm.wsspi.security.cred.uniqueId") == null && ((Hashtable)objectArray2[i]).get("com.ibm.wsspi.security.cred.userId") == null) continue;
                                return objectArray2[i];
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "241", this);
                    this.contextManager.setRootException(privilegedActionException.getException());
                    throw new WSLoginFailedException(privilegedActionException.getException().getMessage(), privilegedActionException.getException());
                }
            }
            if (this.callbackHandler == null) {
                WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("swamLoginModule: No CallbackHandler available to gather authentication information from the user.");
                this.contextManager.setRootException(wSLoginFailedException);
                if (this.debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "swamLoginModule: No CallbackHandler available to gather authentication information from the user.", wSLoginFailedException);
                }
                throw wSLoginFailedException;
            }
            callbackArray = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false), new WSRealmNameCallbackImpl("Realm Name: ", this.contextManager.getDefaultRealm()), new WSX509CertificateChainCallback("X509Certificate[]: ")};
            String string = null;
            String string2 = null;
            char[] cArray = null;
            X509Certificate[] x509CertificateArray = null;
            try {
                this.callbackHandler.handle(callbackArray);
                string = ((NameCallback)callbackArray[0]).getName();
                object3 = ((PasswordCallback)callbackArray[1]).getPassword();
                if (object3 != null) {
                    cArray = new char[((char[])object3).length];
                    System.arraycopy(object3, 0, cArray, 0, ((char[])object3).length);
                    ((PasswordCallback)callbackArray[1]).clearPassword();
                }
                string2 = ((WSRealmNameCallbackImpl)callbackArray[2]).getRealmName();
                x509CertificateArray = ((WSX509CertificateChainCallback)callbackArray[3]).getX509CertificateChain();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.security.server.lm.swamLoginModule.login", "284", this);
                Tr.error(tc, "security.swam.callback.ex", new Object[]{iOException});
                this.contextManager.setRootException(iOException);
                throw new WSLoginFailedException("swamLoginModule IOException: " + iOException.getMessage(), iOException);
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                FFDCFilter.processException((Throwable)unsupportedCallbackException, "com.ibm.ws.security.server.lm.swamLoginModule.login", "291", this);
                Tr.error(tc, "security.swam.unsupport.callback", new Object[]{unsupportedCallbackException.getCallback().toString(), unsupportedCallbackException});
                this.contextManager.setRootException(unsupportedCallbackException);
                throw new WSLoginFailedException(unsupportedCallbackException.getCallback().toString() + " not supported by CallbackHandler to gather authentication information " + "from the user", unsupportedCallbackException);
            }
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "uid = " + string);
                Tr.debug(tc, "X509 cert chain = " + x509CertificateArray);
                Tr.debug(tc, "realm = " + string2);
                Tr.debug(tc, "password = " + (cArray == null ? null : "XXXXXXXX"));
            }
            if (x509CertificateArray == null && string == null && cArray == null) {
                object3 = new WSLoginFailedException("swamLoginModule: No authentication data.");
                this.contextManager.setRootException((Throwable)object3);
                throw object3;
            }
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Successfully gathered authentication information");
            }
            if (hashtable != null && hashtable.get("com.ibm.wsspi.security.cred.uniqueId") != null && hashtable.get("com.ibm.wsspi.security.cred.userId") == null) {
                object3 = System.getSecurityManager();
                if (object3 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                        Tr.debug(tc, "Expecting : " + MAP_CREDENTIAL.toString());
                    }
                    ((SecurityManager)object3).checkPermission(MAP_CREDENTIAL);
                }
                try {
                    try {
                        final Hashtable hashtable2 = hashtable;
                        this.credential = (WSCredential)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws WSLoginFailedException {
                                return swamLoginModule.this.wsCredMapper.createWSCredentialFromProperties(hashtable2);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "355", this);
                        this.contextManager.setRootException(privilegedActionException.getException());
                        if (this.debug || tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception occurred during properties login: ", new Object[]{privilegedActionException.getException()});
                        }
                        throw new WSLoginFailedException(privilegedActionException.getException().getMessage(), privilegedActionException.getException());
                    }
                    if (this.credential != null) {
                        this.sharedState.put("WSCredential", this.credential);
                    }
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "WSCredential contains: " + this.credential);
                    }
                    this.principal = this.contextManager.createPrincipal(this.credential);
                    if (this.principal != null) {
                        this.sharedState.put("WSPrincipal", this.principal);
                    }
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "WSPrincipal contains: " + this.principal);
                    }
                }
                catch (WSLoginFailedException wSLoginFailedException) {
                    this.contextManager.setRootException(wSLoginFailedException);
                    FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "377", this);
                    if (this.debug || tc.isEntryEnabled()) {
                        Tr.exit(tc, "Exception creating SAP tokens.", new Object[]{wSLoginFailedException});
                    }
                    throw wSLoginFailedException;
                }
                catch (Exception exception) {
                    this.contextManager.setRootException(exception);
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "384", this);
                    if (this.debug || tc.isEntryEnabled()) {
                        Tr.exit(tc, "Exception creating SAP tokens.", new Object[]{exception});
                    }
                    throw new WSLoginFailedException(exception.getMessage(), exception);
                }
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.debug(tc, "Custom login module passing in credential properties.");
                    Tr.exit(tc, "login()");
                }
                this.succeeded = true;
                return this.succeeded;
            }
            if (hashtable != null && hashtable.get("com.ibm.wsspi.security.cred.userId") != null) {
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.debug(tc, "Setting uid and/or password from hashtable.");
                }
                string = (String)hashtable.get("com.ibm.wsspi.security.cred.userId");
                object3 = (String)hashtable.get("com.ibm.wsspi.security.cred.password");
                if (object3 != null) {
                    cArray = ((String)object3).toCharArray();
                }
                if (this.debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "uid = " + string);
                    Tr.debug(tc, "password = " + (cArray == null ? "<null>" : "XXXXXXXX"));
                }
            }
            object3 = null;
            if (string != null && cArray != null) {
                if (string2 == null || string2.length() == 0) {
                    string2 = this.contextManager.getDefaultRealm();
                }
                if (this.debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using uid and password for authentication");
                    object = new StringBuffer("Authenticating \"");
                    ((StringBuffer)object).append(string2).append('/').append(string).append("\"");
                    Tr.debug(tc, ((StringBuffer)object).toString());
                }
                try {
                    object = new String(cArray);
                    object3 = this.registry.checkPassword(string, (String)object);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.swamLoginModule.login", "443", this);
                    this.contextManager.setRootException(exception);
                    throw new WSLoginFailedException(exception.getMessage(), exception);
                }
                try {
                    object = SecurityConfig.getIntSvrIdIfUsed();
                    if (object != null && this.contextManager.isInternalServerId((String)object3)) {
                        this.credential = this.contextManager.getServerCredential();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Got credential from ContextManager: " + this.credential);
                        }
                        break block69;
                    }
                    final WSCredential wSCredential = this.registry.createCredential((String)object3);
                    try {
                        this.credential = (WSCredential)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return new WSCredentialImpl(wSCredential, "No OID for this mechanism", RegistryUtil.nullByteArray, false, -1L);
                            }
                        });
                        break block69;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception occurred creating new WS cred.", new Object[]{privilegedActionException.getException()});
                        }
                        FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.server.SecurityServerImpl.mapCredential", "477", this);
                        this.contextManager.setRootException(privilegedActionException.getException());
                        throw privilegedActionException.getException();
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.swamLoginModule.login", "485", this);
                    this.contextManager.setRootException(exception);
                    throw new WSLoginFailedException(exception.getMessage(), exception);
                }
            }
            if (string == null && x509CertificateArray == null) {
                WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("swamLoginModule: No authentication data");
                this.contextManager.setRootException(wSLoginFailedException);
                throw wSLoginFailedException;
            }
            object = System.getSecurityManager();
            if (object != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(tc, "Expecting : " + MAP_CREDENTIAL.toString());
                }
                ((SecurityManager)object).checkPermission(MAP_CREDENTIAL);
            }
            if (x509CertificateArray != null) {
                object2 = x509CertificateArray;
                PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction((X509Certificate[])object2){
                    private final /* synthetic */ X509Certificate[] val$cert_chain_final;
                    {
                        this.val$cert_chain_final = x509CertificateArray;
                    }

                    public Object run() throws Exception {
                        if (swamLoginModule.this.debug || tc.isDebugEnabled()) {
                            Tr.debug(tc, "Mapping X509Certificate[] to uid.");
                        }
                        return CSIUtil.getInstance().parseCert(this.val$cert_chain_final);
                    }
                };
                try {
                    string = (String)ContextManagerFactory.getInstance().runAsSystem(privilegedExceptionAction);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.server.ltpa.ltpaLoginModule.login", "533", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception parsing client certificate.", new Object[]{privilegedActionException.getException()});
                    }
                    throw new WSLoginFailedException(privilegedActionException.getException().getMessage(), privilegedActionException.getException());
                }
            }
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Using uid to mapCredential.");
                object2 = new StringBuffer("Authenticating \"");
                ((StringBuffer)object2).append(string2).append('/').append(string).append("\"");
                Tr.debug(tc, ((StringBuffer)object2).toString());
            }
            try {
                if (SecurityConfig.isRegTAM() && !RegistryUtil.checkValidUserifTAM(string, this.registry)) {
                    throw new WSLoginFailedException("User is not valid in Access Manager");
                }
                object2 = this.registry.createCredential(string);
                try {
                    this.credential = (WSCredential)AccessController.doPrivileged(new PrivilegedExceptionAction((WSCredential)object2){
                        private final /* synthetic */ WSCredential val$wsRegistryCred;
                        {
                            this.val$wsRegistryCred = wSCredential;
                        }

                        public Object run() throws Exception {
                            return new WSCredentialImpl(this.val$wsRegistryCred, "No OID for this mechanism", RegistryUtil.nullByteArray, false, -1L);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception occurred creating new WS cred.", new Object[]{privilegedActionException.getException()});
                    }
                    FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.security.server.lm.swamLoginModule.login", "582", this);
                    this.contextManager.setRootException(privilegedActionException.getException());
                    throw privilegedActionException.getException();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.swamLoginModule.login", "589", this);
                this.contextManager.setRootException(exception);
                if (exception instanceof WSLoginFailedException) {
                    throw (WSLoginFailedException)exception;
                }
                throw new WSLoginFailedException(exception.getMessage(), exception);
            }
        }
        if (this.credential == null) {
            object = new WSLoginFailedException("swamLoginModule: Credential returned from SAS authentication is null");
            this.contextManager.setRootException((Throwable)object);
            throw object;
        }
        try {
            this.principal = this.contextManager.createPrincipal(this.credential);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred creating new WS Principal.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.swamLoginModule.login", "619", this);
            this.contextManager.setRootException(exception);
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
        this.sharedState.put("WSCredential", this.credential);
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "WSCredential contains: " + this.credential);
        }
        this.sharedState.put("WSPrincipal", this.principal);
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "WSPrincipal contains: " + this.principal);
        }
        this.succeeded = true;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "login", new Boolean(this.succeeded));
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "commit");
        }
        boolean bl = false;
        if (!this.succeeded) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Do not commit because of authentication failed.");
            }
            bl = false;
        } else {
            if (!this.commitSucceeded) {
                if (this.principal == null) {
                    WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("swamLoginModule: WSPrincipal is null in commit (phase 2) stage");
                    this.contextManager.setRootException(wSLoginFailedException);
                    throw wSLoginFailedException;
                }
                if (this.credential == null) {
                    WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("swamLoginModule: WSCredential is null in commit (phase 2) stage");
                    this.contextManager.setRootException(wSLoginFailedException);
                    throw wSLoginFailedException;
                }
                try {
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Start committing the changes to the Subject ...");
                    }
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                if (!swamLoginModule.this.subject.getPrincipals().contains(swamLoginModule.this.principal)) {
                                    swamLoginModule.this.subject.getPrincipals().add(swamLoginModule.this.principal);
                                }
                                if (!swamLoginModule.this.subject.getPublicCredentials().contains(swamLoginModule.this.credential)) {
                                    swamLoginModule.this.credential.set("wssecurity.identity_name", "ClientAuthenticationToken");
                                    swamLoginModule.this.credential.set("wssecurity.identity_value", StringBytesConversion.getConvertedBytes(swamLoginModule.this.credential.getRealmSecurityName()));
                                    swamLoginModule.this.subject.getPublicCredentials().add(swamLoginModule.this.credential);
                                }
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.server.lm.swamLoginModule.commit", "725", this);
                        this.contextManager.setRootException(privilegedActionException.getException());
                        throw new WSLoginFailedException(privilegedActionException.getException().getMessage(), privilegedActionException.getException());
                    }
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Change committed!");
                    }
                    this.commitSucceeded = true;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.swamLoginModule.commit", "740", this);
                    Tr.error(tc, "security.swam.commit.ex", new Object[]{exception});
                    this.cleanup();
                    this.commitSucceeded = false;
                }
            } else if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "It has been committed prior this call, nothing is done.");
            }
            bl = this.commitSucceeded;
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "commit", new Boolean(bl));
        }
        return bl;
    }

    public boolean abort() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return true;
    }

    private void cleanup() {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Start removing WSPrinciapl, WSCredential, and CORBA Credentials from the Subject.");
            Tr.debug(tc, "Start removing ...");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    if (swamLoginModule.this.principal != null && swamLoginModule.this.subject.getPrincipals().contains(swamLoginModule.this.principal)) {
                        swamLoginModule.this.subject.getPrincipals().remove(swamLoginModule.this.principal);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.swamLoginModule.run", "871", this);
                    Tr.error(tc, "security.swam.remove.prin.ex", new Object[]{swamLoginModule.this.principal.getName(), exception});
                }
                try {
                    if (swamLoginModule.this.credential != null && swamLoginModule.this.subject.getPublicCredentials().contains(swamLoginModule.this.credential)) {
                        swamLoginModule.this.subject.getPublicCredentials().remove(swamLoginModule.this.credential);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.swamLoginModule.run", "883", this);
                    Tr.error(tc, "security.swam.remove.cred.ex", new Object[]{exception});
                }
                return null;
            }
        });
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed.");
        }
        this.principal = null;
        this.credential = null;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup()");
        }
    }
}

