/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.server.lm;

import com.ibm.ISecurityUtilityImpl.CSIUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.TokenCreationFailedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.BasicAuthData;
import com.ibm.ws.security.common.auth.util.CredentialsHelper;
import com.ibm.ws.security.common.auth.util.Util;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.icsf.ICSFConfigException;
import com.ibm.ws.security.icsf.ICSFServerObject;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.auth.callback.WSX509CertificateChainCallback;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class ICSFLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private WSPrincipal principal;
    private WSCredential credential;
    private ContextManager contextManager;
    private UserRegistry registry;
    protected boolean debug = false;
    private ICSFServerObject icsfServer;
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    private static final TraceComponent tc = Tr.register(ICSFLoginModule.class, null, "com.ibm.ejs.resources.security");

    public ICSFLoginModule() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ICSFLoginModule()");
            Tr.exit(tc, "ICSFLoginModule()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize(subject = \"" + subject.toString() + "\", callbackHandler = \"" + callbackHandler.toString() + "\", sharedState = \"" + map.toString() + "\", options = \"" + map2.toString() + "\")");
            }
            this.subject = subject;
            this.callbackHandler = callbackHandler;
            this.sharedState = map;
            this.options = map2;
            try {
                this.icsfServer = ICSFServerObject.getICSFServer();
            }
            catch (ICSFConfigException iCSFConfigException) {
                FFDCFilter.processException((Throwable)iCSFConfigException, "com.ibm.ws.security.server.lm.ltpaLoginModule.initialize", "120", this);
                if (!this.debug && !tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "ERROR: Failed to get the ICSF server object.");
            }
        }
        this.contextManager = ContextManagerFactory.getInstance();
        if (this.contextManager != null) {
            this.registry = this.contextManager.getRegistry(this.contextManager.getDefaultRealm());
            this.contextManager.clearRootException();
        }
        this.debug = "true".equalsIgnoreCase((String)this.options.get("debug"));
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "WSLoginModuleImpl initialized");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(subject, callbackHandler, sharedState, options)");
        }
    }

    public boolean login() throws LoginException {
        Object object;
        Object object2;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        this.succeeded = false;
        if (this.commitSucceeded) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "The login module is in funny state, cleanup before starting a new login process.");
            }
            this.cleanup();
        }
        if (this.callbackHandler == null) {
            WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("No CallbackHandler available to gather authentication information from the user.");
            this.contextManager.setRootException(wSLoginFailedException);
            throw wSLoginFailedException;
        }
        Callback[] callbackArray = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false), new WSCredTokenCallbackImpl("Credential Token: "), new WSX509CertificateChainCallback("X509Certificate[]: ")};
        String string = null;
        String string2 = null;
        char[] cArray = null;
        byte[] byArray = null;
        X509Certificate[] x509CertificateArray = null;
        try {
            this.callbackHandler.handle(callbackArray);
            string = ((NameCallback)callbackArray[0]).getName();
            object2 = ((PasswordCallback)callbackArray[1]).getPassword();
            if (object2 != null) {
                cArray = new char[((char[])object2).length];
                System.arraycopy(object2, 0, cArray, 0, ((char[])object2).length);
                ((PasswordCallback)callbackArray[1]).clearPassword();
            }
            if ((object = ((WSCredTokenCallbackImpl)callbackArray[2]).getCredToken()) != null) {
                byArray = CredentialsHelper.copyCredToken((byte[])object);
            }
            x509CertificateArray = ((WSX509CertificateChainCallback)callbackArray[3]).getX509CertificateChain();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.security.server.lm.ICSFLoginModule.login", "180", this);
            Tr.error(tc, "security.jaas.callBackHandlerIOException", new Object[]{this.getClass().getName(), iOException});
            this.contextManager.setRootException(iOException);
            throw new WSLoginFailedException("IOException: " + iOException.getMessage(), iOException);
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            FFDCFilter.processException((Throwable)unsupportedCallbackException, "com.ibm.ws.security.server.lm.ICSFLoginModule.login", "184", this);
            Tr.error(tc, "security.jaas.callBackHandlerException", new Object[]{this.getClass().getName(), unsupportedCallbackException.getCallback().toString(), unsupportedCallbackException});
            this.contextManager.setRootException(unsupportedCallbackException);
            throw new WSLoginFailedException(unsupportedCallbackException.getCallback().toString() + " not supported by CallbackHandler to gather authentication information " + "from the user" + unsupportedCallbackException.getMessage(), unsupportedCallbackException);
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "uid = " + string);
            Tr.debug(tc, "X509 cert chain = " + x509CertificateArray);
            Tr.debug(tc, "realm = " + string2);
            Tr.debug(tc, "password = " + (cArray == null ? "<null>" : "XXXXXXXX"));
            Tr.debug(tc, "cred token = " + Util.toString(byArray));
        }
        if (string == null && cArray == null && byArray == null) {
            object2 = new WSLoginFailedException("No authentication data.");
            this.contextManager.setRootException((Throwable)object2);
            throw object2;
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Successfully gathered authentication information");
        }
        if (string != null && cArray != null) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Using uid and password for authentication");
                object2 = new StringBuffer("Authenticating \"");
                ((StringBuffer)object2).append(string2).append('/').append(string).append("\"");
                Tr.debug(tc, ((StringBuffer)object2).toString());
            }
            object2 = new String(cArray);
            object = new BasicAuthData(string, (String)object2);
            try {
                this.credential = this.icsfServer.authenticate((BasicAuthData)object);
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "271", this);
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.exit(tc, "login()", new Object[]{wSLoginFailedException});
                }
                this.contextManager.setRootException(wSLoginFailedException);
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "277", this);
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.exit(tc, "login()", new Object[]{exception});
                }
                this.contextManager.setRootException(exception);
                throw new WSLoginFailedException(exception.getMessage(), exception);
            }
        }
        if (string != null || x509CertificateArray != null) {
            object2 = System.getSecurityManager();
            if (object2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(tc, "Expecting : " + MAP_CREDENTIAL.toString());
                }
                ((SecurityManager)object2).checkPermission(MAP_CREDENTIAL);
            }
            if (x509CertificateArray != null) {
                object = x509CertificateArray;
                PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction((X509Certificate[])object){
                    private final /* synthetic */ X509Certificate[] val$cert_chain_final;
                    {
                        this.val$cert_chain_final = x509CertificateArray;
                    }

                    public Object run() throws Exception {
                        if (ICSFLoginModule.this.debug || tc.isDebugEnabled()) {
                            Tr.debug(tc, "Mapping X509Certificate[] to uid.");
                        }
                        return CSIUtil.getInstance().parseCert(this.val$cert_chain_final);
                    }
                };
                try {
                    string = (String)ContextManagerFactory.getInstance().runAsSystem(privilegedExceptionAction);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.server.ltpa.ltpaLoginModule.login", "350", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception parsing client certificate.", new Object[]{privilegedActionException.getException()});
                    }
                    throw new WSLoginFailedException(privilegedActionException.getException().getMessage(), privilegedActionException.getException());
                }
            }
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Using uid to mapCredential");
                object = new StringBuffer("Authenticating \"");
                ((StringBuffer)object).append(string2).append('/').append(string).append("\"");
                Tr.debug(tc, ((StringBuffer)object).toString());
            }
            try {
                if (SecurityConfig.isRegTAM() && !RegistryUtil.checkValidUserifTAM(string, this.registry)) {
                    throw new WSLoginFailedException("User is not valid in Access Manager");
                }
                object = this.registry.createCredential(string);
                this.credential = this.icsfServer.createICSFToken((WSCredential)object);
            }
            catch (TokenCreationFailedException tokenCreationFailedException) {
                FFDCFilter.processException((Throwable)tokenCreationFailedException, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "311", this);
                Tr.debug(tc, "Using uid to mapCredential");
                this.contextManager.setRootException(tokenCreationFailedException);
                throw new WSLoginFailedException(tokenCreationFailedException.getMessage(), tokenCreationFailedException);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "317", this);
                this.contextManager.setRootException(exception);
                throw new WSLoginFailedException(exception.getMessage(), exception);
            }
        }
        if (byArray != null) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Using credential token for authentication");
            }
            try {
                this.credential = this.icsfServer.validate(byArray);
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "333", this);
                this.contextManager.setRootException(wSLoginFailedException);
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "338", this);
                this.contextManager.setRootException(exception);
                throw new WSLoginFailedException(exception.getMessage(), exception);
            }
        } else {
            object2 = new WSLoginFailedException("ltpaLoginModule: No authentication data");
            this.contextManager.setRootException((Throwable)object2);
            throw object2;
        }
        if (this.credential == null) {
            object2 = new WSLoginFailedException("ltpaLoginModule: Credential returned from SAS authentication is null");
            this.contextManager.setRootException((Throwable)object2);
            throw object2;
        }
        try {
            this.principal = ContextManagerFactory.getInstance().createPrincipal(this.credential);
        }
        catch (WSSecurityException wSSecurityException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSSecurityException caught creating a new principal.", new Object[]{wSSecurityException});
            }
            FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.server.lm.ICSFLoginModule.login", "260", this);
            this.contextManager.setRootException(wSSecurityException);
            throw new WSLoginFailedException(wSSecurityException.getMessage(), wSSecurityException);
        }
        this.succeeded = true;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        boolean bl = false;
        if (!this.succeeded) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Do not commit because of authentication failed.");
            }
            bl = false;
        } else {
            if (!this.commitSucceeded) {
                if (this.principal == null) {
                    WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("ltpaLoginModule: WSPrincipal is null in commit (phase 2) stage");
                    this.contextManager.setRootException(wSLoginFailedException);
                    throw wSLoginFailedException;
                }
                if (this.credential == null) {
                    WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("ltpaLoginModule: WSCredential is null in commit (phase 2) stage");
                    this.contextManager.setRootException(wSLoginFailedException);
                    throw wSLoginFailedException;
                }
                try {
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Start committing the changes to the Subject ...");
                    }
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws CredentialDestroyedException, CredentialExpiredException {
                                if (!ICSFLoginModule.this.subject.getPrincipals().contains(ICSFLoginModule.this.principal)) {
                                    ICSFLoginModule.this.subject.getPrincipals().add(ICSFLoginModule.this.principal);
                                }
                                if (!ICSFLoginModule.this.subject.getPublicCredentials().contains(ICSFLoginModule.this.credential)) {
                                    ICSFLoginModule.this.subject.getPublicCredentials().add(ICSFLoginModule.this.credential);
                                }
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.auth.swamLoginModule.commit", "471", this);
                        this.contextManager.setRootException(privilegedActionException.getException());
                        throw new WSLoginFailedException(privilegedActionException.getException().getMessage(), privilegedActionException.getException());
                    }
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Change committed!");
                    }
                    this.commitSucceeded = true;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.ICSFLoginModule.commit", "341", this);
                    Tr.error(tc, "security.jaas.LoginModuleCommitError", new Object[]{this.getClass().getName(), exception});
                    this.cleanup();
                    this.commitSucceeded = false;
                }
            } else if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "It has been committed prior this call, nothing is done.");
            }
            bl = this.commitSucceeded;
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return bl;
    }

    public boolean abort() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return true;
    }

    private void cleanup() {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Start removing WSPrinciapl, WSCredential, and CORBA Credentials from the Subject.");
            Tr.debug(tc, "Start removing ...");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    if (ICSFLoginModule.this.principal != null && ICSFLoginModule.this.subject.getPrincipals().contains(ICSFLoginModule.this.principal)) {
                        ICSFLoginModule.this.subject.getPrincipals().remove(ICSFLoginModule.this.principal);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.ICSFLoginModule.run", "456", this);
                    Tr.error(tc, "security.jaas.removeCredException", new Object[]{this.getClass().getName(), exception});
                }
                try {
                    if (ICSFLoginModule.this.credential != null && ICSFLoginModule.this.subject.getPublicCredentials().contains(ICSFLoginModule.this.credential)) {
                        ICSFLoginModule.this.subject.getPublicCredentials().remove(ICSFLoginModule.this.credential);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.ICSFLoginModule.run", "464", this);
                    Tr.error(tc, "security.jaas.removeCredException", new Object[]{this.getClass().getName(), exception});
                }
                if (ICSFLoginModule.this.credential == null) {
                    // empty if block
                }
                return null;
            }
        });
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed.");
        }
        this.principal = null;
        this.credential = null;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup()");
        }
    }
}

