/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.server.SecurityServer;
import com.ibm.ws.security.server.SecurityServerImpl;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public final class SecurityServerFactory {
    private static final TraceComponent tc = Tr.register(SecurityServerFactory.class, null, "com.ibm.ejs.resources.security");
    public static SecurityServerImpl newSecServerImpl = null;

    public static SecurityServer create() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create");
        }
        if (newSecServerImpl == null) {
            try {
                PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
                newSecServerImpl = new SecurityServerImpl();
                if (!platformHelper.isZOS() || platformHelper.isControlJvm()) {
                    SecurityServerFactory.bind_security_server("SecurityServer");
                    SecurityServerFactory.bind_security_server_to_nonWLM_namespace("SecurityServer");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.security.server.SecurityServerFactory.create", "66");
                Tr.error(tc, "security.secvrfactory.createrr", new Object[]{exception});
                throw exception;
            }
        }
        return newSecServerImpl;
    }

    public static void setConfigurator(RoleBasedConfigurator roleBasedConfigurator) {
        if (newSecServerImpl != null) {
            newSecServerImpl.setConfigurator(roleBasedConfigurator);
        }
    }

    public static void bind_security_server(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bind_security_server", string);
        }
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
        }
        catch (NamingException namingException) {
            FFDCFilter.processException(namingException, "com.ibm.ws.security.server.SecurityServerFactory.bind_security_server", "100");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to get initial naming context");
            }
            Tr.error(tc, "security.getting.initctx.error", new Object[]{namingException});
        }
        try {
            initialContext.rebind(string, (Object)newSecServerImpl);
        }
        catch (NamingException namingException) {
            FFDCFilter.processException(namingException, "com.ibm.ws.security.server.SecurityServerFactory.bind_security_server", "112");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to bind security server to local name space");
            }
            Tr.error(tc, "security.bind.server.error", new Object[]{namingException});
        }
    }

    public static void bind_security_server_to_nonWLM_namespace(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bind_security_server_to_nonWLM_namespace", string);
        }
        InitialContext initialContext = null;
        try {
            Properties properties = new Properties();
            properties.put("java.naming.provider.url", "corbaloc:rir:/WsnAdminNameService");
            initialContext = new InitialContext(properties);
        }
        catch (NamingException namingException) {
            FFDCFilter.processException(namingException, "com.ibm.ws.security.server.SecurityServerFactory.bind_security_server_to_nonWLM_namespace", "137");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to get initial naming context");
            }
            Tr.error(tc, "security.getting.initctx.error", new Object[]{namingException});
        }
        try {
            initialContext.rebind(string, (Object)newSecServerImpl);
        }
        catch (NamingException namingException) {
            FFDCFilter.processException(namingException, "com.ibm.ws.security.server.SecurityServerFactory.bind_security_server_to_nonWLM_namespace", "149");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to bind security server to local name space");
            }
            Tr.error(tc, "security.bind.server.error", new Object[]{namingException});
        }
    }
}

