/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.role;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.role.DescriptorParseException;
import com.ibm.ws.security.role.Queue;
import com.ibm.ws.security.role.RoleBasedModule;
import com.ibm.ws.security.role.StandardDescriptorFieldName;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class RolePermissionDescriptorLoader
extends DefaultHandler
implements StandardDescriptorFieldName {
    private static TraceComponent tc = Tr.register(RolePermissionDescriptorLoader.class, null, "com.ibm.ejs.resources.security");
    private Queue currentElement = new Queue();
    private Locator locator = null;
    private Map roleMap = new HashMap(6);
    private HashSet roleSet = new HashSet(6);
    private Map resourceMap = new HashMap(10);
    private RoleBasedModule rbMod = null;
    private String moduleName = null;
    private boolean processingCharacters = false;
    private ArrayList method_permissions = new ArrayList(10);

    public RoleBasedModule loadDescriptor(String string, String string2, Object object) throws DescriptorParseException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadDescriptor", string);
        }
        this.moduleName = string2 != null ? string2 : string;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadDescriptor: process module: ", this.moduleName);
        }
        try {
            Object object2;
            XMLReader xMLReader = this.getXMLReader();
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xMLReader.setFeature("http://xml.org/sax/features/validation", true);
            xMLReader.setEntityResolver(this);
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream == null) {
                object2 = object.getClass().getClassLoader();
                inputStream = ((ClassLoader)object2).getResourceAsStream(string);
            }
            if (inputStream == null) {
                throw new DescriptorParseException(string + " not found");
            }
            object2 = new InputSource(inputStream);
            ((InputSource)object2).setSystemId(string);
            xMLReader.parse((InputSource)object2);
            RoleBasedModule roleBasedModule = this.rbMod;
            return roleBasedModule;
        }
        catch (DescriptorParseException descriptorParseException) {
            FFDCFilter.processException((Throwable)descriptorParseException, "com.ibm.ws.security.role.RolePermissionDescriptorLoader.loadDescriptor", "125", this);
            throw descriptorParseException;
        }
        catch (SAXException sAXException) {
            FFDCFilter.processException((Throwable)sAXException, "com.ibm.ws.security.role.RolePermissionDescriptorLoader.loadDescriptor", "128", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unable to parse xml descriptor file");
            }
            throw new DescriptorParseException(sAXException.toString());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.role.RolePermissionDescriptorLoader.loadDescriptor", "133", this);
            String string3 = "unable to parse " + string;
            throw new DescriptorParseException(exception.toString() + string3);
        }
        finally {
            this.locator = null;
            this.currentElement = null;
            this.roleMap = null;
            this.roleSet = null;
        }
    }

    public RoleBasedModule loadDescriptor(InputSource inputSource, String string, Object object) throws DescriptorParseException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadDescriptor");
        }
        this.moduleName = string;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadDescriptor: process module: ", this.moduleName);
        }
        try {
            XMLReader xMLReader = this.getXMLReader();
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xMLReader.setFeature("http://xml.org/sax/features/validation", true);
            xMLReader.setEntityResolver(this);
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            inputSource.setSystemId(this.moduleName);
            xMLReader.parse(inputSource);
            RoleBasedModule roleBasedModule = this.rbMod;
            return roleBasedModule;
        }
        catch (SAXException sAXException) {
            FFDCFilter.processException((Throwable)sAXException, "com.ibm.ws.security.role.RolePermissionDescriptorLoader.loadDescriptor", "128", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unable to parse xml descriptor file");
            }
            throw new DescriptorParseException(sAXException.toString());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.role.RolePermissionDescriptorLoader.loadDescriptor", "133", this);
            String string2 = "unable to parse " + this.moduleName;
            throw new DescriptorParseException(exception.toString() + string2);
        }
        finally {
            this.locator = null;
            this.currentElement = null;
            this.roleMap = null;
            this.roleSet = null;
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveEntity", string2);
        }
        InputSource inputSource = null;
        try {
            if (string2.endsWith("RolePermissionDescriptor.dtd")) {
                string2 = "xml/RolePermissionDescriptor.dtd";
                InputStream inputStream = this.getClass().getResourceAsStream(string2);
                inputSource = new InputSource(inputStream);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.role.RolePermissionDescriptorLoader.resolveEntity", "161", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to load dtd file", exception);
            }
            throw new SAXException("unable to load dtd", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resovleEntity", inputSource);
        }
        return inputSource;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "error", sAXParseException);
        }
        throw new SAXException(sAXParseException);
    }

    public void startDocument() throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startDocument");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startDocument");
        }
    }

    public void endDocument() throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "endDocument");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "endDocument");
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.currentElement.enqueue(string2);
        this.processingCharacters = false;
        if (string2.equals("role-permission")) {
            this.parseRolePermission(attributes);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            if (string2.equals("method-permission")) {
                this.processMethodPermission();
            } else if (string2.equals("security-role")) {
                this.processSecurityRole();
            } else if (string2.equals("resource")) {
                this.processResource();
            } else if (string2.equals("role-permission")) {
                this.processRolePermission();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.role.RolePermissionDescriptorLoader.endElement", "219", this);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string;
        block3: {
            string = null;
            if (n == 0 && !this.currentElement.empty()) {
                try {
                    string = this.processingCharacters ? (String)this.currentElement.undo() + new String(cArray, n, n2) : new String(cArray, n, n2);
                    this.currentElement.enqueue(string);
                    return;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.security.role.RolePermissionDescriptorLoader.characters", "235", this);
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Unexpected exception caught");
                }
            }
        }
        string = new String(cArray, n, n2);
        this.currentElement.enqueue(string);
        this.processingCharacters = true;
    }

    private void parseRolePermission(Attributes attributes) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseRolePermission", attributes);
        }
        this.currentElement.dequeue();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseRolePermission");
        }
    }

    private void processMethodPermission() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processMethodPermission");
        }
        method_permission method_permission2 = new method_permission();
        method method2 = null;
        while (!this.currentElement.empty()) {
            String string = this.currentElement.dequeue().toString();
            if (string.equals("role-name")) {
                string = this.currentElement.dequeue().toString();
                method_permission2.roles.add(string);
                continue;
            }
            if (string.equals("method")) {
                if (method2 != null) {
                    method_permission2.methods.add(method2);
                }
                method2 = new method();
                while (!this.currentElement.empty()) {
                    string = this.currentElement.dequeue().toString();
                    if (string.equals("resource-name")) {
                        string = this.currentElement.dequeue().toString();
                        method2.resource_name = string;
                        continue;
                    }
                    if (string.equals("method-name")) {
                        string = this.currentElement.dequeue().toString();
                        method2.method_name = string;
                        continue;
                    }
                    if (string.equals("method-params")) {
                        while (!this.currentElement.empty()) {
                            string = this.currentElement.dequeue().toString();
                            if (!string.equals("method-param")) continue;
                            string = this.currentElement.dequeue().toString();
                            method2.params.add(string);
                        }
                        continue;
                    }
                    if (string.equals("description")) {
                        string = this.currentElement.dequeue().toString();
                        continue;
                    }
                    if (!string.equals("method")) continue;
                    if (method2 != null) {
                        method_permission2.methods.add(method2);
                    }
                    method2 = new method();
                }
                continue;
            }
            if (!string.equals("description")) continue;
            string = this.currentElement.dequeue().toString();
        }
        if (method2 != null) {
            method_permission2.methods.add(method2);
        }
        this.method_permissions.add(method_permission2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processMethodPermission");
        }
    }

    private void processSecurityRole() {
        Set set;
        String string;
        HashSet hashSet;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processSecurityRole");
        }
        String string2 = null;
        while (!this.currentElement.empty()) {
            String string3 = this.currentElement.dequeue().toString();
            if (string3.equals("security-role")) {
                string3 = this.currentElement.dequeue().toString();
                string3 = this.currentElement.dequeue().toString();
                string2 = this.currentElement.dequeue().toString();
                this.roleSet.add(string2);
                continue;
            }
            if (!string3.equals("imply")) continue;
            while (!this.currentElement.empty()) {
                string3 = this.currentElement.dequeue().toString();
                string3 = this.currentElement.dequeue().toString();
                if (this.roleMap.containsKey(string3)) {
                    hashSet = (HashSet)this.roleMap.get(string3);
                    hashSet.add(string2);
                    this.roleMap.put(string3, hashSet);
                    continue;
                }
                hashSet = new HashSet(6);
                hashSet.add(string2);
                this.roleMap.put(string3, hashSet);
            }
        }
        hashSet = this.roleMap.keySet();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            set = (Set)this.roleMap.get(string);
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                if (!this.roleMap.containsKey(e)) continue;
                Set set2 = (Set)this.roleMap.get(e);
                Iterator iterator3 = set2.iterator();
                while (iterator3.hasNext()) {
                    Object e2 = iterator3.next();
                    if (set.contains(e2)) continue;
                    set.add(e2);
                    this.roleMap.put(string, set);
                    iterator2 = set.iterator();
                }
            }
        }
        hashSet = this.roleMap.keySet();
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            set = (Set)this.roleMap.get(string);
            set.add(string);
            this.roleMap.put(string, set);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSecurityRole");
        }
    }

    private void processResource() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processResource");
        }
        String string = this.currentElement.dequeue().toString();
        String string2 = null;
        String string3 = null;
        while (!this.currentElement.empty()) {
            string = this.currentElement.dequeue().toString();
            if (string.equals("resource-name")) {
                string2 = this.currentElement.dequeue().toString();
                continue;
            }
            if (!string.equals("class-name")) continue;
            string3 = this.currentElement.dequeue().toString();
        }
        this.resourceMap.put(string2, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processResource");
        }
    }

    private void processRolePermission() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processRolePermission");
        }
        this.rbMod = new RoleBasedModule(this.moduleName);
        int n = this.method_permissions.size();
        for (int i = 0; i < n; ++i) {
            CharSequence charSequence;
            method_permission method_permission2 = (method_permission)this.method_permissions.get(i);
            Iterator iterator = method_permission2.roles.iterator();
            HashSet<String> hashSet = new HashSet<String>();
            while (iterator.hasNext()) {
                charSequence = (String)iterator.next();
                if (this.roleMap.containsKey(charSequence)) {
                    hashSet.addAll((HashSet)this.roleMap.get(charSequence));
                    continue;
                }
                hashSet.add((String)charSequence);
            }
            iterator = method_permission2.methods.iterator();
            charSequence = null;
            while (iterator.hasNext()) {
                method method2 = (method)iterator.next();
                charSequence = new StringBuffer(method2.resource_name + ":");
                ((StringBuffer)charSequence).append(method2.method_name);
                int n2 = method2.params.size();
                for (int j = 0; j < n2; ++j) {
                    ((StringBuffer)charSequence).append(":" + (String)method2.params.get(j));
                }
                if (hashSet.size() <= 0) continue;
                this.rbMod.add(((StringBuffer)charSequence).toString(), hashSet);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processRolePermission");
        }
    }

    private XMLReader getXMLReader() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXMLReader");
        }
        XMLReader xMLReader = null;
        try {
            xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getXMLReader ParserConfigurationException getting parser from SAXParserFactory.", new Object[]{parserConfigurationException});
            }
            FFDCFilter.processException((Throwable)parserConfigurationException, "com.ibm.ws.security.role.RolePermissionDescriptorLoader.getXMLReader", "512", this);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getXMLReader exception getting parser from SAXParserFactory.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.role.RolePermissionDescriptorLoader.getXMLReader", "517", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXMLReader");
        }
        return xMLReader;
    }

    class method_permission {
        private HashSet roles = new HashSet(4);
        private ArrayList methods = new ArrayList(15);

        method_permission() {
        }
    }

    class method {
        private String resource_name;
        private String method_name;
        private ArrayList params = new ArrayList();

        method() {
        }
    }
}

