/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.zOS;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.NotImplementedException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.registry.zOS.SAFRegistryException;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.RegExp;
import com.ibm.ws.security.zOS.PlatformCredentialManager;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public final class SAFRegistryImpl
implements UserRegistry {
    private static final TraceComponent tc = Tr.register(SAFRegistryImpl.class, "Security", "com.ibm.ejs.resources.security");
    private static final String TOKEN_DELIMETER = "::";
    private String realm = null;
    private boolean ignoreCase = true;
    private boolean disableGroupLoad = false;
    private boolean disablePrincipalCasePreservation = false;
    private boolean forceCredCreationForValidation = false;
    private boolean useSimpleAuthentication = false;
    private boolean mixedCasePasswordsEnabled = false;
    private PlatformCredentialManager pcManager = PlatformCredentialManager.instance();

    public SAFRegistryImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public void initialize(Properties properties) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        this.mixedCasePasswordsEnabled = SAFRegistryImpl.ntv_isMixedCasePWEnabled();
        this.realm = SAFRegistryImpl.ntv_getRealm();
        if (this.ignoreCase) {
            this.realm.toUpperCase();
        }
        this.ignoreCase = true;
        if (properties != null) {
            String string = properties.getProperty("com.ibm.websphere.security.zos.disableGroupAcquisition");
            this.disableGroupLoad = "true".equalsIgnoreCase(string);
            string = properties.getProperty("com.ibm.websphere.security.SimpleAuthentication");
            this.useSimpleAuthentication = Boolean.valueOf(string);
            string = properties.getProperty("disable.principal.case.preservation");
            this.disablePrincipalCasePreservation = "true".equalsIgnoreCase(string);
            string = properties.getProperty("force.credential.creation.for.validation");
            this.forceCredCreationForValidation = "true".equalsIgnoreCase(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", this);
        }
    }

    public String checkPassword(String string, String string2) throws PasswordCheckFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkPassword", new Object[]{string, string2 == null ? null : "****"});
        }
        String string3 = this.normalizeUserId(string);
        String string4 = this.normalizePassword(string2);
        String string5 = null;
        try {
            Object object;
            if (this.useSimpleAuthentication) {
                string5 = this.disablePrincipalCasePreservation ? SAFRegistryImpl.ntv_checkPassword(string3, string4) : ((string5 = SAFRegistryImpl.ntv_checkPassword(string3, string4)) != null ? string : null);
            } else {
                object = this.pcManager.createPasswordCredential(string3, string4);
                String string6 = this.pcManager.getKeyFromCredential((PlatformCredential)object);
                string5 = this.disablePrincipalCasePreservation ? string6 + TOKEN_DELIMETER + string3 : string6 + TOKEN_DELIMETER + string;
            }
            if (string5 == null) {
                object = "Authentication failed for user: " + string;
                throw new PasswordCheckFailedException((String)object);
            }
        }
        catch (PasswordCheckFailedException passwordCheckFailedException) {
            Tr.error(tc, "security.authn.failed.foruser", new Object[]{string});
            throw passwordCheckFailedException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.checkPassword", "304", this);
            Tr.error(tc, "security.authn.error", new Object[]{string, throwable});
            throw new CustomRegistryException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkPassword", string5);
        }
        return string5;
    }

    public String mapCertificate(X509Certificate[] x509CertificateArray) throws CertificateMapNotSupportedException, CertificateMapFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapCertificate", x509CertificateArray);
        }
        String string = null;
        try {
            if (this.useSimpleAuthentication) {
                byte[] byArray = x509CertificateArray[0].getEncoded();
                string = SAFRegistryImpl.ntv_mapCertificate(byArray, byArray.length);
            } else {
                PlatformCredential platformCredential = this.pcManager.createCertificateCredential(x509CertificateArray);
                String string2 = this.pcManager.getKeyFromCredential(platformCredential);
                string = string2 + TOKEN_DELIMETER + platformCredential.getUserId();
            }
            if (string == null) {
                throw new CertificateMapFailedException("Certificate could not be mapped to a valid SAF user ID");
            }
        }
        catch (CertificateMapFailedException certificateMapFailedException) {
            Tr.error(tc, "security.registry.mapcertificate.failed");
            throw certificateMapFailedException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.mapCertificate", "364", this);
            Tr.error(tc, "security.registry.mapcertificate.failed");
            throw new CustomRegistryException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapCertificate", string);
        }
        return string;
    }

    public String getRealm() {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealm");
        }
        String string2 = string = this.realm == null ? SAFRegistryImpl.ntv_getRealm() : this.realm;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealm", string);
        }
        return string;
    }

    public Result getUsers(String string, int n) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsers", new Object[]{string, new Integer(n)});
        }
        Result result = new Result();
        ArrayList arrayList = this.getUsers(string);
        if (n > 0 && arrayList.size() > n) {
            arrayList = new ArrayList(arrayList.subList(0, n - 1));
            result.setHasMore();
        }
        result.setList(arrayList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsers", result);
        }
        return result;
    }

    public String getUserDisplayName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserDisplayName", string);
        }
        try {
            if (!this.isValidUser(string)) {
                throw new EntryNotFoundException("Display name not found in registry");
            }
            if (this.disablePrincipalCasePreservation) {
                string = this.normalizeUserId(string);
            }
        }
        catch (EntryNotFoundException entryNotFoundException) {
            Tr.error(tc, "security.registry.userdisplayname.notfound", new Object[]{string});
            throw entryNotFoundException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getUserDisplayName", "499", this);
            Tr.error(tc, "security.registry.userdisplayname.error", new Object[]{string, throwable});
            throw new EntryNotFoundException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserDisplayName", string);
        }
        return string;
    }

    public String getUniqueUserId(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueUserId", string);
        }
        try {
            if (!this.isValidUser(string)) {
                String string2 = "User " + string + " not found";
                throw new EntryNotFoundException(string2);
            }
            if (this.disablePrincipalCasePreservation) {
                string = this.normalizeUserId(string);
            }
        }
        catch (EntryNotFoundException entryNotFoundException) {
            FFDCFilter.processException((Throwable)entryNotFoundException, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getUniqueUserId", "545", this);
            Tr.error(tc, "security.registry.uniqueusrid.notfound", new Object[]{string});
            throw entryNotFoundException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getUniqueUserId", "551", this);
            Tr.error(tc, "security.registry.uniqueusrid.error", new Object[]{string, throwable});
            throw new EntryNotFoundException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueUserId", string);
        }
        return string;
    }

    public String getUserSecurityName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserSecurityName", string);
        }
        if (!this.isValidUser(string)) {
            Tr.error(tc, "security.registry.usersecurityname.notfound", new Object[]{string});
            String string2 = "User " + string + " not found";
            throw new EntryNotFoundException(string2);
        }
        if (this.disablePrincipalCasePreservation) {
            string = this.normalizeUserId(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserSecurityName", string);
        }
        return string;
    }

    public boolean isValidUser(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidUser", string);
        }
        boolean bl = false;
        try {
            PlatformCredential platformCredential;
            String string2;
            string = this.normalizeUserId(string);
            bl = this.forceCredCreationForValidation ? (string2 = this.pcManager.getKeyFromCredential(platformCredential = this.pcManager.createCredential(string))) != null : SAFRegistryImpl.ntv_isValidUser(string);
        }
        catch (SAFRegistryException sAFRegistryException) {
            FFDCFilter.processException((Throwable)sAFRegistryException, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.isValidUser", "627", this);
            Tr.error(tc, "security.registry.isvaliduser.error", new Object[]{string, sAFRegistryException});
            throw new CustomRegistryException(sAFRegistryException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidUser", new Boolean(bl));
        }
        return bl;
    }

    public Result getGroups(String string, int n) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroups", new Object[]{string, new Integer(n)});
        }
        Result result = new Result();
        ArrayList arrayList = this.getGroups(string);
        if (n > 0 && arrayList.size() > n) {
            arrayList = new ArrayList(arrayList.subList(0, n - 1));
            result.setHasMore();
        }
        result.setList(arrayList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroups", result);
        }
        return result;
    }

    public String getGroupDisplayName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupDisplayName", string);
        }
        try {
            if (!this.isValidGroup(string)) {
                throw new EntryNotFoundException("Group entry not found");
            }
        }
        catch (EntryNotFoundException entryNotFoundException) {
            FFDCFilter.processException((Throwable)entryNotFoundException, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getGroupDisplayName", "715", this);
            Tr.error(tc, "security.registry.groupdisplayname.notfound", new Object[]{string});
            throw entryNotFoundException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getGroupDisplayName", "721", this);
            Tr.error(tc, "security.registry.groupdisplayname.error", new Object[]{string, throwable});
            throw new CustomRegistryException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupDisplayName", string);
        }
        return string;
    }

    public String getUniqueGroupId(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueGroupId", string);
        }
        try {
            if (!this.isValidGroup(string)) {
                throw new EntryNotFoundException("Group entry not found");
            }
        }
        catch (EntryNotFoundException entryNotFoundException) {
            FFDCFilter.processException((Throwable)entryNotFoundException, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getUniqueGroupId", "760", this);
            Tr.error(tc, "security.registry.uniquegrpid.notfound", new Object[]{string});
            throw entryNotFoundException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getUniqueGroupId", "766", this);
            Tr.error(tc, "security.registry.uniquegrpid.error", new Object[]{string, throwable});
            throw new CustomRegistryException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueGroupId", string);
        }
        return string;
    }

    public List getUniqueGroupIds(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueGroupIds", string);
        }
        List list = this.getGroupsForUser(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueGroupIds", list);
        }
        return list;
    }

    public String getGroupSecurityName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupSecurityName", string);
        }
        if (!this.isValidGroup(string)) {
            Tr.error(tc, "security.registry.groupsecurityname.notfound", new Object[]{string});
            String string2 = "Group " + string + " not found";
            throw new EntryNotFoundException(string2);
        }
        String string3 = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupSecurityName", string3);
        }
        return string3;
    }

    public boolean isValidGroup(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidGroup", string);
        }
        boolean bl = false;
        try {
            string = this.normalizeGroupName(string);
            bl = SAFRegistryImpl.ntv_isValidGroup(string);
        }
        catch (SAFRegistryException sAFRegistryException) {
            FFDCFilter.processException((Throwable)sAFRegistryException, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.isValidGroup", "860", this);
            Tr.error(tc, "security.registry.isvalidgroup.error", new Object[]{string, sAFRegistryException});
            throw new CustomRegistryException(sAFRegistryException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidGroup", new Boolean(bl));
        }
        return bl;
    }

    public List getGroupsForUser(String string) throws CustomRegistryException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupsForUser", string);
        }
        List list = null;
        try {
            String string2 = this.normalizeUserId(string);
            list = SAFRegistryImpl.ntv_getGroupsForUser(string2, new ArrayList());
            List list2 = list = list == null ? new ArrayList() : list;
            if (list.size() == 0 && !this.isValidUser(string)) {
                String string3 = "User " + string + " not found";
                throw new EntryNotFoundException(string3);
            }
        }
        catch (EntryNotFoundException entryNotFoundException) {
            FFDCFilter.processException((Throwable)entryNotFoundException, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getGroupsForUser", "908", this);
            Tr.error(tc, "security.registry.getgrpsforuser.notfound", new Object[]{string});
            throw entryNotFoundException;
        }
        catch (SAFRegistryException sAFRegistryException) {
            FFDCFilter.processException((Throwable)sAFRegistryException, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getGroupsForUser", "914", this);
            Tr.error(tc, "security.registry.getgrpsforuser.notfound", new Object[]{string});
            String string4 = "User " + string + " not found";
            throw new EntryNotFoundException(string4);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getGroupsForUser", "921", this);
            Tr.error(tc, "security.registry.getgrpsforuser.error", new Object[]{string, throwable});
            throw new CustomRegistryException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupsForUser", list);
        }
        return list;
    }

    public Result getUsersForGroup(String string, int n) throws EntryNotFoundException, CustomRegistryException {
        ArrayList arrayList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsersForGroup", new Object[]{string, new Integer(n)});
        }
        Result result = new Result();
        try {
            String string2 = this.normalizeGroupName(string);
            arrayList = SAFRegistryImpl.ntv_getUsersForGroup(string2, new ArrayList());
            ArrayList arrayList2 = arrayList = arrayList == null ? new ArrayList() : arrayList;
            if (arrayList.size() == 0 && !this.isValidGroup(string)) {
                String string3 = "Group " + string + " not found";
                throw new EntryNotFoundException(string3);
            }
        }
        catch (EntryNotFoundException entryNotFoundException) {
            FFDCFilter.processException((Throwable)entryNotFoundException, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getGroupsForUser", "992", this);
            Tr.error(tc, "security.registry.uniquegrpid.notfound", new Object[]{string});
            throw entryNotFoundException;
        }
        catch (SAFRegistryException sAFRegistryException) {
            FFDCFilter.processException((Throwable)sAFRegistryException, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getGroupsForUser", "998", this);
            Tr.error(tc, "security.registry.getusrsforgrp.error", new Object[]{string, sAFRegistryException});
            String string4 = "Group " + string + " not found";
            throw new EntryNotFoundException(string4);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getGroupsForUser", "1005", this);
            Tr.error(tc, "security.registry.getusrsforgrp.error", new Object[]{string, throwable});
            throw new CustomRegistryException(throwable);
        }
        if (n > 0 && arrayList.size() > n) {
            arrayList = new ArrayList(arrayList.subList(0, n - 1));
            result.setHasMore();
        }
        result.setList(arrayList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsersForGroup", result);
        }
        return result;
    }

    public WSCredential createCredential(String string) throws CustomRegistryException, NotImplementedException, EntryNotFoundException {
        Object object;
        Object object2;
        Object object3;
        String[] stringArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCredential", string);
        }
        String string2 = (stringArray = string.split(TOKEN_DELIMETER, 2)).length > 1 ? stringArray[0] : null;
        String string3 = string2 == null ? string : stringArray[1];
        String string4 = this.disablePrincipalCasePreservation ? this.normalizeUserId(string3) : string3;
        WSCredential wSCredential = null;
        try {
            String[] stringArray2;
            object3 = this.getRealm();
            object2 = new ArrayList<String>();
            if (!this.disableGroupLoad && (object = this.getUniqueGroupIds(string4)) != null) {
                stringArray2 = object.toArray(new String[object.size()]);
                for (int i = 0; i < stringArray2.length; ++i) {
                    ((ArrayList)object2).add(RegistryUtil.appendRealm("group", stringArray2[i], (String)object3));
                }
            }
            object = RegistryUtil.appendRealm("user", string4, (String)object3);
            stringArray2 = ((ArrayList)object2).size() > 0 ? (String)((ArrayList)object2).get(0) : RegistryUtil.nullString;
            wSCredential = (WSCredential)AccessController.doPrivileged(new PrivilegedExceptionAction((String)object3, string4, (String)stringArray2, (String)object, (ArrayList)object2){
                private final /* synthetic */ String val$realm;
                private final /* synthetic */ String val$securityName;
                private final /* synthetic */ String val$primaryGroupId;
                private final /* synthetic */ String val$accessId;
                private final /* synthetic */ ArrayList val$groupList;
                {
                    this.val$realm = string;
                    this.val$securityName = string2;
                    this.val$primaryGroupId = string3;
                    this.val$accessId = string4;
                    this.val$groupList = arrayList;
                }

                public Object run() throws Exception {
                    return new WSCredentialImpl(this.val$realm, this.val$securityName, this.val$securityName, this.val$primaryGroupId, this.val$accessId, null, this.val$groupList);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.registry.UserRegistryImpl.createCredential", "1070", this);
            throw new CustomRegistryException(exception.getMessage(), exception);
        }
        catch (EntryNotFoundException entryNotFoundException) {
            throw entryNotFoundException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.registry.UserRegistryImpl.createCredential", "1079", this);
            Tr.error(tc, "security.registry.createcredential.error", new Object[]{string4, exception});
            throw new CustomRegistryException(exception.getMessage(), exception);
        }
        try {
            object3 = null;
            if (string2 != null) {
                object3 = this.pcManager.getCredentialFromKey(string2);
            }
            if (object3 == null && !this.useSimpleAuthentication) {
                object3 = this.pcManager.createCredential(string4);
            }
            if (object3 != null) {
                object2 = object3;
                object = wSCredential;
                AccessController.doPrivileged(new PrivilegedExceptionAction((WSCredential)object, (PlatformCredential)object2){
                    private final /* synthetic */ WSCredential val$wsCred;
                    private final /* synthetic */ PlatformCredential val$platformCred;
                    {
                        this.val$wsCred = wSCredential;
                        this.val$platformCred = platformCredential;
                    }

                    public Object run() throws Exception {
                        this.val$wsCred.set("com.ibm.ws.security.zos.PlatformCredential", this.val$platformCred);
                        return null;
                    }
                });
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.SAFRegistryImpl", "1112", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception setting PlatformCredential", privilegedActionException.getException());
            }
            throw new CustomRegistryException(privilegedActionException.getException().getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.SAFRegistryImpl", "1118", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception setting PlatformCredential", exception);
            }
            throw new CustomRegistryException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCredential", wSCredential);
        }
        return wSCredential;
    }

    List getGroups() throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroups");
        }
        List list = this.getGroups("*");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroups", list);
        }
        return list;
    }

    List getGroups(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroups", string);
        }
        List list = null;
        try {
            list = SAFRegistryImpl.ntv_getGroups(new ArrayList());
            list = list == null ? new ArrayList() : list;
            list = this.filterList(list, string);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getGroups", "1163", this);
            Tr.error(tc, "security.registry.getgroups.error", new Object[]{"*", throwable});
            throw new CustomRegistryException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroups", list);
        }
        return list;
    }

    private List getUsers(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsers", string);
        }
        List list = null;
        try {
            list = SAFRegistryImpl.ntv_getUsers(new ArrayList());
            list = list == null ? new ArrayList() : list;
            list = this.filterList(list, string);
        }
        catch (SAFRegistryException sAFRegistryException) {
            FFDCFilter.processException((Throwable)sAFRegistryException, "com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getUsers", "1190", this);
            Tr.error(tc, "security.registry.getusers.error", new Object[]{string, sAFRegistryException});
            throw new CustomRegistryException(sAFRegistryException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsers", list);
        }
        return list;
    }

    private List filterList(List list, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "filterArray", new Object[]{list, string});
        }
        RegExp regExp = new RegExp(string.toUpperCase());
        Iterator iterator = list.iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!regExp.match(string2)) continue;
            arrayList.add(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "filterArray", arrayList);
        }
        return arrayList;
    }

    private String normalizeUserId(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "normailzeUserId", string);
        }
        String string2 = string = this.ignoreCase ? string.toUpperCase().trim() : string.trim();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "normalizeUserId", string);
        }
        return string;
    }

    private String normalizePassword(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "normalizePassword");
        }
        if (!this.mixedCasePasswordsEnabled) {
            string = string.toUpperCase().trim();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "normalizePassword");
        }
        return string;
    }

    private String normalizeGroupName(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "normalizeGroupName", string);
        }
        String string2 = string = this.ignoreCase ? string.toUpperCase().trim() : string.trim();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "nomralizeGroupName", string);
        }
        return string;
    }

    public String toString() {
        return super.toString() + "[realm=" + this.realm + ";ignoreCase=" + this.ignoreCase + ";disableGroupLoad=" + this.disableGroupLoad + ";useSimpleAuthentication=" + this.useSimpleAuthentication + ";mixedCasePasswordsEnabled=" + this.mixedCasePasswordsEnabled + "]";
    }

    private static synchronized native List ntv_getUsers(List var0) throws SAFRegistryException;

    private static synchronized native List ntv_getGroups(List var0) throws SAFRegistryException;

    private static native List ntv_getGroupsForUser(String var0, List var1) throws SAFRegistryException;

    private static native List ntv_getUsersForGroup(String var0, List var1) throws SAFRegistryException;

    private static native boolean ntv_isValidGroup(String var0) throws SAFRegistryException;

    private static native boolean ntv_isValidUser(String var0) throws SAFRegistryException;

    private static native String ntv_checkPassword(String var0, String var1) throws SAFRegistryException;

    private static native String ntv_mapCertificate(byte[] var0, int var1) throws SAFRegistryException;

    private static native boolean ntv_isMixedCasePWEnabled();

    private static native String ntv_getRealm();
}

