/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.nt;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.NotImplementedException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.registry.RegistryErrorException;
import com.ibm.ws.security.registry.nt.GroupEnumeration;
import com.ibm.ws.security.registry.nt.MultiEnumeration;
import com.ibm.ws.security.registry.nt.NTRegistryImpl;
import com.ibm.ws.security.registry.nt.UserEnumeration;
import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class NTLocalDomainRegistryImpl
implements UserRegistry {
    private static TraceComponent tc = Tr.register(NTLocalDomainRegistryImpl.class, null, "com.ibm.ejs.resources.security");
    private NTRegistryImpl[] registries;
    private static final String realmSeparator = "/";
    private static final String typeSeparator = ":";
    private boolean isLocalOrDomain = false;
    private String realm;

    public String checkPassword(String string, String string2) throws PasswordCheckFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkPassword");
        }
        String string3 = null;
        NTRegistryImpl nTRegistryImpl = this.getRegistryForRealm(string);
        if (nTRegistryImpl != null) {
            string3 = nTRegistryImpl.checkPassword(this.stripRealm(string), string2);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkPassword", string3);
            }
            return string3;
        }
        PasswordCheckFailedException passwordCheckFailedException = null;
        for (int i = 0; i < this.registries.length; ++i) {
            try {
                string3 = this.registries[i].checkPassword(string, string2);
            }
            catch (PasswordCheckFailedException passwordCheckFailedException2) {
                passwordCheckFailedException = passwordCheckFailedException2;
            }
            if (string3 == null) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkPassword", string3);
            }
            return string3;
        }
        if (passwordCheckFailedException != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkPassword", passwordCheckFailedException);
            }
            FFDCFilter.processException((Throwable)passwordCheckFailedException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.checkPassword", "83", this);
            throw passwordCheckFailedException;
        }
        Tr.error(tc, "security.authn.failed.foruser", new Object[]{string3});
        throw new CustomRegistryException("Authentication failed for user" + string3);
    }

    public String mapCertificate(X509Certificate[] x509CertificateArray) throws CertificateMapNotSupportedException, CertificateMapFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapCertificate");
        }
        CertificateMapNotSupportedException certificateMapNotSupportedException = new CertificateMapNotSupportedException("Certificate mapping not supported");
        Tr.error(tc, "security.registry.mapcertificate.notsupported");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapCertificate", certificateMapNotSupportedException);
        }
        throw certificateMapNotSupportedException;
    }

    public String getGroupDisplayName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupDisplayName", string);
        }
        String string2 = null;
        NTRegistryImpl nTRegistryImpl = this.getRegistryForRealm(string);
        WSSecurityException wSSecurityException = null;
        if (nTRegistryImpl != null) {
            string2 = nTRegistryImpl.getGroupDisplayName(string);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroupDisplayName", string2);
            }
            return string2;
        }
        for (int i = 0; i < this.registries.length; ++i) {
            try {
                string2 = this.registries[i].getGroupDisplayName(string);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getGroupDisplayName", string2);
                }
                return string2;
            }
            catch (CustomRegistryException customRegistryException) {
                wSSecurityException = customRegistryException;
                continue;
            }
            catch (EntryNotFoundException entryNotFoundException) {
                wSSecurityException = entryNotFoundException;
            }
        }
        if (wSSecurityException != null) {
            if (wSSecurityException instanceof EntryNotFoundException) {
                FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getGroupDisplayName", "151", this);
                Tr.error(tc, "security.registry.groupdisplayname.error", new Object[]{string, wSSecurityException});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getGroupDisplayName", wSSecurityException);
                }
                throw (EntryNotFoundException)wSSecurityException;
            }
            if (wSSecurityException instanceof CustomRegistryException) {
                FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getGroupDisplayName", "157", this);
                Tr.error(tc, "security.registry.groupdisplayname.error", new Object[]{string, wSSecurityException});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getGroupDisplayName", wSSecurityException);
                }
                throw wSSecurityException;
            }
        }
        Tr.error(tc, "security.registry.groupdisplayname.notfound", new Object[]{string});
        throw new CustomRegistryException("Could not obtain groupDisplayName for group: " + string);
    }

    public String getUniqueGroupId(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueGroupId", string);
        }
        NTRegistryImpl nTRegistryImpl = this.getRegistryForRealm(string);
        String string2 = null;
        if (nTRegistryImpl != null) {
            string2 = nTRegistryImpl.getUniqueGroupId(this.stripRealm(string));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUniqueGroupId", string2);
            }
            return string2;
        }
        WSSecurityException wSSecurityException = null;
        for (int i = 0; i < this.registries.length; ++i) {
            try {
                string2 = this.registries[i].getUniqueGroupId(string);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUniqueGroupId", string2);
                }
                return string2;
            }
            catch (CustomRegistryException customRegistryException) {
                wSSecurityException = customRegistryException;
                continue;
            }
            catch (EntryNotFoundException entryNotFoundException) {
                wSSecurityException = entryNotFoundException;
            }
        }
        if (wSSecurityException != null) {
            if (wSSecurityException instanceof EntryNotFoundException) {
                FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getUniqueGroupId", "208", this);
                Tr.error(tc, "security.registry.uniquegrpid.notfound", new Object[]{string});
                throw (EntryNotFoundException)wSSecurityException;
            }
            if (wSSecurityException instanceof CustomRegistryException) {
                FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getUniqueGroupId", "214", this);
                Tr.error(tc, "security.registry.uniquegrpid.notfound", new Object[]{string});
                throw wSSecurityException;
            }
        }
        Tr.error(tc, "security.registry.uniquegrpid.notfound", new Object[]{string});
        throw new CustomRegistryException();
    }

    public Result getGroups(String string, int n) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroups", string + typeSeparator + n);
        }
        Result result = new Result();
        int n2 = 0;
        if (n < 0) {
            ArrayList arrayList = new ArrayList(0);
            result.setList(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No groups searched as the limit is a negative number.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroups", string + typeSeparator + n);
            }
            return result;
        }
        Enumeration enumeration = this.getGroups(string);
        if (enumeration == null) {
            ArrayList arrayList = new ArrayList(0);
            result.setList(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no groups found");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroups", string + typeSeparator + n);
            }
            return result;
        }
        ArrayList arrayList = new ArrayList();
        if (n != 0) {
            arrayList = new ArrayList(n);
        }
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
            if (n == 0 || ++n2 != n) continue;
        }
        result.setList(arrayList);
        if (enumeration.hasMoreElements()) {
            result.setHasMore();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroups", string + typeSeparator + n);
        }
        return result;
    }

    public Enumeration getGroups(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroups", string);
        }
        try {
            int n;
            Enumeration[] enumerationArray = new Enumeration[this.registries.length];
            if (string.indexOf("\\") == -1) {
                string = "*\\\\" + string;
            } else {
                n = string.indexOf("\\");
                StringBuffer stringBuffer = new StringBuffer(string);
                string = stringBuffer.insert(n, "\\").toString();
            }
            for (n = 0; n < this.registries.length; ++n) {
                enumerationArray[n] = new GroupEnumeration(this.registries[n], string, true);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroups");
            }
            return new MultiEnumeration(enumerationArray);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getGroups", "265", this);
            Tr.error(tc, "security.registry.getgroups.error", new Object[]{string, exception});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroups");
            }
            throw new CustomRegistryException(exception.getMessage());
        }
    }

    public List getGroupsForUser(String string) throws EntryNotFoundException, CustomRegistryException {
        String[] stringArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupsForUser", string);
        }
        if ((stringArray = this.getGroupsForUser1(string)) == null || stringArray.length == 0) {
            return new ArrayList(0);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Number of groups returned = " + arrayList.size());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupsForUser", string);
        }
        return arrayList;
    }

    public String[] getGroupsForUser1(String string) throws EntryNotFoundException, CustomRegistryException {
        NTRegistryImpl nTRegistryImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupsForUser1", string);
        }
        if ((nTRegistryImpl = this.getRegistryForRealm(string)) != null) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getGroupsForUser1", string);
            }
            return nTRegistryImpl.getGroupsForUser(this.stripRealm(string));
        }
        WSSecurityException wSSecurityException = null;
        String[] stringArray = new String[]{};
        for (int i = 0; i < this.registries.length; ++i) {
            try {
                String[] stringArray2 = this.registries[i].getGroupsForUser(string);
                String[] stringArray3 = new String[stringArray2.length + stringArray.length];
                System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
                System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
                stringArray = stringArray3;
                continue;
            }
            catch (CustomRegistryException customRegistryException) {
                wSSecurityException = customRegistryException;
                continue;
            }
            catch (EntryNotFoundException entryNotFoundException) {
                wSSecurityException = entryNotFoundException;
            }
        }
        if (stringArray.length <= 0 && wSSecurityException != null) {
            if (wSSecurityException instanceof EntryNotFoundException) {
                FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getGroupsForUser1", "362", this);
                Tr.error(tc, "security.registry.getgrpsforuser.error", new Object[]{string, wSSecurityException});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getGroupsForUser1", wSSecurityException);
                }
                throw (EntryNotFoundException)wSSecurityException;
            }
            if (wSSecurityException instanceof CustomRegistryException) {
                FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getGroupsForUser1", "368", this);
                Tr.error(tc, "security.registry.getgrpsforuser.error", new Object[]{string, wSSecurityException});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getGroupsForUser1", wSSecurityException);
                }
                throw wSSecurityException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupsForUser1");
        }
        return stringArray;
    }

    public Result getUsersForGroup(String string, int n) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsersForGroup");
        }
        int n2 = 0;
        Result result = new Result();
        if (n < 0) {
            ArrayList arrayList = new ArrayList(0);
            result.setList(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No groups searched for users as the limit is a negative number.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsersForGroup");
            }
            return result;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n != 0 && n < Integer.MAX_VALUE) {
            arrayList = new ArrayList(n + 1);
        } else if (n == Integer.MAX_VALUE) {
            arrayList = new ArrayList(n);
        }
        int n3 = string.indexOf("\\");
        try {
            Enumeration enumeration = this.getUsers();
            block2: while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                List list = this.getGroupsForUser(string2);
                if (list == null || list.size() <= 0) continue;
                for (int i = 0; i < list.size(); ++i) {
                    String string3 = (String)list.get(i);
                    int n4 = string3.indexOf("\\");
                    if (n3 == -1 && n4 != -1) {
                        string3 = string3.substring(n4 + 1);
                    }
                    if (!string3.equals(string)) continue;
                    int n5 = string2.indexOf("\\");
                    string2 = string2.substring(n5 + 1);
                    arrayList.add(string2);
                    if (n >= Integer.MAX_VALUE || n == 0 || ++n2 != n + 1) continue;
                    result.setHasMore();
                    arrayList.remove(string2);
                    continue block2;
                }
            }
            result.setList(arrayList);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsersForGroup");
            }
            return result;
        }
        catch (RegistryErrorException registryErrorException) {
            FFDCFilter.processException((Throwable)registryErrorException, "com.ibm.ws.security.registry.unix.NTLocalDomainRegistryImpl.getUsersForGroup", "388", this);
            Tr.error(tc, "security.registry.getusrsforgrp.error", new Object[]{string, registryErrorException});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsersForGroup", registryErrorException);
            }
            throw new CustomRegistryException(registryErrorException.getMessage());
        }
    }

    public String getGroupSecurityName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupSecurityName", string);
        }
        WSSecurityException wSSecurityException = null;
        for (int i = 0; i < this.registries.length; ++i) {
            try {
                String string2 = this.registries[i].getGroupSecurityName(string);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getGroupSecurityName", string2);
                }
                return string2;
            }
            catch (CustomRegistryException customRegistryException) {
                wSSecurityException = customRegistryException;
                continue;
            }
            catch (EntryNotFoundException entryNotFoundException) {
                wSSecurityException = entryNotFoundException;
            }
        }
        if (wSSecurityException != null) {
            if (wSSecurityException instanceof EntryNotFoundException) {
                FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getGroupSecurityName", "461", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getGroupSecurityName");
                }
                Tr.error(tc, "security.registry.nosecurityname", new Object[]{string, wSSecurityException});
                throw (EntryNotFoundException)wSSecurityException;
            }
            if (wSSecurityException instanceof CustomRegistryException) {
                FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getGroupSecurityName", "467", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getGroupSecurityName");
                }
                Tr.error(tc, "security.registry.nosecurityname", new Object[]{string, wSSecurityException});
                throw wSSecurityException;
            }
        }
        Tr.error(tc, "security.registry.groupsecurityname.notfound", new Object[]{string});
        throw new CustomRegistryException("Could not get the groupSecurityName for group whose uniqueId is : " + string);
    }

    public String getUserDisplayName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserDisplayName", string);
        }
        NTRegistryImpl nTRegistryImpl = this.getRegistryForRealm(string);
        String string2 = null;
        if (nTRegistryImpl != null) {
            string2 = nTRegistryImpl.getUserDisplayName(this.stripRealm(string));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUserDisplayName", string2);
            }
            return string2;
        }
        WSSecurityException wSSecurityException = null;
        for (int i = 0; i < this.registries.length; ++i) {
            try {
                string2 = this.registries[i].getUserDisplayName(string);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUserDisplayName", string2);
                }
                return string2;
            }
            catch (CustomRegistryException customRegistryException) {
                wSSecurityException = customRegistryException;
                continue;
            }
            catch (EntryNotFoundException entryNotFoundException) {
                wSSecurityException = entryNotFoundException;
            }
        }
        if (wSSecurityException != null) {
            if (wSSecurityException instanceof EntryNotFoundException) {
                FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getUserDisplayName", "516", this);
                Tr.error(tc, "security.registry.userdisplayname.error", new Object[]{string, wSSecurityException});
                throw (EntryNotFoundException)wSSecurityException;
            }
            if (wSSecurityException instanceof CustomRegistryException) {
                FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getUserDisplayName", "522", this);
                Tr.error(tc, "security.registry.userdisplayname.error", new Object[]{string, wSSecurityException});
                throw wSSecurityException;
            }
        }
        Tr.error(tc, "security.registry.userdisplayname.notfound", new Object[]{string});
        throw new CustomRegistryException("Cannot get DisplayName for user: " + string);
    }

    public String getUniqueUserId(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueUserId", string);
        }
        NTRegistryImpl nTRegistryImpl = this.getRegistryForRealm(string);
        String string2 = null;
        if (nTRegistryImpl != null) {
            string2 = nTRegistryImpl.getUniqueUserId(this.stripRealm(string));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUniqueUserId", string2);
            }
            return string2;
        }
        WSSecurityException wSSecurityException = null;
        for (int i = 0; i < this.registries.length; ++i) {
            try {
                String string3 = this.registries[i].getUniqueUserId(string);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUniqueUserId");
                }
                return string3;
            }
            catch (CustomRegistryException customRegistryException) {
                wSSecurityException = customRegistryException;
                continue;
            }
            catch (EntryNotFoundException entryNotFoundException) {
                wSSecurityException = entryNotFoundException;
            }
        }
        if (wSSecurityException != null) {
            if (wSSecurityException instanceof EntryNotFoundException) {
                FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getUniqueUserId", "568", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUniqueUserId", string);
                }
                Tr.error(tc, "security.registry.uniqueusrid.notfound", new Object[]{string});
                throw (EntryNotFoundException)wSSecurityException;
            }
            if (wSSecurityException instanceof CustomRegistryException) {
                FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getUniqueUserId", "574", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUniqueUserId", string);
                }
                Tr.error(tc, "security.registry.uniqueusrid.notfound", new Object[]{string});
                throw wSSecurityException;
            }
        }
        Tr.error(tc, "security.registry.uniqueusrid.notfound", new Object[]{string});
        throw new CustomRegistryException();
    }

    public Result getUsers(String string, int n) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsers", string + typeSeparator + n);
        }
        int n2 = 0;
        Result result = new Result();
        if (n < 0) {
            ArrayList arrayList = new ArrayList(0);
            result.setList(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No users searched as the limit is a negative number.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsers", string + typeSeparator + n);
            }
            return result;
        }
        Enumeration enumeration = this.getUsers(string);
        if (enumeration == null) {
            ArrayList arrayList = new ArrayList(0);
            result.setList(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No users found.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsers", string + typeSeparator + n);
            }
            return result;
        }
        ArrayList arrayList = new ArrayList();
        if (n != 0) {
            arrayList = new ArrayList(n);
        }
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
            if (n == 0 || ++n2 != n) continue;
        }
        result.setList(arrayList);
        if (enumeration.hasMoreElements()) {
            result.setHasMore();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsers", string + typeSeparator + n);
        }
        return result;
    }

    public Enumeration getUsers(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsers", string);
        }
        try {
            int n;
            Enumeration[] enumerationArray = new Enumeration[this.registries.length];
            if (string.indexOf("\\") == -1) {
                string = "*\\\\" + string;
            } else {
                n = string.indexOf("\\");
                StringBuffer stringBuffer = new StringBuffer(string);
                string = stringBuffer.insert(n, "\\").toString();
            }
            for (n = 0; n < this.registries.length; ++n) {
                enumerationArray[n] = new UserEnumeration(this.registries[n], string, true);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsers");
            }
            return new MultiEnumeration(enumerationArray);
        }
        catch (RegistryErrorException registryErrorException) {
            FFDCFilter.processException((Throwable)registryErrorException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getUsers", "554", this);
            Tr.error(tc, "security.registry.getusers.error", new Object[]{string, registryErrorException});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsers");
            }
            throw new CustomRegistryException(registryErrorException.getMessage());
        }
    }

    public Enumeration getUsers() throws RegistryErrorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsers");
        }
        Enumeration[] enumerationArray = new Enumeration[this.registries.length];
        for (int i = 0; i < this.registries.length; ++i) {
            enumerationArray[i] = new UserEnumeration(this.registries[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsers");
        }
        return new MultiEnumeration(enumerationArray);
    }

    public String getUserSecurityName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserSecurityName", string);
        }
        WSSecurityException wSSecurityException = null;
        for (int i = 0; i < this.registries.length; ++i) {
            try {
                String string2 = this.registries[i].getUserSecurityName(string);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUserSecurityName");
                }
                return this.stripRealm(string2);
            }
            catch (CustomRegistryException customRegistryException) {
                wSSecurityException = customRegistryException;
                continue;
            }
            catch (EntryNotFoundException entryNotFoundException) {
                wSSecurityException = entryNotFoundException;
            }
        }
        if (wSSecurityException != null) {
            if (wSSecurityException instanceof EntryNotFoundException) {
                FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getUserSecurityName", "706", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUserSecurityName");
                }
                Tr.error(tc, "security.registry.nosecurityname", new Object[]{string, wSSecurityException});
                throw (EntryNotFoundException)wSSecurityException;
            }
            if (wSSecurityException instanceof CustomRegistryException) {
                FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getUserSecurityName", "712", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUserSecurityName");
                }
                Tr.error(tc, "security.registry.nosecurityname", new Object[]{string, wSSecurityException});
                throw wSSecurityException;
            }
        }
        Tr.error(tc, "security.registry.usersecurityname.notfound", new Object[]{string});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserSecurityName");
        }
        throw new EntryNotFoundException("Cannot get security name for user whose uniqueid is " + string);
    }

    public String getUserSecurityNameWithRealm(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserSecurityNameWithRealm", string);
        }
        WSSecurityException wSSecurityException = null;
        for (int i = 0; i < this.registries.length; ++i) {
            try {
                String string2 = this.registries[i].getUserSecurityName(string);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUserSecurityNameWithRealm", string2);
                }
                return string2;
            }
            catch (CustomRegistryException customRegistryException) {
                wSSecurityException = customRegistryException;
                continue;
            }
            catch (EntryNotFoundException entryNotFoundException) {
                wSSecurityException = entryNotFoundException;
            }
        }
        if (wSSecurityException != null) {
            if (wSSecurityException instanceof EntryNotFoundException) {
                FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getUserSecurityName", "751", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUserSecurityNameWithRealm");
                }
                Tr.error(tc, "security.registry.nosecurityname", new Object[]{string, wSSecurityException});
                throw (EntryNotFoundException)wSSecurityException;
            }
            if (wSSecurityException instanceof CustomRegistryException) {
                FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getUserSecurityName", "757", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUserSecurityNameWithRealm");
                }
                Tr.error(tc, "security.registry.nosecurityname", new Object[]{string, wSSecurityException});
                throw wSSecurityException;
            }
        }
        Tr.error(tc, "security.registry.usersecurityname.notfound", new Object[]{string});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserSecurityNameWithRealm");
        }
        throw new EntryNotFoundException("Cannot get security name for user whose uniqueid is " + string);
    }

    public void initialize(Properties properties) throws CustomRegistryException {
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize");
            }
            String string = null;
            if (properties != null) {
                string = properties.getProperty("com.ibm.websphere.registry.UseRegistry");
            }
            if (string != null && (string.equalsIgnoreCase("Domain") || string.equalsIgnoreCase("Local"))) {
                this.isLocalOrDomain = true;
                this.registries = new NTRegistryImpl[1];
                this.registries[0] = string.equalsIgnoreCase("Local") ? new NTRegistryImpl(true) : new NTRegistryImpl(false);
                this.registries[0].initialize(properties);
                this.realm = this.registries[0].getRealm();
                if (tc.isDebugEnabled()) {
                    if (string.equalsIgnoreCase("Local")) {
                        if (this.realm == null || this.realm.trim().length() <= 0) {
                            Tr.debug(tc, "Creation of local registry failed");
                        } else {
                            Tr.debug(tc, "Creation of local registry succeeded");
                        }
                    } else if (this.realm == null || this.realm.trim().length() <= 0) {
                        Tr.debug(tc, "Creation of domain registry failed");
                    } else {
                        Tr.debug(tc, "Creation of domain registry succeeded");
                    }
                }
            } else {
                this.registries = new NTRegistryImpl[2];
                this.registries[0] = new NTRegistryImpl(true);
                this.registries[0].initialize(properties);
                this.realm = this.registries[0].getRealm();
                try {
                    this.registries[1] = new NTRegistryImpl(false);
                    this.registries[1].initialize(properties);
                    this.realm = this.registries[1].getRealm();
                    NTRegistryImpl nTRegistryImpl = this.registries[0];
                    this.registries[0] = this.registries[1];
                    this.registries[1] = nTRegistryImpl;
                }
                catch (CustomRegistryException customRegistryException) {
                    NTRegistryImpl[] nTRegistryImplArray = new NTRegistryImpl[]{this.registries[0]};
                    this.registries = nTRegistryImplArray;
                    if (!tc.isDebugEnabled()) break block15;
                    Tr.debug(tc, "Creation of domain registry failed, using local registry only");
                }
            }
        }
        if (this.realm == null || this.realm.trim().length() <= 0) {
            Tr.error(tc, "security.registry.nullrealm");
            throw new CustomRegistryException("Cannot get the realm");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", this.realm);
        }
    }

    public boolean isValidGroup(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidGroup", string);
        }
        boolean bl = false;
        NTRegistryImpl nTRegistryImpl = this.getRegistryForRealm(string);
        if (nTRegistryImpl != null) {
            bl = nTRegistryImpl.isValidGroup(this.stripRealm(string));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isValidGroup", String.valueOf(bl));
            }
            return bl;
        }
        CustomRegistryException customRegistryException = null;
        for (int i = 0; i < this.registries.length; ++i) {
            try {
                bl = this.registries[i].isValidGroup(string);
                if (!bl) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isValidGroup", String.valueOf(bl));
                }
                return bl;
            }
            catch (CustomRegistryException customRegistryException2) {
                customRegistryException = customRegistryException2;
            }
        }
        if (customRegistryException != null) {
            FFDCFilter.processException((Throwable)customRegistryException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.isValidGroup", "840", this);
            Tr.error(tc, "security.registry.isvalidgroup.error", new Object[]{string, customRegistryException});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isValidGroup", String.valueOf(bl));
            }
            throw customRegistryException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidGroup", String.valueOf(bl));
        }
        return false;
    }

    public boolean isValidUser(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidUser", string);
        }
        boolean bl = false;
        NTRegistryImpl nTRegistryImpl = this.getRegistryForRealm(string);
        if (nTRegistryImpl != null) {
            bl = nTRegistryImpl.isValidUser(this.stripRealm(string));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isValidUser", String.valueOf(bl));
            }
            return bl;
        }
        CustomRegistryException customRegistryException = null;
        for (int i = 0; i < this.registries.length; ++i) {
            try {
                bl = this.registries[i].isValidUser(string);
                if (!bl) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isValidUser", String.valueOf(bl));
                }
                return bl;
            }
            catch (CustomRegistryException customRegistryException2) {
                customRegistryException = customRegistryException2;
            }
        }
        if (customRegistryException != null) {
            FFDCFilter.processException((Throwable)customRegistryException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.isValidUser", "881", this);
            Tr.error(tc, "security.registry.isvaliduser.error", new Object[]{string, customRegistryException});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isValidUser", String.valueOf(bl));
            }
            throw customRegistryException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidUser", String.valueOf(bl));
        }
        return false;
    }

    private NTRegistryImpl getRegistryForRealm(String string) throws CustomRegistryException {
        int n = string.indexOf(92);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        for (int i = 0; i < this.registries.length; ++i) {
            if (!this.registries[i].getRealm().equalsIgnoreCase(string2)) continue;
            return this.registries[i];
        }
        if (this.isLocalOrDomain) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The realm: " + string2 + " does not match the registries realm: " + this.registries[0].getRealm());
            }
            throw new CustomRegistryException("The realm: " + string2 + " does not match the registries realm: " + this.registries[0].getRealm());
        }
        return null;
    }

    private String stripRealm(String string) {
        int n = string.indexOf(92);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    protected String getRelativeName(String string) throws CustomRegistryException {
        int n = string.indexOf(realmSeparator);
        String string2 = string;
        if (n >= 0) {
            int n2 = string.indexOf(typeSeparator);
            String string3 = string.substring(n2 + 1, n);
            for (int i = 0; i < this.registries.length; ++i) {
                if (!string3.equals(this.registries[i].getRealm())) continue;
                return string.substring(n + 1);
            }
            throw new CustomRegistryException();
        }
        return string2;
    }

    public WSCredential createCredential(String string) throws CustomRegistryException, NotImplementedException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCredential", string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCredential");
        }
        return null;
    }

    public String getRealm() throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealm");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealm", this.realm);
        }
        return this.realm;
    }

    public String[] getGroupIDsForUser(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupIDsForUser", string);
        }
        NTRegistryImpl nTRegistryImpl = this.getRegistryForRealm(string);
        String[] stringArray = new String[]{};
        if (nTRegistryImpl != null) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getGroupIDsForUser", string);
            }
            stringArray = nTRegistryImpl.getGroupIDsForUser(this.stripRealm(string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupIDsForUser");
        }
        return stringArray;
    }

    public List getUniqueGroupIds(String string) throws EntryNotFoundException, CustomRegistryException {
        String string2;
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueGroupIds", string);
        }
        if ((stringArray = this.getGroupIDsForUser(string2 = this.getUserSecurityNameWithRealm(string))) != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        } else {
            arrayList = new ArrayList(0);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueGroupIds", String.valueOf(arrayList.size()));
        }
        return arrayList;
    }
}

