/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.NotImplementedException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.registry.ldap.LdapRegistryImpl;
import com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl;
import com.ibm.ws.security.registry.zOS.SAFRegistryImpl;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.util.AccessController;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.rmi.CORBA.Stub;
import javax.rmi.PortableRemoteObject;

public class UserRegistryImpl
extends PortableRemoteObject
implements UserRegistry {
    private static TraceComponent tc = Tr.register(UserRegistryImpl.class, "Security", "com.ibm.ejs.resources.security");
    public static ContextManager ctxMgr = ContextManagerFactory.getInstance();
    private static String CUSTOM_PREFIX = "Custom_";
    private static String CUSTOM_REALM = "customRealm";
    private UserRegistry custImpl;
    private String realm = null;
    private boolean curIntrospected = false;
    private boolean needCurCredImpl = false;
    public static final String NONE = "";
    public static final String USERTYPE = "user";
    public static final String GROUPTYPE = "group";
    public static final String ROLETYPE = "role";
    protected static final String nullString = RegistryUtil.nullString;
    protected static final String[] nullStringArray = RegistryUtil.nullStringArray;
    protected static final byte[] nullByteArray = RegistryUtil.nullByteArray;
    protected static final String realmSeparator = "/";
    public static final String typeSeparator = ":";
    private static RoleBasedAuthorizer authorizer = null;
    private boolean isLDAP = false;
    private boolean isSAF = false;
    private boolean isWindows = false;
    private boolean isLocalOrDomain = false;
    private String useDisplayName = null;
    private String useLoggedInSecName = null;
    private Properties supportedRegistries = new Properties();

    public UserRegistryImpl() throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public void initialize(Properties properties) throws CustomRegistryException, RemoteException {
        Object object;
        Object object2;
        String string;
        block23: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize");
            }
            string = null;
            if (properties != null) {
                this.useDisplayName = properties.getProperty("WAS_UseDisplayName");
                this.useLoggedInSecName = properties.getProperty("com.ibm.websphere.security.useLoggedSecurityName");
                string = (String)properties.get("CustUserRegImplClass");
                if ("com.ibm.ws.security.registry.ldap.LdapRegistryImpl".equals(string) && "true".equalsIgnoreCase((String)(object2 = (String)properties.get("com.ibm.websphere.security.registry.UseTAM")))) {
                    string = "com.ibm.ws.security.registry.ldap.TAMLdapRegistryImpl";
                }
            }
            if (string == null) {
                try {
                    this.supportedRegistries.load(this.getClass().getResourceAsStream("wsregistries.properties"));
                }
                catch (Throwable throwable) {
                    Tr.error(tc, "security.registry.loadproperr", new Object[]{throwable});
                    FFDCFilter.processException(throwable, "com.ibm.ws.security.registry.UserRegistryImpl.initialize", "179", this);
                    throw new CustomRegistryException(throwable.getMessage(), throwable);
                }
                object2 = System.getProperty("os.name");
                if (((String)object2).startsWith("Windows")) {
                    object2 = "Windows";
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Registry type", object2);
                }
                string = this.supportedRegistries.getProperty((String)object2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Registry implementation", string);
                }
            }
            if (string == null) {
                Tr.error(tc, "security.registry.noclassname");
                throw new CustomRegistryException("CustomUserRegistryImplementation Class name is null");
            }
            try {
                object2 = ExtClassLoader.getInstance();
                object = Class.forName(string, true, (ClassLoader)object2);
                Object obj = ((Class)object).newInstance();
                if (obj instanceof UserRegistry) {
                    String string2;
                    this.custImpl = (UserRegistry)obj;
                    this.isLDAP = obj instanceof LdapRegistryImpl;
                    this.isWindows = obj instanceof NTLocalDomainRegistryImpl;
                    this.isSAF = obj instanceof SAFRegistryImpl;
                    if (this.isWindows && properties != null && ("Domain".equalsIgnoreCase(string2 = properties.getProperty("com.ibm.websphere.registry.UseRegistry")) || "Local".equalsIgnoreCase(string2))) {
                        this.isLocalOrDomain = true;
                    }
                    break block23;
                }
                Tr.error(tc, "security.registry.unsupportedclass", new Object[]{string});
                throw new CustomRegistryException("The implementation file for the custom registry: " + string + " is not supported");
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.security.registry.UserRegistryImpl.initialize", "238", this);
                Tr.error(tc, "security.registry.loadclass", new Object[]{string, throwable});
                throw new CustomRegistryException(throwable.getMessage(), throwable);
            }
        }
        try {
            this.custImpl.initialize(properties);
            this.realm = this.custImpl.getRealm();
            if (this.realm == null || this.realm.length() == 0) {
                this.realm = CUSTOM_REALM;
            }
        }
        catch (CustomRegistryException customRegistryException) {
            Tr.error(tc, "security.registry.initerr", new Object[]{string, customRegistryException});
            FFDCFilter.processException((Throwable)customRegistryException, "com.ibm.ws.security.registry.UserRegistryImpl.initialize", "256", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize", customRegistryException);
            }
            throw customRegistryException;
        }
        if (ctxMgr.getPlatformHelper().isControlJvm()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "initialize: in control region, register with JNDI");
            }
            try {
                object2 = (Stub)PortableRemoteObject.toStub((Remote)this);
                object = new InitialContext();
                ((InitialContext)object).rebind("UserRegistry", (Object)this);
            }
            catch (Exception exception) {
                throw new CustomRegistryException(exception.getMessage(), exception);
            }
        }
        Tr.audit(tc, "security.custom.registry.initialized", new Object[]{string});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", this);
        }
    }

    public String checkPassword(String string, String string2) throws PasswordCheckFailedException, CustomRegistryException, RemoteException {
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkPassword", new Object[]{string, string2 == null ? null : "****"});
        }
        if ((string3 = this.custImpl.checkPassword(string, string2)) == null || string3.trim().length() <= 0) {
            Tr.error(tc, "security.registry.checkpass.failed", new Object[]{string});
            throw new PasswordCheckFailedException("checkPassword for: " + string + " failed to return a user: " + string3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "checkPassword", string3);
        }
        return string3;
    }

    public String mapCertificate(X509Certificate[] x509CertificateArray) throws CertificateMapNotSupportedException, CertificateMapFailedException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapCertificate", x509CertificateArray);
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "mapCertificate")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkAccess failed", new Exception("Authorization failed"));
            }
            return null;
        }
        String string = this.custImpl.mapCertificate(x509CertificateArray);
        if (string == null) {
            Tr.error(tc, "security.registry.mapcertfail");
            throw new CertificateMapFailedException("could not map the certificate to a user");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapCertificate", string);
        }
        return string;
    }

    public Result getUsers(String string, int n) throws CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsers", new Object[]{string, new Integer(n)});
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getUsers")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkAccess failed", new Exception("Authorization failed"));
            }
            return null;
        }
        Result result = this.custImpl.getUsers(string, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsers", result);
        }
        return result;
    }

    public String getUserDisplayName(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserDisplayName", string);
        }
        if ((string2 = this.custImpl.getUserDisplayName(string)) == null) {
            string2 = NONE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserDisplayName", string2);
        }
        return string2;
    }

    public String getUniqueUserId(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueUserId", string);
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getUniqueUserId")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkAccess failed", new Exception("Authorization failed"));
            }
            return null;
        }
        String string2 = RegistryUtil.appendRealm(USERTYPE, this.custImpl.getUniqueUserId(string), this.realm);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueUserId", string2);
        }
        return string2;
    }

    public String getUserSecurityName(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserSecurityName", string);
        }
        String string2 = this.custImpl.getUserSecurityName(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserSecurityName", string2);
        }
        return string2;
    }

    public boolean isValidUser(String string) throws CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidUser", string);
        }
        boolean bl = this.custImpl.isValidUser(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidUser", new Boolean(bl));
        }
        return bl;
    }

    public Result getGroups(String string, int n) throws CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroups", new Object[]{string, new Integer(n)});
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getGroups")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkAccess failed", new Exception("Authorization failed"));
            }
            return null;
        }
        Result result = this.custImpl.getGroups(string, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroups", result);
        }
        return result;
    }

    public String getGroupDisplayName(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupDisplayName", string);
        }
        if ((string2 = this.custImpl.getGroupDisplayName(string)) == null) {
            string2 = NONE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupDisplayName", string2);
        }
        return string2;
    }

    public String getUniqueGroupId(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueGroupId", string);
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getUniqueGroupId")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkAccess failed", new Exception("Authorization failed"));
            }
            return null;
        }
        String string2 = RegistryUtil.appendRealm(GROUPTYPE, this.custImpl.getUniqueGroupId(string), this.realm);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueGroupId", string2);
        }
        return string2;
    }

    public String getGroupSecurityName(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupSecurityName", string);
        }
        String string2 = this.custImpl.getGroupSecurityName(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupSecurityName", string2);
        }
        return string2;
    }

    public boolean isValidGroup(String string) throws CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidGroup", string);
        }
        boolean bl = this.custImpl.isValidGroup(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidGroup", new Boolean(bl));
        }
        return bl;
    }

    public List getGroupsForUser(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupsForUser", string);
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getGroupsForGroup")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkAccess failed", new Exception("Authorization failed"));
            }
            return null;
        }
        List list = this.custImpl.getGroupsForUser(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupsForUser", String.valueOf(list.size()));
        }
        return list;
    }

    public WSCredential createCredential(String string) throws CustomRegistryException, EntryNotFoundException, NotImplementedException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCredential", string);
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "createCredential")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkAccess failed", new Exception("Authorization failed"));
            }
            return null;
        }
        if (string == null || string.length() == 0) {
            throw new EntryNotFoundException("SecurityName is null");
        }
        WSCredential wSCredential = null;
        try {
            if (!this.curIntrospected) {
                this.needCurCredImpl = this.custImpl.getClass().getMethod("passControlToCurCred", null) != null;
                this.curIntrospected = true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.needCurCredImpl = false;
        }
        if (this.isLDAP || this.isSAF || this.needCurCredImpl) {
            wSCredential = this.custImpl.createCredential(string);
        } else {
            String string2 = null;
            if ("true".equalsIgnoreCase(this.useDisplayName)) {
                try {
                    string2 = this.getUserDisplayName(string);
                    if (NONE.equals(string2)) {
                        string2 = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                int n;
                Object object;
                String string3 = this.custImpl.getUniqueUserId(string);
                final String string4 = this.getRealm();
                String string5 = RegistryUtil.appendRealm(USERTYPE, string3, string4);
                ArrayList<String> arrayList = new ArrayList<String>();
                List list = this.custImpl.getUniqueGroupIds(string3);
                String string6 = null;
                if (list != null && list.size() > 0) {
                    object = list.toArray(new String[list.size()]);
                    for (int i = 0; i < ((String[])object).length; ++i) {
                        if (i == 0) {
                            string6 = RegistryUtil.appendRealm(GROUPTYPE, object[i], string4);
                        }
                        arrayList.add(RegistryUtil.appendRealm(GROUPTYPE, object[i], string4));
                    }
                }
                String string7 = string = string2 != null ? string2 : string;
                if (this.isWindows && !this.isLocalOrDomain && (n = string.indexOf("\\")) != -1) {
                    string = string.substring(n + 1);
                }
                object = null;
                object = "true".equalsIgnoreCase(this.useLoggedInSecName) ? string : this.custImpl.getUserSecurityName(string3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "securityName used in the credential is: ", object);
                }
                Object object2 = object;
                String string8 = string6 != null ? string6 : NONE;
                try {
                    wSCredential = (WSCredential)AccessController.doPrivileged(new PrivilegedExceptionAction((String)object2, string3, string8, string5, arrayList){
                        private final /* synthetic */ String val$securityName;
                        private final /* synthetic */ String val$uniqueUserId;
                        private final /* synthetic */ String val$primaryGroupId;
                        private final /* synthetic */ String val$accessId;
                        private final /* synthetic */ ArrayList val$groupList;
                        {
                            this.val$securityName = string2;
                            this.val$uniqueUserId = string3;
                            this.val$primaryGroupId = string42;
                            this.val$accessId = string5;
                            this.val$groupList = arrayList;
                        }

                        public Object run() throws Exception {
                            return new WSCredentialImpl(string4, this.val$securityName, this.val$uniqueUserId, this.val$primaryGroupId, this.val$accessId, null, this.val$groupList);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
            }
            catch (CustomRegistryException customRegistryException) {
                Tr.debug(tc, "CustomRegistryException creating credential: " + customRegistryException.getMessage());
                Tr.error(tc, "security.registry.createcredential.error", new Object[]{string, customRegistryException});
                FFDCFilter.processException((Throwable)customRegistryException, "com.ibm.ws.security.registry.UserRegistryImpl.createCredential", "818", this);
                throw new CustomRegistryException(customRegistryException.getMessage(), customRegistryException);
            }
            catch (Exception exception) {
                Tr.debug(tc, "Exception creating credential.", new Object[]{exception});
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.registry.UserRegistryImpl.createCredential", "824", this);
                throw new RemoteException(exception.getMessage(), exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCredential", wSCredential);
        }
        return wSCredential;
    }

    public String getRealm() throws CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealm");
        }
        if (this.realm == null) {
            String string = this.custImpl.getRealm();
            if (string == null || string.length() == 0) {
                string = CUSTOM_REALM;
            }
            this.realm = string;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealm", this.realm);
        }
        return this.realm;
    }

    public List getUniqueGroupIds(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueGroupIds", string);
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getUniqueGroupId")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkAccess failed", new Exception("Authorization failed"));
            }
            return null;
        }
        List list = this.custImpl.getUniqueGroupIds(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueGroupIds", list);
        }
        return list;
    }

    public Result getUsersForGroup(String string, int n) throws NotImplementedException, EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsersForGroup", string);
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getUsersForGroup")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkAccess failed", new Exception("Authorization failed"));
            }
            return null;
        }
        Result result = this.custImpl.getUsersForGroup(string, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsersForGroup", result);
        }
        return result;
    }

    public void setConfigurator(RoleBasedConfigurator roleBasedConfigurator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setConfigurator", roleBasedConfigurator);
        }
        if (authorizer == null && roleBasedConfigurator != null) {
            try {
                authorizer = roleBasedConfigurator.getRoleBasedAuthorizer("admin-authz", "domain");
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught retrieving RoleBasedAuthorizer", exception);
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.registry.UserRegistryImpl.setConfigurator", "917", this);
                Tr.error(tc, "security.init.roleauthz.geterr", new Object[]{exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setConfigurator");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(";").append("impl=").append(this.custImpl.toString());
        stringBuffer.append(";").append("realm=").append(this.realm);
        return stringBuffer.toString();
    }
}

