/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.policy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.provider.AllPolicyConfigs;
import com.ibm.ws.security.provider.JaccProvider;
import com.ibm.ws.security.provider.WSPolicyConfigurationImpl;
import com.ibm.ws.security.util.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;

public class JaccPolicyProxy
extends Policy {
    private static Policy policy = null;
    private ProtectionDomain self = null;
    private JaccProvider jaccProvider = null;
    private static final TraceComponent tc = Tr.register(JaccPolicyProxy.class, null, "com.ibm.ejs.resources.security");

    public JaccPolicyProxy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JaccPolicyProxy");
        }
        final JaccPolicyProxy jaccPolicyProxy = this;
        this.self = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return jaccPolicyProxy.getClass().getProtectionDomain();
            }
        });
        policy = Policy.getPolicy();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JaccPolicyProxy()");
        }
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPermissions", new Object[]{codeSource});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPermissions(CodeSource)");
        }
        return policy.getPermissions(codeSource);
    }

    public void refresh() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refresh()");
        }
        policy.refresh();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refresh()");
        }
    }

    public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPermissions");
        }
        PermissionCollection permissionCollection = null;
        permissionCollection = policy.getPermissions(protectionDomain);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPermissions(domain)");
        }
        return permissionCollection;
    }

    public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        boolean bl = false;
        if (this.self == protectionDomain && this.self != null) {
            bl = true;
        } else {
            if (permission instanceof WebResourcePermission) {
                boolean bl2;
                WSPolicyConfigurationImpl wSPolicyConfigurationImpl = this.getPolicyConfiguration();
                if (wSPolicyConfigurationImpl == null) {
                    return false;
                }
                if (protectionDomain.getPrincipals() == null || protectionDomain.getPrincipals().length < 1) {
                    boolean bl3;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking the unchecked list");
                    }
                    if (bl3 = this.jaccProvider.checkUncheckedPerm(wSPolicyConfigurationImpl, permission)) {
                        return bl3;
                    }
                    return this.jaccProvider.isEveryoneGranted(wSPolicyConfigurationImpl, permission, PolicyContext.getContextID());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking the excluded list");
                }
                if (bl2 = this.jaccProvider.checkExcludedPerm(wSPolicyConfigurationImpl, permission)) {
                    return false;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking the role list");
                }
                return this.jaccProvider.checkRolePerm(wSPolicyConfigurationImpl, permission, PolicyContext.getContextID());
            }
            if (permission instanceof WebUserDataPermission) {
                boolean bl4;
                WSPolicyConfigurationImpl wSPolicyConfigurationImpl = this.getPolicyConfiguration();
                if (wSPolicyConfigurationImpl == null) {
                    return false;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking the excluded list");
                }
                if (bl4 = this.jaccProvider.checkExcludedPerm(wSPolicyConfigurationImpl, permission)) {
                    return false;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not in the excluded list: Checking for unchecked");
                }
                boolean bl5 = this.jaccProvider.checkUncheckedPerm(wSPolicyConfigurationImpl, permission);
                return bl5;
            }
            if (permission instanceof WebRoleRefPermission || permission instanceof EJBRoleRefPermission) {
                WSPolicyConfigurationImpl wSPolicyConfigurationImpl = this.getPolicyConfiguration();
                if (wSPolicyConfigurationImpl == null) {
                    return false;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking the role list");
                }
                return this.jaccProvider.checkRolePerm(wSPolicyConfigurationImpl, permission, PolicyContext.getContextID());
            }
            if (permission instanceof EJBMethodPermission) {
                boolean bl6;
                boolean bl7;
                WSPolicyConfigurationImpl wSPolicyConfigurationImpl = this.getPolicyConfiguration();
                if (wSPolicyConfigurationImpl == null) {
                    return false;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking the excluded list");
                }
                if (bl7 = this.jaccProvider.checkExcludedPerm(wSPolicyConfigurationImpl, permission)) {
                    return false;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking the unchecked list");
                }
                if (bl6 = this.jaccProvider.checkUncheckedPerm(wSPolicyConfigurationImpl, permission)) {
                    return bl6;
                }
                return this.jaccProvider.checkRolePerm(wSPolicyConfigurationImpl, permission, PolicyContext.getContextID());
            }
            bl = policy.implies(protectionDomain, permission);
        }
        return bl;
    }

    private WSPolicyConfigurationImpl getPolicyConfiguration() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicyConfiguration");
        }
        String string = PolicyContext.getContextID();
        WSPolicyConfigurationImpl wSPolicyConfigurationImpl = null;
        wSPolicyConfigurationImpl = AllPolicyConfigs.getInstance().getPolicyConfig(string);
        if (wSPolicyConfigurationImpl == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Cannot get the policy configuration object. exit value:false");
            }
            return null;
        }
        boolean bl = false;
        try {
            bl = wSPolicyConfigurationImpl.inService();
        }
        catch (PolicyContextException policyContextException) {
            FFDCFilter.processException((Throwable)policyContextException, "com.ibm.ws.security.policy.JaccPolicyProxy.JaccProvider.getPolicyConfiguration", "208", this);
            Tr.warning(tc, "security.jacc.provider.inservice", (Object)new Object[]{policyContextException});
        }
        if (!bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The policy configuration object is not in the commit state. exit value:false");
            }
            return null;
        }
        if (this.jaccProvider == null) {
            this.jaccProvider = JaccProvider.getInstance();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicyConfiguration");
        }
        return wSPolicyConfigurationImpl;
    }
}

