/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.policy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.ParserException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Security;
import java.util.ArrayList;

public class FilterPolicyParser {
    private Object parser = null;
    private Method parseMethod = null;
    private Method getFilterPermissionsMethod = null;
    private static final String CLASS = "com.ibm.ws.security.policy.FilterParserTr";
    private static final String PARSE_METHOD = "parse";
    private static final String GETFILTERPERMISSIONS_METHOD = "getFilterPermissions";
    private static final TraceComponent tc = Tr.register(FilterPolicyParser.class, null, "com.ibm.ejs.resources.security");

    public FilterPolicyParser(Reader reader, boolean bl) throws ParserException {
        try {
            Class<?> clazz = Class.forName(CLASS);
            Constructor<?> constructor = clazz.getDeclaredConstructor(Reader.class, Boolean.TYPE);
            this.parser = constructor.newInstance(reader, new Boolean(bl));
            Class<?> clazz2 = Class.forName("com.ibm.ws.security.policy.FilterParser");
            this.parseMethod = clazz2.getDeclaredMethod(PARSE_METHOD, null);
            this.getFilterPermissionsMethod = clazz2.getDeclaredMethod(GETFILTERPERMISSIONS_METHOD, null);
        }
        catch (InvocationTargetException invocationTargetException) {
            FFDCFilter.processException((Throwable)invocationTargetException, "com.ibm.ws.security.policy.FilterPolicyParser.FilterPolicyParser", "35", this);
            Throwable throwable = invocationTargetException.getTargetException();
            Tr.error(tc, "security.policy.parser.cannotcreateclass", new Object[]{CLASS, throwable});
            throw new ParserException(throwable.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.policy.FilterPolicyParser.FilterPolicyParser", "40", this);
            Tr.error(tc, "security.policy.parser.cannotcreateclass", new Object[]{CLASS, exception});
            throw new ParserException(exception.getMessage());
        }
    }

    public void parse() throws ParserException, IOException {
        if (this.parser == null) {
            Tr.error(tc, "security.policy.parser.objectisnull", new Object[]{CLASS});
        } else if (this.parseMethod == null) {
            Tr.error(tc, "security.policy.parser.methodisnull", new Object[]{PARSE_METHOD, CLASS});
        } else {
            try {
                this.parseMethod.invoke(this.parser, null);
            }
            catch (IllegalAccessException illegalAccessException) {
                FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.security.policy.FilterPolicyParser.parse", "55", this);
                Tr.error(tc, "security.policy.parser.methodinvocationfailed", new Object[]{PARSE_METHOD, CLASS, illegalAccessException});
                throw new ParserException(illegalAccessException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                FFDCFilter.processException((Throwable)invocationTargetException, "com.ibm.ws.security.policy.FilterPolicyParser.parse", "59", this);
                Throwable throwable = invocationTargetException.getTargetException();
                Tr.error(tc, "security.policy.parser.methodinvocationfailed", new Object[]{PARSE_METHOD, CLASS, throwable});
                if (throwable instanceof ParserException) {
                    throw (ParserException)throwable;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw new ParserException(throwable.getMessage());
            }
        }
    }

    public ArrayList getFilterPermissions() throws ParserException {
        ArrayList arrayList = null;
        if (this.parser == null) {
            Tr.error(tc, "security.policy.parser.objectisnull", new Object[]{CLASS});
        } else if (this.getFilterPermissionsMethod == null) {
            Tr.error(tc, "security.policy.parser.methodisnull", new Object[]{GETFILTERPERMISSIONS_METHOD, CLASS});
        } else {
            try {
                arrayList = (ArrayList)this.getFilterPermissionsMethod.invoke(this.parser, null);
            }
            catch (IllegalAccessException illegalAccessException) {
                FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.security.policy.FilterPolicyParser.getFilterPermissions", "84", this);
                Tr.error(tc, "security.policy.parser.methodinvocationfailed", new Object[]{GETFILTERPERMISSIONS_METHOD, CLASS, illegalAccessException});
                throw new ParserException(illegalAccessException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                FFDCFilter.processException((Throwable)invocationTargetException, "com.ibm.ws.security.policy.FilterPolicyParser.getFilterPermissions", "88", this);
                Throwable throwable = invocationTargetException.getTargetException();
                Tr.error(tc, "security.policy.parser.methodinvocationfailed", new Object[]{GETFILTERPERMISSIONS_METHOD, CLASS, throwable});
                if (throwable instanceof ParserException) {
                    throw (ParserException)throwable;
                }
                throw new ParserException(throwable.getMessage());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("usage: java " + FilterPolicyParser.class.getName() + " <filerpolicy file>");
            System.exit(1);
        }
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(stringArray[0]);
            String string = Security.getProperty("policy.expandProperties");
            boolean bl = false;
            if (string != null) {
                bl = string.equalsIgnoreCase("true");
            }
            FilterPolicyParser filterPolicyParser = new FilterPolicyParser(fileReader, bl);
            filterPolicyParser.parse();
            System.out.println("Permissions to be filtered: " + filterPolicyParser.getFilterPermissions());
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.policy.FilterPolicyParser.main", "120");
            System.err.println("Error: exception caught");
            exception.printStackTrace();
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException(iOException, "com.ibm.ws.security.policy.FilterPolicyParser.main", "128");
                    System.err.println("Error: exception caught");
                    iOException.printStackTrace();
                }
            }
        }
    }
}

