/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.policy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.policy.PolicyTemplate;
import com.ibm.ws.security.util.ParserException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Security;

public class ApplicationPolicyParser {
    private Object parser = null;
    private Method parseMethod = null;
    private Method getPolicyTemplateMethod = null;
    private static final String CLASS = "com.ibm.ws.security.policy.ApplicationParserTr";
    private static final String PARSE_METHOD = "parse";
    private static final String GETPOLICYTEMPLATE_METHOD = "getPolicyTemplate";
    private static final TraceComponent tc = Tr.register(ApplicationPolicyParser.class, null, "com.ibm.ejs.resources.security");

    public ApplicationPolicyParser(Reader reader, boolean bl) throws ParserException {
        try {
            Class<?> clazz = Class.forName(CLASS);
            Constructor<?> constructor = clazz.getDeclaredConstructor(Reader.class, Boolean.TYPE);
            this.parser = constructor.newInstance(reader, new Boolean(bl));
            Class<?> clazz2 = Class.forName("com.ibm.ws.security.policy.Parser");
            this.parseMethod = clazz2.getDeclaredMethod(PARSE_METHOD, null);
            this.getPolicyTemplateMethod = clazz2.getDeclaredMethod(GETPOLICYTEMPLATE_METHOD, null);
        }
        catch (InvocationTargetException invocationTargetException) {
            FFDCFilter.processException((Throwable)invocationTargetException, "com.ibm.ws.security.policy.ApplicationPolicyParser.ApplicationPolicyParser", "35", this);
            Throwable throwable = invocationTargetException.getTargetException();
            Tr.error(tc, "security.policy.parser.cannotcreateclass", new Object[]{CLASS, throwable});
            throw new ParserException(throwable.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.policy.ApplicationPolicyParser.ApplicationPolicyParser", "40", this);
            Tr.error(tc, "security.policy.parser.cannotcreateclass", new Object[]{CLASS, exception});
            throw new ParserException(exception.getMessage());
        }
    }

    public void parse() throws ParserException, IOException {
        if (this.parser == null) {
            Tr.error(tc, "security.policy.parser.objectisnull", new Object[]{CLASS});
        } else if (this.parseMethod == null) {
            Tr.error(tc, "security.policy.parser.methodisnull", new Object[]{PARSE_METHOD, CLASS});
        } else {
            try {
                this.parseMethod.invoke(this.parser, null);
            }
            catch (IllegalAccessException illegalAccessException) {
                FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.security.policy.ApplicationPolicyParser.parse", "55", this);
                Tr.error(tc, "security.policy.parser.methodinvocationfailed", new Object[]{PARSE_METHOD, CLASS, illegalAccessException});
                throw new ParserException(illegalAccessException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                FFDCFilter.processException((Throwable)invocationTargetException, "com.ibm.ws.security.policy.ApplicationPolicyParser.parse", "59", this);
                Throwable throwable = invocationTargetException.getTargetException();
                Tr.error(tc, "security.policy.parser.methodinvocationfailed", new Object[]{PARSE_METHOD, CLASS, throwable});
                if (throwable instanceof ParserException) {
                    throw (ParserException)throwable;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw new ParserException(throwable.getMessage());
            }
        }
    }

    public PolicyTemplate getPolicyTemplate() throws ParserException {
        PolicyTemplate policyTemplate = null;
        if (this.parser == null) {
            Tr.error(tc, "security.policy.parser.objectisnull", new Object[]{CLASS});
        } else if (this.getPolicyTemplateMethod == null) {
            Tr.error(tc, "security.policy.parser.methodisnull", new Object[]{GETPOLICYTEMPLATE_METHOD, CLASS});
        } else {
            try {
                policyTemplate = (PolicyTemplate)this.getPolicyTemplateMethod.invoke(this.parser, null);
            }
            catch (IllegalAccessException illegalAccessException) {
                FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.security.policy.ApplicationPolicyParser.getPolicyTemplate", "84", this);
                Tr.error(tc, "security.policy.parser.methodinvocationfailed", new Object[]{GETPOLICYTEMPLATE_METHOD, CLASS, illegalAccessException});
                throw new ParserException(illegalAccessException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                FFDCFilter.processException((Throwable)invocationTargetException, "com.ibm.ws.security.policy.ApplicationPolicyParser.getPolicyTemplate", "88", this);
                Throwable throwable = invocationTargetException.getTargetException();
                Tr.error(tc, "security.policy.parser.methodinvocationfailed", new Object[]{GETPOLICYTEMPLATE_METHOD, CLASS, throwable});
                if (throwable instanceof ParserException) {
                    throw (ParserException)throwable;
                }
                throw new ParserException(throwable.getMessage());
            }
        }
        return policyTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("usage: java " + ApplicationPolicyParser.class.getName() + " <policy file>");
            System.exit(1);
        }
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(stringArray[0]);
            String string = Security.getProperty("policy.expandProperties");
            boolean bl = false;
            if (string != null) {
                bl = string.equalsIgnoreCase("true");
            }
            ApplicationPolicyParser applicationPolicyParser = new ApplicationPolicyParser(fileReader, bl);
            applicationPolicyParser.parse();
            System.out.println("Policy Template: " + applicationPolicyParser.getPolicyTemplate());
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.policy.ApplicationPolicyParser.main", "120");
            System.err.println("Error: exception caught");
            exception.printStackTrace();
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException(iOException, "com.ibm.ws.security.policy.ApplicationPolicyParser.main", "128");
                    System.err.println("Error: exception caught");
                    iOException.printStackTrace();
                }
            }
        }
    }
}

